/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Fields;
import freenet.support.URLEncodedFormatException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class URLDecoder {
    public static void main(String[] args) throws URLEncodedFormatException {
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i] + " -> " + URLDecoder.decode(args[i], false));
        }
    }

    public static String decode(String s, boolean tolerant) throws URLEncodedFormatException {
        if (s.length() == 0) {
            return "";
        }
        int len = s.length();
        ByteArrayOutputStream decodedBytes = new ByteArrayOutputStream();
        boolean hasDecodedSomething = false;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i >= len - 2) {
                    throw new URLEncodedFormatException(s);
                }
                char[] hexChars = new char[]{s.charAt(++i), s.charAt(++i)};
                String hexval = new String(hexChars);
                try {
                    long read = Fields.hexToLong(hexval);
                    if (read == 0L) {
                        throw new URLEncodedFormatException("Can't encode 00");
                    }
                    decodedBytes.write((int)read);
                    hasDecodedSomething = true;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    if (tolerant && !hasDecodedSomething) {
                        try {
                            byte[] buf = ('%' + hexval).getBytes("UTF-8");
                            decodedBytes.write(buf, 0, buf.length);
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                        }
                    }
                    throw new URLEncodedFormatException("Not a two character hex % escape: " + hexval + " in " + s);
                }
            }
            try {
                byte[] encoded = ("" + c).getBytes("UTF-8");
                decodedBytes.write(encoded, 0, encoded.length);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
        }
        try {
            decodedBytes.close();
            return new String(decodedBytes.toByteArray(), "utf-8");
        }
        catch (IOException ioe1) {
            throw new URLEncodedFormatException(s);
        }
    }
}

