/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;

public class URIPreEncoder {
    public static final String allowedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-!.~'()*,;:$&+=?/@%#";

    public static String encode(String s) {
        StringBuilder output = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (allowedChars.indexOf(c) >= 0) {
                output.append(c);
                continue;
            }
            String tmp = "" + c;
            try {
                byte[] utf = tmp.getBytes("UTF-8");
                for (int j = 0; j < utf.length; ++j) {
                    int x = utf[j] & 0xFF;
                    output.append('%');
                    if (x < 16) {
                        output.append('0');
                    }
                    output.append(Integer.toHexString(x));
                }
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
        }
        return output.toString();
    }

    public static URI encodeURI(String s) throws URISyntaxException {
        return new URI(URIPreEncoder.encode(s));
    }
}

