/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientPutCallback;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.PrioRunnable;
import freenet.support.Logger;
import freenet.support.io.TempBucketFactory;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransferThread
implements PrioRunnable,
ClientGetCallback,
ClientPutCallback {
    private final String mName;
    protected final Node mNode;
    protected final HighLevelSimpleClient mClient;
    protected final TempBucketFactory mTBF;
    private Thread mThread;
    private volatile boolean isRunning = false;
    private volatile boolean shutdownFinished = false;
    private final Collection<ClientGetter> mFetches = this.createFetchStorage();
    private final Collection<BaseClientPutter> mInserts = this.createInsertStorage();

    public TransferThread(Node myNode, HighLevelSimpleClient myClient, String myName) {
        this.mNode = myNode;
        this.mClient = myClient;
        this.mTBF = this.mNode.clientCore.tempBucketFactory;
        this.mName = myName;
    }

    protected void start() {
        this.mNode.executor.execute(this, this.mName);
        Logger.debug(this, "Started.");
    }

    @Override
    public abstract int getPriority();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Object v1;
        this.isRunning = true;
        this.mThread = Thread.currentThread();
        try {
            Thread.sleep(this.getStartupDelay());
        }
        catch (InterruptedException e) {
            this.mThread.interrupt();
        }
        try {
            while (this.isRunning) {
                Thread.interrupted();
                try {
                    Logger.debug(this, "Loop running...");
                    this.iterate();
                    long sleepTime = this.getSleepTime();
                    Logger.debug(this, "Loop finished. Sleeping for " + sleepTime / 60000L + " minutes.");
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    this.mThread.interrupt();
                }
                catch (Exception e) {
                    Logger.error(this, "Error in iterate probably()", e);
                }
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var4_6 = null;
            try {
                try {
                    this.abortAllTransfers();
                    v0 = null;
                }
                catch (RuntimeException e) {
                    Logger.error(this, "SHOULD NOT HAPPEN, please report this exception", e);
                    v0 = null;
                }
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var7_12 = v0;
            TransferThread transferThread6 = this;
            synchronized (transferThread6) {
                this.shutdownFinished = true;
                this.notify();
                throw throwable;
            }
        }
        try {
            try {
                this.abortAllTransfers();
                v1 = null;
            }
            catch (RuntimeException e) {
                Logger.error(this, "SHOULD NOT HAPPEN, please report this exception", e);
                v1 = null;
            }
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var7_11 = v1;
        TransferThread transferThread = this;
        synchronized (transferThread) {
            this.shutdownFinished = true;
            this.notify();
            return;
        }
    }

    public void nextIteration() {
        this.mThread.interrupt();
    }

    protected void abortAllTransfers() {
        Logger.debug(this, "Trying to stop all fetches & inserts...");
        this.abortFetches();
        this.abortInserts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortFetches() {
        Logger.debug(this, "Trying to stop all fetches...");
        if (this.mFetches != null) {
            Collection<ClientGetter> collection = this.mFetches;
            synchronized (collection) {
                ClientGetter[] fetches = this.mFetches.toArray(new ClientGetter[this.mFetches.size()]);
                int fcounter = 0;
                for (ClientGetter fetch : fetches) {
                    fetch.cancel(null, this.mNode.clientCore.clientContext);
                    ++fcounter;
                }
                Logger.debug(this, "Stopped " + fcounter + " current fetches.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortInserts() {
        Logger.debug(this, "Trying to stop all inserts...");
        if (this.mInserts != null) {
            Collection<BaseClientPutter> collection = this.mInserts;
            synchronized (collection) {
                BaseClientPutter[] inserts = this.mInserts.toArray(new BaseClientPutter[this.mInserts.size()]);
                int icounter = 0;
                for (BaseClientPutter insert : inserts) {
                    insert.cancel(null, this.mNode.clientCore.clientContext);
                    ++icounter;
                }
                Logger.debug(this, "Stopped " + icounter + " current inserts.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFetch(ClientGetter g) {
        Collection<ClientGetter> collection = this.mFetches;
        synchronized (collection) {
            this.mFetches.add(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFetch(ClientGetter g) {
        Collection<ClientGetter> collection = this.mFetches;
        synchronized (collection) {
            this.mFetches.remove(g);
        }
        Logger.debug(this, "Removed request for " + g.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInsert(BaseClientPutter p) {
        Collection<BaseClientPutter> collection = this.mInserts;
        synchronized (collection) {
            this.mInserts.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInsert(BaseClientPutter p) {
        Collection<BaseClientPutter> collection = this.mInserts;
        synchronized (collection) {
            this.mInserts.remove(p);
        }
        Logger.debug(this, "Removed insert for " + p.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fetchCount() {
        Collection<ClientGetter> collection = this.mFetches;
        synchronized (collection) {
            return this.mFetches.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertCount() {
        Collection<BaseClientPutter> collection = this.mInserts;
        synchronized (collection) {
            return this.mInserts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Logger.debug(this, "Terminating...");
        this.isRunning = false;
        this.mThread.interrupt();
        TransferThread transferThread = this;
        synchronized (transferThread) {
            while (!this.shutdownFinished) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
        Logger.debug(this, "Terminated.");
    }

    protected abstract Collection<ClientGetter> createFetchStorage();

    protected abstract Collection<BaseClientPutter> createInsertStorage();

    protected abstract long getStartupDelay();

    protected abstract long getSleepTime();

    protected abstract void iterate();

    @Override
    public abstract void onSuccess(FetchResult var1, ClientGetter var2, ObjectContainer var3);

    @Override
    public abstract void onFailure(FetchException var1, ClientGetter var2, ObjectContainer var3);

    @Override
    public abstract void onSuccess(BaseClientPutter var1, ObjectContainer var2);

    @Override
    public abstract void onFailure(InsertException var1, BaseClientPutter var2, ObjectContainer var3);

    @Override
    public abstract void onFetchable(BaseClientPutter var1, ObjectContainer var2);

    @Override
    public abstract void onGeneratedURI(FreenetURI var1, BaseClientPutter var2, ObjectContainer var3);

    @Override
    public abstract void onMajorProgress(ObjectContainer var1);

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing TransferThread in database", new Exception("error"));
        return false;
    }
}

