/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.text.DecimalFormat;

public class TimeUtil {
    public static String formatTime(long timeInterval, int maxTerms, boolean withSecondFractions) {
        if (maxTerms > 6) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(64);
        long l = timeInterval;
        int termCount = 0;
        if (l < 0L) {
            sb.append('-');
            l *= -1L;
        }
        if (!withSecondFractions && l < 1000L) {
            return "0";
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long weeks = l / 604800000L;
        if (weeks > 0L) {
            sb.append(weeks).append('w');
            ++termCount;
            l -= weeks * 604800000L;
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long days = l / 86400000L;
        if (days > 0L) {
            sb.append(days).append('d');
            ++termCount;
            l -= days * 86400000L;
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long hours = l / 3600000L;
        if (hours > 0L) {
            sb.append(hours).append('h');
            ++termCount;
            l -= hours * 3600000L;
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long minutes = l / 60000L;
        if (minutes > 0L) {
            sb.append(minutes).append('m');
            ++termCount;
            l -= minutes * 60000L;
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        if (withSecondFractions && maxTerms - termCount >= 2) {
            if (l > 0L) {
                double fractionalSeconds = (double)l / 1000.0;
                DecimalFormat fix3 = new DecimalFormat("0.000");
                sb.append(fix3.format(fractionalSeconds)).append('s');
                ++termCount;
            }
        } else {
            long seconds = l / 1000L;
            if (seconds > 0L) {
                sb.append(seconds).append('s');
                ++termCount;
            }
        }
        return sb.toString();
    }

    public static String formatTime(long timeInterval) {
        return TimeUtil.formatTime(timeInterval, 2, false);
    }

    public static String formatTime(long timeInterval, int maxTerms) {
        return TimeUtil.formatTime(timeInterval, maxTerms, false);
    }
}

