/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.HTMLNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class StringCounter {
    private final HashMap<String, Item> map = new HashMap();

    public synchronized void inc(String string) {
        Item item = this.map.get(string);
        if (item == null) {
            item = new Item(string);
            item.counter = 1;
            this.map.put(string, item);
        } else {
            ++item.counter;
        }
    }

    public int get(String string) {
        Item item = this.map.get(string);
        if (item == null) {
            return 0;
        }
        return item.counter;
    }

    private synchronized Item[] items() {
        return this.map.values().toArray(new Item[this.map.size()]);
    }

    private synchronized Item[] sortedItems(final boolean ascending) {
        Item[] items = this.items();
        Arrays.sort(items, new Comparator<Item>(){

            @Override
            public int compare(Item it0, Item it1) {
                int ret = it0.counter > it1.counter ? 1 : (it0.counter < it1.counter ? -1 : it0.string.compareTo(it1.string));
                if (!ascending) {
                    ret = -ret;
                }
                return ret;
            }
        });
        return items;
    }

    public String toLongString() {
        Item[] items = this.sortedItems(false);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i != 0) {
                sb.append('\n');
            }
            Item it = items[i];
            sb.append(it.string);
            sb.append('\t');
            sb.append(it.counter);
        }
        return sb.toString();
    }

    public int toTableRows(HTMLNode table) {
        Item[] items = this.sortedItems(false);
        for (int i = 0; i < items.length; ++i) {
            Item it = items[i];
            HTMLNode row = table.addChild("tr");
            row.addChild("td", Integer.toString(it.counter) + "\u00a0");
            row.addChild("td", it.string);
        }
        return items.length;
    }

    private static class Item {
        final String string;
        int counter;

        public Item(String string2) {
            this.string = string2;
        }
    }
}

