/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.support.IntNumberedItem;
import freenet.support.Logger;
import freenet.support.SimpleIntNumberedItemComparator;
import java.util.Arrays;
import java.util.Comparator;

public class SortedVectorByNumber {
    private IntNumberedItem[] data = new IntNumberedItem[4];
    private int length = 0;
    private static final Comparator<Object> comparator = new SimpleIntNumberedItemComparator(true);
    private static final int MIN_SIZE = 4;
    private final boolean persistent;

    public SortedVectorByNumber(boolean persistent) {
        this.persistent = persistent;
    }

    public synchronized IntNumberedItem getFirst() {
        if (this.length == 0) {
            return null;
        }
        return this.data[0];
    }

    public synchronized boolean isEmpty() {
        return this.length == 0;
    }

    public synchronized IntNumberedItem get(int retryCount, ObjectContainer container) {
        int x;
        if (this.persistent) {
            for (int i = 0; i < this.length; ++i) {
                container.activate((Object)this.data[i], 1);
            }
        }
        if ((x = Arrays.binarySearch(this.data, retryCount, comparator)) >= 0) {
            return this.data[x];
        }
        return null;
    }

    public synchronized void remove(int item, ObjectContainer container) {
        int x;
        if (this.persistent) {
            for (int i = 0; i < this.length; ++i) {
                container.activate((Object)this.data[i], 1);
            }
        }
        if ((x = Arrays.binarySearch(this.data, item, comparator)) >= 0) {
            if (x < this.length - 1) {
                System.arraycopy(this.data, x + 1, this.data, x, this.length - x - 1);
            }
            this.data[--this.length] = null;
        }
        if (this.length * 4 < this.data.length && this.length > 4) {
            IntNumberedItem[] newData = new IntNumberedItem[Math.max(this.length * 2, 4)];
            System.arraycopy(this.data, 0, newData, 0, this.length);
            this.data = newData;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        this.verify(container);
    }

    private synchronized void verify(ObjectContainer container) {
        int i;
        IntNumberedItem lastItem = null;
        for (i = 0; i < this.length; ++i) {
            IntNumberedItem item = this.data[i];
            if (this.persistent) {
                container.activate((Object)this.data[i], 1);
            }
            if (i > 0 && item.getNumber() <= lastItem.getNumber()) {
                throw new IllegalStateException("Verify failed! at " + i + " this=" + item.getNumber() + " but last=" + lastItem.getNumber());
            }
            lastItem = item;
        }
        for (i = this.length; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            throw new IllegalStateException("length=" + this.length + ", data.length=" + this.data.length + " but [" + i + "] != null");
        }
    }

    public synchronized boolean push(IntNumberedItem grabber, ObjectContainer container) {
        int x;
        if (this.persistent) {
            for (int i = 0; i < this.length; ++i) {
                container.activate((Object)this.data[i], 1);
            }
        }
        if ((x = Arrays.binarySearch(this.data, grabber.getNumber(), comparator)) >= 0) {
            return false;
        }
        x = -x - 1;
        this.push(grabber, x, container);
        return true;
    }

    public synchronized void add(IntNumberedItem grabber, ObjectContainer container) {
        int x;
        if (this.persistent) {
            for (int i = 0; i < this.length; ++i) {
                container.activate((Object)this.data[i], 1);
            }
        }
        if ((x = Arrays.binarySearch(this.data, grabber.getNumber(), comparator)) >= 0) {
            if (grabber != this.data[x]) {
                throw new IllegalArgumentException();
            }
            return;
        }
        x = -x - 1;
        this.push(grabber, x, container);
    }

    private synchronized void push(IntNumberedItem grabber, int x, ObjectContainer container) {
        boolean logMINOR;
        if (this.persistent) {
            for (int i = 0; i < this.length; ++i) {
                container.activate((Object)this.data[i], 1);
            }
        }
        if (logMINOR = Logger.shouldLog(4, this)) {
            Logger.minor(this, "Insertion point: " + x);
        }
        if (this.length == this.data.length) {
            if (logMINOR) {
                Logger.minor(this, "Expanding from " + this.length + " to " + this.length * 2);
            }
            IntNumberedItem[] newData = new IntNumberedItem[this.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        if (x < this.length) {
            System.arraycopy(this.data, x, this.data, x + 1, this.length - x);
        }
        this.data[x] = grabber;
        ++this.length;
        if (this.persistent) {
            container.store((Object)this);
        }
        this.verify(container);
    }

    public synchronized int count() {
        return this.length;
    }

    public synchronized IntNumberedItem getByIndex(int index) {
        if (index > this.length) {
            return null;
        }
        return this.data[index];
    }

    public int getNumberByIndex(int idx) {
        if (idx >= this.length) {
            return Integer.MAX_VALUE;
        }
        return this.data[idx].getNumber();
    }

    public boolean persistent() {
        return this.persistent;
    }
}

