/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Fields;
import freenet.support.Logger;

public class SortedLongSet {
    private long[] data = new long[32];
    private int length;
    private static final int MIN_SIZE = 32;

    public SortedLongSet() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Long.MAX_VALUE;
        }
        this.length = 0;
    }

    public synchronized long getFirst() {
        if (this.length == 0) {
            return -1L;
        }
        return this.data[0];
    }

    public synchronized boolean isEmpty() {
        return this.length == 0;
    }

    public synchronized boolean contains(long num) {
        int x = this.binarySearch(num);
        return x >= 0;
    }

    public synchronized void remove(long item) {
        int x = this.binarySearch(item);
        if (x >= 0) {
            if (x < this.length - 1) {
                System.arraycopy(this.data, x + 1, this.data, x, this.length - x - 1);
            }
            this.data[--this.length] = Long.MAX_VALUE;
        }
        if (this.length * 4 < this.data.length && this.length > 32) {
            long[] newData = new long[Math.max(this.data.length / 2, 32)];
            System.arraycopy(this.data, 0, newData, 0, this.length);
            for (int i = this.length; i < newData.length; ++i) {
                newData[i] = Long.MAX_VALUE;
            }
            this.data = newData;
        }
        this.verify();
    }

    private synchronized void verify() {
        int i;
        long lastItem = -1L;
        for (i = 0; i < this.length; ++i) {
            long item = this.data[i];
            if (i > 0 && item <= lastItem) {
                throw new IllegalStateException("Verify failed!");
            }
            lastItem = item;
        }
        for (i = this.length; i < this.data.length; ++i) {
            if (this.data[i] == Long.MAX_VALUE) continue;
            throw new IllegalStateException("length=" + this.length + ", data.length=" + this.data.length + " but [" + i + "] != Long.MAX_VALUE");
        }
    }

    public synchronized boolean push(long num) {
        int x = this.binarySearch(num);
        if (x >= 0) {
            return false;
        }
        x = -x - 1;
        this.push(num, x);
        return true;
    }

    public synchronized void add(long num) {
        int x = this.binarySearch(num);
        if (x >= 0) {
            throw new IllegalArgumentException();
        }
        x = -x - 1;
        this.push(num, x);
    }

    private synchronized void push(long num, int x) {
        boolean logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "Insertion point: " + x + " length " + this.length + " data.length " + this.data.length);
        }
        if (this.length == this.data.length) {
            if (logMINOR) {
                Logger.minor(this, "Expanding from " + this.length + " to " + this.length * 2);
            }
            long[] newData = new long[this.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            for (int i = this.length; i < newData.length; ++i) {
                newData[i] = Long.MAX_VALUE;
            }
            this.data = newData;
        }
        if (x < this.length) {
            System.arraycopy(this.data, x, this.data, x + 1, this.length - x);
        }
        this.data[x] = num;
        ++this.length;
        this.verify();
    }

    public long removeFirst() {
        long val = this.getFirst();
        this.remove(val);
        return val;
    }

    public synchronized void clear() {
        this.data = new long[32];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Long.MAX_VALUE;
        }
        this.length = 0;
    }

    public synchronized long[] toArray() {
        long[] output = new long[this.length];
        System.arraycopy(this.data, 0, output, 0, this.length);
        return output;
    }

    private int binarySearch(long key) {
        return Fields.binarySearch(this.data, key, 0, this.length - 1);
    }
}

