/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

public class SizeUtil {
    public static final String[] suffixes = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};

    public static String formatSize(long sz) {
        return SizeUtil.formatSize(sz, false);
    }

    public static String formatSizeWithoutSpace(long sz) {
        String[] result = SizeUtil._formatSize(sz);
        return result[0].concat(result[1]);
    }

    public static String formatSize(long sz, boolean useNonBreakingSpace) {
        String[] result = SizeUtil._formatSize(sz);
        return result[0].concat(useNonBreakingSpace ? "\u00a0" : " ").concat(result[1]);
    }

    public static String[] _formatSize(long sz) {
        int i;
        long s = 1L;
        for (i = 0; i < suffixes.length && (s *= 1024L) <= sz; ++i) {
        }
        if ((s /= 1024L) == 1L) {
            return new String[]{String.valueOf(sz), suffixes[0]};
        }
        double mantissa = (double)sz / (double)s;
        String o = String.valueOf(mantissa);
        if (o.indexOf(46) == 3) {
            o = o.substring(0, 3);
        } else if (o.indexOf(46) > -1 && o.indexOf(69) == -1 && o.length() > 4) {
            o = o.substring(0, 4);
        }
        if (i < suffixes.length) {
            return new String[]{o, suffixes[i]};
        }
        return new String[]{o, ""};
    }
}

