/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.support.api.Bucket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SimpleReadOnlyArrayBucket
implements Bucket {
    final byte[] buf;
    final int offset;
    final int length;

    public SimpleReadOnlyArrayBucket(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    public SimpleReadOnlyArrayBucket(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Read only");
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.buf, this.offset, this.length);
    }

    public String getName() {
        return "SimpleReadOnlyArrayBucket: len=" + this.length + ' ' + super.toString();
    }

    public long size() {
        return this.length;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setReadOnly() {
    }

    public void free() {
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    public Bucket createShadow() throws IOException {
        if (this.buf.length < 262144) {
            byte[] newBuf = new byte[this.length];
            System.arraycopy(this.buf, this.offset, newBuf, 0, this.length);
            return new SimpleReadOnlyArrayBucket(newBuf);
        }
        return null;
    }
}

