/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.node.FSParseException;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.io.Closer;
import freenet.support.io.LineReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFieldSet {
    private final Map<String, String> values;
    private Map<String, SimpleFieldSet> subsets;
    private String endMarker;
    private final boolean shortLived;
    public static final char MULTI_LEVEL_CHAR = '.';
    public static final char MULTI_VALUE_CHAR = ';';
    public static final char KEYVALUE_SEPARATOR_CHAR = '=';
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public SimpleFieldSet(boolean shortLived) {
        this.values = new HashMap<String, String>();
        this.subsets = null;
        this.shortLived = shortLived;
    }

    public SimpleFieldSet(BufferedReader br, boolean allowMultiple, boolean shortLived) throws IOException {
        this(shortLived);
        this.read(br, allowMultiple);
    }

    public SimpleFieldSet(SimpleFieldSet sfs) {
        this.values = new HashMap<String, String>(sfs.values);
        if (sfs.subsets != null) {
            this.subsets = new HashMap<String, SimpleFieldSet>(sfs.subsets);
        }
        this.shortLived = false;
        this.endMarker = sfs.endMarker;
    }

    public SimpleFieldSet(LineReader lis, int maxLineLength, int lineBufferSize, boolean tolerant, boolean utf8OrIso88591, boolean allowMultiple, boolean shortLived) throws IOException {
        this(shortLived);
        this.read(lis, maxLineLength, lineBufferSize, tolerant, utf8OrIso88591, allowMultiple);
    }

    public SimpleFieldSet(String content, boolean allowMultiple, boolean shortLived) throws IOException {
        this(shortLived);
        StringReader sr = new StringReader(content);
        BufferedReader br = new BufferedReader(sr);
        this.read(br, allowMultiple);
    }

    private void read(BufferedReader br, boolean allowMultiple) throws IOException {
        String line;
        boolean firstLine = true;
        while (true) {
            if ((line = br.readLine()) == null) {
                if (firstLine) {
                    throw new EOFException();
                }
                throw new IOException("No end Marker!");
            }
            firstLine = false;
            int index = line.indexOf(61);
            if (index < 0) break;
            String before = line.substring(0, index);
            String after = line.substring(index + 1);
            if (!this.shortLived) {
                after = after.intern();
            }
            this.put(before, after, allowMultiple, false);
        }
        this.endMarker = line;
    }

    private void read(LineReader br, int maxLength, int bufferSize, boolean tolerant, boolean utfOrIso88591, boolean allowMultiple) throws IOException {
        String line;
        boolean firstLine = true;
        while (true) {
            if ((line = br.readLine(maxLength, bufferSize, utfOrIso88591)) == null) {
                if (firstLine) {
                    throw new EOFException();
                }
                if (!tolerant) {
                    throw new IOException("No end marker");
                }
                Logger.error(this, "No end marker");
                return;
            }
            if (line.length() == 0 && tolerant) continue;
            firstLine = false;
            int index = line.indexOf(61);
            if (index < 0) break;
            String before = line.substring(0, index);
            String after = line.substring(index + 1);
            if (!this.shortLived) {
                after = after.intern();
            }
            this.put(before, after, allowMultiple, false);
        }
        this.endMarker = line;
    }

    public synchronized String get(String key) {
        int idx = key.indexOf(46);
        if (idx == -1) {
            return this.values.get(key);
        }
        if (idx == 0) {
            return this.subset("") == null ? null : this.subset("").get(key.substring(1));
        }
        if (this.subsets == null) {
            return null;
        }
        String before = key.substring(0, idx);
        String after = key.substring(idx + 1);
        SimpleFieldSet fs = this.subsets.get(before);
        if (fs == null) {
            return null;
        }
        return fs.get(after);
    }

    public String[] getAll(String key) {
        String k = this.get(key);
        if (k == null) {
            return null;
        }
        return SimpleFieldSet.split(k);
    }

    private static final String[] split(String string) {
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        return string.split(String.valueOf(';'));
    }

    private static final String unsplit(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i != 0) {
                sb.append(';');
            }
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    public void putAllOverwrite(SimpleFieldSet fs) {
        for (String key : fs.values.keySet()) {
            String hisVal = fs.values.get(key);
            this.values.put(key, hisVal);
        }
        if (fs.subsets == null) {
            return;
        }
        if (this.subsets == null) {
            this.subsets = new HashMap<String, SimpleFieldSet>();
        }
        for (String key : fs.subsets.keySet()) {
            SimpleFieldSet hisFS = fs.subsets.get(key);
            SimpleFieldSet myFS = this.subsets.get(key);
            if (myFS != null) {
                myFS.putAllOverwrite(hisFS);
                continue;
            }
            this.subsets.put(key, hisFS);
        }
    }

    public void putSingle(String key, String value) {
        if (value == null) {
            return;
        }
        if (!this.shortLived) {
            value = value.intern();
        }
        if (!this.put(key, value, false, false)) {
            throw new IllegalStateException("Value already exists: " + value + " but want to set " + key + " to " + value);
        }
    }

    public void putAppend(String key, String value) {
        if (value == null) {
            return;
        }
        if (!this.shortLived) {
            value = value.intern();
        }
        this.put(key, value, true, false);
    }

    public void putOverwrite(String key, String value) {
        if (value == null) {
            return;
        }
        if (!this.shortLived) {
            value = value.intern();
        }
        this.put(key, value, false, true);
    }

    private final synchronized boolean put(String key, String value, boolean allowMultiple, boolean overwrite) {
        if (value == null) {
            return true;
        }
        if (value.indexOf(10) != -1) {
            throw new IllegalArgumentException("A simplefieldSet can't accept newlines !");
        }
        int idx = key.indexOf(46);
        if (idx == -1) {
            if (!this.shortLived) {
                key = key.intern();
            }
            if (overwrite) {
                this.values.put(key, value);
            } else if (this.values.get(key) == null) {
                this.values.put(key, value);
            } else {
                if (!allowMultiple) {
                    return false;
                }
                this.values.put(key, this.values.get(key) + ';' + value);
            }
        } else {
            String before = key.substring(0, idx);
            String after = key.substring(idx + 1);
            SimpleFieldSet fs = null;
            if (this.subsets == null) {
                this.subsets = new HashMap<String, SimpleFieldSet>();
            }
            if ((fs = this.subsets.get(before)) == null) {
                fs = new SimpleFieldSet(this.shortLived);
                if (!this.shortLived) {
                    before = before.intern();
                }
                this.subsets.put(before, fs);
            }
            fs.put(after, value, allowMultiple, overwrite);
        }
        return true;
    }

    public void put(String key, int value) {
        this.putSingle(key, Integer.toString(value));
    }

    public void put(String key, long value) {
        this.putSingle(key, Long.toString(value));
    }

    public void put(String key, short value) {
        this.putSingle(key, Short.toString(value));
    }

    public void put(String key, char c) {
        this.putSingle(key, Character.toString(c));
    }

    public void put(String key, boolean b) {
        this.put(key, Boolean.toString(b), false, false);
    }

    public void put(String key, double windowSize) {
        this.putSingle(key, Double.toString(windowSize));
    }

    public void writeTo(Writer w) throws IOException {
        this.writeTo(w, "", false);
    }

    synchronized void writeTo(Writer w, String prefix, boolean noEndMarker) throws IOException {
        String key;
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            key = entry.getKey();
            String value = entry.getValue();
            w.write(prefix);
            w.write(key);
            w.write(61);
            w.write(value);
            w.write(10);
        }
        if (this.subsets != null) {
            for (Map.Entry<String, Object> entry : this.subsets.entrySet()) {
                key = entry.getKey();
                SimpleFieldSet subset = (SimpleFieldSet)entry.getValue();
                if (subset == null) {
                    throw new NullPointerException();
                }
                subset.writeTo(w, prefix + key + '.', true);
            }
        }
        if (!noEndMarker) {
            if (this.endMarker == null) {
                w.write("End\n");
            } else {
                w.write(this.endMarker);
                w.write(10);
            }
        }
    }

    public void writeToOrdered(Writer w) throws IOException {
        this.writeToOrdered(w, "", false);
    }

    private synchronized void writeToOrdered(Writer w, String prefix, boolean noEndMarker) throws IOException {
        Object[] keys = this.values.keySet().toArray(new String[this.values.size()]);
        int i = 0;
        Arrays.sort(keys);
        for (i = 0; i < keys.length; ++i) {
            w.write(prefix + (String)keys[i] + '=' + this.get((String)keys[i]) + '\n');
        }
        if (this.subsets != null) {
            Object[] orderedPrefixes = this.subsets.keySet().toArray(new String[this.subsets.size()]);
            Arrays.sort(orderedPrefixes);
            for (i = 0; i < orderedPrefixes.length; ++i) {
                SimpleFieldSet subset = this.subset((String)orderedPrefixes[i]);
                if (subset == null) {
                    throw new NullPointerException();
                }
                subset.writeToOrdered(w, prefix + (String)orderedPrefixes[i] + '.', true);
            }
        }
        if (!noEndMarker) {
            if (this.endMarker == null) {
                w.write("End\n");
            } else {
                w.write(this.endMarker + '\n');
            }
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeTo(sw);
        }
        catch (IOException e) {
            Logger.error(this, "WTF?!: " + e + " in toString()!", e);
        }
        return sw.toString();
    }

    public String toOrderedString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeToOrdered(sw);
        }
        catch (IOException e) {
            Logger.error(this, "WTF?!: " + e + " in toString()!", e);
        }
        return sw.toString();
    }

    public String getEndMarker() {
        return this.endMarker;
    }

    public void setEndMarker(String s) {
        this.endMarker = s;
    }

    public synchronized SimpleFieldSet subset(String key) {
        if (this.subsets == null) {
            return null;
        }
        int idx = key.indexOf(46);
        if (idx == -1) {
            return this.subsets.get(key);
        }
        String before = key.substring(0, idx);
        String after = key.substring(idx + 1);
        SimpleFieldSet fs = this.subsets.get(before);
        if (fs == null) {
            return null;
        }
        return fs.subset(after);
    }

    public synchronized SimpleFieldSet getSubset(String key) throws FSParseException {
        SimpleFieldSet fs = this.subset(key);
        if (fs == null) {
            throw new FSParseException("No such subset " + key);
        }
        return fs;
    }

    public Iterator<String> keyIterator() {
        return new KeyIterator("");
    }

    public KeyIterator keyIterator(String prefix) {
        return new KeyIterator(prefix);
    }

    public Iterator<String> toplevelKeyIterator() {
        return this.values.keySet().iterator();
    }

    public void tput(String key, SimpleFieldSet fs) {
        if (fs == null || fs.isEmpty()) {
            return;
        }
        this.put(key, fs);
    }

    public void put(String key, SimpleFieldSet fs) {
        if (fs == null) {
            return;
        }
        if (fs.isEmpty()) {
            throw new IllegalArgumentException("Empty");
        }
        if (this.subsets == null) {
            this.subsets = new HashMap<String, SimpleFieldSet>();
        }
        if (this.subsets.containsKey(key)) {
            throw new IllegalArgumentException("Already contains " + key + " but trying to add a SimpleFieldSet!");
        }
        if (!this.shortLived) {
            key = key.intern();
        }
        this.subsets.put(key, fs);
    }

    public synchronized void removeValue(String key) {
        int idx = key.indexOf(46);
        if (idx == -1) {
            this.values.remove(key);
        } else {
            if (this.subsets == null) {
                return;
            }
            String before = key.substring(0, idx);
            String after = key.substring(idx + 1);
            SimpleFieldSet fs = this.subsets.get(before);
            if (fs == null) {
                return;
            }
            fs.removeValue(after);
            if (fs.isEmpty()) {
                this.subsets.remove(before);
                if (this.subsets.isEmpty()) {
                    this.subsets = null;
                }
            }
        }
    }

    public synchronized void removeSubset(String key) {
        if (this.subsets == null) {
            return;
        }
        int idx = key.indexOf(46);
        if (idx == -1) {
            this.subsets.remove(key);
        } else {
            String before = key.substring(0, idx);
            String after = key.substring(idx + 1);
            SimpleFieldSet fs = this.subsets.get(before);
            if (fs == null) {
                return;
            }
            fs.removeSubset(after);
            if (fs.isEmpty()) {
                this.subsets.remove(before);
                if (this.subsets.isEmpty()) {
                    this.subsets = null;
                }
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.values.isEmpty() && (this.subsets == null || this.subsets.isEmpty());
    }

    public Iterator<String> directSubsetNameIterator() {
        return this.subsets == null ? null : this.subsets.keySet().iterator();
    }

    public String[] namesOfDirectSubsets() {
        return this.subsets == null ? EMPTY_STRING_ARRAY : this.subsets.keySet().toArray(new String[this.subsets.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFieldSet readFrom(InputStream is, boolean allowMultiple, boolean shortLived) throws IOException {
        SimpleFieldSet simpleFieldSet;
        BufferedInputStream bis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            bis = new BufferedInputStream(is);
            try {
                isr = new InputStreamReader((InputStream)bis, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logger.error(SimpleFieldSet.class, "Impossible: " + e, e);
                is.close();
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            br = new BufferedReader(isr);
            SimpleFieldSet fs = new SimpleFieldSet(br, allowMultiple, shortLived);
            br.close();
            simpleFieldSet = fs;
        }
        catch (Throwable throwable) {
            Closer.close(br);
            Closer.close(isr);
            Closer.close(bis);
            throw throwable;
        }
        Closer.close(br);
        Closer.close(isr);
        Closer.close(bis);
        return simpleFieldSet;
    }

    public static SimpleFieldSet readFrom(File f, boolean allowMultiple, boolean shortLived) throws IOException {
        return SimpleFieldSet.readFrom(new FileInputStream(f), allowMultiple, shortLived);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream os) throws IOException {
        BufferedOutputStream bos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            bos = new BufferedOutputStream(os);
            try {
                osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logger.error(SimpleFieldSet.class, "Impossible: " + e, e);
                os.close();
                Closer.close(bw);
                Closer.close(osw);
                Closer.close(bos);
                return;
            }
        }
        catch (Throwable throwable) {
            Closer.close(bw);
            Closer.close(osw);
            Closer.close(bos);
            throw throwable;
        }
        bw = new BufferedWriter(osw);
        this.writeTo(bw);
        bw.flush();
        bw.close();
        Closer.close(bw);
        Closer.close(osw);
        Closer.close(bos);
    }

    public int getInt(String key, int def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public int getInt(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new FSParseException("Cannot parse " + s + " for integer " + key);
        }
    }

    public double getDouble(String key, double def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public double getDouble(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new FSParseException("Cannot parse " + s + " for integer " + key);
        }
    }

    public long getLong(String key, long def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public long getLong(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new FSParseException("Cannot parse " + s + " for long " + key);
        }
    }

    public short getShort(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException e) {
            throw new FSParseException("Cannot parse " + s + " for short " + key);
        }
    }

    public short getShort(String key, short def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public char getChar(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        throw new FSParseException("Cannot parse " + s + " for char " + key);
    }

    public char getChar(String key, char def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        return Fields.stringToBool(this.get(key), def);
    }

    public boolean getBoolean(String key) throws FSParseException {
        try {
            return Fields.stringToBool(this.get(key));
        }
        catch (NumberFormatException e) {
            throw new FSParseException(e);
        }
    }

    public void put(String key, int[] value) {
        this.removeValue(key);
        for (int v : value) {
            this.putAppend(key, String.valueOf(v));
        }
    }

    public void put(String key, double[] value) {
        this.removeValue(key);
        for (double v : value) {
            this.putAppend(key, String.valueOf(v));
        }
    }

    public int[] getIntArray(String key) {
        String[] strings = this.getAll(key);
        if (strings == null) {
            return null;
        }
        int[] ret = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ret[i] = Integer.parseInt(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Cannot parse " + strings[i] + " : " + e, e);
                return null;
            }
        }
        return ret;
    }

    public double[] getDoubleArray(String key) {
        String[] strings = this.getAll(key);
        if (strings == null) {
            return null;
        }
        double[] ret = new double[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ret[i] = Double.valueOf(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Cannot parse " + strings[i] + " : " + e, e);
                return null;
            }
        }
        return ret;
    }

    public void putOverwrite(String key, String[] strings) {
        this.putOverwrite(key, SimpleFieldSet.unsplit(strings));
    }

    public String getString(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No such element " + key);
        }
        return s;
    }

    public void removeFrom(ObjectContainer container) {
        container.delete(this.values);
        for (SimpleFieldSet fs : this.subsets.values()) {
            fs.removeFrom(container);
        }
        container.delete(this.subsets);
        container.delete((Object)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeyIterator
    implements Iterator<String> {
        final Iterator<String> valuesIterator;
        final Iterator<String> subsetIterator;
        KeyIterator subIterator;
        String prefix;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeyIterator(String prefix) {
            SimpleFieldSet simpleFieldSet2 = SimpleFieldSet.this;
            synchronized (simpleFieldSet2) {
                this.valuesIterator = SimpleFieldSet.this.values.keySet().iterator();
                this.subsetIterator = SimpleFieldSet.this.subsets != null ? SimpleFieldSet.this.subsets.keySet().iterator() : null;
                while ((this.valuesIterator == null || !this.valuesIterator.hasNext()) && this.subsetIterator != null && this.subsetIterator.hasNext()) {
                    SimpleFieldSet fs;
                    String name = this.subsetIterator.next();
                    if (name == null || (fs = (SimpleFieldSet)SimpleFieldSet.this.subsets.get(name)) == null) continue;
                    String newPrefix = prefix + name + '.';
                    this.subIterator = fs.keyIterator(newPrefix);
                    if (this.subIterator.hasNext()) break;
                    this.subIterator = null;
                }
                this.prefix = prefix;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            SimpleFieldSet simpleFieldSet = SimpleFieldSet.this;
            synchronized (simpleFieldSet) {
                while (true) {
                    if (this.valuesIterator.hasNext()) {
                        return true;
                    }
                    if (this.subIterator != null && this.subIterator.hasNext()) {
                        return true;
                    }
                    if (this.subIterator != null) {
                        this.subIterator = null;
                    }
                    if (this.subsetIterator == null || !this.subsetIterator.hasNext()) break;
                    String key = this.subsetIterator.next();
                    SimpleFieldSet fs = (SimpleFieldSet)SimpleFieldSet.this.subsets.get(key);
                    String newPrefix = this.prefix + key + '.';
                    this.subIterator = fs.keyIterator(newPrefix);
                }
                return false;
            }
        }

        @Override
        public final String next() {
            return this.nextKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String nextKey() {
            SimpleFieldSet simpleFieldSet = SimpleFieldSet.this;
            synchronized (simpleFieldSet) {
                String ret = null;
                if (this.valuesIterator != null && this.valuesIterator.hasNext()) {
                    return this.prefix + this.valuesIterator.next();
                }
                while (true) {
                    if (this.subIterator != null && this.subIterator.hasNext()) {
                        if (ret != null) {
                            return ret;
                        }
                        ret = this.subIterator.next();
                        if (this.subIterator.hasNext() && ret != null) {
                            return ret;
                        }
                    }
                    this.subIterator = null;
                    if (this.subsetIterator == null || !this.subsetIterator.hasNext()) break;
                    String key = this.subsetIterator.next();
                    SimpleFieldSet fs = (SimpleFieldSet)SimpleFieldSet.this.subsets.get(key);
                    String newPrefix = this.prefix + key + '.';
                    this.subIterator = fs.keyIterator(newPrefix);
                }
                if (ret == null) {
                    Logger.error(this, "Returning null from KeyIterator.nextKey() - should never happen!");
                }
                return ret;
            }
        }

        @Override
        public synchronized void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

