/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.io.WritableToDataOutputStream;
import freenet.support.Fields;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class ShortBuffer
implements WritableToDataOutputStream {
    public static final String VERSION = "$Id: ShortBuffer.java,v 1.2 2005/08/25 17:28:19 amphibian Exp $";
    private final byte[] _data;
    private final int _start;
    private final short _length;

    public ShortBuffer(DataInput dis) throws IOException {
        this._length = dis.readShort();
        if (this._length < 0) {
            throw new IllegalArgumentException("Negative Length: " + this._length);
        }
        this._data = new byte[this._length];
        this._start = 0;
        dis.readFully(this._data);
    }

    public ShortBuffer(byte[] data) {
        if (data.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Too big: " + data.length);
        }
        this._start = 0;
        this._length = (short)data.length;
        this._data = data;
    }

    public ShortBuffer(byte[] data, int start, int length) {
        if (length > Short.MAX_VALUE || length < 0 || start < 0 || start + length > data.length) {
            throw new IllegalArgumentException("Invalid Length: start=" + start + ", length=" + length);
        }
        this._start = start;
        this._data = data;
        this._length = (short)length;
    }

    public byte[] getData() {
        if (this._start == 0 && this._length == this._data.length) {
            return this._data;
        }
        byte[] r = new byte[this._length];
        System.arraycopy(this._data, this._start, r, 0, this._length);
        return r;
    }

    public void copyTo(byte[] array, int position) {
        System.arraycopy(this._data, this._start, array, position, this._length);
    }

    public byte byteAt(int pos) {
        if (pos >= this._length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._data[pos + this._start];
    }

    public void writeToDataOutputStream(DataOutputStream stream) throws IOException {
        stream.writeShort(this._length);
        stream.write(this._data, this._start, this._length);
    }

    public String toString() {
        if (this._length > 50) {
            return "Buffer {" + this._length + '}';
        }
        StringBuilder b = new StringBuilder(this._length * 3);
        b.append('{').append(this._length).append(':');
        for (int x = 0; x < this._length; ++x) {
            b.append(this.byteAt(x));
            b.append(' ');
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShortBuffer)) {
            return false;
        }
        ShortBuffer buffer = (ShortBuffer)o;
        if (this._length != buffer._length) {
            return false;
        }
        if (this._start != buffer._start) {
            return false;
        }
        return Arrays.equals(this._data, buffer._data);
    }

    public int hashCode() {
        return Fields.hashCode(this._data) ^ this._start ^ this._length << 16;
    }

    public int getLength() {
        return this._length;
    }
}

