/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.io.WritableToDataOutputStream;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerContext;
import freenet.keys.Key;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.support.BitArray;
import freenet.support.Buffer;
import freenet.support.ShortBuffer;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Serializer {
    public static final String VERSION = "$Id: Serializer.java,v 1.5 2005/09/15 18:16:04 amphibian Exp $";
    public static final int MAX_BITARRAY_SIZE = 16384;

    public static List<Object> readListFromDataInputStream(Class<?> elementType, DataInput dis) throws IOException {
        LinkedList<Object> ret = new LinkedList<Object>();
        int length = dis.readInt();
        for (int x = 0; x < length; ++x) {
            ret.add(Serializer.readFromDataInputStream(elementType, dis));
        }
        return ret;
    }

    public static Object readFromDataInputStream(Class<?> type, DataInput dis) throws IOException {
        if (type.equals(Boolean.class)) {
            byte bool = dis.readByte();
            if (bool == 1) {
                return Boolean.TRUE;
            }
            if (bool == 0) {
                return Boolean.FALSE;
            }
            throw new IOException("Boolean is non boolean value: " + bool);
        }
        if (type.equals(Byte.class)) {
            byte b = dis.readByte();
            return b;
        }
        if (type.equals(Short.class)) {
            return dis.readShort();
        }
        if (type.equals(Integer.class)) {
            return dis.readInt();
        }
        if (type.equals(Long.class)) {
            return dis.readLong();
        }
        if (type.equals(Double.class)) {
            return dis.readDouble();
        }
        if (type.equals(String.class)) {
            int length = dis.readInt();
            StringBuilder sb = new StringBuilder(length);
            for (int x = 0; x < length; ++x) {
                sb.append(dis.readChar());
            }
            return sb.toString();
        }
        if (type.equals(Buffer.class)) {
            return new Buffer(dis);
        }
        if (type.equals(ShortBuffer.class)) {
            return new ShortBuffer(dis);
        }
        if (type.equals(Peer.class)) {
            return new Peer(dis);
        }
        if (type.equals(BitArray.class)) {
            return new BitArray(dis, 16384);
        }
        if (type.equals(NodeCHK.class)) {
            return Key.read(dis);
        }
        if (type.equals(NodeSSK.class)) {
            return Key.read(dis);
        }
        if (type.equals(Key.class)) {
            return Key.read(dis);
        }
        throw new RuntimeException("Unrecognised field type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToDataOutputStream(Object object, DataOutputStream dos, PeerContext ctx) throws IOException {
        Class<?> type = object.getClass();
        if (type.equals(Long.class)) {
            dos.writeLong((Long)object);
        } else if (type.equals(Boolean.class)) {
            dos.write((Boolean)object != false ? 1 : 0);
        } else if (type.equals(Integer.class)) {
            dos.writeInt((Integer)object);
        } else if (type.equals(Short.class)) {
            dos.writeShort(((Short)object).shortValue());
        } else if (type.equals(Double.class)) {
            dos.writeDouble((Double)object);
        } else if (WritableToDataOutputStream.class.isAssignableFrom(type)) {
            WritableToDataOutputStream b = (WritableToDataOutputStream)object;
            b.writeToDataOutputStream(dos);
        } else if (type.equals(String.class)) {
            String s = (String)object;
            dos.writeInt(s.length());
            for (int x = 0; x < s.length(); ++x) {
                dos.writeChar(s.charAt(x));
            }
        } else if (type.equals(LinkedList.class)) {
            LinkedList ll = (LinkedList)object;
            dos.writeInt(ll.size());
            LinkedList linkedList = ll;
            synchronized (linkedList) {
                for (Object o : ll) {
                    Serializer.writeToDataOutputStream(o, dos, ctx);
                }
            }
        } else if (type.equals(Byte.class)) {
            dos.write(((Byte)object).byteValue());
        } else {
            throw new RuntimeException("Unrecognised field type: " + type);
        }
    }
}

