/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SerialExecutor
implements Executor {
    private static volatile boolean logMINOR;
    private final LinkedBlockingQueue<Runnable> jobs;
    private final Object syncLock;
    private final int priority;
    private volatile boolean threadWaiting;
    private volatile boolean threadStarted;
    private String name;
    private Executor realExecutor;
    private static final int NEWJOB_TIMEOUT = 300000;
    private final Runnable runner = new PrioRunnable(){

        public int getPriority() {
            return SerialExecutor.this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = SerialExecutor.this.syncLock;
                synchronized (object) {
                    SerialExecutor.this.threadWaiting = true;
                }
                Runnable job = null;
                try {
                    job = (Runnable)SerialExecutor.this.jobs.poll(300000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                Object e = SerialExecutor.this.syncLock;
                synchronized (e) {
                    SerialExecutor.this.threadWaiting = false;
                }
                if (job == null) {
                    e = SerialExecutor.this.syncLock;
                    synchronized (e) {
                        SerialExecutor.this.threadStarted = false;
                    }
                    return;
                }
                try {
                    job.run();
                    continue;
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t, t);
                    Logger.error(this, "While running " + job + " on " + this);
                    continue;
                }
                break;
            }
        }
    };

    public SerialExecutor(int priority) {
        this.jobs = new LinkedBlockingQueue();
        this.priority = priority;
        this.syncLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Executor realExecutor, String name) {
        this.realExecutor = realExecutor;
        this.name = name;
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.jobs.isEmpty()) {
                this.reallyStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyStart() {
        Object object = this.syncLock;
        synchronized (object) {
            this.threadStarted = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Starting thread... " + this.name + " : " + this.runner);
        }
        this.realExecutor.execute(this.runner, this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable job, String jobName) {
        if (logMINOR) {
            Logger.minor(this, "Running " + jobName + " : " + job + " started=" + this.threadStarted + " waiting=" + this.threadWaiting);
        }
        this.jobs.add(job);
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.threadStarted && this.realExecutor != null) {
                this.reallyStart();
            }
        }
    }

    public void execute(Runnable job, String jobName, boolean fromTicker) {
        this.execute(job, jobName);
    }

    public int[] runningThreads() {
        int[] retval = new int[10];
        if (this.threadStarted && !this.threadWaiting) {
            retval[this.priority] = 1;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] waitingThreads() {
        int[] retval = new int[10];
        Object object = this.syncLock;
        synchronized (object) {
            if (this.threadStarted && this.threadWaiting) {
                retval[this.priority] = 1;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitingThreadsCount() {
        Object object = this.syncLock;
        synchronized (object) {
            return this.threadStarted && this.threadWaiting ? 1 : 0;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

