/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RandomGrabArrayItemExclusionList;
import freenet.support.RandomGrabArrayWithClient;
import freenet.support.RemoveRandom;
import freenet.support.RemoveRandomParent;
import freenet.support.RemoveRandomWithObject;

public class SectoredRandomGrabArray
implements RemoveRandom,
RemoveRandomParent {
    private static volatile boolean logMINOR;
    private RemoveRandomWithObject[] grabArrays;
    private Object[] grabClients;
    private final boolean persistent;
    private final RemoveRandomParent parent;

    public SectoredRandomGrabArray(boolean persistent, ObjectContainer container, RemoveRandomParent parent) {
        this.persistent = persistent;
        this.grabClients = new Object[0];
        this.grabArrays = new RemoveRandomWithObject[0];
        this.parent = parent;
    }

    public synchronized void add(Object client, RandomGrabArrayItem item, ObjectContainer container) {
        RandomGrabArrayWithClient rga;
        if (item.persistent() != this.persistent) {
            throw new IllegalArgumentException("item.persistent()=" + item.persistent() + " but array.persistent=" + this.persistent + " item=" + item + " array=" + this);
        }
        int clientIndex = this.haveClient(client);
        if (clientIndex == -1) {
            if (logMINOR) {
                Logger.minor(this, "Adding new RGAWithClient for " + client + " on " + this + " for " + item);
            }
            rga = new RandomGrabArrayWithClient(client, this.persistent, container, this);
            this.addElement(client, rga);
            if (this.persistent) {
                container.store((Object)rga);
                container.store((Object)this);
            }
        } else {
            rga = (RandomGrabArrayWithClient)this.grabArrays[clientIndex];
            if (this.persistent) {
                container.activate((Object)rga, 1);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Adding " + item + " to RGA " + rga + " for " + client);
        }
        rga.add(item, container);
        if (this.persistent) {
            container.deactivate((Object)rga, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Size now " + this.grabArrays.length + " on " + this);
        }
    }

    private void addElement(Object client, RemoveRandomWithObject rga) {
        int len = this.grabArrays.length;
        RemoveRandomWithObject[] newArrays = new RemoveRandomWithObject[len + 1];
        System.arraycopy(this.grabArrays, 0, newArrays, 0, len);
        newArrays[len] = rga;
        this.grabArrays = newArrays;
        Object[] newClients = new Object[len + 1];
        System.arraycopy(this.grabClients, 0, newClients, 0, len);
        newClients[len] = client;
        this.grabClients = newClients;
    }

    private synchronized int haveClient(Object client) {
        for (int i = 0; i < this.grabClients.length; ++i) {
            if (this.grabClients[i] != client) continue;
            return i;
        }
        return -1;
    }

    public synchronized RemoveRandomWithObject getGrabber(Object client) {
        int idx = this.haveClient(client);
        if (idx == -1) {
            return null;
        }
        return this.grabArrays[idx];
    }

    public synchronized Object getClient(int x) {
        return this.grabClients[x];
    }

    public synchronized void addGrabber(Object client, RemoveRandomWithObject requestGrabber, ObjectContainer container) {
        if (requestGrabber.getObject() != client) {
            throw new IllegalArgumentException("Client not equal to RemoveRandomWithObject's client: client=" + client + " rr=" + requestGrabber + " his object=" + requestGrabber.getObject());
        }
        this.addElement(client, requestGrabber);
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    public synchronized RandomGrabArrayItem removeRandom(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context) {
        RandomGrabArrayItem item;
        int excluded = 0;
        int MAX_EXCLUDED = 10;
        while (true) {
            RemoveRandomWithObject rga;
            int x;
            if (this.grabArrays.length == 0) {
                return null;
            }
            if (this.grabArrays.length == 1) {
                RemoveRandomWithObject rga2 = this.grabArrays[0];
                if (this.persistent) {
                    container.activate((Object)rga2, 1);
                }
                RandomGrabArrayItem item2 = rga2.removeRandom(excluding, container, context);
                if (rga2.isEmpty()) {
                    if (logMINOR) {
                        Logger.minor(this, "Removing only grab array (0) : " + rga2);
                    }
                    this.grabArrays = new RemoveRandomWithObject[0];
                    this.grabClients = new Object[0];
                    if (this.persistent) {
                        container.store((Object)this);
                        rga2.removeFrom(container);
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Returning (one item only) " + item2 + " for " + rga2);
                }
                return item2;
            }
            if (this.grabArrays.length == 2) {
                RandomGrabArrayItem item3;
                x = context.fastWeakRandom.nextBoolean() ? 1 : 0;
                rga = this.grabArrays[x];
                if (this.persistent) {
                    container.activate((Object)rga, 1);
                }
                RemoveRandomWithObject firstRGA = rga;
                if (rga == null) {
                    Logger.error(this, "rga = null on " + this);
                    if (container != null && !container.ext().isActive((Object)this)) {
                        Logger.error(this, "NOT ACTIVE!!");
                    }
                    if (this.grabArrays[1 - x] == null) {
                        Logger.error(this, "other rga is also null on " + this);
                    } else {
                        RemoveRandomWithObject valid = this.grabArrays[1 - x];
                        Logger.error(this, "grabArrays[" + (1 - x) + "] is valid but [" + x + "] is null, correcting...");
                        this.grabArrays = new RemoveRandomWithObject[]{this.grabArrays[1 - x]};
                        this.grabClients = new Object[]{this.grabClients[1 - x]};
                        if (!this.persistent) continue;
                        container.store((Object)this);
                        continue;
                    }
                }
                if ((item3 = rga.removeRandom(excluding, container, context)) == null) {
                    x = 1 - x;
                    rga = this.grabArrays[x];
                    if (this.persistent) {
                        container.activate((Object)rga, 1);
                    }
                    item3 = rga.removeRandom(excluding, container, context);
                    if (firstRGA.isEmpty() && rga.isEmpty()) {
                        this.grabArrays = new RemoveRandomWithObject[0];
                        this.grabClients = new Object[0];
                        if (this.persistent) {
                            container.store((Object)this);
                            firstRGA.removeFrom(container);
                            rga.removeFrom(container);
                        }
                    } else if (firstRGA.isEmpty()) {
                        if (this.persistent) {
                            container.activate((Object)firstRGA, 1);
                        }
                        this.grabArrays = new RemoveRandomWithObject[]{rga};
                        this.grabClients = new Object[]{this.grabClients[x]};
                        if (this.persistent) {
                            container.store((Object)this);
                            firstRGA.removeFrom(container);
                        }
                    }
                    if (this.persistent) {
                        container.deactivate((Object)rga, 1);
                        container.deactivate((Object)firstRGA, 1);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Returning (two items only) " + item3 + " for " + rga);
                    }
                    return item3;
                }
                if (this.persistent) {
                    container.deactivate((Object)rga, 1);
                }
                if (logMINOR) {
                    Logger.minor(this, "Returning (two items only) " + item3 + " for " + rga);
                }
                return item3;
            }
            x = context.fastWeakRandom.nextInt(this.grabArrays.length);
            rga = this.grabArrays[x];
            if (this.persistent) {
                container.activate((Object)rga, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Picked " + x + " of " + this.grabArrays.length + " : " + rga + " on " + this);
            }
            item = rga.removeRandom(excluding, container, context);
            if (logMINOR) {
                Logger.minor(this, "RGA has picked " + x + "/" + this.grabArrays.length + ": " + item + (item == null ? "" : " cancelled=" + item.isEmpty(container) + ")") + " rga.isEmpty=" + rga.isEmpty());
            }
            if (rga.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "Removing grab array " + x + " : " + rga + " (is empty)");
                }
                this.removeElement(x);
                if (this.persistent) {
                    container.store((Object)this);
                    rga.removeFrom(container);
                }
            }
            if (item == null) {
                if (!rga.isEmpty() && ++excluded > 10) {
                    Logger.normal(this, "Too many sub-arrays are entirely excluded on " + this + " length = " + this.grabArrays.length, new Exception("error"));
                    if (this.persistent) {
                        container.deactivate((Object)rga, 1);
                    }
                    return null;
                }
                if (!this.persistent) continue;
                container.deactivate((Object)rga, 1);
                continue;
            }
            if (this.persistent) {
                container.deactivate((Object)rga, 1);
            }
            if (!item.isEmpty(container)) break;
        }
        return item;
    }

    private synchronized void removeElement(int x) {
        int grabArraysLength = this.grabArrays.length;
        int newLen = grabArraysLength > 1 ? grabArraysLength - 1 : 0;
        RemoveRandomWithObject[] newArray = new RemoveRandomWithObject[newLen];
        if (x > 0) {
            System.arraycopy(this.grabArrays, 0, newArray, 0, x);
        }
        if (x < grabArraysLength - 1) {
            System.arraycopy(this.grabArrays, x + 1, newArray, x, grabArraysLength - (x + 1));
        }
        this.grabArrays = newArray;
        Object[] newClients = new Object[newLen];
        if (x > 0) {
            System.arraycopy(this.grabClients, 0, newClients, 0, x);
        }
        if (x < grabArraysLength - 1) {
            System.arraycopy(this.grabClients, x + 1, newClients, x, grabArraysLength - (x + 1));
        }
        this.grabClients = newClients;
    }

    public synchronized boolean isEmpty() {
        return this.grabArrays.length == 0;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public int size() {
        return this.grabArrays.length;
    }

    public void removeFrom(ObjectContainer container) {
        if (this.grabArrays != null && this.grabArrays.length != 0) {
            for (RemoveRandomWithObject rr : this.grabArrays) {
                if (rr == null) continue;
                Logger.error(this, "NOT EMPTY REMOVING " + this + " : " + rr);
                return;
            }
        }
        container.delete((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeRemove(RemoveRandom r, ObjectContainer container) {
        int count = 0;
        SectoredRandomGrabArray sectoredRandomGrabArray = this;
        synchronized (sectoredRandomGrabArray) {
            while (true) {
                int found = -1;
                for (int i = 0; i < this.grabArrays.length; ++i) {
                    if (this.grabArrays[i] != r) continue;
                    found = i;
                    break;
                }
                if (found == -1) break;
                if (++count > 1) {
                    Logger.error(this, "Found " + r + " many times in " + this, new Exception("error"));
                }
                this.removeElement(found);
            }
        }
        if (count == 0) {
            Logger.error(this, "Not in parent: " + r + " for " + this, new Exception("error"));
        } else if (this.persistent) {
            container.store((Object)this);
            r.removeFrom(container);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

