/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RandomGrabArrayItemExclusionList;
import freenet.support.RemoveRandom;
import freenet.support.RemoveRandomParent;

public class RandomGrabArray
implements RemoveRandom {
    private static volatile boolean logMINOR;
    private Block[] blocks = new Block[]{new Block()};
    private int index;
    private static final int MIN_SIZE = 32;
    private static final int BLOCK_SIZE = 1024;
    private final boolean persistent;
    private final int hashCode;
    private final RemoveRandomParent parent;

    public RandomGrabArray(boolean persistent, ObjectContainer container, RemoveRandomParent parent) {
        this.blocks[0].reqs = new RandomGrabArrayItem[32];
        this.persistent = persistent;
        this.index = 0;
        this.hashCode = super.hashCode();
        this.parent = parent;
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RandomGrabArrayItem req, ObjectContainer container) {
        if (req.persistent() != this.persistent) {
            throw new IllegalArgumentException("req.persistent()=" + req.persistent() + " but array.persistent=" + this.persistent + " item=" + req + " array=" + this);
        }
        if (req.isEmpty(container)) {
            if (logMINOR) {
                Logger.minor(this, "Is finished already: " + req);
            }
            return;
        }
        req.setParentGrabArray(this, container);
        RandomGrabArray randomGrabArray = this;
        synchronized (randomGrabArray) {
            int i;
            int x = 0;
            if (this.blocks.length == 1 && this.index < 1024) {
                if (this.persistent) {
                    container.activate((Object)this.blocks[0], 1);
                }
                for (int i2 = 0; i2 < this.index; ++i2) {
                    if (this.blocks[0].reqs[i2] != req) continue;
                    if (this.persistent) {
                        container.deactivate((Object)this.blocks[0], 1);
                    }
                    return;
                }
                if (this.index >= this.blocks[0].reqs.length) {
                    int newSize = Math.min(1024, this.blocks[0].reqs.length * 2);
                    RandomGrabArrayItem[] newReqs = new RandomGrabArrayItem[newSize];
                    System.arraycopy(this.blocks[0].reqs, 0, newReqs, 0, this.blocks[0].reqs.length);
                    this.blocks[0].reqs = newReqs;
                }
                this.blocks[0].reqs[this.index++] = req;
                if (this.persistent) {
                    container.store((Object)this.blocks[0]);
                    container.store((Object)this);
                    container.deactivate((Object)this.blocks[0], 1);
                }
                return;
            }
            int targetBlock = this.index / 1024;
            for (int i3 = 0; i3 < this.blocks.length; ++i3) {
                Block block = this.blocks[i3];
                if (this.persistent) {
                    container.activate((Object)block, 1);
                }
                if (i3 != this.blocks.length - 1 && block.reqs.length != 1024) {
                    Logger.error(this, "Block " + i3 + " of " + this.blocks.length + " is wrong size: " + block.reqs.length + " should be " + 1024);
                }
                for (int j = 0; j < block.reqs.length && x < this.index; ++x, ++j) {
                    if (block.reqs[j] == req) {
                        if (logMINOR) {
                            Logger.minor(this, "Already contains " + req + " : " + this + " size now " + this.index);
                        }
                        if (this.persistent) {
                            container.deactivate((Object)block, 1);
                        }
                        return;
                    }
                    if (block.reqs[j] != null) continue;
                    Logger.error(this, "reqs[" + i3 + "." + j + "] = null on " + this);
                }
                if (!this.persistent || i3 == targetBlock) continue;
                container.deactivate((Object)block, 1);
            }
            int oldBlockLen = this.blocks.length;
            if (this.blocks.length <= targetBlock) {
                if (logMINOR) {
                    Logger.minor(this, "Adding blocks on " + this);
                }
                Block[] newBlocks = new Block[targetBlock + 1];
                System.arraycopy(this.blocks, 0, newBlocks, 0, this.blocks.length);
                for (i = this.blocks.length; i < newBlocks.length; ++i) {
                    newBlocks[i] = new Block();
                    newBlocks[i].reqs = new RandomGrabArrayItem[1024];
                }
                this.blocks = newBlocks;
            } else if (this.persistent) {
                container.activate((Object)this.blocks[targetBlock], 1);
            }
            Block target = this.blocks[targetBlock];
            target.reqs[this.index++ % 1024] = req;
            if (this.persistent) {
                for (i = oldBlockLen; i < this.blocks.length; ++i) {
                    container.store((Object)this.blocks[i]);
                }
                container.store((Object)this);
                container.store((Object)target);
                for (i = oldBlockLen; i < this.blocks.length; ++i) {
                    container.deactivate((Object)this.blocks[i], 1);
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Added: " + req + " to " + this + " size now " + this.index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomGrabArrayItem removeRandom(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context) {
        RandomGrabArrayItem ret;
        if (logMINOR) {
            Logger.minor(this, "removeRandom() on " + this + " index=" + this.index);
        }
        RandomGrabArray randomGrabArray = this;
        synchronized (randomGrabArray) {
            int lastActiveBlock = -1;
            int MAX_EXCLUDED = 10;
            int excluded = 0;
            boolean changedMe = false;
            while (true) {
                if (this.index == 0) {
                    if (logMINOR) {
                        Logger.minor(this, "All null on " + this);
                    }
                    return null;
                }
                if (this.index < 10) {
                    int random = -1;
                    if (this.persistent) {
                        container.activate((Object)this.blocks[0], 1);
                    }
                    RandomGrabArrayItem[] reqs = this.blocks[0].reqs;
                    while (true) {
                        int exclude = 0;
                        int valid = 0;
                        int validIndex = -1;
                        int target = 0;
                        int chosenIndex = -1;
                        RandomGrabArrayItem chosenItem = null;
                        RandomGrabArrayItem validItem = null;
                        for (int i = 0; i < this.index; ++i) {
                            RandomGrabArrayItem item = reqs[i];
                            if (this.persistent) {
                                container.activate((Object)item, 1);
                            }
                            if (item == null) continue;
                            if (item.isEmpty(container)) {
                                changedMe = true;
                                reqs[i] = null;
                                item.setParentGrabArray(null, container);
                                if (!this.persistent) continue;
                                container.deactivate((Object)item, 1);
                                continue;
                            }
                            if (i != target) {
                                changedMe = true;
                                reqs[i] = null;
                                reqs[target] = item;
                            }
                            ++target;
                            if (excluding.exclude(item, container, context)) {
                                ++exclude;
                            } else {
                                if (valid == random) {
                                    chosenIndex = target - 1;
                                    chosenItem = item;
                                }
                                if (validIndex == -1) {
                                    validIndex = target - 1;
                                    validItem = item;
                                }
                                ++valid;
                            }
                            if (!this.persistent || item == chosenItem || item == validItem) continue;
                            if (logMINOR) {
                                Logger.minor(this, "Deactivating " + item);
                            }
                            container.deactivate((Object)item, 1);
                            if (container.ext().isActive((Object)item)) {
                                Logger.error(this, "Still active after deactivation: " + item);
                                continue;
                            }
                            if (!logMINOR) continue;
                            Logger.minor(this, "Deactivated: " + item);
                        }
                        if (this.index != target) {
                            changedMe = true;
                            this.index = target;
                        }
                        if (chosenItem != null) {
                            if (this.persistent && validItem != null && validItem != chosenItem) {
                                container.deactivate(validItem, 1);
                            }
                            changedMe = true;
                            ret = chosenItem;
                            assert (ret == reqs[chosenIndex]);
                            if (logMINOR) {
                                Logger.minor(this, "Chosen random item " + ret + " out of " + valid + " total " + this.index);
                            }
                            if (this.persistent && changedMe) {
                                container.store((Object)this.blocks[0]);
                                container.store((Object)this);
                            }
                            return ret;
                        }
                        if (valid == 0 && exclude == 0) {
                            this.index = 0;
                            if (this.persistent) {
                                container.store((Object)this.blocks[0]);
                                container.store((Object)this);
                            }
                            if (logMINOR) {
                                Logger.minor(this, "No valid or excluded items total " + this.index);
                            }
                            return null;
                        }
                        if (valid == 0) {
                            if (this.persistent && changedMe) {
                                container.store((Object)this.blocks[0]);
                                container.store((Object)this);
                            }
                            if (logMINOR) {
                                Logger.minor(this, "No valid items, " + exclude + " excluded items total " + this.index);
                            }
                            return null;
                        }
                        if (valid == 1) {
                            ret = validItem;
                            assert (ret == reqs[validIndex]);
                            if (logMINOR) {
                                Logger.minor(this, "No valid or excluded items apart from " + ret + " total " + this.index);
                            }
                            if (this.persistent && changedMe) {
                                container.store((Object)this.blocks[0]);
                                container.store((Object)this);
                            }
                            return ret;
                        }
                        random = context.fastWeakRandom.nextInt(valid);
                    }
                }
                int i = context.fastWeakRandom.nextInt(this.index);
                int blockNo = i / 1024;
                if (this.persistent && blockNo != lastActiveBlock) {
                    if (lastActiveBlock != -1) {
                        container.deactivate((Object)this.blocks[lastActiveBlock], 1);
                    }
                    lastActiveBlock = blockNo;
                    container.activate((Object)this.blocks[blockNo], 1);
                }
                if ((ret = this.blocks[blockNo].reqs[i % 1024]) == null) {
                    Logger.error(this, "reqs[" + i + "] = null");
                    this.remove(blockNo, i, container);
                    changedMe = true;
                    continue;
                }
                if (this.persistent) {
                    container.activate((Object)ret, 1);
                }
                RandomGrabArrayItem oret = ret;
                if (ret.isEmpty(container)) {
                    if (logMINOR) {
                        Logger.minor(this, "Not returning because cancelled: " + ret);
                    }
                    ret = null;
                    oret.setParentGrabArray(null, container);
                }
                if (ret != null && excluding.exclude(ret, container, context)) {
                    ++excluded;
                    if (this.persistent) {
                        container.deactivate((Object)ret, 1);
                    }
                    if (excluded <= 10) continue;
                    Logger.normal(this, "Remove random returning null because " + excluded + " excluded items, length = " + this.index, new Exception("error"));
                    if (this.persistent && changedMe) {
                        container.store((Object)this);
                    }
                    return null;
                }
                if (ret != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Returning (cannot remove): " + ret + " of " + this.index);
                    }
                    if (this.persistent && changedMe) {
                        container.store((Object)this);
                    }
                    return ret;
                }
                do {
                    changedMe = true;
                    this.remove(blockNo, i, container);
                    if (this.persistent && oret != null && ret == null) {
                        container.deactivate((Object)oret, 1);
                    }
                    oret = this.blocks[blockNo].reqs[i % 1024];
                } while (this.index > i && oret == null);
                if (this.blocks.length == 1 && this.index < this.blocks[0].reqs.length / 4) {
                    changedMe = true;
                    int newSize = Math.max(this.index * 2, 32);
                    RandomGrabArrayItem[] r = new RandomGrabArrayItem[newSize];
                    System.arraycopy(this.blocks[0].reqs, 0, r, 0, r.length);
                    this.blocks[0].reqs = r;
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                } else if (this.blocks.length > 1 && (this.index + 512) / 1024 + 1 < this.blocks.length) {
                    if (logMINOR) {
                        Logger.minor(this, "Shrinking blocks on " + this);
                    }
                    Block[] newBlocks = new Block[(this.index + 512) / 1024 + 1];
                    System.arraycopy(this.blocks, 0, newBlocks, 0, newBlocks.length);
                    if (this.persistent) {
                        container.store((Object)this);
                        for (int x = newBlocks.length; x < this.blocks.length; ++x) {
                            container.delete((Object)this.blocks[x]);
                        }
                    }
                    this.blocks = newBlocks;
                }
                if (ret != null) break;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Returning " + ret + " of " + this.index);
        }
        ret.setParentGrabArray(null, container);
        if (this.persistent) {
            container.store((Object)this);
        }
        return ret;
    }

    private void remove(int blockNo, int i, ObjectContainer container) {
        --this.index;
        int endBlock = this.index / 1024;
        if (this.blocks.length == 1 || blockNo == endBlock) {
            RandomGrabArrayItem[] items = this.blocks[blockNo].reqs;
            int idx = this.index % 1024;
            items[i % 1024] = items[idx];
            items[idx] = null;
            if (this.persistent) {
                container.store((Object)this.blocks[blockNo]);
            }
        } else {
            RandomGrabArrayItem[] toItems = this.blocks[blockNo].reqs;
            if (this.persistent) {
                container.activate((Object)this.blocks[endBlock], 1);
            }
            RandomGrabArrayItem[] endItems = this.blocks[endBlock].reqs;
            toItems[i % 1024] = endItems[this.index % 1024];
            endItems[this.index % 1024] = null;
            if (this.persistent) {
                container.store((Object)this.blocks[blockNo]);
                container.store((Object)this.blocks[endBlock]);
                container.deactivate((Object)this.blocks[endBlock], 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RandomGrabArrayItem it, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Removing " + it + " from " + this);
        }
        boolean matched = false;
        boolean empty = false;
        RandomGrabArray randomGrabArray = this;
        synchronized (randomGrabArray) {
            if (this.blocks.length == 1) {
                Block block = this.blocks[0];
                if (this.persistent) {
                    container.activate((Object)block, 1);
                }
                for (int i = 0; i < this.index; ++i) {
                    if (block.reqs[i] != it) continue;
                    block.reqs[i] = block.reqs[--this.index];
                    block.reqs[this.index] = null;
                    matched = true;
                    if (!this.persistent) break;
                    container.store((Object)block);
                    break;
                }
                if (this.index == 0) {
                    empty = true;
                }
                if (this.persistent) {
                    container.deactivate((Object)block, 1);
                }
            } else {
                int x = 0;
                for (int i = 0; i < this.blocks.length; ++i) {
                    Block block = this.blocks[i];
                    if (this.persistent) {
                        container.activate((Object)block, 1);
                    }
                    for (int j = 0; j < block.reqs.length && x < this.index; ++x, ++j) {
                        if (block.reqs[i] != it) continue;
                        int pullFrom = --this.index;
                        int idx = pullFrom % 1024;
                        int endBlock = pullFrom / 1024;
                        if (i == endBlock) {
                            block.reqs[j] = block.reqs[idx];
                            block.reqs[idx] = null;
                        } else {
                            Block fromBlock = this.blocks[endBlock];
                            if (this.persistent) {
                                container.activate((Object)fromBlock, 1);
                            }
                            block.reqs[j] = fromBlock.reqs[idx];
                            fromBlock.reqs[idx] = null;
                            if (this.persistent) {
                                container.store((Object)fromBlock);
                                container.deactivate((Object)fromBlock, 1);
                            }
                        }
                        if (this.persistent) {
                            container.store((Object)block);
                        }
                        matched = true;
                        break;
                    }
                    if (!this.persistent) continue;
                    container.deactivate((Object)block, 1);
                }
                if (this.index == 0) {
                    empty = true;
                }
            }
        }
        if (it.getParentGrabArray() == this) {
            it.setParentGrabArray(null, container);
        } else {
            Logger.error(this, "Removing item " + it + " from " + this + " but RGA is " + it.getParentGrabArray(), new Exception("debug"));
        }
        if (!matched) {
            return;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (empty && this.parent != null) {
            boolean active = true;
            if (this.persistent) {
                active = container.ext().isActive((Object)this.parent);
            }
            if (!active) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.maybeRemove(this, container);
            if (!active) {
                container.deactivate((Object)this.parent, 1);
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.index == 0;
    }

    public boolean persistent() {
        return this.persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RandomGrabArrayItem item, ObjectContainer container) {
        RandomGrabArray randomGrabArray = this;
        synchronized (randomGrabArray) {
            if (this.blocks.length == 1) {
                Block block = this.blocks[0];
                if (this.persistent) {
                    container.activate((Object)block, 1);
                }
                for (int i = 0; i < this.index; ++i) {
                    if (block.reqs[i] != item) continue;
                    if (this.persistent) {
                        container.deactivate((Object)block, 1);
                    }
                    return true;
                }
                if (this.persistent) {
                    container.deactivate((Object)block, 1);
                }
            } else {
                int x = 0;
                for (int i = 0; i < this.blocks.length; ++i) {
                    Block block = this.blocks[i];
                    if (this.persistent) {
                        container.activate((Object)block, 1);
                    }
                    for (int j = 0; j < block.reqs.length && x < this.index; ++x, ++j) {
                        if (block.reqs[i] != item) continue;
                        if (this.persistent) {
                            container.deactivate((Object)block, 1);
                        }
                        return true;
                    }
                    if (!this.persistent) continue;
                    container.deactivate((Object)block, 1);
                }
            }
        }
        return false;
    }

    public synchronized int size() {
        return this.index;
    }

    public synchronized RandomGrabArrayItem get(int idx, ObjectContainer container) {
        int blockNo = idx / 1024;
        if (this.persistent) {
            container.activate((Object)this.blocks[blockNo], 1);
        }
        RandomGrabArrayItem item = this.blocks[blockNo].reqs[idx % 1024];
        if (this.persistent) {
            container.deactivate((Object)this.blocks[blockNo], 1);
        }
        return item;
    }

    public void removeFrom(ObjectContainer container) {
        if (this.blocks != null) {
            for (Block block : this.blocks) {
                container.activate((Object)block, 1);
                for (RandomGrabArrayItem item : block.reqs) {
                    if (item == null) continue;
                    Logger.error(this, "VALID ITEM WHILE DELETING BLOCK: " + item + " on " + this);
                }
                container.delete((Object)block);
            }
        }
        container.delete((Object)this);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    private static class Block {
        RandomGrabArrayItem[] reqs;

        private Block() {
        }
    }
}

