/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.ExecutorIdleCallback;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class PrioritizedSerialExecutor
implements Executor {
    private static volatile boolean logMINOR;
    private final LinkedList<Runnable>[] jobs;
    private final int priority;
    private final int defaultPriority;
    private boolean waiting;
    private final boolean invertOrder;
    private final Map<String, Long> timeByJobClasses = new HashMap<String, Long>();
    private String name;
    private Executor realExecutor;
    private boolean running;
    private final ExecutorIdleCallback callback;
    private static final int DEFAULT_JOB_TIMEOUT = 300000;
    private final int jobTimeout;
    private final Runner runner = new Runner();

    public PrioritizedSerialExecutor(int priority, int internalPriorityCount, int defaultPriority, boolean invertOrder, int jobTimeout, ExecutorIdleCallback callback) {
        this.jobs = new LinkedList[internalPriorityCount];
        for (int i = 0; i < this.jobs.length; ++i) {
            this.jobs[i] = new LinkedList();
        }
        this.priority = priority;
        this.defaultPriority = defaultPriority;
        this.invertOrder = invertOrder;
        this.jobTimeout = jobTimeout;
        this.callback = callback;
    }

    public PrioritizedSerialExecutor(int priority, int internalPriorityCount, int defaultPriority, boolean invertOrder) {
        this(priority, internalPriorityCount, defaultPriority, invertOrder, 300000, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Executor realExecutor, String name) {
        this.realExecutor = realExecutor;
        this.name = name;
        LinkedList<Runnable>[] linkedListArray = this.jobs;
        synchronized (this.jobs) {
            boolean empty = true;
            for (int i = 0; i < this.jobs.length; ++i) {
                if (this.jobs[i].isEmpty()) continue;
                empty = false;
                break;
            }
            if (!empty) {
                this.reallyStart();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyStart() {
        LinkedList<Runnable>[] linkedListArray = this.jobs;
        synchronized (this.jobs) {
            if (this.running) {
                Logger.error(this, "Not reallyStart()ing: ALREADY RUNNING", new Exception("error"));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.running = true;
            if (logMINOR) {
                Logger.minor(this, "Starting thread... " + this.name + " : " + this.runner, (Throwable)new Exception("debug"));
            }
            this.realExecutor.execute(this.runner, this.name);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void execute(Runnable job, String jobName) {
        int prio = this.defaultPriority;
        if (job instanceof PrioRunnable) {
            prio = ((PrioRunnable)job).getPriority();
        }
        this.execute(job, prio, jobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable job, int prio, String jobName) {
        LinkedList<Runnable>[] linkedListArray = this.jobs;
        synchronized (this.jobs) {
            if (logMINOR) {
                Logger.minor(this, "Running " + jobName + " : " + job + " priority " + prio + " running=" + this.running + " waiting=" + this.waiting);
            }
            this.jobs[prio].addLast(job);
            this.jobs.notifyAll();
            if (!this.running && this.realExecutor != null) {
                this.reallyStart();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNoDupes(Runnable job, int prio, String jobName) {
        LinkedList<Runnable>[] linkedListArray = this.jobs;
        synchronized (this.jobs) {
            if (logMINOR) {
                Logger.minor(this, "Running " + jobName + " : " + job + " priority " + prio + " running=" + this.running + " waiting=" + this.waiting);
            }
            if (this.jobs[prio].contains(job)) {
                if (logMINOR) {
                    Logger.minor(this, "Not adding duplicate job " + job);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            this.jobs[prio].addLast(job);
            this.jobs.notifyAll();
            if (!this.running && this.realExecutor != null) {
                this.reallyStart();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public void execute(Runnable job, String jobName, boolean fromTicker) {
        this.execute(job, jobName);
    }

    public int[] runningThreads() {
        int[] retval = new int[10];
        if (this.running) {
            retval[this.priority] = 1;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] waitingThreads() {
        int[] retval = new int[10];
        LinkedList<Runnable>[] linkedListArray = this.jobs;
        synchronized (this.jobs) {
            if (this.waiting) {
                retval[this.priority] = 1;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onThread() {
        Thread running = Thread.currentThread();
        LinkedList<Runnable>[] linkedListArray = this.jobs;
        synchronized (this.jobs) {
            if (this.runner == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.runner.current == running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] queuedJobs() {
        int[] retval = new int[this.jobs.length];
        LinkedList<Runnable>[] linkedListArray = this.jobs;
        synchronized (this.jobs) {
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = this.jobs[i].size();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize(int priority) {
        LinkedList<Runnable>[] linkedListArray = this.jobs;
        synchronized (this.jobs) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.jobs[priority].size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitingThreadsCount() {
        LinkedList<Runnable>[] linkedListArray = this.jobs;
        synchronized (this.jobs) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.waiting ? 1 : 0;
        }
    }

    static /* synthetic */ boolean access$302(PrioritizedSerialExecutor x0, boolean x1) {
        x0.waiting = x1;
        return x0.waiting;
    }

    static /* synthetic */ int access$400(PrioritizedSerialExecutor x0) {
        return x0.jobTimeout;
    }

    static /* synthetic */ boolean access$502(PrioritizedSerialExecutor x0, boolean x1) {
        x0.running = x1;
        return x0.running;
    }

    static /* synthetic */ Map access$600(PrioritizedSerialExecutor x0) {
        return x0.timeByJobClasses;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    class Runner
    implements PrioRunnable {
        Thread current;

        Runner() {
        }

        public int getPriority() {
            return PrioritizedSerialExecutor.this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block25: {
                lastDumped = System.currentTimeMillis();
                var3_2 = PrioritizedSerialExecutor.access$200(PrioritizedSerialExecutor.this);
                synchronized (var3_2) {
                    if (this.current != null && this.current.isAlive()) {
                        Logger.error(this, "Already running a thread for " + this + " !!", new Exception("error"));
                        return;
                    }
                    this.current = Thread.currentThread();
                }
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        job = null;
                        var4_3 = PrioritizedSerialExecutor.access$200(PrioritizedSerialExecutor.this);
                        synchronized (var4_3) {
                            job = this.checkQueue();
                            if (job == null) {
                                PrioritizedSerialExecutor.access$302(PrioritizedSerialExecutor.this, true);
                                try {
                                    PrioritizedSerialExecutor.access$200(PrioritizedSerialExecutor.this).wait(PrioritizedSerialExecutor.access$400(PrioritizedSerialExecutor.this));
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                PrioritizedSerialExecutor.access$302(PrioritizedSerialExecutor.this, false);
                                job = this.checkQueue();
                                if (job == null) {
                                    PrioritizedSerialExecutor.access$502(PrioritizedSerialExecutor.this, false);
                                    // MONITOREXIT @DISABLED, blocks:[16, 1, 23, 24, 9] lbl30 : MonitorExitStatement: MONITOREXIT : var4_3
                                    var15_13 = null;
                                    break block25;
                                }
                            }
                        }
                        try {
                            if (PrioritizedSerialExecutor.access$000()) {
                                Logger.minor(this, "Running job " + job);
                            }
                            start = System.currentTimeMillis();
                            job.run();
                            end = System.currentTimeMillis();
                            if (!PrioritizedSerialExecutor.access$000()) ** GOTO lbl-1000
                            Logger.minor(this, "Job " + job + " took " + (end - start) + "ms");
                            var8_8 = PrioritizedSerialExecutor.access$600(PrioritizedSerialExecutor.this);
                            synchronized (var8_8) {
                                name = job.toString();
                                if (name.indexOf(64) > 0) {
                                    name = name.substring(0, name.indexOf(64));
                                }
                                l = (l = (Long)PrioritizedSerialExecutor.access$600(PrioritizedSerialExecutor.this).get(name)) != null ? Long.valueOf(l + (end - start)) : Long.valueOf(end - start);
                                PrioritizedSerialExecutor.access$600(PrioritizedSerialExecutor.this).put(name, l);
                                if (PrioritizedSerialExecutor.access$000()) {
                                    Logger.minor(this, "Total for class " + name + " : " + l);
                                    if (System.currentTimeMillis() > lastDumped + 60000L) {
                                        for (Map.Entry<K, V> e : PrioritizedSerialExecutor.access$600(PrioritizedSerialExecutor.this).entrySet()) {
                                            Logger.minor(this, "Class " + e.getKey() + " : total time " + e.getValue());
                                        }
                                        lastDumped = System.currentTimeMillis();
                                    }
                                }
                            }
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Caught " + t, t);
                            Logger.error(this, "While running " + job + " on " + this);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var14_17) {
                    var15_14 = null;
                    var16_16 = PrioritizedSerialExecutor.access$200(PrioritizedSerialExecutor.this);
                    synchronized (var16_16) {
                        this.current = null;
                        PrioritizedSerialExecutor.access$502(PrioritizedSerialExecutor.this, false);
                        throw var14_17;
                    }
                }
                ** GOTO lbl-1000
            }
            var16_15 = PrioritizedSerialExecutor.access$200(PrioritizedSerialExecutor.this);
            synchronized (var16_15) {
                this.current = null;
                PrioritizedSerialExecutor.access$502(PrioritizedSerialExecutor.this, false);
                return;
            }
        }

        private Runnable checkQueue() {
            if (!PrioritizedSerialExecutor.this.invertOrder) {
                for (int i = 0; i < PrioritizedSerialExecutor.this.jobs.length; ++i) {
                    if (PrioritizedSerialExecutor.this.jobs[i].isEmpty()) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Chosen job at priority " + i);
                    }
                    return (Runnable)PrioritizedSerialExecutor.this.jobs[i].removeFirst();
                }
            } else {
                for (int i = PrioritizedSerialExecutor.this.jobs.length - 1; i >= 0; --i) {
                    if (PrioritizedSerialExecutor.this.jobs[i].isEmpty()) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Chosen job at priority " + i);
                    }
                    return (Runnable)PrioritizedSerialExecutor.this.jobs[i].removeFirst();
                }
            }
            return null;
        }
    }
}

