/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.PrioRunnable;
import freenet.node.Ticker;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.io.NativeThread;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class PooledExecutor
implements Executor {
    private final ArrayList<MyThread>[] runningThreads = new ArrayList[10];
    private final ArrayList<MyThread>[] waitingThreads = new ArrayList[this.runningThreads.length];
    private volatile int waitingThreadsCount;
    AtomicLong[] threadCounter = new AtomicLong[this.runningThreads.length];
    private long jobCount;
    private long jobMisses;
    private static boolean logMINOR;
    private Ticker ticker;
    static final int TIMEOUT = 300000;

    public synchronized void setTicker(Ticker ticker) {
        this.ticker = ticker;
    }

    public PooledExecutor() {
        for (int i = 0; i < this.runningThreads.length; ++i) {
            this.runningThreads[i] = new ArrayList();
            this.waitingThreads[i] = new ArrayList();
            this.threadCounter[i] = new AtomicLong();
        }
        this.waitingThreadsCount = 0;
    }

    public void start() {
        logMINOR = Logger.shouldLog(4, this);
    }

    public void execute(Runnable job, String jobName) {
        this.execute(job, jobName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void execute(Runnable runnable, String jobName, boolean fromTicker) {
        int prio = 5;
        if (runnable instanceof PrioRunnable) {
            prio = ((PrioRunnable)runnable).getPriority();
        }
        if (logMINOR) {
            Logger.minor(this, "Executing " + runnable + " as " + jobName + " at prio " + prio);
        }
        if (prio < 1) throw new IllegalArgumentException("Unreconized priority level : " + prio + '!');
        if (prio > 10) {
            throw new IllegalArgumentException("Unreconized priority level : " + prio + '!');
        }
        Job job = new Job(runnable, jobName);
        while (true) {
            MyThread t = null;
            boolean miss = false;
            PooledExecutor pooledExecutor = this;
            // MONITORENTER : pooledExecutor
            ++this.jobCount;
            if (!this.waitingThreads[prio - 1].isEmpty()) {
                t = this.waitingThreads[prio - 1].remove(this.waitingThreads[prio - 1].size() - 1);
                if (t != null) {
                    --this.waitingThreadsCount;
                }
                if (logMINOR) {
                    Logger.minor(this, "Reusing thread " + t);
                }
            } else {
                if (!fromTicker && NativeThread.usingNativeCode() && prio > Thread.currentThread().getPriority()) {
                    this.ticker.queueTimedJob(runnable, jobName, 0L, true, false);
                    // MONITOREXIT : pooledExecutor
                    return;
                }
                miss = true;
            }
            // MONITOREXIT : pooledExecutor
            if (miss) {
                long threadNo = this.threadCounter[prio - 1].getAndIncrement();
                t = new MyThread("Pooled thread awaiting work @" + threadNo, job, threadNo, prio, !fromTicker);
                t.setDaemon(true);
                PooledExecutor pooledExecutor2 = this;
                // MONITORENTER : pooledExecutor2
                this.runningThreads[prio - 1].add(t);
                ++this.jobMisses;
                if (logMINOR) {
                    Logger.minor(this, "Jobs: " + this.jobMisses + " misses of " + this.jobCount + " starting urgently " + jobName);
                }
                // MONITOREXIT : pooledExecutor2
                t.start();
                return;
            }
            pooledExecutor = t;
            // MONITORENTER : pooledExecutor
            if (!t.alive) {
                // MONITOREXIT : pooledExecutor
                continue;
            }
            if (t.nextJob == null) {
                t.nextJob = job;
                t.notifyAll();
                // MONITOREXIT : pooledExecutor
                if (!logMINOR) return;
                pooledExecutor = this;
                // MONITORENTER : pooledExecutor
                Logger.minor(this, "Not starting: Jobs: " + this.jobMisses + " misses of " + this.jobCount + " starting urgently " + jobName);
                // MONITOREXIT : pooledExecutor
                return;
            }
            // MONITOREXIT : pooledExecutor
        }
    }

    public synchronized int[] runningThreads() {
        int[] result = new int[this.runningThreads.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.runningThreads[i].size() - this.waitingThreads[i].size();
        }
        return result;
    }

    public synchronized int[] waitingThreads() {
        int[] result = new int[this.waitingThreads.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.waitingThreads[i].size();
        }
        return result;
    }

    public int getWaitingThreadsCount() {
        return this.waitingThreadsCount;
    }

    private class MyThread
    extends NativeThread {
        final String defaultName;
        volatile boolean alive;
        Job nextJob;
        final long threadNo;

        public MyThread(String defaultName, Job firstJob, long threadCounter, int prio, boolean dontCheckRenice) {
            super(defaultName, prio, dontCheckRenice);
            this.alive = true;
            this.defaultName = defaultName;
            this.threadNo = threadCounter;
            this.nextJob = firstJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            super.run();
            long ranJobs = 0L;
            int nativePriority = this.getNativePriority();
            while (true) {
                Job job;
                Object object = this;
                synchronized (object) {
                    job = this.nextJob;
                    this.nextJob = null;
                }
                if (job == null) {
                    object = PooledExecutor.this;
                    synchronized (object) {
                        PooledExecutor.this.waitingThreads[nativePriority - 1].add(this);
                        PooledExecutor.this.waitingThreadsCount++;
                    }
                    object = this;
                    synchronized (object) {
                        if (this.nextJob == null) {
                            this.setName(this.defaultName);
                            try {
                                this.wait(300000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                    object = PooledExecutor.this;
                    synchronized (object) {
                        if (PooledExecutor.this.waitingThreads[nativePriority - 1].remove(this)) {
                            PooledExecutor.this.waitingThreadsCount--;
                        }
                        MyThread myThread = this;
                        synchronized (myThread) {
                            job = this.nextJob;
                            this.nextJob = null;
                            if (job == null) {
                                this.alive = false;
                            }
                        }
                        if (!this.alive) {
                            PooledExecutor.this.runningThreads[nativePriority - 1].remove(this);
                            if (logMINOR) {
                                Logger.minor(this, "Exiting having executed " + ranJobs + " jobs : " + this);
                            }
                            return;
                        }
                    }
                }
                try {
                    this.setName(job.name + "(" + this.threadNo + ")");
                    job.runnable.run();
                }
                catch (OutOfMemoryError e) {
                    OOMHandler.handleOOM(e);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " running job " + job, t);
                }
                ++ranJobs;
            }
        }
    }

    private static class Job {
        private Runnable runnable;
        private String name;

        Job(Runnable runnable, String name) {
            this.runnable = runnable;
            this.name = name;
        }
    }
}

