/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.LoggerHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerHookChain
extends LoggerHook {
    private LoggerHook[] hooks = new LoggerHook[0];

    public LoggerHookChain() {
        this(8);
    }

    public LoggerHookChain(int threshold) {
        super(threshold);
    }

    public LoggerHookChain(String threshold) throws LoggerHook.InvalidThresholdException {
        super(threshold);
    }

    @Override
    public synchronized void log(Object o, Class<?> c, String msg, Throwable e, int priority) {
        LoggerHook[] myHooks = this.hooks;
        for (int i = 0; i < myHooks.length; ++i) {
            myHooks[i].log(o, c, msg, e, priority);
        }
    }

    public synchronized void addHook(LoggerHook lh) {
        LoggerHook[] newHooks = new LoggerHook[this.hooks.length + 1];
        System.arraycopy(newHooks, 0, this.hooks, 0, this.hooks.length);
        newHooks[this.hooks.length] = lh;
        this.hooks = newHooks;
    }

    public synchronized void removeHook(LoggerHook lh) {
        int hooksLength = this.hooks.length;
        LoggerHook[] newHooks = new LoggerHook[hooksLength > 1 ? hooksLength - 1 : 0];
        int x = 0;
        boolean removed = false;
        for (int i = 0; i < hooksLength; ++i) {
            if (this.hooks[i] == lh) {
                removed = true;
                continue;
            }
            newHooks[x++] = this.hooks[i];
        }
        if (!removed) {
            return;
        }
        if (x == newHooks.length) {
            this.hooks = newHooks;
        } else {
            LoggerHook[] finalHooks = new LoggerHook[x];
            System.arraycopy(newHooks, 0, finalHooks, 0, x);
            this.hooks = finalHooks;
        }
    }

    public synchronized LoggerHook[] getHooks() {
        return this.hooks;
    }

    @Override
    public long minFlags() {
        return 0L;
    }

    @Override
    public long notFlags() {
        return 0L;
    }

    @Override
    public long anyFlags() {
        return 0x1F & ~(this.threshold - 1);
    }

    @Override
    public void setDetailedThresholds(String details) throws LoggerHook.InvalidThresholdException {
        super.setDetailedThresholds(details);
    }

    @Override
    public void setThreshold(int thresh) {
        super.setThreshold(thresh);
        LoggerHook[] h = this.getHooks();
        for (int i = 0; i < h.length; ++i) {
            h[i].setThreshold(thresh);
        }
    }
}

