/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.l10n.L10n;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoggerHook
extends Logger {
    protected int threshold;
    public DetailedThreshold[] detailedThresholds = new DetailedThreshold[0];
    private CopyOnWriteArrayList<LogThresholdCallback> thresholdsCallbacks = new CopyOnWriteArrayList();

    LoggerHook(int thresh) {
        this.threshold = thresh;
    }

    LoggerHook(String thresh) throws InvalidThresholdException {
        this.threshold = LoggerHook.priorityOf(thresh);
    }

    @Override
    public abstract void log(Object var1, Class<?> var2, String var3, Throwable var4, int var5);

    @Override
    public void log(Object source, String message, int priority) {
        if (!this.instanceShouldLog(priority, source)) {
            return;
        }
        this.log(source, source == null ? null : source.getClass(), message, null, priority);
    }

    @Override
    public void log(Object o, String message, Throwable e, int priority) {
        if (!this.instanceShouldLog(priority, o)) {
            return;
        }
        this.log(o, o == null ? null : o.getClass(), message, e, priority);
    }

    @Override
    public void log(Class<?> c, String message, int priority) {
        if (!this.instanceShouldLog(priority, c)) {
            return;
        }
        this.log(null, c, message, null, priority);
    }

    @Override
    public void log(Class<?> c, String message, Throwable e, int priority) {
        if (!this.instanceShouldLog(priority, c)) {
            return;
        }
        this.log(null, c, message, e, priority);
    }

    public boolean acceptPriority(int prio) {
        return prio >= this.threshold;
    }

    @Override
    public void setThreshold(int thresh) {
        this.threshold = thresh;
        this.notifyLogThresholdCallbacks();
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(String symbolicThreshold) throws InvalidThresholdException {
        this.setThreshold(LoggerHook.priorityOf(symbolicThreshold));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDetailedThresholds(String details) throws InvalidThresholdException {
        if (details == null || details.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(details, ",", false);
        ArrayList<DetailedThreshold> stuff = new ArrayList<DetailedThreshold>();
        while (st.hasMoreTokens()) {
            int x;
            String token = st.nextToken();
            if (token.length() == 0 || (x = token.indexOf(58)) < 0 || x == token.length() - 1) continue;
            String section = token.substring(0, x);
            String value = token.substring(x + 1, token.length());
            int thresh = LoggerHook.priorityOf(value);
            stuff.add(new DetailedThreshold(section, thresh));
        }
        DetailedThreshold[] newThresholds = new DetailedThreshold[stuff.size()];
        stuff.toArray(newThresholds);
        LoggerHook loggerHook = this;
        synchronized (loggerHook) {
            this.detailedThresholds = newThresholds;
            this.notifyLogThresholdCallbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetailedThresholds() {
        DetailedThreshold[] thresh = null;
        LoggerHook loggerHook = this;
        synchronized (loggerHook) {
            thresh = this.detailedThresholds;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < thresh.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(thresh[i].section);
            sb.append(':');
            sb.append(LoggerHook.priorityOf(thresh[i].dThreshold));
        }
        return sb.toString();
    }

    public static int priorityOf(String s) throws InvalidThresholdException {
        if (s.equalsIgnoreCase("error")) {
            return 16;
        }
        if (s.equalsIgnoreCase("normal")) {
            return 8;
        }
        if (s.equalsIgnoreCase("minor")) {
            return 4;
        }
        if (s.equalsIgnoreCase("debugging")) {
            return 2;
        }
        if (s.equalsIgnoreCase("debug")) {
            return 2;
        }
        throw new InvalidThresholdException(L10n.getString("LoggerHook.unrecognisedPriority", "name", s));
    }

    public static String priorityOf(int priority) {
        switch (priority) {
            case 16: {
                return "ERROR";
            }
            case 8: {
                return "NORMAL";
            }
            case 4: {
                return "MINOR";
            }
            case 2: {
                return "DEBUG";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean instanceShouldLog(int priority, Class<?> c) {
        int thresh;
        DetailedThreshold[] thresholds;
        LoggerHook loggerHook = this;
        synchronized (loggerHook) {
            thresholds = this.detailedThresholds;
            thresh = this.threshold;
        }
        if (c != null && thresholds.length > 0) {
            String cname = c.getName();
            for (DetailedThreshold dt : thresholds) {
                if (!cname.startsWith(dt.section)) continue;
                thresh = dt.dThreshold;
            }
        }
        return priority >= thresh;
    }

    @Override
    public final boolean instanceShouldLog(int prio, Object o) {
        return this.instanceShouldLog(prio, o == null ? null : o.getClass());
    }

    @Override
    public final void instanceRegisterLogThresholdCallback(LogThresholdCallback ltc) {
        this.thresholdsCallbacks.add(ltc);
        ltc.shouldUpdate();
    }

    @Override
    public final void instanceUnregisterLogThresholdCallback(LogThresholdCallback ltc) {
        this.thresholdsCallbacks.remove(ltc);
    }

    private final void notifyLogThresholdCallbacks() {
        for (LogThresholdCallback ltc : this.thresholdsCallbacks) {
            ltc.shouldUpdate();
        }
    }

    public abstract long minFlags();

    public abstract long notFlags();

    public abstract long anyFlags();

    public static class InvalidThresholdException
    extends Exception {
        private static final long serialVersionUID = -1L;

        InvalidThresholdException(String msg) {
            super(msg);
        }
    }

    public static final class DetailedThreshold {
        final String section;
        final int dThreshold;

        public DetailedThreshold(String section, int thresh) {
            this.section = section;
            this.dThreshold = thresh;
        }
    }
}

