/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.FileLoggerHook;
import freenet.support.LogThresholdCallback;
import freenet.support.LoggerHook;
import freenet.support.LoggerHookChain;
import freenet.support.VoidLogger;
import freenet.support.io.Closer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Logger {
    public static final int ERROR = 16;
    public static final int NORMAL = 8;
    public static final int MINOR = 4;
    public static final int DEBUG = 2;
    public static final int INTERNAL = 1;
    static Logger logger = new VoidLogger();

    public static synchronized FileLoggerHook setupStdoutLogging(int level, String detail) throws LoggerHook.InvalidThresholdException {
        Logger.setupChain();
        logger.setThreshold(level);
        logger.setDetailedThresholds(detail);
        FileLoggerHook fh = new FileLoggerHook((OutputStream)System.out, "d (c, t, p): m", "MMM dd, yyyy HH:mm:ss:SSS", level);
        if (detail != null) {
            fh.setDetailedThresholds(detail);
        }
        ((LoggerHookChain)logger).addHook(fh);
        fh.start();
        return fh;
    }

    public static synchronized void setupChain() {
        logger = new LoggerHookChain();
    }

    public static synchronized void debug(Object o, String s) {
        logger.log(o, s, 2);
    }

    public static synchronized void debug(Object o, String s, Throwable t) {
        logger.log(o, s, t, 2);
    }

    public static synchronized void error(Class<?> c, String s) {
        logger.log(c, s, 16);
    }

    public static synchronized void error(Object o, String s) {
        logger.log(o, s, 16);
    }

    public static synchronized void error(Object o, String s, Throwable e) {
        logger.log(o, s, e, 16);
    }

    public static synchronized void minor(Class<?> c, String s) {
        logger.log(c, s, 4);
    }

    public static synchronized void minor(Object o, String s) {
        logger.log(o, s, 4);
    }

    public static synchronized void minor(Object o, String s, Throwable t) {
        logger.log(o, s, t, 4);
    }

    public static synchronized void minor(Class<?> class1, String string, Throwable t) {
        logger.log(class1, string, t, 4);
    }

    public static synchronized void normal(Object o, String s) {
        logger.log(o, s, 8);
    }

    public static synchronized void normal(Object o, String s, Throwable t) {
        logger.log(o, s, t, 8);
    }

    public static synchronized void normal(Class<?> c, String s) {
        logger.log(c, s, 8);
    }

    public static synchronized void logStatic(Object o, String s, int prio) {
        logger.log(o, s, prio);
    }

    public abstract void log(Object var1, Class<?> var2, String var3, Throwable var4, int var5);

    public abstract void log(Object var1, String var2, int var3);

    public abstract void log(Object var1, String var2, Throwable var3, int var4);

    public abstract void log(Class<?> var1, String var2, int var3);

    public abstract void log(Class<?> var1, String var2, Throwable var3, int var4);

    public abstract boolean instanceShouldLog(int var1, Class<?> var2);

    public static boolean shouldLog(int priority, Class<?> c) {
        return logger.instanceShouldLog(priority, c);
    }

    public static boolean shouldLog(int priority, Object o) {
        return Logger.shouldLog(priority, o.getClass());
    }

    public abstract boolean instanceShouldLog(int var1, Object var2);

    public abstract void setThreshold(int var1);

    public abstract void setThreshold(String var1) throws LoggerHook.InvalidThresholdException;

    public abstract int getThreshold();

    public abstract void setDetailedThresholds(String var1) throws LoggerHook.InvalidThresholdException;

    public static void registerLogThresholdCallback(LogThresholdCallback ltc) {
        logger.instanceRegisterLogThresholdCallback(ltc);
    }

    public abstract void instanceRegisterLogThresholdCallback(LogThresholdCallback var1);

    public static void unregisterLogThresholdCallback(LogThresholdCallback ltc) {
        logger.instanceUnregisterLogThresholdCallback(ltc);
    }

    public abstract void instanceUnregisterLogThresholdCallback(LogThresholdCallback var1);

    public static void registerClass(final Class<?> clazz) {
        LogThresholdCallback ltc = new LogThresholdCallback(){
            WeakReference<Class<?>> ref;
            {
                this.ref = new WeakReference<Class>(clazz);
            }

            public void shouldUpdate() {
                Class clazz2 = (Class)this.ref.get();
                if (clazz2 == null) {
                    Logger.unregisterLogThresholdCallback(this);
                    return;
                }
                boolean done = false;
                try {
                    Field logMINOR_Field = clazz2.getDeclaredField("logMINOR");
                    if ((logMINOR_Field.getModifiers() & 8) != 0) {
                        logMINOR_Field.setAccessible(true);
                        logMINOR_Field.set(null, Logger.shouldLog(4, clazz2));
                    }
                    done = true;
                }
                catch (SecurityException e) {
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                try {
                    Field logDEBUG_Field = clazz2.getDeclaredField("logDEBUG");
                    if ((logDEBUG_Field.getModifiers() & 8) != 0) {
                        logDEBUG_Field.setAccessible(true);
                        logDEBUG_Field.set(null, Logger.shouldLog(2, clazz2));
                    }
                    done = true;
                }
                catch (SecurityException e) {
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (!done) {
                    Logger.error(this, "No log level field for " + clazz2);
                }
            }
        };
        Logger.registerLogThresholdCallback(ltc);
    }

    public static void fatal(Object cause, int retcode, String message) {
        Logger.error(cause, message);
        System.exit(retcode);
    }

    public static synchronized void globalAddHook(LoggerHook logger2) {
        if (logger instanceof VoidLogger) {
            Logger.setupChain();
        }
        ((LoggerHookChain)logger).addHook(logger2);
    }

    public static synchronized void globalSetThreshold(int i) {
        logger.setThreshold(i);
    }

    public static synchronized int globalGetThreshold() {
        return logger.getThreshold();
    }

    public static synchronized void globalRemoveHook(FileLoggerHook hook) {
        if (logger instanceof LoggerHookChain) {
            ((LoggerHookChain)logger).removeHook(hook);
        } else {
            System.err.println("Cannot remove hook: " + hook + " global logger is " + logger);
        }
    }

    public static synchronized void destroyChainIfEmpty() {
        if (logger instanceof VoidLogger) {
            return;
        }
        if (logger instanceof LoggerHookChain && ((LoggerHookChain)logger).getHooks().length == 0) {
            logger = new VoidLogger();
        }
    }

    public static synchronized LoggerHookChain getChain() {
        if (logger instanceof LoggerHookChain) {
            return (LoggerHookChain)logger;
        }
        Logger.setupChain();
        return (LoggerHookChain)logger;
    }

    public static final class OSThread {
        private static boolean getPIDEnabled = false;
        private static boolean getPPIDEnabled = false;
        private static boolean logToFileEnabled = false;
        private static int logToFileVerbosity = 2;
        private static boolean logToStdOutEnabled = false;
        private static boolean procSelfStatEnabled = false;

        public static synchronized int getPID(Object o) {
            if (!getPIDEnabled) {
                return -1;
            }
            return OSThread.getPIDFromProcSelfStat(o);
        }

        public static synchronized int getPPID(Object o) {
            if (!getPPIDEnabled) {
                return -1;
            }
            return OSThread.getPPIDFromProcSelfStat(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static synchronized String getFieldFromProcSelfStat(int fieldNumber, Object o) {
            String readLine = null;
            if (!procSelfStatEnabled) {
                return null;
            }
            BufferedReader br = null;
            FileReader fr = null;
            File procFile = new File("/proc/self/stat");
            if (!procFile.exists()) return null;
            try {
                fr = new FileReader(procFile);
                br = new BufferedReader(fr);
            }
            catch (FileNotFoundException e1) {
                Logger.logStatic(o, "'/proc/self/stat' not found", logToFileVerbosity);
                procSelfStatEnabled = false;
                fr = null;
            }
            if (null != br) {
                block12: {
                    try {
                        try {
                            readLine = br.readLine();
                        }
                        catch (IOException e) {
                            Logger.error(o, "Caught IOException in br.readLine() of OSThread.getFieldFromProcSelfStat()", e);
                            readLine = null;
                            Object var8_11 = null;
                            Closer.close(br);
                            break block12;
                        }
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        Closer.close(br);
                        throw throwable;
                    }
                    Closer.close(br);
                }
                if (null != readLine) {
                    try {
                        String[] procFields = readLine.trim().split(" ");
                        if (4 <= procFields.length) {
                            return procFields[fieldNumber];
                        }
                    }
                    catch (PatternSyntaxException e) {
                        Logger.error(o, "Caught PatternSyntaxException in readLine.trim().split(\" \") of OSThread.getFieldFromProcSelfStat() while parsing '" + readLine + "'", e);
                    }
                }
            }
            Closer.close(br);
            return null;
        }

        public static synchronized int getPIDFromProcSelfStat(Object o) {
            int pid = -1;
            if (!getPIDEnabled) {
                return -1;
            }
            if (!procSelfStatEnabled) {
                return -1;
            }
            String pidString = OSThread.getFieldFromProcSelfStat(0, o);
            if (null == pidString) {
                return -1;
            }
            try {
                pid = Integer.parseInt(pidString.trim());
            }
            catch (NumberFormatException e) {
                Logger.error(o, "Caught NumberFormatException in Integer.parseInt() of OSThread.getPIDFromProcSelfStat() while parsing '" + pidString + "'", e);
            }
            return pid;
        }

        public static synchronized int getPPIDFromProcSelfStat(Object o) {
            int ppid = -1;
            if (!getPPIDEnabled) {
                return -1;
            }
            if (!procSelfStatEnabled) {
                return -1;
            }
            String ppidString = OSThread.getFieldFromProcSelfStat(3, o);
            if (null == ppidString) {
                return -1;
            }
            try {
                ppid = Integer.parseInt(ppidString.trim());
            }
            catch (NumberFormatException e) {
                Logger.error(o, "Caught NumberFormatException in Integer.parseInt() of OSThread.getPPIDFromProcSelfStat() while parsing '" + ppidString + "'", e);
            }
            return ppid;
        }

        public static synchronized int logPID(Object o) {
            if (!getPIDEnabled) {
                return -1;
            }
            int pid = OSThread.getPID(o);
            String msg = -1 != pid ? "This thread's OS PID is " + pid : "This thread's OS PID could not be determined";
            if (logToStdOutEnabled) {
                System.out.println(msg + ": " + o);
            }
            if (logToFileEnabled) {
                Logger.logStatic(o, msg, logToFileVerbosity);
            }
            return pid;
        }

        public static synchronized int logPPID(Object o) {
            if (!getPPIDEnabled) {
                return -1;
            }
            int ppid = OSThread.getPPID(o);
            String msg = -1 != ppid ? "This thread's OS PPID is " + ppid : "This thread's OS PPID could not be determined";
            if (logToStdOutEnabled) {
                System.out.println(msg + ": " + o);
            }
            if (logToFileEnabled) {
                Logger.logStatic(o, msg, logToFileVerbosity);
            }
            return ppid;
        }
    }
}

