/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.io.comm.AsyncMessageCallback;
import freenet.support.LimitedRangeIntByteArrayMapElement;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.WouldBlockException;
import java.util.HashMap;
import java.util.Iterator;

public class LimitedRangeIntByteArrayMap {
    private static volatile boolean logMINOR;
    private final HashMap<Integer, LimitedRangeIntByteArrayMapElement> contents;
    private int minValue;
    private int maxValue;
    private final int maxRange;
    private volatile boolean flag;

    public LimitedRangeIntByteArrayMap(int maxRange) {
        this.maxRange = maxRange;
        this.contents = new HashMap();
        this.minValue = -1;
        this.maxValue = -1;
        this.flag = false;
    }

    public synchronized int minValue() {
        return this.minValue;
    }

    public synchronized int maxValue() {
        return this.maxValue;
    }

    public synchronized byte[] get(int index) {
        LimitedRangeIntByteArrayMapElement wrapper = this.contents.get(index);
        if (wrapper != null) {
            return wrapper.data;
        }
        return null;
    }

    public synchronized AsyncMessageCallback[] getCallbacks(int index) {
        LimitedRangeIntByteArrayMapElement wrapper = this.contents.get(index);
        if (wrapper != null) {
            return wrapper.callbacks;
        }
        return null;
    }

    public synchronized long getTime(int index) {
        LimitedRangeIntByteArrayMapElement wrapper = this.contents.get(index);
        if (wrapper != null) {
            return wrapper.createdTime;
        }
        return -1L;
    }

    public short getPriority(int index, short defaultValue) {
        Integer i = index;
        LimitedRangeIntByteArrayMapElement wrapper = this.contents.get(i);
        if (wrapper != null) {
            return wrapper.priority;
        }
        return defaultValue;
    }

    public synchronized long getReaddedTime(int index) {
        LimitedRangeIntByteArrayMapElement wrapper = this.contents.get(index);
        if (wrapper != null) {
            return wrapper.reputTime;
        }
        return -1L;
    }

    public synchronized boolean add(int index, byte[] data, AsyncMessageCallback[] callbacks, short priority) {
        if (logMINOR) {
            Logger.minor(this, this.toString() + " add " + index);
        }
        if (this.maxValue == -1) {
            this.minValue = index;
            this.maxValue = index;
        }
        if (index > this.maxValue) {
            if (index - this.minValue >= this.maxRange) {
                return false;
            }
            this.maxValue = index;
        }
        if (index < this.minValue) {
            if (this.maxValue - index >= this.maxRange) {
                return false;
            }
            this.minValue = index;
        }
        if (data == null) {
            throw new NullPointerException();
        }
        Integer idx = index;
        LimitedRangeIntByteArrayMapElement le = this.contents.get(idx);
        if (le == null) {
            this.contents.put(idx, new LimitedRangeIntByteArrayMapElement(idx, data, callbacks, priority));
        } else {
            le.reput();
        }
        this.notifyAll();
        return true;
    }

    public synchronized void interrupt() {
        this.flag = !this.flag;
        this.notifyAll();
    }

    public synchronized void lock(int index) throws InterruptedException {
        boolean oldFlag = this.flag;
        if (this.minValue == -1) {
            return;
        }
        if (index - this.minValue < this.maxRange) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, this.toString() + " lock(" + index + ") - minValue = " + this.minValue + ", maxValue = " + this.maxValue + ", maxRange=" + this.maxRange);
        }
        do {
            this.wait();
            if (this.flag == oldFlag) continue;
            if (logMINOR) {
                Logger.minor(this, "Interrupted");
            }
            throw new InterruptedException();
        } while (index - this.minValue >= this.maxRange && this.minValue != -1);
        if (logMINOR) {
            Logger.minor(this, "index=" + index + ", minValue=" + this.minValue + ", maxRange=" + this.maxRange + " - returning");
        }
    }

    public boolean wouldBlock(int index) {
        if (this.minValue == -1) {
            return false;
        }
        return index - this.minValue >= this.maxRange;
    }

    public synchronized void lockNeverBlock(int index) throws WouldBlockException {
        if (this.minValue == -1) {
            return;
        }
        if (index - this.minValue < this.maxRange) {
            return;
        }
        throw new WouldBlockException(this.toString() + " WOULD BLOCK: lockNeverBlock(" + index + ") - minValue = " + this.minValue + ", maxValue = " + this.maxValue + ", maxRange=" + this.maxRange);
    }

    public synchronized boolean remove(int index) {
        if (logMINOR) {
            Logger.minor(this, "Removing " + index + " - min=" + this.minValue + " max=" + this.maxValue);
        }
        if (this.contents.remove(index) != null) {
            if (index > this.minValue && index < this.maxValue) {
                return true;
            }
            if (this.contents.size() == 0) {
                this.maxValue = -1;
                this.minValue = -1;
                this.notifyAll();
                return true;
            }
            if (index == this.maxValue) {
                for (int i = this.maxValue; i >= this.minValue; --i) {
                    Integer ii = i;
                    if (!this.contents.containsKey(ii)) continue;
                    this.maxValue = i;
                    this.notifyAll();
                    return true;
                }
                this.notifyAll();
                throw new IllegalStateException("Still here! (a)");
            }
            if (index == this.minValue) {
                for (int i = this.minValue; i <= this.maxValue; ++i) {
                    Integer ii = i;
                    if (!this.contents.containsKey(ii)) continue;
                    this.minValue = i;
                    this.notifyAll();
                    return true;
                }
                this.notifyAll();
                throw new IllegalStateException("Still here! (b)");
            }
            this.notifyAll();
            throw new IllegalStateException("impossible");
        }
        return false;
    }

    public synchronized byte[][] grabAllBytes() {
        int len = this.contents.size();
        byte[][] output = new byte[len][];
        int count = 0;
        for (LimitedRangeIntByteArrayMapElement o : this.contents.values()) {
            output[count++] = o.data;
        }
        this.clear();
        return output;
    }

    public synchronized LimitedRangeIntByteArrayMapElement[] grabAll() {
        int len = this.contents.size();
        LimitedRangeIntByteArrayMapElement[] output = new LimitedRangeIntByteArrayMapElement[len];
        Iterator<LimitedRangeIntByteArrayMapElement> i = this.contents.values().iterator();
        int count = 0;
        while (i.hasNext()) {
            output[count++] = i.next();
        }
        this.clear();
        return output;
    }

    private synchronized void clear() {
        this.contents.clear();
        this.maxValue = -1;
        this.minValue = -1;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

