/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;

public class LibraryLoader {
    public static String getSimplifiedArchitecture() {
        String arch = System.getProperty("os.arch").toLowerCase().matches("(i?[x0-9]86_64|amd64)") ? "amd64" : (System.getProperty("os.arch").toLowerCase().matches("(ppc)") ? "ppc" : "i386");
        return arch;
    }

    public static boolean loadNative(String path, String libraryName) {
        boolean isWindows;
        boolean success = false;
        boolean bl = isWindows = File.pathSeparatorChar == ';';
        String prefix = isWindows ? ".dll" : (System.getProperty("os.name").toLowerCase().startsWith("mac") ? ".jnilib" : ".so");
        String libraryNameWithPrefix = (isWindows ? "" : "lib") + libraryName;
        String libraryNameWithPrefixAndArch = libraryNameWithPrefix + '-' + LibraryLoader.getSimplifiedArchitecture();
        String libraryNameWithPrefixAndArchAndSuffix = libraryNameWithPrefixAndArch + prefix;
        String resourceName = path + libraryNameWithPrefixAndArchAndSuffix;
        File nativeLib = new File(System.getProperty("java.library.path") + "/lib" + libraryName + prefix);
        if (nativeLib.exists()) {
            System.out.println("Attempting to load the NativeThread library [" + libraryName + ']');
            System.loadLibrary(libraryName);
            success = true;
        } else {
            try {
                URL resource = LibraryLoader.class.getResource(resourceName);
                InputStream inputStream = resource.openStream();
                File temporaryLib = File.createTempFile(libraryNameWithPrefixAndArch, ".tmp");
                temporaryLib.deleteOnExit();
                FileOutputStream outputStream = new FileOutputStream(temporaryLib);
                byte[] array = new byte[2048];
                int read = 0;
                while ((read = inputStream.read(array)) > 0) {
                    outputStream.write(array, 0, read);
                }
                outputStream.close();
                System.out.println("Attempting to load the " + libraryName + " library [" + resource + ']');
                System.load(temporaryLib.getPath());
                success = true;
            }
            catch (Throwable e) {
                System.err.println("Caught the following exception attempting to load " + resourceName);
                e.printStackTrace();
            }
        }
        return success;
    }
}

