/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.DoublyLinkedListImpl;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUQueue<T> {
    private final DoublyLinkedListImpl<QItem<T>> list = new DoublyLinkedListImpl();
    private final Map<T, QItem<T>> hash = new HashMap<T, QItem<T>>();

    public final synchronized void push(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        QItem<T> insert = this.hash.get(obj);
        if (insert == null) {
            insert = new QItem<T>(obj);
            this.hash.put(obj, insert);
        } else {
            this.list.remove(insert);
        }
        this.list.unshift(insert);
    }

    public synchronized void pushLeast(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        QItem<T> insert = this.hash.get(obj);
        if (insert == null) {
            insert = new QItem<T>(obj);
            this.hash.put(obj, insert);
        } else {
            this.list.remove(insert);
        }
        this.list.push(insert);
    }

    public final synchronized T pop() {
        if (this.list.size() > 0) {
            return this.hash.remove(this.list.pop().obj).obj;
        }
        return null;
    }

    public final int size() {
        return this.list.size();
    }

    public final synchronized boolean remove(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        QItem<T> i = this.hash.remove(obj);
        if (i != null) {
            this.list.remove(i);
            return true;
        }
        return false;
    }

    public final synchronized boolean contains(Object obj) {
        return this.hash.containsKey(obj);
    }

    public Enumeration<T> elements() {
        return new ItemEnumeration();
    }

    public synchronized Object[] toArray() {
        return this.hash.keySet().toArray();
    }

    public synchronized <E> E[] toArray(E[] array) {
        return this.hash.keySet().toArray(array);
    }

    public synchronized Object[] toArrayOrdered() {
        Object[] array = new Object[this.list.size()];
        int x = 0;
        Enumeration<QItem<T>> e = this.list.reverseElements();
        while (e.hasMoreElements()) {
            array[x++] = e.nextElement().obj;
        }
        return array;
    }

    public synchronized <E> E[] toArrayOrdered(E[] array) {
        int listSize;
        if ((array = this.toArray(array)).length != (listSize = this.list.size())) {
            throw new IllegalStateException("array.length=" + array.length + " but list.size=" + listSize);
        }
        int x = 0;
        Enumeration<QItem<T>> e = this.list.reverseElements();
        while (e.hasMoreElements()) {
            array[x++] = e.nextElement().obj;
        }
        return array;
    }

    public synchronized boolean isEmpty() {
        return this.hash.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QItem<T>
    extends DoublyLinkedListImpl.Item<QItem<T>> {
        public T obj;

        public QItem(T obj) {
            this.obj = obj;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemEnumeration
    implements Enumeration<T> {
        private Enumeration<QItem<T>> source;

        private ItemEnumeration() {
            this.source = LRUQueue.this.list.reverseElements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.source.hasMoreElements();
        }

        @Override
        public T nextElement() {
            return this.source.nextElement().obj;
        }
    }
}

