/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarClassLoader
extends ClassLoader
implements Closeable {
    private JarFile tempJarFile;

    public JarClassLoader(String fileName) throws IOException {
        this(new File(fileName));
    }

    public JarClassLoader(URL fileUrl, long length) throws IOException {
        this.copyFileToTemp(fileUrl.openStream(), length);
    }

    public JarClassLoader(File file) throws IOException {
        this.tempJarFile = new JarFile(file);
    }

    private void copyFileToTemp(InputStream inputStream, long length) throws IOException {
        File tempFile = File.createTempFile("jar-", ".tmp");
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        FileUtil.copy(inputStream, fileOutputStream, length);
        fileOutputStream.close();
        tempFile.deleteOnExit();
        this.tempJarFile = new JarFile(tempFile);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            String pathName = this.transformName(name);
            JarEntry jarEntry = this.tempJarFile.getJarEntry(pathName);
            if (jarEntry != null) {
                long size = jarEntry.getSize();
                InputStream jarEntryInputStream = this.tempJarFile.getInputStream(jarEntry);
                ByteArrayOutputStream classBytesOutputStream = new ByteArrayOutputStream((int)size);
                FileUtil.copy(jarEntryInputStream, classBytesOutputStream, size);
                classBytesOutputStream.close();
                jarEntryInputStream.close();
                byte[] classBytes = classBytesOutputStream.toByteArray();
                Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
                return clazz;
            }
            throw new ClassNotFoundException("could not find jar entry for class " + name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    protected URL findResource(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        try {
            return new URL("jar:" + new File(this.tempJarFile.getName()).toURI().toURL() + "!/" + name);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private String transformName(String name) {
        return name.replace('.', '/') + ".class";
    }

    @Override
    public void close() throws IOException {
        this.tempJarFile.close();
    }
}

