/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.Version;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.OutputStreamLogger;
import freenet.support.io.FileUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLoggerHook
extends LoggerHook
implements Closeable {
    public static final int DATE = 1;
    public static final int CLASS = 2;
    public static final int HASHCODE = 3;
    public static final int THREAD = 4;
    public static final int PRIORITY = 5;
    public static final int MESSAGE = 6;
    public static final int UNAME = 7;
    private volatile boolean closed = false;
    protected int INTERVAL = 12;
    protected int INTERVAL_MULTIPLIER = 5;
    private static String uname = "unknown";
    private DateFormat df;
    private int[] fmt;
    private String[] str;
    protected OutputStream logStream;
    protected OutputStream altLogStream;
    protected final boolean logOverwrite;
    protected String baseFilename = null;
    protected File latestFile;
    protected File previousFile;
    protected boolean redirectStdOut = false;
    protected boolean redirectStdErr = false;
    protected final LinkedList<byte[]> list = new LinkedList();
    protected long listBytes = 0L;
    protected int MAX_LIST_SIZE = 100000;
    protected long MAX_LIST_BYTES = 0xA00000L;
    long maxOldLogfilesDiskUsage;
    protected final LinkedList<OldLogFile> logFiles = new LinkedList();
    private long oldLogFilesDiskSpaceUsage = 0L;
    protected int runningCompressors = 0;
    protected Object runningCompressorsSync = new Object();
    private Date myDate = new Date();
    private final Object trimOldLogFilesLock = new Object();
    private static final int LINE_OVERHEAD = 60;
    private boolean switchedBaseFilename;

    static final synchronized void getUName() {
        if (!uname.equals("unknown")) {
            return;
        }
        System.out.println("Getting uname for logging");
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (addr != null) {
                uname = new StringTokenizer(addr.getHostName(), ".").nextToken();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxListLength(int len) {
        LinkedList<byte[]> linkedList = this.list;
        synchronized (linkedList) {
            this.MAX_LIST_SIZE = len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxListBytes(long len) {
        LinkedList<byte[]> linkedList = this.list;
        synchronized (linkedList) {
            this.MAX_LIST_BYTES = len;
        }
    }

    public void setInterval(String intervalName) throws IntervalParseException {
        char c;
        StringBuilder sb = new StringBuilder(intervalName.length());
        for (int i = 0; i < intervalName.length() && Character.isDigit(c = intervalName.charAt(i)); ++i) {
            sb.append(c);
        }
        if (sb.length() > 0) {
            String prefix = sb.toString();
            intervalName = intervalName.substring(prefix.length());
            this.INTERVAL_MULTIPLIER = Integer.parseInt(prefix);
        } else {
            this.INTERVAL_MULTIPLIER = 1;
        }
        if (intervalName.endsWith("S")) {
            intervalName = intervalName.substring(0, intervalName.length() - 1);
        }
        if (intervalName.equalsIgnoreCase("MINUTE")) {
            this.INTERVAL = 12;
        } else if (intervalName.equalsIgnoreCase("HOUR")) {
            this.INTERVAL = 10;
        } else if (intervalName.equalsIgnoreCase("DAY")) {
            this.INTERVAL = 5;
        } else if (intervalName.equalsIgnoreCase("WEEK")) {
            this.INTERVAL = 3;
        } else if (intervalName.equalsIgnoreCase("MONTH")) {
            this.INTERVAL = 2;
        } else if (intervalName.equalsIgnoreCase("YEAR")) {
            this.INTERVAL = 1;
        } else {
            throw new IntervalParseException("invalid interval " + intervalName);
        }
    }

    protected String getHourLogName(Calendar c, int digit, boolean compressed) {
        StringBuilder buf = new StringBuilder(50);
        buf.append(this.baseFilename).append('-');
        buf.append(Version.buildNumber());
        buf.append('-');
        buf.append(c.get(1)).append('-');
        this.pad2digits(buf, c.get(2) + 1);
        buf.append('-');
        this.pad2digits(buf, c.get(5));
        buf.append('-');
        this.pad2digits(buf, c.get(11));
        if (this.INTERVAL == 12) {
            buf.append('-');
            this.pad2digits(buf, c.get(12));
        }
        if (digit > 0) {
            buf.append("-");
            buf.append(digit);
        }
        buf.append(".log");
        if (compressed) {
            buf.append(".gz");
        }
        return buf.toString();
    }

    private StringBuilder pad2digits(StringBuilder buf, int x) {
        String s = Integer.toString(x);
        if (s.length() == 1) {
            buf.append('0');
        }
        buf.append(s);
        return buf;
    }

    public FileLoggerHook(String filename, String fmt, String dfmt, int threshold, boolean assumeWorking, boolean logOverwrite, long maxOldLogfilesDiskUsage) throws IOException {
        this(false, filename, fmt, dfmt, threshold, assumeWorking, logOverwrite, maxOldLogfilesDiskUsage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimOldLogFiles() {
        Object object = this.trimOldLogFilesLock;
        synchronized (object) {
            while (this.oldLogFilesDiskSpaceUsage > this.maxOldLogfilesDiskUsage) {
                OldLogFile olf;
                LinkedList<OldLogFile> linkedList = this.logFiles;
                synchronized (linkedList) {
                    if (this.logFiles.isEmpty()) {
                        System.err.println("ERROR: INCONSISTENT LOGGER TOTALS: Log file list is empty but still used " + this.oldLogFilesDiskSpaceUsage + " bytes!");
                    }
                    olf = this.logFiles.removeFirst();
                }
                olf.filename.delete();
                this.oldLogFilesDiskSpaceUsage -= olf.size;
                if (!Logger.shouldLog(4, this)) continue;
                Logger.minor(this, "Deleting " + olf.filename + " - saving " + olf.size + " bytes, disk usage now: " + this.oldLogFilesDiskSpaceUsage + " of " + this.maxOldLogfilesDiskUsage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findOldLogFiles() {
        String prefix;
        File dir;
        GregorianCalendar gc = new GregorianCalendar();
        File currentFilename = new File(this.getHourLogName(gc, -1, true));
        int slashIndex = this.baseFilename.lastIndexOf(File.separatorChar);
        if (slashIndex == -1) {
            dir = new File(System.getProperty("user.dir"));
            prefix = this.baseFilename.toLowerCase();
        } else {
            dir = new File(this.baseFilename.substring(0, slashIndex));
            prefix = this.baseFilename.substring(slashIndex + 1).toLowerCase();
        }
        Object[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        long lastStartTime = -1L;
        Object oldFile = null;
        if (this.latestFile.exists()) {
            FileUtil.renameTo(this.latestFile, this.previousFile);
        }
        boolean logMINOR = Logger.shouldLog(4, this);
        for (int i = 0; i < files.length; ++i) {
            Object f = files[i];
            String name = ((File)f).getName();
            if (name.toLowerCase().startsWith(prefix)) {
                if (name.equals(this.previousFile.getName()) || name.equals(this.latestFile.getName())) continue;
                if (!name.endsWith(".log.gz")) {
                    if (logMINOR) {
                        Logger.minor(this, "Does not end in .log.gz: " + name);
                    }
                    ((File)f).delete();
                    continue;
                }
                name = name.substring(0, name.length() - ".log.gz".length());
                if ((name = name.substring(prefix.length())).length() == 0 || name.charAt(0) != '-') {
                    if (logMINOR) {
                        Logger.minor(this, "Deleting unrecognized: " + name + " (" + ((File)f).getPath() + ')');
                    }
                    ((File)f).delete();
                    continue;
                }
                name = name.substring(1);
                String[] tokens = name.split("-");
                int[] nums = new int[tokens.length];
                for (int j = 0; j < tokens.length; ++j) {
                    try {
                        nums[j] = Integer.parseInt(tokens[j]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        Logger.normal(this, "Could not parse: " + tokens[j] + " into number from " + name);
                        ((File)f).delete();
                    }
                }
                if (nums[0] != Version.buildNumber()) {
                    if (logMINOR) {
                        Logger.minor(this, "Deleting old log from build " + nums[0] + ", current=" + Version.buildNumber());
                    }
                    ((File)f).delete();
                    continue;
                }
                if (nums.length > 1) {
                    gc.set(1, nums[1]);
                }
                if (nums.length > 2) {
                    gc.set(2, nums[2] - 1);
                }
                if (nums.length > 3) {
                    gc.set(5, nums[3]);
                }
                if (nums.length > 4) {
                    gc.set(11, nums[4]);
                }
                if (nums.length > 5) {
                    gc.set(12, nums[5]);
                }
                gc.set(13, 0);
                gc.set(14, 0);
                long startTime = gc.getTimeInMillis();
                if (oldFile != null) {
                    long l = ((File)oldFile).length();
                    OldLogFile olf = new OldLogFile((File)oldFile, lastStartTime, startTime, l);
                    Object object = this.logFiles;
                    synchronized (object) {
                        this.logFiles.addLast(olf);
                    }
                    object = this.trimOldLogFilesLock;
                    synchronized (object) {
                        this.oldLogFilesDiskSpaceUsage += l;
                    }
                }
                lastStartTime = startTime;
                oldFile = f;
                continue;
            }
            Logger.normal(this, "Unknown file: " + name + " in the log directory");
        }
        int a = 1;
        while (currentFilename != null && currentFilename.exists()) {
            File numericSameDateFilename = new File(this.getHourLogName(gc, a, true));
            if (numericSameDateFilename == null || !numericSameDateFilename.exists()) {
                FileUtil.renameTo(currentFilename, numericSameDateFilename);
                currentFilename = numericSameDateFilename;
                break;
            }
            currentFilename = numericSameDateFilename;
            ++a;
        }
        if (oldFile != null) {
            long l = ((File)oldFile).length();
            OldLogFile olf = new OldLogFile((File)oldFile, lastStartTime, System.currentTimeMillis(), l);
            Object object = this.logFiles;
            synchronized (object) {
                this.logFiles.addLast(olf);
            }
            object = this.trimOldLogFilesLock;
            synchronized (object) {
                this.oldLogFilesDiskSpaceUsage += l;
            }
        }
        this.trimOldLogFiles();
    }

    public FileLoggerHook(String filename, String fmt, String dfmt, String threshold, boolean assumeWorking, boolean logOverwrite, long maxOldLogFilesDiskUsage) throws IOException, LoggerHook.InvalidThresholdException {
        this(filename, fmt, dfmt, FileLoggerHook.priorityOf(threshold), assumeWorking, logOverwrite, maxOldLogFilesDiskUsage);
    }

    private void checkStdStreams() {
        System.out.print(" \b");
        if (System.out.checkError()) {
            this.redirectStdOut = true;
        }
        System.err.print(" \b");
        if (System.err.checkError()) {
            this.redirectStdErr = true;
        }
    }

    public FileLoggerHook(OutputStream os, String fmt, String dfmt, int threshold) {
        this(new PrintStream(os), fmt, dfmt, threshold, true);
        this.logStream = os;
    }

    public FileLoggerHook(OutputStream os, String fmt, String dfmt, String threshold) throws LoggerHook.InvalidThresholdException {
        this(new PrintStream(os), fmt, dfmt, FileLoggerHook.priorityOf(threshold), true);
        this.logStream = os;
    }

    public FileLoggerHook(PrintStream stream, String fmt, String dfmt, int threshold, boolean overwrite) {
        this(fmt, dfmt, threshold, overwrite, -1L);
        this.logStream = stream;
    }

    public void start() {
        if (this.redirectStdOut) {
            System.setOut(new PrintStream(new OutputStreamLogger(8, "Stdout: ")));
        }
        if (this.redirectStdErr) {
            System.setErr(new PrintStream(new OutputStreamLogger(16, "Stderr: ")));
        }
        WriterThread wt = new WriterThread();
        wt.setDaemon(true);
        CloserThread ct = new CloserThread();
        Runtime.getRuntime().addShutdownHook(ct);
        wt.start();
    }

    public FileLoggerHook(boolean rotate, String baseFilename, String fmt, String dfmt, int threshold, boolean assumeWorking, boolean logOverwrite, long maxOldLogfilesDiskUsage) throws IOException {
        this(fmt, dfmt, threshold, logOverwrite, maxOldLogfilesDiskUsage);
        if (!assumeWorking) {
            this.checkStdStreams();
        }
        if (rotate) {
            this.baseFilename = baseFilename;
        } else {
            this.logStream = new BufferedOutputStream(new FileOutputStream(baseFilename, !logOverwrite), 65536);
        }
    }

    public FileLoggerHook(boolean rotate, String baseFilename, String fmt, String dfmt, String threshold, boolean assumeWorking, boolean logOverwrite, long maxOldLogFilesDiskUsage) throws IOException, LoggerHook.InvalidThresholdException {
        this(rotate, baseFilename, fmt, dfmt, FileLoggerHook.priorityOf(threshold), assumeWorking, logOverwrite, maxOldLogFilesDiskUsage);
    }

    private FileLoggerHook(String fmt, String dfmt, int threshold, boolean overwrite, long maxOldLogfilesDiskUsage) {
        super(threshold);
        this.maxOldLogfilesDiskUsage = maxOldLogfilesDiskUsage;
        this.logOverwrite = overwrite;
        this.setDateFormat(dfmt);
        this.setLogFormat(fmt);
    }

    private void setLogFormat(String fmt) {
        if (fmt == null || fmt.length() == 0) {
            fmt = "d:c:h:t:p:m";
        }
        char[] f = fmt.toCharArray();
        ArrayList<Integer> fmtVec = new ArrayList<Integer>();
        ArrayList<String> strVec = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean comment = false;
        for (int i = 0; i < f.length; ++i) {
            int type = FileLoggerHook.numberOf(f[i]);
            if (type == 7) {
                FileLoggerHook.getUName();
            }
            if (!comment && type != 0) {
                if (sb.length() > 0) {
                    strVec.add(sb.toString());
                    fmtVec.add(0);
                    sb = new StringBuilder();
                }
                fmtVec.add(type);
                continue;
            }
            if (f[i] == '\\') {
                comment = true;
                continue;
            }
            comment = false;
            sb.append(f[i]);
        }
        if (sb.length() > 0) {
            strVec.add(sb.toString());
            fmtVec.add(0);
        }
        this.fmt = new int[fmtVec.size()];
        int size = fmtVec.size();
        for (int i = 0; i < size; ++i) {
            this.fmt[i] = (Integer)fmtVec.get(i);
        }
        this.str = new String[strVec.size()];
        this.str = strVec.toArray(this.str);
    }

    private void setDateFormat(String dfmt) {
        if (dfmt != null && dfmt.length() != 0) {
            try {
                this.df = new SimpleDateFormat(dfmt);
            }
            catch (RuntimeException e) {
                this.df = DateFormat.getDateTimeInstance();
            }
        } else {
            this.df = DateFormat.getDateTimeInstance();
        }
        this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object o, Class<?> c, String msg, Throwable e, int priority) {
        if (!this.instanceShouldLog(priority, c)) {
            return;
        }
        if (this.closed) {
            return;
        }
        StringBuilder sb = new StringBuilder(e == null ? 512 : 1024);
        int sctr = 0;
        block13: for (int i = 0; i < this.fmt.length; ++i) {
            switch (this.fmt[i]) {
                case 0: {
                    sb.append(this.str[sctr++]);
                    continue block13;
                }
                case 1: {
                    long now = System.currentTimeMillis();
                    FileLoggerHook fileLoggerHook = this;
                    synchronized (fileLoggerHook) {
                        this.myDate.setTime(now);
                        sb.append(this.df.format(this.myDate));
                        continue block13;
                    }
                }
                case 2: {
                    sb.append(c == null ? "<none>" : c.getName());
                    continue block13;
                }
                case 3: {
                    sb.append(o == null ? "<none>" : Integer.toHexString(o.hashCode()));
                    continue block13;
                }
                case 4: {
                    sb.append(Thread.currentThread().getName());
                    continue block13;
                }
                case 5: {
                    sb.append(LoggerHook.priorityOf(priority));
                    continue block13;
                }
                case 6: {
                    sb.append(msg);
                    continue block13;
                }
                case 7: {
                    sb.append(uname);
                }
            }
        }
        sb.append('\n');
        for (int j = 0; j < 20 && e != null; ++j) {
            sb.append(e.toString());
            StackTraceElement[] trace = e.getStackTrace();
            if (trace == null) {
                sb.append("(null)\n");
            } else if (trace.length == 0) {
                sb.append("(no stack trace)\n");
            } else {
                sb.append('\n');
                for (int i = 0; i < trace.length; ++i) {
                    sb.append("\tat ");
                    sb.append(trace[i].toString());
                    sb.append('\n');
                }
            }
            Throwable cause = e.getCause();
            if (cause == e) break;
            e = cause;
        }
        this.logString(sb.toString().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logString(byte[] b) {
        int noElementCount = 0;
        LinkedList<byte[]> linkedList = this.list;
        synchronized (linkedList) {
            int sz = this.list.size();
            this.list.add(b);
            this.listBytes += (long)(b.length + 60);
            int x = 0;
            if (this.list.size() > this.MAX_LIST_SIZE || this.listBytes > this.MAX_LIST_BYTES) {
                while ((float)this.list.size() > (float)this.MAX_LIST_SIZE * 0.9f || (float)this.listBytes > (float)this.MAX_LIST_BYTES * 0.9f) {
                    byte[] ss;
                    try {
                        ss = this.list.removeFirst();
                    }
                    catch (NoSuchElementException e) {
                        if (++noElementCount <= 1000) continue;
                        System.err.println("Lost log line because of constant NoSuchElementException's");
                        e.printStackTrace();
                        return;
                    }
                    this.listBytes -= (long)(ss.length + 60);
                    ++x;
                }
                String err = "GRRR: ERROR: Logging too fast, chopped " + x + " entries, " + this.listBytes + " bytes in memory\n";
                byte[] buf = err.getBytes();
                this.list.add(0, buf);
                this.listBytes += (long)(buf.length + 60);
            }
            if (sz == 0) {
                this.list.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long listBytes() {
        LinkedList<byte[]> linkedList = this.list;
        synchronized (linkedList) {
            return this.listBytes;
        }
    }

    public static int numberOf(char c) {
        switch (c) {
            case 'd': {
                return 1;
            }
            case 'c': {
                return 2;
            }
            case 'h': {
                return 3;
            }
            case 't': {
                return 4;
            }
            case 'p': {
                return 5;
            }
            case 'm': {
                return 6;
            }
            case 'u': {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public long minFlags() {
        return 0L;
    }

    @Override
    public long notFlags() {
        return 1L;
    }

    @Override
    public long anyFlags() {
        return 0x1F & ~(this.threshold - 1);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listAvailableLogs(OutputStreamWriter writer) throws IOException {
        OldLogFile[] oldLogFiles;
        LinkedList<OldLogFile> linkedList = this.logFiles;
        synchronized (linkedList) {
            oldLogFiles = this.logFiles.toArray(new OldLogFile[this.logFiles.size()]);
        }
        DateFormat tempDF = DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH);
        tempDF.setTimeZone(TimeZone.getTimeZone("GMT"));
        for (int i = 0; i < oldLogFiles.length; ++i) {
            OldLogFile olf = oldLogFiles[i];
            writer.write(olf.filename.getName() + " : " + tempDF.format(new Date(olf.start)) + " to " + tempDF.format(new Date(olf.end)) + " - " + olf.size + " bytes\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLogByContainedDate(long time, OutputStream os) throws IOException {
        int toRead;
        OldLogFile toReturn = null;
        LinkedList<OldLogFile> linkedList = this.logFiles;
        synchronized (linkedList) {
            for (OldLogFile olf : this.logFiles) {
                boolean logMINOR = Logger.shouldLog(4, this);
                if (logMINOR) {
                    Logger.minor(this, "Checking " + time + " against " + olf.filename + " : start=" + olf.start + ", end=" + olf.end);
                }
                if (time < olf.start || time >= olf.end) continue;
                toReturn = olf;
                if (!logMINOR) break;
                Logger.minor(this, "Found " + olf);
                break;
            }
            if (toReturn == null) {
                return;
            }
        }
        FileInputStream fis = new FileInputStream(toReturn.filename);
        DataInputStream dis = new DataInputStream(fis);
        long size = toReturn.size;
        byte[] buf = new byte[4096];
        for (long written = 0L; written < size; written += (long)toRead) {
            toRead = (int)Math.min((long)buf.length, size - written);
            try {
                dis.readFully(buf, 0, toRead);
            }
            catch (IOException e) {
                Logger.error(this, "Could not read bytes " + written + " to " + (written + (long)toRead) + " from file " + toReturn.filename + " which is supposed to be " + size + " bytes (" + toReturn.filename.length() + ')');
                return;
            }
            os.write(buf, 0, toRead);
        }
        dis.close();
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxOldLogsSize(long val) {
        Object object = this.trimOldLogFilesLock;
        synchronized (object) {
            this.maxOldLogfilesDiskUsage = val;
        }
        Runnable r = new Runnable(){

            public void run() {
                FileLoggerHook.this.trimOldLogFiles();
            }
        };
        Thread t = new Thread(r, "Shrink logs");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchBaseFilename(String filename) {
        FileLoggerHook fileLoggerHook = this;
        synchronized (fileLoggerHook) {
            this.baseFilename = filename;
            this.switchedBaseFilename = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSwitch() {
        long now = System.currentTimeMillis();
        FileLoggerHook fileLoggerHook = this;
        synchronized (fileLoggerHook) {
            if (!this.switchedBaseFilename) {
                return;
            }
            long startTime = now;
            long endTime = startTime + 10000L;
            while ((now = System.currentTimeMillis()) < endTime && !this.switchedBaseFilename) {
                try {
                    this.wait(Math.max(1L, endTime - now));
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllOldLogFiles() {
        Object object = this.trimOldLogFilesLock;
        synchronized (object) {
            while (true) {
                OldLogFile olf;
                LinkedList<OldLogFile> linkedList = this.logFiles;
                synchronized (linkedList) {
                    if (this.logFiles.isEmpty()) {
                        return;
                    }
                    olf = this.logFiles.removeFirst();
                }
                olf.filename.delete();
                this.oldLogFilesDiskSpaceUsage -= olf.size;
                if (!Logger.shouldLog(4, this)) continue;
                Logger.minor(this, "Deleting " + olf.filename + " - saving " + olf.size + " bytes, disk usage now: " + this.oldLogFilesDiskSpaceUsage + " of " + this.maxOldLogfilesDiskUsage);
            }
        }
    }

    public boolean hasRedirectedStdOutErrNoLock() {
        return this.redirectStdOut || this.redirectStdErr;
    }

    class CloserThread
    extends Thread {
        CloserThread() {
        }

        public void run() {
            FileLoggerHook.this.closed = true;
        }
    }

    class WriterThread
    extends Thread {
        static final int maxSleepTime = 60000;

        WriterThread() {
            super("Log File Writer Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            LinkedList<OldLogFile> x2;
            File currentFilename = null;
            byte[] o = null;
            long lastTime = -1L;
            long nextHour = -1L;
            GregorianCalendar gc = null;
            if (FileLoggerHook.this.baseFilename != null) {
                FileLoggerHook.this.latestFile = new File(FileLoggerHook.this.baseFilename + "-latest.log");
                FileLoggerHook.this.previousFile = new File(FileLoggerHook.this.baseFilename + "-previous.log");
                FileLoggerHook.this.findOldLogFiles();
                gc = new GregorianCalendar();
                switch (FileLoggerHook.this.INTERVAL) {
                    case 1: {
                        gc.set(2, 0);
                    }
                    case 2: {
                        gc.set(5, 0);
                    }
                    case 3: {
                        if (FileLoggerHook.this.INTERVAL == 3) {
                            gc.set(7, 0);
                        }
                    }
                    case 5: {
                        gc.set(10, 0);
                    }
                    case 10: {
                        gc.set(12, 0);
                    }
                    case 12: {
                        gc.set(13, 0);
                        gc.set(14, 0);
                        break;
                    }
                }
                if (FileLoggerHook.this.INTERVAL_MULTIPLIER > 1) {
                    int x2 = gc.get(FileLoggerHook.this.INTERVAL);
                    gc.set(FileLoggerHook.this.INTERVAL, x2 / FileLoggerHook.this.INTERVAL_MULTIPLIER * FileLoggerHook.this.INTERVAL_MULTIPLIER);
                }
                currentFilename = new File(FileLoggerHook.this.getHourLogName(gc, -1, true));
                x2 = FileLoggerHook.this.logFiles;
                // MONITORENTER : x2
                if (!FileLoggerHook.this.logFiles.isEmpty() && FileLoggerHook.this.logFiles.getLast().filename.equals(currentFilename)) {
                    FileLoggerHook.this.logFiles.removeLast();
                }
                // MONITOREXIT : x2
                FileLoggerHook.this.logStream = this.openNewLogFile(currentFilename, true);
                if (FileLoggerHook.this.latestFile != null) {
                    FileLoggerHook.this.altLogStream = this.openNewLogFile(FileLoggerHook.this.latestFile, false);
                }
                System.err.println("Created log files");
                long startTime = gc.getTimeInMillis();
                if (Logger.shouldLog(4, this)) {
                    Logger.minor(this, "Start time: " + gc + " -> " + startTime);
                }
                lastTime = startTime;
                gc.add(FileLoggerHook.this.INTERVAL, FileLoggerHook.this.INTERVAL_MULTIPLIER);
                nextHour = gc.getTimeInMillis();
            }
            while (true) {
                try {
                    while (true) {
                        long thisTime = System.currentTimeMillis();
                        if (FileLoggerHook.this.baseFilename != null && (thisTime > nextHour || FileLoggerHook.this.switchedBaseFilename)) {
                            currentFilename = this.rotateLog(currentFilename, lastTime, nextHour, gc);
                            gc.add(FileLoggerHook.this.INTERVAL, FileLoggerHook.this.INTERVAL_MULTIPLIER);
                            lastTime = nextHour;
                            nextHour = gc.getTimeInMillis();
                            if (FileLoggerHook.this.switchedBaseFilename) {
                                x2 = FileLoggerHook.class;
                                // MONITORENTER : freenet.support.FileLoggerHook.class
                                FileLoggerHook.this.switchedBaseFilename = false;
                                // MONITOREXIT : x2
                            }
                        }
                        if (FileLoggerHook.this.list.size() == 0) {
                            if (currentFilename == null) {
                                this.myWrite(FileLoggerHook.this.logStream, null);
                            }
                            if (FileLoggerHook.this.altLogStream != null) {
                                this.myWrite(FileLoggerHook.this.altLogStream, null);
                            }
                        }
                        x2 = FileLoggerHook.this.list;
                        // MONITORENTER : x2
                        while (FileLoggerHook.this.list.size() == 0) {
                            if (FileLoggerHook.this.closed) {
                                // MONITOREXIT : x2
                                return;
                            }
                            try {
                                FileLoggerHook.this.list.wait(500L);
                            }
                            catch (InterruptedException e) {}
                        }
                        o = FileLoggerHook.this.list.removeFirst();
                        FileLoggerHook.this.listBytes -= (long)(o.length + 60);
                        // MONITOREXIT : x2
                        this.myWrite(FileLoggerHook.this.logStream, o);
                        if (FileLoggerHook.this.altLogStream == null) continue;
                        this.myWrite(FileLoggerHook.this.altLogStream, o);
                    }
                }
                catch (OutOfMemoryError e) {
                    System.err.println(e.getClass());
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable t) {
                    System.err.println("FileLoggerHook log writer caught " + t);
                    t.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File rotateLog(File currentFilename, long lastTime, long nextHour, GregorianCalendar gc) {
            try {
                FileLoggerHook.this.logStream.flush();
                if (FileLoggerHook.this.altLogStream != null) {
                    FileLoggerHook.this.altLogStream.flush();
                }
            }
            catch (IOException e) {
                System.err.println("Flushing on change caught " + e);
            }
            try {
                FileLoggerHook.this.logStream.close();
            }
            catch (IOException e) {
                System.err.println("Closing on change caught " + e);
            }
            long length = currentFilename.length();
            OldLogFile olf = new OldLogFile(currentFilename, lastTime, nextHour, length);
            LinkedList<OldLogFile> linkedList = FileLoggerHook.this.logFiles;
            synchronized (linkedList) {
                FileLoggerHook.this.logFiles.addLast(olf);
            }
            FileLoggerHook.this.oldLogFilesDiskSpaceUsage += length;
            FileLoggerHook.this.trimOldLogFiles();
            currentFilename = new File(FileLoggerHook.this.getHourLogName(gc, -1, true));
            FileLoggerHook.this.logStream = this.openNewLogFile(currentFilename, true);
            if (FileLoggerHook.this.latestFile != null) {
                try {
                    FileLoggerHook.this.altLogStream.close();
                }
                catch (IOException e) {
                    System.err.println("Closing alt on change caught " + e);
                }
                if (FileLoggerHook.this.previousFile != null && FileLoggerHook.this.previousFile.exists()) {
                    FileUtil.renameTo(FileLoggerHook.this.latestFile, FileLoggerHook.this.previousFile);
                }
                FileLoggerHook.this.latestFile.delete();
                FileLoggerHook.this.altLogStream = this.openNewLogFile(FileLoggerHook.this.latestFile, false);
            }
            return currentFilename;
        }

        protected void myWrite(OutputStream os, byte[] b) {
            long sleepTime = 1000L;
            while (true) {
                boolean thrown = false;
                try {
                    if (b != null) {
                        os.write(b);
                    } else {
                        os.flush();
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception writing to log: " + e + ", sleeping " + sleepTime);
                    thrown = true;
                }
                if (!thrown) break;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((sleepTime += sleepTime) <= 60000L) continue;
                sleepTime = 60000L;
            }
        }

        protected OutputStream openNewLogFile(File filename, boolean compress) {
            while (true) {
                long sleepTime = 1000L;
                try {
                    OutputStream o = new FileOutputStream(filename, !FileLoggerHook.this.logOverwrite);
                    if (compress) {
                        o = new BufferedOutputStream(o, 32768);
                        o = new GZIPOutputStream(o);
                        o = new BufferedOutputStream(o, 65536);
                    } else {
                        o = new BufferedOutputStream(o, 32768);
                    }
                    return o;
                }
                catch (IOException e) {
                    System.err.println("Could not create FOS " + filename + ": " + e);
                    System.err.println("Sleeping " + sleepTime / 1000L + " seconds");
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    long l = sleepTime + sleepTime;
                    continue;
                }
                break;
            }
        }
    }

    public static class IntervalParseException
    extends Exception {
        private static final long serialVersionUID = 69847854744673572L;

        public IntervalParseException(String string) {
            super(string);
        }
    }

    private static class OldLogFile {
        final File filename;
        final long start;
        final long end;
        final long size;

        public OldLogFile(File currentFilename, long startTime, long endTime, long length) {
            this.filename = currentFilename;
            this.start = startTime;
            this.end = endTime;
            this.size = length;
        }
    }
}

