/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.client.ArchiveManager;
import freenet.client.async.ManifestElement;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerSizeEstimator {
    public static final ArchiveManager.ARCHIVE_TYPE DEFAULT_ARCHIVE_TYPE = ArchiveManager.ARCHIVE_TYPE.TAR;

    private ContainerSizeEstimator() {
    }

    public static ContainerSize getSubTreeSize(HashMap<String, Object> metadata, long maxItemSize, long maxContainerSize, int maxDeep) {
        ContainerSize result = new ContainerSize();
        ContainerSizeEstimator.getSubTreeSize(metadata, result, maxItemSize, maxContainerSize, maxDeep);
        return result;
    }

    private static void getSubTreeSize(HashMap<String, Object> metadata, ContainerSize result, long maxItemSize, long maxContainerSize, int maxDeep) {
        Object o;
        Set<String> set = metadata.keySet();
        for (String name : set) {
            ManifestElement me;
            long itemsize;
            o = metadata.get(name);
            if (!(o instanceof ManifestElement) || (itemsize = (me = (ManifestElement)o).getSize()) <= -1L) continue;
            result._sizeFilesNoLimit += ContainerSizeEstimator.getContainerItemSize(me.getSize());
            if (itemsize > maxItemSize) {
                result._sizeFiles += 512L;
            } else {
                result._sizeFiles += ContainerSizeEstimator.getContainerItemSize(me.getSize());
            }
            if (result._sizeFiles <= maxContainerSize) continue;
            break;
        }
        if (maxDeep > 0) {
            for (String name : set) {
                o = metadata.get(name);
                if (!(o instanceof HashMap)) continue;
                result._sizeSubTrees += 512L;
                HashMap hm = (HashMap)o;
                ContainerSize tempResult = new ContainerSize();
                ContainerSizeEstimator.getSubTreeSize(hm, tempResult, maxItemSize, maxContainerSize - result._sizeSubTrees, maxDeep - 1);
                result._sizeSubTrees += tempResult.getSizeTotal();
                result._sizeSubTreesNoLimit += tempResult.getSizeTotalNoLimit();
                if (result._sizeSubTrees <= maxContainerSize) continue;
                break;
            }
        }
    }

    public static long getContainerItemSize(long size) {
        return ContainerSizeEstimator.getContainerItemSize(DEFAULT_ARCHIVE_TYPE, size);
    }

    private static long getContainerItemSize(ArchiveManager.ARCHIVE_TYPE archiveType, long size) {
        if (archiveType == ArchiveManager.ARCHIVE_TYPE.TAR) {
            return ContainerSizeEstimator.tarItemSize(size);
        }
        throw new UnsupportedOperationException("TODO, only TAR supportet atm.");
    }

    public static final long tarItemSize(long size) {
        return 512L + (size + 511L) / 512L * 512L;
    }

    public static final class ContainerSize {
        private long _sizeFiles = 0L;
        private long _sizeFilesNoLimit = 0L;
        private long _sizeSubTrees = 0L;
        private long _sizeSubTreesNoLimit = 0L;

        private ContainerSize() {
        }

        public long getSizeTotal() {
            return this._sizeFiles + this._sizeSubTrees;
        }

        public long getSizeTotalNoLimit() {
            return this._sizeFilesNoLimit + this._sizeSubTreesNoLimit;
        }

        public long getSizeFiles() {
            return this._sizeFiles;
        }

        public long getSizeFilesNoLimit() {
            return this._sizeFilesNoLimit;
        }

        public long getSizeSubTrees() {
            return this._sizeSubTrees;
        }

        public long getSizeSubTreesNoLimit() {
            return this._sizeSubTreesNoLimit;
        }
    }
}

