/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream
implements DataInput {
    protected ByteBuffer buf;

    public ByteBufferInputStream(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteBufferInputStream(byte[] array, int offset, int length) {
        this(ByteBuffer.wrap(array, offset, length));
    }

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    public int read() throws IOException {
        try {
            return this.buf.get() & Integer.MAX_VALUE;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public boolean readBoolean() throws IOException {
        try {
            return this.buf.get() != 0;
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public byte readByte() throws IOException {
        try {
            return this.buf.get();
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public char readChar() throws IOException {
        try {
            return this.buf.getChar();
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public double readDouble() throws IOException {
        try {
            return this.buf.getDouble();
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public float readFloat() throws IOException {
        try {
            return this.buf.getFloat();
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void readFully(byte[] b) throws IOException {
        try {
            this.buf.get(b);
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.buf.get(b, off, len);
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public int readInt() throws IOException {
        try {
            return this.buf.getInt();
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public long readLong() throws IOException {
        try {
            return this.buf.getLong();
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public short readShort() throws IOException {
        try {
            return this.buf.getShort();
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public int readUnsignedByte() throws IOException {
        try {
            return this.buf.get() & 0xFF;
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public int readUnsignedShort() throws IOException {
        try {
            return this.buf.getShort() & 0xFFFF;
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public int skipBytes(int n) throws IOException {
        int skip = Math.min(n, this.buf.remaining());
        this.buf.position(this.buf.position() + skip);
        return skip;
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Deprecated
    public String readLine() throws IOException {
        return new DataInputStream(this).readLine();
    }

    public ByteBufferInputStream slice(int size) throws IOException {
        try {
            if (this.buf.remaining() < size) {
                throw new EOFException();
            }
            ByteBuffer bf2 = this.buf.slice();
            bf2.limit(size);
            this.skip(size);
            return new ByteBufferInputStream(bf2);
        }
        catch (BufferUnderflowException e) {
            EOFException ioe = new EOFException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

