/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.BinaryBloomFilter;
import freenet.support.CountingBloomFilter;
import freenet.support.NullBloomFilter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.spaceroots.mantissa.random.MersenneTwister;

public abstract class BloomFilter {
    protected ByteBuffer filter;
    protected final int k;
    protected final int length;
    protected ReadWriteLock lock = new ReentrantReadWriteLock();
    protected BloomFilter forkedFilter;
    protected boolean needRebuild;

    public static BloomFilter createFilter(int length, int k, boolean counting) {
        if (length == 0) {
            return new NullBloomFilter(length, k);
        }
        if (counting) {
            return new CountingBloomFilter(length, k);
        }
        return new BinaryBloomFilter(length, k);
    }

    public static BloomFilter createFilter(File file, int length, int k, boolean counting) throws IOException {
        if (length == 0) {
            return new NullBloomFilter(length, k);
        }
        if (counting) {
            return new CountingBloomFilter(file, length, k);
        }
        return new BinaryBloomFilter(file, length, k);
    }

    protected BloomFilter(int length, int k) {
        if (length % 8 != 0) {
            length -= length % 8;
        }
        this.length = length;
        this.k = k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKey(byte[] key) {
        Random hashes = this.getHashes(key);
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < this.k; ++i) {
                this.setBit(hashes.nextInt(this.length));
            }
            Object var5_4 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
        if (this.forkedFilter != null) {
            this.forkedFilter.addKey(key);
        }
    }

    public void addKeyForked(byte[] key) {
        if (this.forkedFilter != null) {
            this.forkedFilter.addKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkFilter(byte[] key) {
        Random hashes = this.getHashes(key);
        this.lock.readLock().lock();
        try {
            int i = 0;
            while (true) {
                if (i >= this.k) {
                    Object var6_6 = null;
                    this.lock.readLock().unlock();
                    return true;
                }
                if (!this.getBit(hashes.nextInt(this.length))) {
                    boolean bl = false;
                    Object var6_5 = null;
                    this.lock.readLock().unlock();
                    return bl;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(byte[] key) {
        Random hashes = this.getHashes(key);
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < this.k; ++i) {
                this.unsetBit(hashes.nextInt(this.length));
            }
            Object var5_4 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
        if (this.forkedFilter != null) {
            this.forkedFilter.removeKey(key);
        }
    }

    protected abstract boolean getBit(int var1);

    protected abstract void setBit(int var1);

    protected abstract void unsetBit(int var1);

    public void unsetAll() {
        int x = this.filter.limit();
        for (int i = 0; i < x; ++i) {
            this.filter.put(i, (byte)0);
        }
    }

    protected Random getHashes(byte[] key) {
        return new MersenneTwister(key);
    }

    public abstract void fork(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge() {
        this.lock.writeLock().lock();
        try {
            if (this.forkedFilter == null) {
                Object var5_1 = null;
                this.lock.writeLock().unlock();
                return;
            }
            Lock forkedLock = this.forkedFilter.lock.writeLock();
            forkedLock.lock();
            try {
                this.filter.position(0);
                this.forkedFilter.filter.position(0);
                this.filter.put(this.forkedFilter.filter);
                this.filter.position(0);
                this.forkedFilter.close();
                this.forkedFilter = null;
                Object var3_5 = null;
                forkedLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                forkedLock.unlock();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
        Object var5_2 = null;
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() {
        this.lock.writeLock().lock();
        try {
            if (this.forkedFilter == null) {
                Object var2_1 = null;
                this.lock.writeLock().unlock();
                return;
            }
            this.forkedFilter.close();
            this.forkedFilter = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
        Object var2_2 = null;
        this.lock.writeLock().unlock();
    }

    public static int optimialK(int filterLength, long maxKey) {
        long k = Math.round(Math.log(2.0) * (double)filterLength / (double)maxKey);
        if (k > 64L) {
            k = 64L;
        }
        if (k < 1L) {
            k = 1L;
        }
        return (int)k;
    }

    public int getK() {
        return this.k;
    }

    public boolean needRebuild() {
        boolean _needRebuild = this.needRebuild;
        this.needRebuild = false;
        return _needRebuild;
    }

    public void force() {
        if (this.filter instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this.filter).force();
        }
    }

    public void close() {
        if (this.filter != null) {
            this.force();
        }
        this.filter = null;
        this.forkedFilter = null;
    }

    protected void finalize() {
        this.close();
    }
}

