/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.io.WritableToDataOutputStream;
import freenet.support.Fields;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class BitArray
implements WritableToDataOutputStream {
    public static final String VERSION = "$Id: BitArray.java,v 1.2 2005/08/25 17:28:19 amphibian Exp $";
    private final int _size;
    private final byte[] _bits;

    public BitArray(byte[] data) {
        this._bits = data;
        this._size = data.length * 8;
    }

    public BitArray(DataInput dis) throws IOException {
        this._size = dis.readInt();
        this._bits = new byte[this._size / 8 + (this._size % 8 == 0 ? 0 : 1)];
        dis.readFully(this._bits);
    }

    public BitArray(DataInput dis, int maxSize) throws IOException {
        this._size = dis.readInt();
        if (this._size <= 0 || this._size > maxSize) {
            throw new IOException("Unacceptable bitarray size: " + this._size);
        }
        this._bits = new byte[this._size / 8 + (this._size % 8 == 0 ? 0 : 1)];
        dis.readFully(this._bits);
    }

    public BitArray(int size) {
        this._size = size;
        this._bits = new byte[size / 8 + (size % 8 == 0 ? 0 : 1)];
    }

    public BitArray(BitArray src) {
        this._size = src._size;
        this._bits = new byte[src._bits.length];
        System.arraycopy(src._bits, 0, this._bits, 0, src._bits.length);
    }

    public void setBit(int pos, boolean f) {
        int b = BitArray.unsignedByteToInt(this._bits[pos / 8]);
        int mask = 1 << pos % 8;
        this._bits[pos / 8] = f ? (byte)(b | mask) : (byte)(b & ~mask);
    }

    public boolean bitAt(int pos) {
        int mask;
        int b = BitArray.unsignedByteToInt(this._bits[pos / 8]);
        return (b & (mask = 1 << pos % 8)) != 0;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._size);
        for (int x = 0; x < this._size; ++x) {
            if (this.bitAt(x)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }

    public void writeToDataOutputStream(DataOutputStream dos) throws IOException {
        dos.writeInt(this._size);
        dos.write(this._bits);
    }

    public static int serializedLength(int size) {
        return size / 8 + (size % 8 == 0 ? 0 : 1) + 4;
    }

    public int getSize() {
        return this._size;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitArray)) {
            return false;
        }
        BitArray ba = (BitArray)o;
        if (ba.getSize() != this.getSize()) {
            return false;
        }
        for (int x = 0; x < this.getSize(); ++x) {
            if (ba.bitAt(x) == this.bitAt(x)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Fields.hashCode(this._bits);
    }

    public void setAllOnes() {
        for (int i = 0; i < this._bits.length; ++i) {
            this._bits[i] = -1;
        }
    }

    public int firstOne() {
        for (int i = 0; i < this._bits.length; ++i) {
            byte b = this._bits[i];
            if (b == 0) continue;
            for (int j = 0; j < 8; ++j) {
                int mask = 1 << j;
                if ((b & mask) == 0) continue;
                int x = i * 8 + j;
                if (x >= this._size) {
                    return -1;
                }
                return x;
            }
        }
        return -1;
    }
}

