/*
 * Decompiled with CFR 0.152.
 */
package freenet.store.saltedhash;

import freenet.keys.KeyVerifyException;
import freenet.l10n.L10n;
import freenet.node.SemiOrderedShutdownHook;
import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.store.saltedhash.CipherManager;
import freenet.store.saltedhash.LockManager;
import freenet.support.BloomFilter;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.spaceroots.mantissa.random.MersenneTwister;
import org.tanukisoftware.wrapper.WrapperManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaltedHashFreenetStore
implements FreenetStore {
    private static final boolean OPTION_SAVE_PLAINKEY = false;
    private static final int OPTION_MAX_PROBE = 5;
    private static final byte FLAG_DIRTY = 1;
    private static final byte FLAG_REBUILD_BLOOM = 2;
    private boolean checkBloom = true;
    private int bloomFilterSize;
    private int bloomFilterK;
    private final BloomFilter bloomFilter;
    private static boolean logMINOR;
    private static boolean logDEBUG;
    private final File baseDir;
    private final String name;
    private final StoreCallback callback;
    private final boolean collisionPossible;
    private final int headerBlockLength;
    private final int fullKeyLength;
    private final int dataBlockLength;
    private final Random random;
    private long storeSize;
    private int generation;
    private int flags;
    private boolean preallocate = true;
    private File metaFile;
    private RandomAccessFile metaRAF;
    private FileChannel metaFC;
    private File hdFile;
    private RandomAccessFile hdRAF;
    private FileChannel hdFC;
    private final int hdPadding;
    private volatile long storeFileOffsetReady = -1L;
    private final File configFile;
    private long prevStoreSize = 0L;
    private Lock cleanerLock = new ReentrantLock();
    private Condition cleanerCondition = this.cleanerLock.newCondition();
    private static Lock cleanerGlobalLock;
    private Cleaner cleanerThread;
    private CleanerStatusUserAlert cleanerStatusUserAlert;
    private final Entry NOT_MODIFIED = new Entry();
    volatile boolean shutdown = false;
    private LockManager lockManager;
    private ReadWriteLock configLock = new ReentrantReadWriteLock();
    private CipherManager cipherManager;
    private AtomicLong hits = new AtomicLong();
    private AtomicLong misses = new AtomicLong();
    private AtomicLong writes = new AtomicLong();
    private AtomicLong keyCount = new AtomicLong();
    private AtomicLong bloomFalsePos = new AtomicLong();

    public static SaltedHashFreenetStore construct(File baseDir, String name, StoreCallback callback, Random random, long maxKeys, int bloomFilterSize, boolean bloomCounting, SemiOrderedShutdownHook shutdownHook, boolean preallocate, boolean resizeOnStart) throws IOException {
        return new SaltedHashFreenetStore(baseDir, name, callback, random, maxKeys, bloomFilterSize, bloomCounting, shutdownHook, preallocate, resizeOnStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaltedHashFreenetStore(File baseDir, String name, StoreCallback callback, Random random, long maxKeys, int bloomFilterSize, boolean bloomCounting, SemiOrderedShutdownHook shutdownHook, boolean preallocate, boolean resizeOnStart) throws IOException {
        logMINOR = Logger.shouldLog(4, this);
        logDEBUG = Logger.shouldLog(2, this);
        this.baseDir = baseDir;
        this.name = name;
        this.callback = callback;
        this.collisionPossible = callback.collisionPossible();
        this.headerBlockLength = callback.headerLength();
        this.fullKeyLength = callback.fullKeyLength();
        this.dataBlockLength = callback.dataLength();
        this.hdPadding = (this.headerBlockLength + this.dataBlockLength) % 512 == 0 ? 0 : 512 - (this.headerBlockLength + this.dataBlockLength) % 512;
        this.random = random;
        this.storeSize = maxKeys;
        this.bloomFilterSize = bloomFilterSize;
        this.preallocate = preallocate;
        this.lockManager = new LockManager();
        this.baseDir.mkdirs();
        this.configFile = new File(this.baseDir, name + ".config");
        boolean newStore = this.loadConfigFile();
        newStore |= this.openStoreFiles(baseDir, name);
        File bloomFile = new File(this.baseDir, name + ".bloom");
        this.bloomFilter = BloomFilter.createFilter(bloomFile, bloomFilterSize, this.bloomFilterK, bloomCounting);
        System.err.println("Bloomfilter (" + this.bloomFilter + ") for " + name + " is loaded.");
        if ((this.flags & 1) != 0) {
            System.err.println("Datastore(" + name + ") is dirty.");
        }
        this.flags |= 1;
        this.writeConfigFile();
        if (maxKeys != this.storeSize) {
            if (this.prevStoreSize != 0L) {
                this.storeSize = Math.max(this.prevStoreSize, this.storeSize);
                this.prevStoreSize = 0L;
            }
            this.setMaxKeys(maxKeys, true);
        }
        callback.setStore(this);
        shutdownHook.addEarlyJob(new Thread(new ShutdownDB()));
        this.cleanerThread = new Cleaner();
        this.cleanerStatusUserAlert = new CleanerStatusUserAlert(this.cleanerThread);
        if (resizeOnStart && this.prevStoreSize != 0L && cleanerGlobalLock.tryLock()) {
            System.out.println("Resizing datastore (" + name + ")");
            try {
                this.cleanerThread.resizeStore(this.prevStoreSize, false);
                Object var15_13 = null;
                cleanerGlobalLock.unlock();
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                cleanerGlobalLock.unlock();
                throw throwable;
            }
            this.writeConfigFile();
        }
        if (this.bloomFilter.needRebuild() && !newStore) {
            this.flags |= 2;
            this.checkBloom = false;
        }
        System.err.println(" checkBloom=" + this.checkBloom + ", flags=" + this.flags + " bloom size = " + bloomFilterSize + " keys = " + maxKeys);
        this.cleanerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StorableBlock fetch(byte[] routingKey, byte[] fullKey, boolean dontPromote) throws IOException {
        block24: {
            block23: {
                block21: {
                    if (SaltedHashFreenetStore.logMINOR) {
                        Logger.minor(this, "Fetch " + HexUtil.bytesToHex(routingKey) + " for " + this.callback);
                    }
                    try {
                        retry = 0;
                        while (!this.configLock.readLock().tryLock(2L, TimeUnit.SECONDS)) {
                            if (this.shutdown) {
                                return null;
                            }
                            if (retry++ <= 10) continue;
                            throw new IOException("lock timeout (20s)");
                        }
                    }
                    catch (InterruptedException e) {
                        throw new IOException("interrupted: " + e);
                    }
                    try {
                        lockMap = this.lockPlainKey(routingKey, true);
                        if (lockMap == null) {
                            if (SaltedHashFreenetStore.logDEBUG) {
                                Logger.debug(this, "cannot lock key: " + HexUtil.bytesToHex(routingKey) + ", shutting down?");
                            }
                            var5_7 = null;
                            var11_9 = null;
                            this.configLock.readLock().unlock();
                            return var5_7;
                        }
                        entry = this.probeEntry(routingKey, true);
                        if (entry == null) {
                            this.misses.incrementAndGet();
                            var6_15 = null;
                            var9_18 = null;
                            this.unlockPlainKey(routingKey, true, lockMap);
                            break block21;
                        }
                        ** GOTO lbl40
                        {
                            block22: {
                                catch (Throwable var8_26) {
                                    var9_22 = null;
                                    this.unlockPlainKey(routingKey, true, lockMap);
                                    throw var8_26;
                                }
lbl40:
                                // 2 sources

                                block = Entry.access$200(entry, routingKey, fullKey);
                                if (block != null) break block22;
                                this.misses.incrementAndGet();
                                var7_23 = null;
                                var9_19 = null;
                                this.unlockPlainKey(routingKey, true, lockMap);
                                break block23;
                            }
                            try {
                                this.hits.incrementAndGet();
                                var7_24 = block;
                            }
                            catch (KeyVerifyException e) {}
                            {
                                Logger.minor(this, "key verification exception", (Throwable)e);
                                this.misses.incrementAndGet();
                                var7_25 = null;
                                var9_21 = null;
                                this.unlockPlainKey(routingKey, true, lockMap);
                            }
                            var11_13 = null;
                            this.configLock.readLock().unlock();
                            return var7_25;
                            var9_20 = null;
                            this.unlockPlainKey(routingKey, true, lockMap);
                            break block24;
                        }
                    }
                    catch (Throwable var10_27) {
                        var11_14 = null;
                        this.configLock.readLock().unlock();
                        throw var10_27;
                    }
                }
                var11_10 = null;
                this.configLock.readLock().unlock();
                return var6_15;
            }
            var11_11 = null;
            this.configLock.readLock().unlock();
            return var7_23;
        }
        var11_12 = null;
        this.configLock.readLock().unlock();
        return var7_24;
    }

    private Entry probeEntry(byte[] routingKey, boolean withData) throws IOException {
        if (this.checkBloom && !this.bloomFilter.checkFilter(this.cipherManager.getDigestedKey(routingKey))) {
            return null;
        }
        Entry entry = this.probeEntry0(routingKey, this.storeSize, withData);
        if (entry == null && this.prevStoreSize != 0L) {
            entry = this.probeEntry0(routingKey, this.prevStoreSize, withData);
        }
        if (this.checkBloom && entry == null) {
            this.bloomFalsePos.incrementAndGet();
        }
        return entry;
    }

    private Entry probeEntry0(byte[] routingKey, long probeStoreSize, boolean withData) throws IOException {
        Entry entry = null;
        long[] offset = this.getOffsetFromPlainKey(routingKey, probeStoreSize);
        for (int i = 0; i < offset.length; ++i) {
            if (logDEBUG) {
                Logger.debug(this, "probing for i=" + i + ", offset=" + offset[i]);
            }
            try {
                entry = this.readEntry(offset[i], routingKey, withData);
                if (entry == null) continue;
                return entry;
            }
            catch (EOFException e) {
                if (this.prevStoreSize != 0L) continue;
                Logger.error(this, "EOFException on probeEntry", e);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public void put(StorableBlock block, byte[] data, byte[] header, boolean overwrite) throws IOException, KeyCollisionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean openStoreFiles(File baseDir, String name) throws IOException {
        this.metaFile = new File(baseDir, name + ".metadata");
        this.hdFile = new File(baseDir, name + ".hd");
        boolean newStore = !this.metaFile.exists() || !this.hdFile.exists();
        this.metaRAF = new RandomAccessFile(this.metaFile, "rw");
        this.metaFC = this.metaRAF.getChannel();
        this.metaFC.lock();
        this.hdRAF = new RandomAccessFile(this.hdFile, "rw");
        this.hdFC = this.hdRAF.getChannel();
        this.hdFC.lock();
        long storeFileSize = Math.max(this.storeSize, this.prevStoreSize);
        WrapperManager.signalStarting((int)600000);
        this.setStoreFileSize(storeFileSize, true);
        return newStore;
    }

    private Entry readEntry(long offset, byte[] routingKey, boolean withData) throws IOException {
        ByteBuffer mbf = ByteBuffer.allocate(128);
        do {
            int status;
            if ((status = this.metaFC.read(mbf, 128L * offset + (long)mbf.position())) != -1) continue;
            throw new EOFException();
        } while (mbf.hasRemaining());
        mbf.flip();
        Entry entry = new Entry(mbf, null);
        entry.curOffset = offset;
        if (routingKey != null) {
            if (entry.isFree()) {
                return null;
            }
            if (!Arrays.equals(this.cipherManager.getDigestedKey(routingKey), entry.digestedRoutingKey)) {
                return null;
            }
            if (withData) {
                ByteBuffer hdBuf = this.readHD(offset);
                entry.setHD(hdBuf);
                boolean decrypted = this.cipherManager.decrypt(entry, routingKey);
                if (!decrypted) {
                    return null;
                }
            }
        }
        return entry;
    }

    private ByteBuffer readHD(long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(this.headerBlockLength + this.dataBlockLength + this.hdPadding);
        long pos = (long)(this.headerBlockLength + this.dataBlockLength + this.hdPadding) * offset;
        do {
            int status;
            if ((status = this.hdFC.read(buf, pos + (long)buf.position())) != -1) continue;
            throw new EOFException();
        } while (buf.hasRemaining());
        buf.flip();
        return buf;
    }

    private boolean isFree(long offset) throws IOException {
        Entry entry = this.readEntry(offset, null, false);
        return entry.isFree();
    }

    private byte[] getDigestedKeyFromOffset(long offset) throws IOException {
        Entry entry = this.readEntry(offset, null, false);
        return entry.getDigestedRoutingKey();
    }

    private void writeEntry(Entry entry, long offset) throws IOException {
        this.cipherManager.encrypt(entry, this.random);
        ByteBuffer bf = entry.toMetaDataBuffer();
        do {
            int status;
            if ((status = this.metaFC.write(bf, 128L * offset + (long)bf.position())) != -1) continue;
            throw new EOFException();
        } while (bf.hasRemaining());
        bf = entry.toHDBuffer();
        if (bf != null) {
            long pos = (long)(this.headerBlockLength + this.dataBlockLength + this.hdPadding) * offset;
            do {
                int status;
                if ((status = this.hdFC.write(bf, pos + (long)bf.position())) != -1) continue;
                throw new EOFException();
            } while (bf.hasRemaining());
        }
        entry.curOffset = offset;
    }

    private void flushAndClose() {
        Logger.normal(this, "Flush and closing this store: " + this.name);
        try {
            this.metaFC.force(true);
            this.metaFC.close();
        }
        catch (Exception e) {
            Logger.error(this, "error flusing store", e);
        }
        try {
            this.hdFC.force(true);
            this.hdFC.close();
        }
        catch (Exception e) {
            Logger.error(this, "error flusing store", e);
        }
        this.bloomFilter.force();
    }

    public void setPreallocate(boolean preallocate) {
        this.preallocate = preallocate;
    }

    private void setStoreFileSize(long storeMaxEntries, boolean starting) {
        try {
            long oldMetaLen = this.metaRAF.length();
            long currentHdLen = this.hdRAF.length();
            long newMetaLen = 128L * storeMaxEntries;
            long newHdLen = (long)(this.headerBlockLength + this.dataBlockLength + this.hdPadding) * storeMaxEntries;
            if (this.preallocate) {
                byte[] b = new byte[4096];
                ByteBuffer bf = ByteBuffer.wrap(b);
                if (oldMetaLen % 4096L != 0L) {
                    oldMetaLen += 4096L - oldMetaLen % 4096L;
                }
                if (currentHdLen % 4096L != 0L) {
                    currentHdLen += 4096L - currentHdLen % 4096L;
                }
                this.storeFileOffsetReady = -1L;
                while (oldMetaLen < newMetaLen) {
                    bf.rewind();
                    this.metaFC.write(bf, oldMetaLen);
                    oldMetaLen += 4096L;
                }
                byte[] seed = new byte[64];
                this.random.nextBytes(seed);
                MersenneTwister mt = new MersenneTwister(seed);
                int x = 0;
                while (currentHdLen < newHdLen) {
                    mt.nextBytes(b);
                    bf.rewind();
                    this.hdFC.write(bf, currentHdLen);
                    if ((currentHdLen += 4096L) % 0x40000000L == 0L) {
                        this.random.nextBytes(seed);
                        mt = new MersenneTwister(seed);
                        if (starting) {
                            WrapperManager.signalStarting((int)300000);
                            if (x++ % 32 == 0) {
                                System.err.println("Preallocating space for " + this.name + ": " + currentHdLen + "/" + newHdLen);
                            }
                        }
                    }
                    this.storeFileOffsetReady = currentHdLen / (long)(this.headerBlockLength + this.dataBlockLength + this.hdPadding);
                }
            }
            this.storeFileOffsetReady = 1L + storeMaxEntries;
            this.metaRAF.setLength(newMetaLen);
            this.hdRAF.setLength(newHdLen);
        }
        catch (IOException e) {
            Logger.error(this, "error resizing store file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadConfigFile() throws IOException {
        assert (this.cipherManager == null);
        if (!this.configFile.exists()) {
            byte[] newsalt = new byte[16];
            this.random.nextBytes(newsalt);
            this.cipherManager = new CipherManager(newsalt);
            this.bloomFilterK = BloomFilter.optimialK(this.bloomFilterSize, this.storeSize);
            this.writeConfigFile();
            return true;
        }
        try {
            boolean bl;
            RandomAccessFile raf = new RandomAccessFile(this.configFile, "r");
            try {
                byte[] salt = new byte[16];
                raf.readFully(salt);
                this.cipherManager = new CipherManager(salt);
                this.storeSize = raf.readLong();
                this.prevStoreSize = raf.readLong();
                this.keyCount.set(raf.readLong());
                this.generation = raf.readInt();
                this.flags = raf.readInt();
                if ((this.flags & 1) != 0) {
                    this.flags |= 2;
                }
                try {
                    this.bloomFilterK = raf.readInt();
                    if (this.bloomFilterK == 0) {
                        this.bloomFilterK = BloomFilter.optimialK(this.bloomFilterSize, this.storeSize);
                        this.flags |= 2;
                        this.checkBloom = false;
                    }
                }
                catch (IOException e) {
                    this.flags |= 2;
                }
                bl = false;
                Object var5_8 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                Closer.close(raf);
                throw throwable;
            }
            Closer.close(raf);
            return bl;
        }
        catch (IOException e) {
            Logger.error(this, "config file corrupted, trying to create a new store: " + this.name, e);
            System.err.println("config file corrupted, trying to create a new store: " + this.name);
            if (this.configFile.exists() && this.configFile.delete()) {
                File metaFile = new File(this.baseDir, this.name + ".metadata");
                metaFile.delete();
                return this.loadConfigFile();
            }
            Logger.error(this, "can't delete config file, please delete the store manually: " + this.name, e);
            System.err.println("can't delete config file, please delete the store manually: " + this.name);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigFile() {
        this.configLock.writeLock().lock();
        try {
            try {
                File tempConfig = new File(this.configFile.getPath() + ".tmp");
                RandomAccessFile raf = new RandomAccessFile(tempConfig, "rw");
                raf.seek(0L);
                raf.write(this.cipherManager.getSalt());
                raf.writeLong(this.storeSize);
                raf.writeLong(this.prevStoreSize);
                raf.writeLong(this.keyCount.get());
                raf.writeInt(this.generation);
                raf.writeInt(this.flags);
                raf.writeInt(this.bloomFilterK);
                raf.writeInt(0);
                raf.writeLong(0L);
                raf.getFD().sync();
                raf.close();
                FileUtil.renameTo(tempConfig, this.configFile);
            }
            catch (IOException ioe) {
                Logger.error(this, "error writing config file for " + this.name, ioe);
                Object var4_5 = null;
                this.configLock.writeLock().unlock();
            }
            Object var4_4 = null;
            this.configLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.configLock.writeLock().unlock();
            throw throwable;
        }
    }

    public void setUserAlertManager(UserAlertManager userAlertManager) {
        if (this.cleanerStatusUserAlert != null) {
            userAlertManager.register(this.cleanerStatusUserAlert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMaxKeys(long newStoreSize, boolean shrinkNow) throws IOException {
        block6: {
            block5: {
                Logger.normal(this, "[" + this.name + "] Resize newStoreSize=" + newStoreSize + ", shinkNow=" + shrinkNow);
                this.configLock.writeLock().lock();
                try {
                    if (newStoreSize == this.storeSize) {
                        Object var5_3 = null;
                        this.configLock.writeLock().unlock();
                        return;
                    }
                    if (this.prevStoreSize != 0L) {
                        Logger.normal(this, "[" + this.name + "] resize already in progress, ignore resize request");
                        break block5;
                    }
                    this.prevStoreSize = this.storeSize;
                    this.storeSize = newStoreSize;
                    this.writeConfigFile();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.configLock.writeLock().unlock();
                    throw throwable;
                }
            }
            Object var5_4 = null;
            this.configLock.writeLock().unlock();
            return;
        }
        Object var5_5 = null;
        this.configLock.writeLock().unlock();
        if (this.cleanerLock.tryLock()) {
            this.cleanerCondition.signal();
            this.cleanerLock.unlock();
        }
    }

    private Map<Long, Condition> lockPlainKey(byte[] plainKey, boolean usePrevStoreSize) {
        return this.lockDigestedKey(this.cipherManager.getDigestedKey(plainKey), usePrevStoreSize);
    }

    private void unlockPlainKey(byte[] plainKey, boolean usePrevStoreSize, Map<Long, Condition> lockMap) {
        this.unlockDigestedKey(this.cipherManager.getDigestedKey(plainKey), usePrevStoreSize, lockMap);
    }

    /*
     * WARNING - void declaration
     */
    private Map<Long, Condition> lockDigestedKey(byte[] digestedKey, boolean usePrevStoreSize) {
        long l;
        Condition condition;
        void var7_9;
        long[] offsetArray;
        TreeSet<Long> offsets = new TreeSet<Long>();
        long[] arr$ = offsetArray = this.getOffsetFromDigestedKey(digestedKey, this.storeSize);
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_9 < len$) {
            long offset2 = arr$[var7_9];
            offsets.add(offset2);
            ++var7_9;
        }
        if (usePrevStoreSize && this.prevStoreSize != 0L) {
            void var7_11;
            arr$ = offsetArray = this.getOffsetFromDigestedKey(digestedKey, this.prevStoreSize);
            len$ = arr$.length;
            boolean bl2 = false;
            while (var7_11 < len$) {
                long offset = arr$[var7_11];
                offsets.add(offset);
                ++var7_11;
            }
        }
        TreeMap<Long, Condition> locked = new TreeMap<Long, Condition>();
        Iterator<Object> i$ = offsets.iterator();
        while (i$.hasNext() && (condition = this.lockManager.lockEntry(l = ((Long)i$.next()).longValue())) != null) {
            locked.put(l, condition);
        }
        if (locked.size() == offsets.size()) {
            return locked;
        }
        for (Map.Entry entry : locked.entrySet()) {
            this.lockManager.unlockEntry((Long)entry.getKey(), (Condition)entry.getValue());
        }
        return null;
    }

    private void unlockDigestedKey(byte[] digestedKey, boolean usePrevStoreSize, Map<Long, Condition> lockMap) {
        long[] offsetArray;
        TreeSet<Long> offsets = new TreeSet<Long>();
        for (long offset : offsetArray = this.getOffsetFromDigestedKey(digestedKey, this.storeSize)) {
            offsets.add(offset);
        }
        if (usePrevStoreSize && this.prevStoreSize != 0L) {
            for (long offset : offsetArray = this.getOffsetFromDigestedKey(digestedKey, this.prevStoreSize)) {
                offsets.add(offset);
            }
        }
        Iterator i$ = offsets.iterator();
        while (i$.hasNext()) {
            long offset = (Long)i$.next();
            this.lockManager.unlockEntry(offset, lockMap.get(offset));
            lockMap.remove(offset);
        }
    }

    private long[] getOffsetFromPlainKey(byte[] plainKey, long storeSize) {
        return this.getOffsetFromDigestedKey(this.cipherManager.getDigestedKey(plainKey), storeSize);
    }

    private long[] getOffsetFromDigestedKey(byte[] digestedKey, long storeSize) {
        long keyValue = Fields.bytesToLong(digestedKey);
        long[] offsets = new long[5];
        for (int i = 0; i < 5; ++i) {
            offsets[i] = (keyValue + (long)(141 * (i * i)) + (long)(13 * i) & Long.MAX_VALUE) % storeSize;
        }
        return offsets;
    }

    @Override
    public long hits() {
        return this.hits.get();
    }

    @Override
    public long misses() {
        return this.misses.get();
    }

    @Override
    public long writes() {
        return this.writes.get();
    }

    @Override
    public long keyCount() {
        return this.keyCount.get();
    }

    @Override
    public long getMaxKeys() {
        this.configLock.readLock().lock();
        long _storeSize = this.storeSize;
        this.configLock.readLock().unlock();
        return _storeSize;
    }

    @Override
    public long getBloomFalsePositive() {
        return this.bloomFalsePos.get();
    }

    public void migrationFrom(File storeFile, File keyFile) {
        try {
            System.out.println("Migrating from " + storeFile);
            RandomAccessFile storeRAF = new RandomAccessFile(storeFile, "r");
            RandomAccessFile keyRAF = keyFile.exists() ? new RandomAccessFile(keyFile, "r") : null;
            byte[] header = new byte[this.headerBlockLength];
            byte[] data = new byte[this.dataBlockLength];
            byte[] key = new byte[this.fullKeyLength];
            long maxKey = storeRAF.length() / (long)(this.headerBlockLength + this.dataBlockLength);
            int l = 0;
            while ((long)l < maxKey) {
                if (l % 1024 == 0) {
                    System.out.println(" migrating key " + l + "/" + maxKey);
                    WrapperManager.signalStarting((int)600000);
                }
                boolean keyRead = false;
                storeRAF.readFully(header);
                storeRAF.readFully(data);
                try {
                    if (keyRAF != null) {
                        keyRAF.readFully(key);
                        keyRead = true;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    Object b = this.callback.construct(data, header, null, (byte[])(keyRead ? key : null));
                    this.put((StorableBlock)b, data, header, true);
                }
                catch (KeyVerifyException e) {
                    System.out.println("kve at block " + l);
                }
                catch (KeyCollisionException e) {
                    System.out.println("kce at block " + l);
                }
                ++l;
            }
        }
        catch (EOFException eof) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean probablyInStore(byte[] routingKey) {
        block3: {
            this.configLock.readLock().lock();
            try {
                if (this.checkBloom) break block3;
                boolean bl = true;
                Object var4_4 = null;
                this.configLock.readLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.configLock.readLock().unlock();
                throw throwable;
            }
        }
        boolean bl = this.bloomFilter.checkFilter(this.cipherManager.getDigestedKey(routingKey));
        Object var4_5 = null;
        this.configLock.readLock().unlock();
        return bl;
    }

    static /* synthetic */ FileChannel access$4200(SaltedHashFreenetStore x0) {
        return x0.metaFC;
    }

    static {
        cleanerGlobalLock = new ReentrantLock();
    }

    public class ShutdownDB
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SaltedHashFreenetStore.this.shutdown = true;
            SaltedHashFreenetStore.this.lockManager.shutdown();
            SaltedHashFreenetStore.this.cleanerLock.lock();
            try {
                SaltedHashFreenetStore.this.cleanerCondition.signalAll();
                SaltedHashFreenetStore.this.cleanerThread.interrupt();
                Object var2_1 = null;
                SaltedHashFreenetStore.this.cleanerLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                SaltedHashFreenetStore.this.cleanerLock.unlock();
                throw throwable;
            }
            SaltedHashFreenetStore.this.configLock.writeLock().lock();
            try {
                SaltedHashFreenetStore.this.flushAndClose();
                SaltedHashFreenetStore.this.flags &= -2;
                SaltedHashFreenetStore.this.writeConfigFile();
                Object var4_4 = null;
                SaltedHashFreenetStore.this.configLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                throw throwable;
            }
            System.out.println("Successfully closed store " + SaltedHashFreenetStore.this.name);
        }
    }

    private final class CleanerStatusUserAlert
    implements UserAlert {
        private Cleaner cleaner;

        private CleanerStatusUserAlert(Cleaner cleaner) {
            this.cleaner = cleaner;
        }

        public String anchor() {
            return "store-cleaner-" + SaltedHashFreenetStore.this.name;
        }

        public String dismissButtonText() {
            return L10n.getString("UserAlert.hide");
        }

        public HTMLNode getHTMLText() {
            return new HTMLNode("#", this.getText());
        }

        public short getPriorityClass() {
            return 3;
        }

        public String getShortText() {
            if (this.cleaner.isResizing) {
                return L10n.getString("SaltedHashFreenetStore.shortResizeProgress", new String[]{"name", "processed", "total"}, new String[]{SaltedHashFreenetStore.this.name, this.cleaner.entriesTotal - this.cleaner.entriesLeft + "", this.cleaner.entriesTotal + ""});
            }
            return L10n.getString("SaltedHashFreenetStore.shortRebuildProgress", new String[]{"name", "processed", "total"}, new String[]{SaltedHashFreenetStore.this.name, this.cleaner.entriesTotal - this.cleaner.entriesLeft + "", this.cleaner.entriesTotal + ""});
        }

        public String getText() {
            if (this.cleaner.isResizing) {
                return L10n.getString("SaltedHashFreenetStore.longResizeProgress", new String[]{"name", "processed", "total"}, new String[]{SaltedHashFreenetStore.this.name, this.cleaner.entriesTotal - this.cleaner.entriesLeft + "", this.cleaner.entriesTotal + ""});
            }
            return L10n.getString("SaltedHashFreenetStore.longRebuildProgress", new String[]{"name", "processed", "total"}, new String[]{SaltedHashFreenetStore.this.name, this.cleaner.entriesTotal - this.cleaner.entriesLeft + "", this.cleaner.entriesTotal + ""});
        }

        public String getTitle() {
            return L10n.getString("SaltedHashFreenetStore.cleanerAlertTitle", new String[]{"name"}, new String[]{SaltedHashFreenetStore.this.name});
        }

        public Object getUserIdentifier() {
            return null;
        }

        public boolean isValid() {
            return this.cleaner.isRebuilding || this.cleaner.isResizing;
        }

        public void isValid(boolean validity) {
        }

        public void onDismiss() {
        }

        public boolean shouldUnregisterOnDismiss() {
            return true;
        }

        public boolean userCanDismiss() {
            return false;
        }

        public boolean isEventNotification() {
            return false;
        }
    }

    private class Cleaner
    extends NativeThread {
        private static final int CLEANER_PERIOD = 300000;
        private volatile boolean isRebuilding;
        private volatile boolean isResizing;
        private static final int RESIZE_MEMORY_ENTRIES = 128;
        private volatile long entriesLeft;
        private volatile long entriesTotal;

        public Cleaner() {
            super("Store-" + SaltedHashFreenetStore.this.name + "-Cleaner", 3, false);
            this.setPriority(1);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            super.run();
            try {
                Thread.sleep((int)(150000.0 + 300000.0 * Math.random()));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (SaltedHashFreenetStore.this.shutdown) {
                return;
            }
            int loop = 0;
            while (!SaltedHashFreenetStore.this.shutdown) {
                Object var13_12;
                ++loop;
                SaltedHashFreenetStore.this.cleanerLock.lock();
                try {
                    Object var9_10;
                    boolean _rebuildBloom;
                    Object var5_6;
                    long _prevStoreSize;
                    SaltedHashFreenetStore.this.configLock.readLock().lock();
                    try {
                        _prevStoreSize = SaltedHashFreenetStore.this.prevStoreSize;
                        var5_6 = null;
                        SaltedHashFreenetStore.this.configLock.readLock().unlock();
                    }
                    catch (Throwable throwable) {
                        var5_6 = null;
                        SaltedHashFreenetStore.this.configLock.readLock().unlock();
                        throw throwable;
                    }
                    if (_prevStoreSize != 0L && cleanerGlobalLock.tryLock()) {
                        Object var7_9;
                        try {
                            this.isResizing = true;
                            this.resizeStore(_prevStoreSize, true);
                            var7_9 = null;
                            this.isResizing = false;
                            cleanerGlobalLock.unlock();
                        }
                        catch (Throwable throwable) {
                            var7_9 = null;
                            this.isResizing = false;
                            cleanerGlobalLock.unlock();
                            throw throwable;
                        }
                    }
                    SaltedHashFreenetStore.this.configLock.readLock().lock();
                    try {
                        _rebuildBloom = (SaltedHashFreenetStore.this.flags & 2) != 0;
                        var9_10 = null;
                        SaltedHashFreenetStore.this.configLock.readLock().unlock();
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        SaltedHashFreenetStore.this.configLock.readLock().unlock();
                        throw throwable;
                    }
                    if (_rebuildBloom && SaltedHashFreenetStore.this.prevStoreSize == 0L && cleanerGlobalLock.tryLock()) {
                        Object var11_11;
                        try {
                            this.isRebuilding = true;
                            this.rebuildBloom(false);
                            var11_11 = null;
                            this.isRebuilding = false;
                            cleanerGlobalLock.unlock();
                        }
                        catch (Throwable throwable) {
                            var11_11 = null;
                            this.isRebuilding = false;
                            cleanerGlobalLock.unlock();
                            throw throwable;
                        }
                    }
                    try {
                        if (loop % 6 == 0) {
                            SaltedHashFreenetStore.this.bloomFilter.force();
                        }
                    }
                    catch (Exception e) {
                        Logger.error(this, "Can't force bloom filter", e);
                    }
                    SaltedHashFreenetStore.this.writeConfigFile();
                    try {
                        SaltedHashFreenetStore.this.cleanerCondition.await(300000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Logger.debug(this, "interrupted", e);
                    }
                    var13_12 = null;
                    SaltedHashFreenetStore.this.cleanerLock.unlock();
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    SaltedHashFreenetStore.this.cleanerLock.unlock();
                    throw throwable;
                }
            }
        }

        private void resizeStore(final long _prevStoreSize, boolean sleep) {
            Logger.normal(this, "Starting datastore resize");
            BatchProcessor resizeProcesser = new BatchProcessor(){
                List<Entry> oldEntryList = new LinkedList<Entry>();
                int optimialK;
                int i = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void init() {
                    if (SaltedHashFreenetStore.this.storeSize > _prevStoreSize) {
                        SaltedHashFreenetStore.this.setStoreFileSize(SaltedHashFreenetStore.this.storeSize, false);
                    }
                    this.optimialK = BloomFilter.optimialK(SaltedHashFreenetStore.this.bloomFilterSize, SaltedHashFreenetStore.this.storeSize);
                    SaltedHashFreenetStore.this.configLock.writeLock().lock();
                    try {
                        SaltedHashFreenetStore.this.generation++;
                        SaltedHashFreenetStore.this.bloomFilter.fork(this.optimialK);
                        SaltedHashFreenetStore.this.keyCount.set(0L);
                        Object var2_1 = null;
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                        throw throwable;
                    }
                    WrapperManager.signalStarting((int)3841000);
                }

                public Entry process(Entry entry) {
                    int oldGeneration = entry.generation;
                    if (oldGeneration != SaltedHashFreenetStore.this.generation) {
                        entry.generation = SaltedHashFreenetStore.this.generation;
                        SaltedHashFreenetStore.this.keyCount.incrementAndGet();
                    }
                    if (entry.storeSize == SaltedHashFreenetStore.this.storeSize) {
                        if (entry.generation != SaltedHashFreenetStore.this.generation) {
                            SaltedHashFreenetStore.this.bloomFilter.addKeyForked(entry.getDigestedRoutingKey());
                            return entry;
                        }
                        return SaltedHashFreenetStore.this.NOT_MODIFIED;
                    }
                    if (oldGeneration == SaltedHashFreenetStore.this.generation) {
                        Logger.error(this, "new generation object with wrong storeSize. DigestedRoutingKey=" + HexUtil.bytesToHex(entry.getDigestedRoutingKey()) + ", Offset=" + entry.curOffset);
                        SaltedHashFreenetStore.this.bloomFilter.removeKey(entry.getDigestedRoutingKey());
                    }
                    try {
                        entry.setHD(SaltedHashFreenetStore.this.readHD(entry.curOffset));
                        this.oldEntryList.add(entry);
                        if (this.oldEntryList.size() > 128) {
                            this.oldEntryList.remove(0);
                        }
                    }
                    catch (IOException e) {
                        Logger.error(this, "error reading entry (offset=" + entry.curOffset + ")", e);
                    }
                    return null;
                }

                public boolean batch(long entriesLeft) {
                    WrapperManager.signalStarting((int)3841000);
                    if (this.i++ % 16 == 0) {
                        SaltedHashFreenetStore.this.writeConfigFile();
                    }
                    if (SaltedHashFreenetStore.this.storeSize < _prevStoreSize) {
                        SaltedHashFreenetStore.this.setStoreFileSize(Math.max(SaltedHashFreenetStore.this.storeSize, entriesLeft), false);
                    }
                    ListIterator<Entry> it = this.oldEntryList.listIterator();
                    while (it.hasNext()) {
                        if (!Cleaner.this.resolveOldEntry(it.next())) continue;
                        it.remove();
                    }
                    return _prevStoreSize == SaltedHashFreenetStore.this.prevStoreSize;
                }

                public void abort() {
                    SaltedHashFreenetStore.this.bloomFilter.discard();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finish() {
                    SaltedHashFreenetStore.this.configLock.writeLock().lock();
                    try {
                        if (_prevStoreSize != SaltedHashFreenetStore.this.prevStoreSize) {
                            Object var2_1 = null;
                            SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                            return;
                        }
                        SaltedHashFreenetStore.this.bloomFilter.merge();
                        SaltedHashFreenetStore.this.prevStoreSize = 0L;
                        SaltedHashFreenetStore.this.flags &= -3;
                        SaltedHashFreenetStore.this.checkBloom = true;
                        SaltedHashFreenetStore.this.bloomFilterK = this.optimialK;
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                        throw throwable;
                    }
                    Object var2_2 = null;
                    SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                    Logger.normal(this, "Finish resizing (" + SaltedHashFreenetStore.this.name + ")");
                }
            };
            this.batchProcessEntries(resizeProcesser, _prevStoreSize, true, sleep);
        }

        private void rebuildBloom(boolean sleep) {
            if (SaltedHashFreenetStore.this.bloomFilter == null) {
                return;
            }
            Logger.normal(this, "Start rebuilding bloom filter (" + SaltedHashFreenetStore.this.name + ")");
            BatchProcessor rebuildBloomProcessor = new BatchProcessor(){
                int optimialK;
                int i = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void init() {
                    this.optimialK = BloomFilter.optimialK(SaltedHashFreenetStore.this.bloomFilterSize, SaltedHashFreenetStore.this.storeSize);
                    SaltedHashFreenetStore.this.configLock.writeLock().lock();
                    try {
                        SaltedHashFreenetStore.this.generation++;
                        SaltedHashFreenetStore.this.bloomFilter.fork(SaltedHashFreenetStore.this.bloomFilterK);
                        SaltedHashFreenetStore.this.keyCount.set(0L);
                        Object var2_1 = null;
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                        throw throwable;
                    }
                    WrapperManager.signalStarting((int)641000);
                }

                public Entry process(Entry entry) {
                    if (entry.generation != SaltedHashFreenetStore.this.generation) {
                        SaltedHashFreenetStore.this.bloomFilter.addKeyForked(entry.getDigestedRoutingKey());
                        SaltedHashFreenetStore.this.keyCount.incrementAndGet();
                        entry.generation = SaltedHashFreenetStore.this.generation;
                        return entry;
                    }
                    return SaltedHashFreenetStore.this.NOT_MODIFIED;
                }

                public boolean batch(long entriesLeft) {
                    WrapperManager.signalStarting((int)641000);
                    if (this.i++ % 16 == 0) {
                        SaltedHashFreenetStore.this.writeConfigFile();
                    }
                    return SaltedHashFreenetStore.this.prevStoreSize == 0L;
                }

                public void abort() {
                    SaltedHashFreenetStore.this.bloomFilter.discard();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finish() {
                    SaltedHashFreenetStore.this.bloomFilter.merge();
                    SaltedHashFreenetStore.this.configLock.writeLock().lock();
                    try {
                        SaltedHashFreenetStore.this.flags &= -3;
                        SaltedHashFreenetStore.this.checkBloom = true;
                        SaltedHashFreenetStore.this.bloomFilterK = this.optimialK;
                        Object var2_1 = null;
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                        throw throwable;
                    }
                    Logger.normal(this, "Finish rebuilding bloom filter (" + SaltedHashFreenetStore.this.name + ")");
                }
            };
            this.batchProcessEntries(rebuildBloomProcessor, SaltedHashFreenetStore.this.storeSize, false, sleep);
        }

        private void batchProcessEntries(BatchProcessor processor, long storeSize, boolean reverse, boolean sleep) {
            long step;
            long startOffset;
            this.entriesLeft = this.entriesTotal = storeSize;
            if (!reverse) {
                startOffset = 0L;
                step = 128L;
            } else {
                startOffset = (storeSize - 1L) / 128L * 128L;
                step = -128L;
            }
            int i = 0;
            processor.init();
            try {
                for (long curOffset = startOffset; curOffset >= 0L && curOffset < storeSize; curOffset += step) {
                    if (SaltedHashFreenetStore.this.shutdown) {
                        processor.abort();
                        return;
                    }
                    if (i++ % 64 == 0) {
                        System.err.println(SaltedHashFreenetStore.this.name + " cleaner in progress: " + (this.entriesTotal - this.entriesLeft) + "/" + this.entriesTotal);
                    }
                    this.batchProcessEntries(curOffset, 128, processor);
                    long l = this.entriesLeft = reverse ? curOffset : Math.max(storeSize - curOffset - 128L, 0L);
                    if (!processor.batch(this.entriesLeft)) {
                        processor.abort();
                        return;
                    }
                    try {
                        if (!sleep) continue;
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        processor.abort();
                        return;
                    }
                }
                processor.finish();
            }
            catch (Exception e) {
                processor.abort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean batchProcessEntries(long offset, int length, BatchProcessor processor) {
            block34: {
                block32: {
                    locked = new Condition[length];
                    try {
                        block33: {
                            for (i = 0; i < length; ++i) {
                                locked[i] = SaltedHashFreenetStore.access$4100(SaltedHashFreenetStore.this).lockEntry(offset + (long)i);
                                if (locked[i] != null) continue;
                                var7_7 = false;
                                var22_8 = null;
                                break block32;
                            }
                            startFileOffset = offset * 128L;
                            entriesToRead = length;
                            bufLen = 128L * entriesToRead;
                            buf = ByteBuffer.allocate((int)bufLen);
                            dirty = false;
                            try {
                                while (buf.hasRemaining() && (status = SaltedHashFreenetStore.access$4200(SaltedHashFreenetStore.this).read(buf, startFileOffset + (long)buf.position())) != -1) {
                                }
                            }
                            catch (IOException ioe) {
                                if (SaltedHashFreenetStore.this.shutdown) {
                                    var15_22 = false;
                                    var22_9 = null;
                                    i = 0;
                                    while (true) {
                                        if (i >= length) {
                                            return var15_22;
                                        }
                                        if (locked[i] != null) {
                                            SaltedHashFreenetStore.access$4100(SaltedHashFreenetStore.this).unlockEntry(offset + (long)i, locked[i]);
                                        }
                                        ++i;
                                    }
                                }
                                Logger.error(this, "unexpected IOException", ioe);
                            }
                            buf.flip();
                            try {
                                j = 0;
                                while (!SaltedHashFreenetStore.this.shutdown && buf.limit() > j * 128) {
                                    buf.position(j * 128);
                                    if (buf.remaining() < 128) break;
                                    enBuf = buf.slice();
                                    enBuf.limit(128);
                                    entry = new Entry(enBuf, null);
                                    Entry.access$402(entry, offset + (long)j);
                                    if (!Entry.access$300(entry)) {
                                        newEntry = processor.process(entry);
                                        if (newEntry == null) {
                                            buf.position(j * 128);
                                            buf.put(ByteBuffer.allocate(128));
                                            SaltedHashFreenetStore.access$3400(SaltedHashFreenetStore.this).decrementAndGet();
                                            dirty = true;
                                        } else if (newEntry != SaltedHashFreenetStore.access$3600(SaltedHashFreenetStore.this)) {
                                            buf.position(j * 128);
                                            buf.put(Entry.access$2000(newEntry));
                                            if (!Cleaner.$assertionsDisabled && newEntry.header != null) {
                                                throw new AssertionError();
                                            }
                                            if (!Cleaner.$assertionsDisabled && newEntry.data != null) {
                                                throw new AssertionError();
                                            }
                                            dirty = true;
                                        }
                                    }
                                    ++j;
                                }
                                var19_26 = null;
                                if (!dirty) break block33;
                                buf.flip();
                            }
                            catch (Throwable var18_30) {
                                var19_27 = null;
                                if (!dirty) throw var18_30;
                                buf.flip();
                                try {
                                    while (buf.hasRemaining()) {
                                        SaltedHashFreenetStore.access$4200(SaltedHashFreenetStore.this).write(buf, startFileOffset + (long)buf.position());
                                    }
                                    throw var18_30;
                                }
                                catch (IOException ioe) {
                                    Logger.error(this, "unexpected IOException", ioe);
                                }
                                throw var18_30;
                            }
                            ** try [egrp 3[TRYBLOCK] [3 : 452->488)] { 
lbl90:
                            // 2 sources

                            while (buf.hasRemaining()) {
                                SaltedHashFreenetStore.access$4200(SaltedHashFreenetStore.this).write(buf, startFileOffset + (long)buf.position());
                            }
                            break block33;
lbl95:
                            // 1 sources

                            catch (IOException ioe) {
                                Logger.error(this, "unexpected IOException", ioe);
                            }
                        }
                        var14_20 = true;
                        break block34;
                    }
                    catch (Throwable var21_31) {
                        var22_11 = null;
                        i = 0;
                        while (true) {
                            if (i >= length) {
                                throw var21_31;
                            }
                            if (locked[i] != null) {
                                SaltedHashFreenetStore.access$4100(SaltedHashFreenetStore.this).unlockEntry(offset + (long)i, locked[i]);
                            }
                            ++i;
                        }
                    }
                }
                for (i = 0; i < length; ++i) {
                    if (locked[i] == null) continue;
                    SaltedHashFreenetStore.access$4100(SaltedHashFreenetStore.this).unlockEntry(offset + (long)i, locked[i]);
                }
                return var7_7;
            }
            var22_10 = null;
            i = 0;
            while (true) {
                if (i >= length) {
                    return var14_20;
                }
                if (locked[i] != null) {
                    SaltedHashFreenetStore.access$4100(SaltedHashFreenetStore.this).unlockEntry(offset + (long)i, locked[i]);
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean resolveOldEntry(Entry entry) {
            boolean bl;
            Map lockMap = SaltedHashFreenetStore.this.lockDigestedKey(entry.getDigestedRoutingKey(), false);
            if (lockMap == null) {
                return false;
            }
            try {
                long[] offsets;
                entry.storeSize = SaltedHashFreenetStore.this.storeSize;
                for (long offset : offsets = entry.getOffset()) {
                    boolean bl2;
                    try {
                        if (SaltedHashFreenetStore.this.isFree(offset) || !Arrays.equals(SaltedHashFreenetStore.this.getDigestedKeyFromOffset(offset), entry.getDigestedRoutingKey())) continue;
                        bl2 = true;
                    }
                    catch (IOException e) {
                        Logger.debug(this, "IOExcception on resolveOldEntry", e);
                    }
                    Object var11_14 = null;
                    SaltedHashFreenetStore.this.unlockDigestedKey(entry.getDigestedRoutingKey(), false, lockMap);
                    return bl2;
                }
                for (long offset : offsets) {
                    try {
                        if (!SaltedHashFreenetStore.this.isFree(offset)) continue;
                        SaltedHashFreenetStore.this.writeEntry(entry, offset);
                        SaltedHashFreenetStore.this.bloomFilter.addKeyForked(entry.getDigestedRoutingKey());
                        SaltedHashFreenetStore.this.keyCount.incrementAndGet();
                        boolean e = true;
                    }
                    catch (IOException e) {
                        Logger.debug(this, "IOExcception on resolveOldEntry", e);
                    }
                    Object var11_15 = null;
                    SaltedHashFreenetStore.this.unlockDigestedKey(entry.getDigestedRoutingKey(), false, lockMap);
                    return e;
                }
                bl = false;
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                SaltedHashFreenetStore.this.unlockDigestedKey(entry.getDigestedRoutingKey(), false, lockMap);
                throw throwable;
            }
            SaltedHashFreenetStore.this.unlockDigestedKey(entry.getDigestedRoutingKey(), false, lockMap);
            return bl;
        }
    }

    private static interface BatchProcessor {
        public void init();

        public boolean batch(long var1);

        public void abort();

        public void finish();

        public Entry process(Entry var1);
    }

    class Entry {
        private static final long ENTRY_FLAG_OCCUPIED = 1L;
        private static final long ENTRY_FLAG_PLAINKEY = 2L;
        private static final int METADATA_LENGTH = 128;
        byte[] plainRoutingKey;
        byte[] digestedRoutingKey;
        byte[] dataEncryptIV;
        private long flag;
        private long storeSize;
        private int generation;
        byte[] header;
        byte[] data;
        boolean isEncrypted;
        private long curOffset = -1L;

        private Entry() {
        }

        private Entry(ByteBuffer metaDataBuf, ByteBuffer hdBuf) {
            assert (metaDataBuf.remaining() == 128);
            this.digestedRoutingKey = new byte[32];
            metaDataBuf.get(this.digestedRoutingKey);
            this.dataEncryptIV = new byte[16];
            metaDataBuf.get(this.dataEncryptIV);
            this.flag = metaDataBuf.getLong();
            this.storeSize = metaDataBuf.getLong();
            if ((this.flag & 2L) != 0L) {
                this.plainRoutingKey = new byte[32];
                metaDataBuf.get(this.plainRoutingKey);
            }
            metaDataBuf.position(96);
            this.generation = metaDataBuf.getInt();
            this.isEncrypted = true;
            if (hdBuf != null) {
                this.setHD(hdBuf);
            }
        }

        private void setHD(ByteBuffer hdBuf) {
            assert (hdBuf.remaining() == SaltedHashFreenetStore.this.headerBlockLength + SaltedHashFreenetStore.this.dataBlockLength + SaltedHashFreenetStore.this.hdPadding);
            assert (this.isEncrypted);
            this.header = new byte[SaltedHashFreenetStore.this.headerBlockLength];
            hdBuf.get(this.header);
            this.data = new byte[SaltedHashFreenetStore.this.dataBlockLength];
            hdBuf.get(this.data);
        }

        private Entry(byte[] plainRoutingKey, byte[] header, byte[] data) {
            this.plainRoutingKey = plainRoutingKey;
            this.flag = 1L;
            this.storeSize = SaltedHashFreenetStore.this.storeSize;
            this.generation = SaltedHashFreenetStore.this.generation;
            this.header = new byte[SaltedHashFreenetStore.this.headerBlockLength];
            System.arraycopy(header, 0, this.header, 0, SaltedHashFreenetStore.this.headerBlockLength);
            this.data = new byte[SaltedHashFreenetStore.this.dataBlockLength];
            System.arraycopy(data, 0, this.data, 0, SaltedHashFreenetStore.this.dataBlockLength);
            this.isEncrypted = false;
        }

        private ByteBuffer toMetaDataBuffer() {
            ByteBuffer out = ByteBuffer.allocate(128);
            SaltedHashFreenetStore.this.cipherManager.encrypt(this, SaltedHashFreenetStore.this.random);
            out.put(this.getDigestedRoutingKey());
            out.put(this.dataEncryptIV);
            out.putLong(this.flag);
            out.putLong(this.storeSize);
            if ((this.flag & 2L) != 0L && this.plainRoutingKey != null) {
                assert (this.plainRoutingKey.length == 32);
                out.put(this.plainRoutingKey);
            }
            out.position(96);
            out.putInt(this.generation);
            out.position(0);
            return out;
        }

        private ByteBuffer toHDBuffer() {
            assert (this.isEncrypted);
            assert (this.header.length == SaltedHashFreenetStore.this.headerBlockLength);
            assert (this.data.length == SaltedHashFreenetStore.this.dataBlockLength);
            if (this.header == null || this.data == null) {
                return null;
            }
            ByteBuffer out = ByteBuffer.allocate(SaltedHashFreenetStore.this.headerBlockLength + SaltedHashFreenetStore.this.dataBlockLength + SaltedHashFreenetStore.this.hdPadding);
            out.put(this.header);
            out.put(this.data);
            out.position(0);
            return out;
        }

        private StorableBlock getStorableBlock(byte[] routingKey, byte[] fullKey) throws KeyVerifyException {
            if (this.isFree() || this.header == null || this.data == null) {
                return null;
            }
            if (!SaltedHashFreenetStore.this.cipherManager.decrypt(this, routingKey)) {
                return null;
            }
            Object block = SaltedHashFreenetStore.this.callback.construct(this.data, this.header, routingKey, fullKey);
            byte[] blockRoutingKey = block.getRoutingKey();
            if (!Arrays.equals(blockRoutingKey, routingKey)) {
                return null;
            }
            return block;
        }

        private long[] getOffset() {
            if (this.digestedRoutingKey != null) {
                return SaltedHashFreenetStore.this.getOffsetFromDigestedKey(this.digestedRoutingKey, this.storeSize);
            }
            return SaltedHashFreenetStore.this.getOffsetFromPlainKey(this.plainRoutingKey, this.storeSize);
        }

        private boolean isFree() {
            return (this.flag & 1L) == 0L;
        }

        byte[] getDigestedRoutingKey() {
            if (this.digestedRoutingKey == null) {
                if (this.plainRoutingKey == null) {
                    return null;
                }
                this.digestedRoutingKey = SaltedHashFreenetStore.this.cipherManager.getDigestedKey(this.plainRoutingKey);
            }
            return this.digestedRoutingKey;
        }

        static /* synthetic */ StorableBlock access$200(Entry x0, byte[] x1, byte[] x2) throws KeyVerifyException {
            return x0.getStorableBlock(x1, x2);
        }
    }
}

