/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.node.GetPubkey;
import freenet.store.KeyCollisionException;
import freenet.store.StoreCallback;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSKStore
extends StoreCallback<SSKBlock> {
    private final GetPubkey pubkeyCache;

    public SSKStore(GetPubkey pubkeyCache) {
        this.pubkeyCache = pubkeyCache;
    }

    @Override
    public SSKBlock construct(byte[] data, byte[] headers, byte[] routingKey, byte[] fullKey) throws SSKVerifyException {
        if (data == null || headers == null) {
            throw new SSKVerifyException("Need data and headers");
        }
        if (fullKey == null) {
            throw new SSKVerifyException("Need full key to reconstruct an SSK");
        }
        NodeSSK key = NodeSSK.construct(fullKey);
        if (!key.grabPubkey(this.pubkeyCache)) {
            throw new SSKVerifyException("No pubkey found");
        }
        SSKBlock block = new SSKBlock(data, headers, key, false);
        return block;
    }

    public SSKBlock fetch(NodeSSK chk, boolean dontPromote) throws IOException {
        return (SSKBlock)this.store.fetch(chk.getRoutingKey(), chk.getFullKey(), dontPromote);
    }

    public void put(SSKBlock b, boolean overwrite) throws IOException, KeyCollisionException {
        this.store.put(b, b.getRawData(), b.getRawHeaders(), overwrite);
    }

    @Override
    public int dataLength() {
        return 1024;
    }

    @Override
    public int fullKeyLength() {
        return 66;
    }

    @Override
    public int headerLength() {
        return 136;
    }

    @Override
    public int routingKeyLength() {
        return 32;
    }

    @Override
    public boolean storeFullKeys() {
        return true;
    }

    @Override
    public boolean collisionPossible() {
        return true;
    }

    @Override
    public boolean constructNeedsKey() {
        return true;
    }

    @Override
    public byte[] routingKeyFromFullKey(byte[] keyBuf) {
        return NodeSSK.routingKeyFromFullKey(keyBuf);
    }
}

