/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import com.sleepycat.je.DatabaseException;
import freenet.keys.KeyVerifyException;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.support.ByteArrayWrapper;
import freenet.support.LRUHashtable;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMFreenetStore<T extends StorableBlock>
implements FreenetStore<T> {
    private final LRUHashtable<ByteArrayWrapper, Block> blocksByRoutingKey;
    private final StoreCallback<T> callback;
    private int maxKeys;
    private long hits;
    private long misses;
    private long writes;

    public RAMFreenetStore(StoreCallback<T> callback, int maxKeys) {
        this.callback = callback;
        this.blocksByRoutingKey = new LRUHashtable();
        this.maxKeys = maxKeys;
        callback.setStore(this);
    }

    @Override
    public synchronized T fetch(byte[] routingKey, byte[] fullKey, boolean dontPromote) throws IOException {
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        Block block = this.blocksByRoutingKey.get(key);
        if (block == null) {
            ++this.misses;
            return null;
        }
        try {
            T ret = this.callback.construct(block.data, block.header, routingKey, block.fullKey);
            ++this.hits;
            if (!dontPromote) {
                this.blocksByRoutingKey.push(key, block);
            }
            return ret;
        }
        catch (KeyVerifyException e) {
            this.blocksByRoutingKey.removeKey(key);
            ++this.misses;
            return null;
        }
    }

    @Override
    public synchronized long getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public synchronized long hits() {
        return this.hits;
    }

    @Override
    public synchronized long keyCount() {
        return this.blocksByRoutingKey.size();
    }

    @Override
    public synchronized long misses() {
        return this.misses;
    }

    @Override
    public synchronized void put(T block, byte[] data, byte[] header, boolean overwrite) throws KeyCollisionException {
        byte[] routingkey = block.getRoutingKey();
        byte[] fullKey = block.getFullKey();
        ++this.writes;
        ByteArrayWrapper key = new ByteArrayWrapper(routingkey);
        Block oldBlock = this.blocksByRoutingKey.get(key);
        boolean storeFullKeys = this.callback.storeFullKeys();
        if (oldBlock != null) {
            if (this.callback.collisionPossible()) {
                boolean equals;
                boolean bl = equals = Arrays.equals(oldBlock.data, data) && Arrays.equals(oldBlock.header, header) && (!storeFullKeys || Arrays.equals(oldBlock.fullKey, fullKey));
                if (equals) {
                    return;
                }
                if (overwrite) {
                    oldBlock.data = data;
                    oldBlock.header = header;
                    if (storeFullKeys) {
                        oldBlock.fullKey = fullKey;
                    }
                } else {
                    throw new KeyCollisionException();
                }
                return;
            }
            return;
        }
        Block storeBlock = new Block();
        storeBlock.data = data;
        storeBlock.header = header;
        if (storeFullKeys) {
            storeBlock.fullKey = fullKey;
        }
        this.blocksByRoutingKey.push(key, storeBlock);
        while (this.blocksByRoutingKey.size() > this.maxKeys) {
            this.blocksByRoutingKey.popKey();
        }
    }

    @Override
    public synchronized void setMaxKeys(long maxStoreKeys, boolean shrinkNow) throws DatabaseException, IOException {
        this.maxKeys = (int)Math.min(Integer.MAX_VALUE, maxStoreKeys);
        while (this.blocksByRoutingKey.size() > this.maxKeys) {
            this.blocksByRoutingKey.popKey();
        }
    }

    @Override
    public long writes() {
        return this.writes;
    }

    @Override
    public long getBloomFalsePositive() {
        return -1L;
    }

    @Override
    public boolean probablyInStore(byte[] routingKey) {
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        return this.blocksByRoutingKey.get(key) != null;
    }

    private static final class Block {
        byte[] header;
        byte[] data;
        byte[] fullKey;

        private Block() {
        }
    }
}

