/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.crypt.CryptFormatException;
import freenet.crypt.DSAPublicKey;
import freenet.keys.KeyVerifyException;
import freenet.keys.PubkeyVerifyException;
import freenet.store.KeyCollisionException;
import freenet.store.StoreCallback;
import freenet.support.Logger;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubkeyStore
extends StoreCallback<DSAPublicKey> {
    private static final byte[] empty = new byte[0];

    @Override
    public boolean collisionPossible() {
        return false;
    }

    @Override
    public DSAPublicKey construct(byte[] data, byte[] headers, byte[] routingKey, byte[] fullKey) throws KeyVerifyException {
        if (data == null) {
            throw new PubkeyVerifyException("Need data to construct pubkey");
        }
        try {
            return DSAPublicKey.create(data);
        }
        catch (CryptFormatException e) {
            throw new PubkeyVerifyException(e);
        }
    }

    public DSAPublicKey fetch(byte[] hash, boolean dontPromote) throws IOException {
        return (DSAPublicKey)this.store.fetch(hash, null, dontPromote);
    }

    public void put(byte[] hash, DSAPublicKey key) throws IOException {
        try {
            this.store.put(key, key.asPaddedBytes(), empty, false);
        }
        catch (KeyCollisionException e) {
            Logger.error(this, "Impossible for PubkeyStore: " + e, e);
        }
    }

    @Override
    public int dataLength() {
        return 1024;
    }

    @Override
    public int fullKeyLength() {
        return 32;
    }

    @Override
    public int headerLength() {
        return 0;
    }

    @Override
    public int routingKeyLength() {
        return 32;
    }

    @Override
    public boolean storeFullKeys() {
        return false;
    }

    @Override
    public boolean constructNeedsKey() {
        return false;
    }

    @Override
    public byte[] routingKeyFromFullKey(byte[] keyBuf) {
        return keyBuf;
    }
}

