/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.log.LogFileNotFoundException;
import freenet.crypt.RandomSource;
import freenet.keys.KeyVerifyException;
import freenet.node.SemiOrderedShutdownHook;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.OOMHook;
import freenet.support.SortedLongSet;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import org.tanukisoftware.wrapper.WrapperManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BerkeleyDBFreenetStore<T extends StorableBlock>
implements FreenetStore<T>,
OOMHook {
    private static boolean logMINOR;
    private static boolean logDEBUG;
    private final File reconstructFile;
    private final int dataBlockSize;
    private final int headerBlockSize;
    private final RandomSource random;
    private final Environment environment;
    private final TupleBinding<StoreBlock> storeBlockTupleBinding;
    private final File fixSecondaryFile;
    private long blocksInStore = 0L;
    private final Object blocksInStoreLock = new Object();
    private long maxBlocksInStore;
    private long hits = 0L;
    private long misses = 0L;
    private long writes = 0L;
    private final int keyLength;
    private Database keysDB;
    private SecondaryDatabase accessTimeDB;
    private SecondaryDatabase blockNumDB;
    private RandomAccessFile storeRAF;
    private RandomAccessFile keysRAF;
    private RandomAccessFile lruRAF;
    private FileChannel storeFC;
    private FileChannel keysFC;
    private FileChannel lruFC;
    private final SortedLongSet freeBlocks;
    private final String name;
    private final StoreCallback<T> callback;
    private final boolean collisionPossible;
    private long lastRecentlyUsed;
    private final Object lastRecentlyUsedSync = new Object();
    private boolean closed;
    private boolean reallyClosed;
    private final Object shrinkLock = new Object();
    private boolean shrinking = false;
    private int runningFetches;
    private final Object closeLock = new Object();

    public static String getName(boolean isStore, FreenetStore.StoreType type) {
        String newDBPrefix = BerkeleyDBFreenetStore.typeName(type) + '-' + (isStore ? "store" : "cache") + '-';
        return newDBPrefix + "CHK";
    }

    public static File getFile(boolean isStore, FreenetStore.StoreType type, File baseStoreDir, String suffix) {
        String newStoreFileName = BerkeleyDBFreenetStore.typeName(type) + suffix + '.' + (isStore ? "store" : "cache");
        return new File(baseStoreDir, newStoreFileName);
    }

    public static <T extends StorableBlock> FreenetStore<T> construct(File baseStoreDir, boolean isStore, String suffix, long maxStoreKeys, FreenetStore.StoreType type, Environment storeEnvironment, SemiOrderedShutdownHook storeShutdownHook, File reconstructFile, StoreCallback<T> callback, RandomSource random) throws DatabaseException, IOException {
        String newStoreFileName = BerkeleyDBFreenetStore.typeName(type) + suffix + '.' + (isStore ? "store" : "cache");
        File newStoreFile = new File(baseStoreDir, newStoreFileName);
        File lruFile = new File(baseStoreDir, newStoreFileName + ".lru");
        File keysFile = callback.storeFullKeys() ? new File(baseStoreDir, newStoreFileName + ".keys") : null;
        String newDBPrefix = BerkeleyDBFreenetStore.typeName(type) + '-' + (isStore ? "store" : "cache") + '-';
        File newFixSecondaryFile = new File(baseStoreDir, "recreate_secondary_db-" + newStoreFileName);
        System.err.println("Opening database using " + newStoreFile);
        return BerkeleyDBFreenetStore.openStore(storeEnvironment, newDBPrefix, newStoreFile, lruFile, keysFile, newFixSecondaryFile, maxStoreKeys, storeShutdownHook, reconstructFile, callback, random);
    }

    private static <T extends StorableBlock> FreenetStore<T> openStore(Environment storeEnvironment, String newDBPrefix, File newStoreFile, File lruFile, File keysFile, File newFixSecondaryFile, long maxStoreKeys, SemiOrderedShutdownHook storeShutdownHook, File reconstructFile, StoreCallback<T> callback, RandomSource random) throws DatabaseException, IOException {
        try {
            return new BerkeleyDBFreenetStore<T>(storeEnvironment, newDBPrefix, newStoreFile, lruFile, keysFile, newFixSecondaryFile, maxStoreKeys, false, storeShutdownHook, reconstructFile, callback, random);
        }
        catch (DatabaseException e) {
            System.err.println("Could not open store: " + (Object)((Object)e));
            e.printStackTrace();
            System.err.println("Attempting to reconstruct index...");
            WrapperManager.signalStarting((int)18000000);
            return new BerkeleyDBFreenetStore<T>(storeEnvironment, newDBPrefix, newStoreFile, lruFile, keysFile, newFixSecondaryFile, maxStoreKeys, storeShutdownHook, reconstructFile, callback, random);
        }
    }

    private static String typeName(FreenetStore.StoreType type) {
        return type.toString().toLowerCase();
    }

    private BerkeleyDBFreenetStore(Environment env, String prefix, File storeFile, File lruFile, File keysFile, File fixSecondaryFile, long maxChkBlocks, boolean wipe, SemiOrderedShutdownHook storeShutdownHook, File reconstructFile, StoreCallback<T> callback, RandomSource random) throws IOException, DatabaseException {
        logMINOR = Logger.shouldLog(4, this);
        logDEBUG = Logger.shouldLog(2, this);
        this.random = random;
        this.environment = env;
        this.name = prefix;
        this.fixSecondaryFile = fixSecondaryFile;
        this.maxBlocksInStore = maxChkBlocks;
        this.reconstructFile = reconstructFile;
        this.callback = callback;
        this.collisionPossible = callback.collisionPossible();
        this.dataBlockSize = callback.dataLength();
        this.headerBlockSize = callback.headerLength();
        this.keyLength = callback.fullKeyLength();
        callback.setStore(this);
        OOMHandler.addOOMHook(this);
        this.freeBlocks = new SortedLongSet();
        if (wipe) {
            System.err.println("Wiping old database for " + prefix);
            BerkeleyDBFreenetStore.wipeOldDatabases(this.environment, prefix);
        }
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(true);
        this.keysDB = this.environment.openDatabase(null, prefix + "CHK", dbConfig);
        System.err.println("Opened main database for " + prefix);
        if (fixSecondaryFile.exists()) {
            fixSecondaryFile.delete();
            this.removeSecondaryDatabase();
        }
        this.storeBlockTupleBinding = new StoreBlockTupleBinding();
        this.accessTimeDB = this.openSecondaryDataBase(prefix + "CHK_accessTime", this.keysDB.count() == 0L || wipe, wipe, true, new AccessTimeKeyCreator(this.storeBlockTupleBinding));
        this.blockNumDB = this.openSecondaryDataBase(prefix + "CHK_blockNum", this.keysDB.count() == 0L || wipe, wipe, false, new BlockNumberKeyCreator(this.storeBlockTupleBinding));
        try {
            if (!storeFile.exists() && !storeFile.createNewFile()) {
                throw new IOException("Can't create a new file " + storeFile + " !");
            }
            this.storeRAF = new RandomAccessFile(storeFile, "rw");
            this.storeFC = this.storeRAF.getChannel();
            if (!lruFile.exists() && !lruFile.createNewFile()) {
                throw new IOException("Can't create a new file " + lruFile + " !");
            }
            this.lruRAF = new RandomAccessFile(lruFile, "rw");
            this.lruFC = this.lruRAF.getChannel();
            if (keysFile != null) {
                if (!keysFile.exists() && !keysFile.createNewFile()) {
                    throw new IOException("Can't create a new file " + keysFile + " !");
                }
                this.keysRAF = new RandomAccessFile(keysFile, "rw");
                this.keysFC = this.keysRAF.getChannel();
            } else {
                this.keysRAF = null;
            }
            if (wipe) {
                this.blocksInStore = 0L;
                this.lastRecentlyUsed = 0L;
                this.reconstruct();
                this.blocksInStore = this.countCHKBlocksFromFile();
                this.lastRecentlyUsed = this.getMaxRecentlyUsed();
                this.maybeOfflineShrink(true);
            } else {
                long chkBlocksInDatabase;
                boolean dontCheckForHolesShrinking = false;
                this.blocksInStore = chkBlocksInDatabase = this.highestBlockNumberInDatabase();
                long chkBlocksFromFile = this.countCHKBlocksFromFile();
                this.lastRecentlyUsed = this.getMaxRecentlyUsed();
                System.out.println("Keys in store: db " + chkBlocksInDatabase + " file " + chkBlocksFromFile + " / max " + maxChkBlocks);
                if (chkBlocksInDatabase > chkBlocksFromFile) {
                    System.out.println("More keys in database than in store!");
                }
                if (this.blocksInStore == 0L && chkBlocksFromFile != 0L || (double)(this.blocksInStore + 10L) * 1.1 < (double)chkBlocksFromFile) {
                    try {
                        this.close(false);
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Failed to close: " + t, t);
                        System.err.println("Failed to close: " + t);
                        t.printStackTrace();
                    }
                    throw new DatabaseException("Keys in database: " + this.blocksInStore + " but keys in file: " + chkBlocksFromFile);
                }
                this.blocksInStore = Math.max(this.blocksInStore, chkBlocksFromFile);
                if (logMINOR) {
                    Logger.minor(this, "Keys in store: " + this.blocksInStore);
                }
                this.maybeOfflineShrink(dontCheckForHolesShrinking);
                chkBlocksFromFile = this.countCHKBlocksFromFile();
                this.blocksInStore = Math.max(this.blocksInStore, chkBlocksFromFile);
            }
            storeShutdownHook.addEarlyJob(new ShutdownHook());
        }
        catch (DatabaseException t) {
            Logger.error(this, "Caught exception, closing database: " + prefix, t);
            System.err.println("Caught exception, closing database: " + prefix + " (" + (Object)((Object)t) + ")");
            t.printStackTrace();
            this.close(false);
            throw t;
        }
        catch (IOException t) {
            System.err.println("Caught exception, closing database: " + prefix + " (" + t + ")");
            Logger.error(this, "Caught exception, closing database: " + prefix, t);
            this.close(false);
            throw t;
        }
    }

    private long checkForHoles(long blocksInFile, boolean dontTruncate) throws DatabaseException {
        System.err.println("Checking for holes in database... " + blocksInFile + " blocks in file");
        WrapperManager.signalStarting((int)((int)Math.min(Integer.MAX_VALUE, 300000L + blocksInFile * 100L)));
        long holes = 0L;
        long maxPresent = 0L;
        this.freeBlocks.clear();
        for (long i = 0L; i < blocksInFile; ++i) {
            DatabaseEntry blockNumEntry = new DatabaseEntry();
            DatabaseEntry found = new DatabaseEntry();
            LongBinding.longToEntry((long)i, (DatabaseEntry)blockNumEntry);
            OperationStatus success = this.blockNumDB.get(null, blockNumEntry, found, LockMode.DEFAULT);
            if (success.equals(OperationStatus.NOTFOUND)) {
                this.addFreeBlock(i, true, "hole found");
                ++holes;
            } else {
                maxPresent = i;
            }
            if (i % 1024L != 0L) continue;
            System.err.println("Checked " + i + " blocks, found " + holes + " holes");
        }
        System.err.println("Checked database of " + blocksInFile + " blocks, found " + holes + " holes, maximum non-hole block: " + maxPresent);
        long bound = maxPresent + 1L;
        if (!dontTruncate && bound < this.blocksInStore) {
            System.err.println("Truncating to " + bound + " as no non-holes after that point");
            try {
                this.storeRAF.setLength(bound * (long)(this.dataBlockSize + this.headerBlockSize));
                this.lruRAF.setLength(bound * 8L);
                if (this.keysRAF != null) {
                    this.keysRAF.setLength(bound * (long)this.keyLength);
                }
                this.blocksInStore = bound;
                for (long l = bound; l < this.blocksInStore; ++l) {
                    this.freeBlocks.remove(l);
                }
            }
            catch (IOException e) {
                Logger.error(this, "Unable to truncate!: " + e, e);
                System.err.println("Unable to truncate: " + e);
                e.printStackTrace();
            }
        }
        return bound;
    }

    private void maybeOfflineShrink(boolean dontCheckForHoles) throws DatabaseException, IOException {
        if (this.blocksInStore <= this.maxBlocksInStore) {
            return;
        }
        this.maybeSlowShrink(dontCheckForHoles, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeOnlineShrink(boolean forceBigOnlineShrinks) throws DatabaseException, IOException {
        BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
        synchronized (berkeleyDBFreenetStore) {
            if (this.blocksInStore <= this.maxBlocksInStore) {
                return true;
            }
        }
        if ((double)this.blocksInStore * 0.9 > (double)this.maxBlocksInStore || forceBigOnlineShrinks) {
            Logger.error(this, "Doing quick and dirty shrink of the store by " + 100L * (this.blocksInStore - this.maxBlocksInStore) / this.blocksInStore + "%");
            Logger.error(this, "Offline shrinks will preserve the most recently used data, this online shrink does not.");
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block15: {
                        block14: {
                            try {
                                try {
                                    Object object = BerkeleyDBFreenetStore.this.shrinkLock;
                                    synchronized (object) {
                                        if (BerkeleyDBFreenetStore.this.shrinking) {
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 13] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                                            Object var4_3 = null;
                                            break block14;
                                        }
                                        BerkeleyDBFreenetStore.this.shrinking = true;
                                    }
                                    BerkeleyDBFreenetStore.this.maybeQuickShrink(false);
                                    break block15;
                                }
                                catch (Throwable t) {
                                    Logger.error(this, "Online shrink failed: " + t, t);
                                    Object var4_5 = null;
                                    Object object = BerkeleyDBFreenetStore.this.shrinkLock;
                                    synchronized (object) {
                                        BerkeleyDBFreenetStore.this.shrinking = false;
                                        return;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                Object object = BerkeleyDBFreenetStore.this.shrinkLock;
                                synchronized (object) {
                                    BerkeleyDBFreenetStore.this.shrinking = false;
                                    throw throwable;
                                }
                            }
                        }
                        Object object = BerkeleyDBFreenetStore.this.shrinkLock;
                        synchronized (object) {
                            BerkeleyDBFreenetStore.this.shrinking = false;
                            return;
                        }
                    }
                    Object var4_4 = null;
                    Object object = BerkeleyDBFreenetStore.this.shrinkLock;
                    synchronized (object) {
                        BerkeleyDBFreenetStore.this.shrinking = false;
                        return;
                    }
                }
            };
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.start();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void maybeSlowShrink(boolean dontCheckForHoles, boolean inStartUp) throws DatabaseException, IOException {
        long newSize;
        Object t;
        Cursor c;
        ArrayList<Integer> alreadyDropped;
        ArrayList<Integer> unwantedMove;
        ArrayList<Integer> wantedMove;
        ArrayList<Integer> unwantedIgnore;
        ArrayList<Integer> wantedKeep;
        block50: {
            block48: {
                wantedKeep = new ArrayList<Integer>();
                unwantedIgnore = new ArrayList<Integer>();
                wantedMove = new ArrayList<Integer>();
                unwantedMove = new ArrayList<Integer>();
                alreadyDropped = new ArrayList<Integer>();
                c = null;
                t = null;
                newSize = this.maxBlocksInStore;
                if (this.blocksInStore < this.maxBlocksInStore) {
                    return;
                }
                System.err.println("Shrinking from " + this.blocksInStore + " to " + this.maxBlocksInStore + " (from db " + this.keysDB.count() + " from file " + this.countCHKBlocksFromFile() + ')');
                if (!dontCheckForHoles) {
                    this.checkForHoles(this.maxBlocksInStore, true);
                }
                WrapperManager.signalStarting((int)((int)Math.min(Integer.MAX_VALUE, 300000L + this.blocksInStore * 100L)));
                long realSize = this.countCHKBlocksFromFile();
                long highestBlock = 0L;
                try {
                    c = this.accessTimeDB.openCursor(null, null);
                    DatabaseEntry keyDBE = new DatabaseEntry();
                    DatabaseEntry blockDBE = new DatabaseEntry();
                    OperationStatus opStat = c.getLast(keyDBE, blockDBE, LockMode.RMW);
                    if (opStat == OperationStatus.NOTFOUND) {
                        System.err.println("Database is empty (shrinking).");
                        c.close();
                        return;
                    }
                    int x = 0;
                    do {
                        StoreBlock storeBlock;
                        long block;
                        if ((block = (storeBlock = (StoreBlock)this.storeBlockTupleBinding.entryToObject(blockDBE)).offset) > highestBlock) {
                            highestBlock = block;
                        }
                        if (storeBlock.offset > Integer.MAX_VALUE) {
                            System.err.println("Store too big, doing quick shrink");
                            c.close();
                            c = null;
                            this.maybeQuickShrink(true);
                            break block48;
                        }
                        Integer blockNum = (int)storeBlock.offset;
                        if (blockNum.longValue() >= realSize) {
                            Logger.minor(this, "Truncated already? " + blockNum.longValue());
                            alreadyDropped.add(blockNum);
                            continue;
                        }
                        if ((long)x < newSize) {
                            if (block < newSize) {
                                wantedKeep.add(blockNum);
                            } else {
                                wantedMove.add(blockNum);
                            }
                        } else if (block < newSize) {
                            unwantedMove.add(blockNum);
                        } else {
                            unwantedIgnore.add(blockNum);
                        }
                        if (++x % 1024 == 0) {
                            System.out.println("Reading store prior to shrink: " + (long)x * 100L / realSize + "% ( " + x + '/' + realSize + ')');
                        }
                        if (x != Integer.MAX_VALUE) continue;
                        System.err.println("Key number " + x + " - ignoring store after " + x * (this.dataBlockSize + this.headerBlockSize) + " bytes");
                        break block50;
                    } while ((opStat = c.getPrev(keyDBE, blockDBE, LockMode.RMW)) != OperationStatus.NOTFOUND);
                    System.out.println("Read store: " + x + " keys.");
                    break block50;
                }
                catch (Throwable throwable) {
                    Object var25_19 = null;
                    if (c == null) throw throwable;
                    c.close();
                    throw throwable;
                }
            }
            Object var25_17 = null;
            if (c == null) return;
            c.close();
            return;
        }
        Object var25_18 = null;
        if (c != null) {
            c.close();
        }
        Object[] wantedKeepNums = wantedKeep.toArray(new Integer[wantedKeep.size()]);
        Object[] unwantedIgnoreNums = unwantedIgnore.toArray(new Integer[unwantedIgnore.size()]);
        Object[] wantedMoveNums = wantedMove.toArray(new Integer[wantedMove.size()]);
        Object[] unwantedMoveNums = unwantedMove.toArray(new Integer[unwantedMove.size()]);
        long[] freeEarlySlots = this.freeBlocks.toArray();
        Arrays.sort(wantedKeepNums);
        Arrays.sort(unwantedIgnoreNums);
        Arrays.sort(wantedMoveNums);
        Arrays.sort(unwantedMoveNums);
        int i = 0;
        while ((long)i < newSize) {
            Integer ii = i;
            if (Arrays.binarySearch(wantedKeepNums, ii) < 0 && Arrays.binarySearch(unwantedIgnoreNums, ii) < 0 && Arrays.binarySearch(wantedMoveNums, ii) < 0 && Arrays.binarySearch(unwantedMoveNums, ii) < 0) {
                unwantedMove.add(ii);
            }
            ++i;
        }
        unwantedMoveNums = unwantedMove.toArray(new Integer[unwantedMove.size()]);
        System.err.println("Keys to keep where they are:     " + wantedKeepNums.length);
        System.err.println("Keys which will be wiped anyway: " + unwantedIgnoreNums.length);
        System.err.println("Keys to move:                    " + wantedMoveNums.length);
        System.err.println("Keys to be moved over:           " + unwantedMoveNums.length);
        System.err.println("Free slots to be moved over:     " + freeEarlySlots.length);
        WrapperManager.signalStarting((int)((int)Math.min(Integer.MAX_VALUE, 300000L + (long)wantedMoveNums.length * 1000L + (long)alreadyDropped.size() * 100L)));
        ByteBuffer buf = ByteBuffer.allocate(this.headerBlockSize + this.dataBlockSize);
        byte[] keyBuf = new byte[this.keyLength];
        t = null;
        try {
            t = this.environment.beginTransaction(null, null);
            if (alreadyDropped.size() > 0) {
                System.err.println("Deleting " + alreadyDropped.size() + " blocks beyond the length of the file");
                for (int i2 = 0; i2 < alreadyDropped.size(); ++i2) {
                    int unwantedBlock = (Integer)alreadyDropped.get(i2);
                    DatabaseEntry unwantedBlockEntry = new DatabaseEntry();
                    LongBinding.longToEntry((long)unwantedBlock, (DatabaseEntry)unwantedBlockEntry);
                    this.blockNumDB.delete(t, unwantedBlockEntry);
                    if (i2 % 1024 != 0) continue;
                    t.commit();
                    t = this.environment.beginTransaction(null, null);
                }
                if (alreadyDropped.size() % 1024 != 0) {
                    t.commit();
                    t = this.environment.beginTransaction(null, null);
                }
            }
            for (int i3 = 0; i3 < wantedMoveNums.length; ++i3) {
                long lruValue;
                Object unwantedBlock;
                Object wantedBlock = wantedMoveNums[i3];
                if (i3 < freeEarlySlots.length) {
                    unwantedBlock = (int)freeEarlySlots[i3];
                } else if (unwantedMoveNums.length + freeEarlySlots.length > i3) {
                    unwantedBlock = unwantedMoveNums[i3 - freeEarlySlots.length];
                    DatabaseEntry unwantedBlockEntry = new DatabaseEntry();
                    LongBinding.longToEntry((long)((Integer)unwantedBlock).longValue(), (DatabaseEntry)unwantedBlockEntry);
                    this.blockNumDB.delete(t, unwantedBlockEntry);
                } else {
                    System.err.println("Keys to move but no keys to move over! Moved " + i3);
                    t.commit();
                    return;
                }
                DatabaseEntry wantedBlockEntry = new DatabaseEntry();
                LongBinding.longToEntry((long)((Integer)wantedBlock).longValue(), (DatabaseEntry)wantedBlockEntry);
                long entry = ((Integer)wantedBlock).longValue();
                boolean readLRU = false;
                boolean readKey = false;
                try {
                    buf.rewind();
                    do {
                        int byteRead;
                        if ((byteRead = this.storeFC.read(buf, entry * (long)(this.headerBlockSize + this.dataBlockSize) + (long)buf.position())) != -1) continue;
                        throw new EOFException();
                    } while (buf.hasRemaining());
                    buf.flip();
                    lruValue = 0L;
                    if (this.lruRAF.length() > (entry + 1L) * 8L) {
                        readLRU = true;
                        lruValue = this.fcReadLRU(entry);
                    }
                    if (this.keysRAF != null && this.keysRAF.length() > (entry + 1L) * (long)this.keyLength) {
                        readKey = true;
                        this.fcReadKey(entry, keyBuf);
                    }
                }
                catch (EOFException e) {
                    System.err.println("Was reading " + wantedBlock + " to write to " + unwantedBlock);
                    System.err.println(e);
                    e.printStackTrace();
                    throw e;
                }
                entry = ((Integer)unwantedBlock).longValue();
                do {
                    int byteWritten;
                    if ((byteWritten = this.storeFC.write(buf, entry * (long)(this.headerBlockSize + this.dataBlockSize) + (long)buf.position())) != -1) continue;
                    throw new EOFException();
                } while (buf.hasRemaining());
                if (readLRU) {
                    this.fcWriteLRU(entry, lruValue);
                }
                if (readKey) {
                    this.fcWriteKey(entry, keyBuf);
                }
                DatabaseEntry routingKeyDBE = new DatabaseEntry();
                DatabaseEntry blockDBE = new DatabaseEntry();
                this.blockNumDB.get(t, wantedBlockEntry, routingKeyDBE, blockDBE, LockMode.RMW);
                StoreBlock block = (StoreBlock)this.storeBlockTupleBinding.entryToObject(blockDBE);
                block.offset = ((Integer)unwantedBlock).longValue();
                this.storeBlockTupleBinding.objectToEntry((Object)block, blockDBE);
                this.keysDB.put(t, routingKeyDBE, blockDBE);
                if ((i3 + 1) % 2048 != 0) continue;
                t.commit();
                t = this.environment.beginTransaction(null, null);
                System.out.println("Moving blocks: " + i3 * 100 / wantedMove.size() + "% ( " + i3 + '/' + wantedMove.size() + ')');
            }
            System.out.println("Moved all " + wantedMove.size() + " blocks");
            if (t != null) {
                t.commit();
                t = null;
            }
        }
        catch (Throwable throwable) {
            Object var37_52 = null;
            if (t != null) {
                t.abort();
            }
            t = null;
            throw throwable;
        }
        Object var37_51 = null;
        if (t != null) {
            t.abort();
        }
        t = null;
        System.out.println("Completing shrink");
        int totalUnwantedBlocks = unwantedMoveNums.length + freeEarlySlots.length;
        WrapperManager.signalStarting((int)((int)Math.min(Integer.MAX_VALUE, 300000L + (long)(totalUnwantedBlocks - wantedMoveNums.length) * 100L)));
        this.freeBlocks.clear();
        t = this.environment.beginTransaction(null, null);
        for (int i4 = wantedMoveNums.length; i4 < totalUnwantedBlocks; ++i4) {
            String reason;
            long blockNo;
            if (i4 < freeEarlySlots.length) {
                blockNo = freeEarlySlots[i4];
                reason = "early slot " + i4;
            } else {
                blockNo = ((Integer)unwantedMoveNums[i4 - freeEarlySlots.length]).longValue();
                reason = "unwanted " + (i4 - freeEarlySlots.length);
            }
            DatabaseEntry unwantedBlockEntry = new DatabaseEntry();
            LongBinding.longToEntry((long)blockNo, (DatabaseEntry)unwantedBlockEntry);
            this.blockNumDB.delete(t, unwantedBlockEntry);
            if (i4 % 1024 == 0) {
                System.out.println("Trimmed surplus keys in database: " + (i4 - wantedMoveNums.length) + "/" + (totalUnwantedBlocks - wantedMoveNums.length));
                t.commit();
                t = i4 == totalUnwantedBlocks - 1 ? null : this.environment.beginTransaction(null, null);
            }
            this.addFreeBlock(blockNo, true, reason);
        }
        if (t != null) {
            t.commit();
        }
        t = null;
        System.out.println("Finishing shrink");
        this.storeRAF.setLength(newSize * (long)(this.dataBlockSize + this.headerBlockSize));
        this.lruRAF.setLength(newSize * 8L);
        if (this.keysRAF != null) {
            this.keysRAF.setLength(newSize * (long)this.keyLength);
        }
        BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
        synchronized (berkeleyDBFreenetStore) {
            this.blocksInStore = newSize;
        }
        System.err.println("Shrunk store, now have " + this.blocksInStore + " of " + this.maxBlocksInStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeQuickShrink(boolean offline) throws DatabaseException, IOException {
        long curBlocks;
        long maxBlocks;
        BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
        synchronized (berkeleyDBFreenetStore) {
            maxBlocks = this.maxBlocksInStore;
            curBlocks = this.blocksInStore;
            if (maxBlocks >= curBlocks) {
                System.out.println("Not shrinking store: " + curBlocks + " < " + maxBlocks);
                return;
            }
        }
        this.innerQuickShrink(curBlocks, maxBlocks, offline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void innerQuickShrink(long curBlocks, long maxBlocks, boolean offline) throws DatabaseException, IOException {
        long oldCurBlocks = curBlocks;
        try {
            curBlocks = Math.max(oldCurBlocks, this.highestBlockNumberInDatabase());
        }
        catch (DatabaseException e) {
            Logger.error(this, "Ignoring " + (Object)((Object)e) + " in innerQuickShrink initialisation", e);
        }
        Transaction t = null;
        try {
            String msg = "Shrinking store: " + curBlocks + " -> " + maxBlocks + " (from db " + this.keysDB.count() + ", highest " + this.highestBlockNumberInDatabase() + ", from file " + this.countCHKBlocksFromFile() + ')';
            System.err.println(msg);
            Logger.normal(this, msg);
            WrapperManager.signalStarting((int)((int)Math.min(Integer.MAX_VALUE, 300000L + 100L * Math.max(0L, curBlocks - maxBlocks))));
            while (true) {
                t = this.environment.beginTransaction(null, null);
                long deleted = 0L;
                for (long i = curBlocks - 1L; i >= maxBlocks; --i) {
                    if (t == null) {
                        t = this.environment.beginTransaction(null, null);
                    }
                    DatabaseEntry blockNumEntry = new DatabaseEntry();
                    LongBinding.longToEntry((long)i, (DatabaseEntry)blockNumEntry);
                    OperationStatus result = this.blockNumDB.delete(t, blockNumEntry);
                    if (result.equals(OperationStatus.SUCCESS)) {
                        ++deleted;
                    }
                    t.commit();
                    t = null;
                    this.freeBlocks.remove(i);
                    long chkBlocksInDatabase = this.highestBlockNumberInDatabase();
                    BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
                    synchronized (berkeleyDBFreenetStore) {
                        maxBlocks = this.maxBlocksInStore;
                        curBlocks = this.blocksInStore = chkBlocksInDatabase;
                        if (maxBlocks >= curBlocks) {
                            break;
                        }
                        continue;
                    }
                }
                if (t != null) {
                    t.commit();
                }
                System.err.println("Deleted " + deleted + " keys");
                t = null;
                if (offline) break;
                System.err.println("Checking...");
                BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
                synchronized (berkeleyDBFreenetStore) {
                    maxBlocks = this.maxBlocksInStore;
                    curBlocks = this.blocksInStore;
                    if (maxBlocks >= curBlocks) {
                        break;
                    }
                }
            }
            this.storeRAF.setLength(this.maxBlocksInStore * (long)(this.dataBlockSize + this.headerBlockSize));
            this.lruRAF.setLength(this.maxBlocksInStore * 8L);
            if (this.keysRAF != null) {
                this.keysRAF.setLength(this.maxBlocksInStore * (long)this.keyLength);
            }
            this.blocksInStore = this.maxBlocksInStore;
            System.err.println("Successfully shrunk store to " + this.blocksInStore);
            Object var22_17 = null;
            if (t == null) return;
        }
        catch (Throwable throwable) {
            Object var22_18 = null;
            if (t == null) throw throwable;
            t.abort();
            throw throwable;
        }
        t.abort();
    }

    private BerkeleyDBFreenetStore(Environment env, String prefix, File storeFile, File lruFile, File keysFile, File fixSecondaryFile, long maxChkBlocks, SemiOrderedShutdownHook storeShutdownHook, File reconstructFile, StoreCallback<T> callback, RandomSource random) throws DatabaseException, IOException {
        this(env, prefix, storeFile, lruFile, keysFile, fixSecondaryFile, maxChkBlocks, true, storeShutdownHook, reconstructFile, callback, random);
    }

    private static void wipeOldDatabases(Environment env, String prefix) {
        BerkeleyDBFreenetStore.wipeDatabase(env, prefix + "CHK");
        BerkeleyDBFreenetStore.wipeDatabase(env, prefix + "CHK_accessTime");
        BerkeleyDBFreenetStore.wipeDatabase(env, prefix + "CHK_blockNum");
        System.err.println("Removed old database " + prefix);
    }

    private static void wipeDatabase(Environment env, String name) {
        WrapperManager.signalStarting((int)18000000);
        Logger.normal(BerkeleyDBFreenetStore.class, "Wiping database " + name);
        try {
            env.removeDatabase(null, name);
        }
        catch (DatabaseNotFoundException e) {
            System.err.println("Database " + name + " does not exist deleting it");
        }
        catch (DatabaseException e) {
            Logger.error(BerkeleyDBFreenetStore.class, "Could not remove old database: " + name + ": " + (Object)((Object)e), e);
            System.err.println("Could not remove old database: " + name + ": " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reconstruct() throws DatabaseException, IOException {
        if (this.keysDB.count() != 0L) {
            throw new IllegalStateException("Store must be empty before reconstruction!");
        }
        int timeout = (int)Math.min(604800000L, 300000L + this.storeRAF.length() / (long)(this.dataBlockSize + this.headerBlockSize) * 1000L);
        System.err.println("Reconstructing store index from store file: callback=" + this.callback + " - allowing " + timeout + "ms");
        Logger.error(this, "Reconstructing store index from store file: callback=" + this.callback);
        WrapperManager.signalStarting((int)timeout);
        byte[] header = new byte[this.headerBlockSize];
        byte[] data = new byte[this.dataBlockSize];
        byte[] keyBuf = new byte[this.keyLength];
        long l = 0L;
        long dupes = 0L;
        long failures = 0L;
        long expectedLength = this.storeRAF.length() / (long)(this.dataBlockSize + this.headerBlockSize);
        long minLRU = Long.MAX_VALUE;
        long maxLRU = Long.MIN_VALUE;
        try {
            this.lruRAF.seek(0L);
            for (long i = 0L; i < this.lruRAF.length() / 8L; ++i) {
                long lru = this.lruRAF.readLong();
                if (lru > maxLRU) {
                    maxLRU = lru;
                }
                if (lru >= minLRU) continue;
                minLRU = lru;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.storeRAF.seek(0L);
            this.lruRAF.seek(0L);
            long lruRAFLength = this.lruRAF.length();
            long keysRAFLength = 0L;
            if (this.keysRAF != null) {
                this.keysRAF.seek(0L);
                keysRAFLength = this.keysRAF.length();
            }
            l = 0L;
            while (true) {
                block47: {
                    Object var36_33;
                    Transaction t;
                    block51: {
                        block50: {
                            block48: {
                                if (l % 1024L == 0L) {
                                    System.out.println("Key " + l + '/' + expectedLength + " OK (" + dupes + " dupes, " + failures + " failures)");
                                }
                                long lruVal = 0L;
                                t = null;
                                boolean dataRead = false;
                                if (lruRAFLength > (l + 1L) * 8L) {
                                    try {
                                        lruVal = this.lruRAF.readLong();
                                    }
                                    catch (EOFException e) {
                                        System.err.println("EOF reading LRU file at " + this.lruRAF.getFilePointer() + " of " + this.lruRAF.length() + " l = " + l + " orig lru length = " + lruRAFLength);
                                        lruVal = 0L;
                                        lruRAFLength = 0L;
                                    }
                                }
                                if (lruVal == 0L) {
                                    Logger.minor(this, "Block " + l + " : resetting LRU");
                                    lruVal = this.getNewRecentlyUsed();
                                } else {
                                    Logger.minor(this, "Block " + l + " : LRU " + lruVal);
                                }
                                boolean readKey = false;
                                if (this.keysRAF != null && keyBuf != null && keysRAFLength > (l + 1L) * (long)this.keyLength) {
                                    try {
                                        this.keysRAF.readFully(keyBuf);
                                        readKey = true;
                                    }
                                    catch (EOFException e) {
                                        System.err.println("EOF reading keys file at " + this.keysRAF.getFilePointer() + " of " + this.keysRAF.length() + " l = " + l + " orig keys length = " + keysRAFLength);
                                        readKey = false;
                                    }
                                }
                                if (!readKey) {
                                    keyBuf = null;
                                }
                                boolean keyFromData = false;
                                try {
                                    try {
                                        byte[] routingkey = null;
                                        if (keyBuf != null && !this.isAllNull(keyBuf) && (routingkey = this.callback.routingKeyFromFullKey(keyBuf)) == keyBuf) {
                                            byte[] newkey = new byte[routingkey.length];
                                            System.arraycopy(routingkey, 0, newkey, 0, routingkey.length);
                                            routingkey = newkey;
                                        }
                                        if (!dataRead) {
                                            this.storeRAF.seek(l * (long)(this.headerBlockSize + this.dataBlockSize));
                                            this.storeRAF.readFully(header);
                                            this.storeRAF.readFully(data);
                                            dataRead = true;
                                        }
                                        if (routingkey == null && !this.isAllNull(header) && !this.isAllNull(data)) {
                                            keyFromData = true;
                                            try {
                                                T block = this.callback.construct(data, header, null, keyBuf);
                                                routingkey = block.getRoutingKey();
                                            }
                                            catch (KeyVerifyException e) {
                                                String err = "Bogus or unreconstructible key at slot " + l + " : " + e + " - lost block " + l;
                                                Logger.error(this, err, e);
                                                System.err.println(err);
                                                ++failures;
                                            }
                                        }
                                        if (routingkey == null) {
                                            t = this.environment.beginTransaction(null, null);
                                            this.reconstructAddFreeBlock(l, t, --minLRU);
                                            t.commitNoSync();
                                            t = null;
                                            var36_33 = null;
                                            if (t == null) break block47;
                                            break block48;
                                        }
                                        t = this.environment.beginTransaction(null, null);
                                        StoreBlock storeBlock = new StoreBlock(l, lruVal);
                                        DatabaseEntry routingkeyDBE = new DatabaseEntry(routingkey);
                                        DatabaseEntry blockDBE = new DatabaseEntry();
                                        this.storeBlockTupleBinding.objectToEntry((Object)storeBlock, blockDBE);
                                        OperationStatus op = this.keysDB.putNoOverwrite(t, routingkeyDBE, blockDBE);
                                        if (op == OperationStatus.KEYEXIST) {
                                            block49: {
                                                if (!keyFromData) {
                                                    String err;
                                                    byte[] oldRoutingkey = routingkey;
                                                    try {
                                                        T block;
                                                        if (!dataRead) {
                                                            this.storeRAF.seek(l * (long)(this.headerBlockSize + this.dataBlockSize));
                                                            this.storeRAF.readFully(header);
                                                            this.storeRAF.readFully(data);
                                                            dataRead = true;
                                                        }
                                                        if (Arrays.equals(oldRoutingkey, routingkey = (block = this.callback.construct(data, header, null, keyBuf)).getRoutingKey())) {
                                                            ++dupes;
                                                            err = "Really duplicated block: " + l + " key null = " + this.isAllNull(keyBuf) + " routing key null = " + this.isAllNull(routingkey) + " headers null = " + this.isAllNull(header) + " data null = " + this.isAllNull(data);
                                                            Logger.error(this, err);
                                                            System.err.println(err);
                                                            this.reconstructAddFreeBlock(l, t, --minLRU);
                                                            break block49;
                                                        }
                                                        routingkeyDBE = new DatabaseEntry(routingkey);
                                                        op = this.keysDB.putNoOverwrite(t, routingkeyDBE, blockDBE);
                                                        if (op == OperationStatus.KEYEXIST) {
                                                            ++dupes;
                                                            err = "Duplicate block, reconstructed the key, different duplicate block!: " + l + " key null = " + this.isAllNull(keyBuf) + " routing key null = " + this.isAllNull(routingkey) + " headers null = " + this.isAllNull(header) + " data null = " + this.isAllNull(data);
                                                            Logger.error(this, err);
                                                            System.err.println(err);
                                                            this.reconstructAddFreeBlock(l, t, --minLRU);
                                                        } else if (op != OperationStatus.SUCCESS) {
                                                            ++failures;
                                                            err = "Unknown error: " + op + " for duplicate block " + l + " after reconstructing key";
                                                            Logger.error(this, err);
                                                            System.err.println(err);
                                                            this.reconstructAddFreeBlock(l, t, --minLRU);
                                                        }
                                                    }
                                                    catch (KeyVerifyException e) {
                                                        err = "Duplicate slot, bogus or unreconstructible key at " + l + " : " + e + " - lost block " + l;
                                                        Logger.error(this, err, e);
                                                        System.err.println(err);
                                                        ++failures;
                                                        this.reconstructAddFreeBlock(l, t, --minLRU);
                                                    }
                                                } else {
                                                    Logger.error(this, "Duplicate block: " + l + " key null = " + this.isAllNull(keyBuf) + " routing key null = " + this.isAllNull(routingkey) + " headers null = " + this.isAllNull(header) + " data null = " + this.isAllNull(data));
                                                    System.err.println("Duplicate block: " + l + " key null = " + this.isAllNull(keyBuf) + " routing key null = " + this.isAllNull(routingkey) + " headers null = " + this.isAllNull(header) + " data null = " + this.isAllNull(data));
                                                    ++dupes;
                                                    this.reconstructAddFreeBlock(l, t, --minLRU);
                                                }
                                            }
                                            t.commitNoSync();
                                            t = null;
                                            break block50;
                                        }
                                        if (op != OperationStatus.SUCCESS) {
                                            this.addFreeBlock(l, true, "failure: " + op);
                                            ++failures;
                                        }
                                        t.commitNoSync();
                                        t = null;
                                        break block51;
                                    }
                                    catch (DatabaseException e) {
                                        System.err.println("Error while reconstructing: " + (Object)((Object)e));
                                        e.printStackTrace();
                                        var36_33 = null;
                                        if (t != null) {
                                            t.abort();
                                        }
                                        break block47;
                                    }
                                }
                                catch (Throwable throwable) {
                                    var36_33 = null;
                                    if (t == null) throw throwable;
                                    t.abort();
                                    throw throwable;
                                }
                            }
                            t.abort();
                            break block47;
                        }
                        var36_33 = null;
                        if (t != null) {
                            t.abort();
                        }
                        break block47;
                    }
                    var36_33 = null;
                    if (t != null) {
                        t.abort();
                    }
                }
                ++l;
            }
        }
        catch (EOFException e) {
            long size = l * (long)(this.dataBlockSize + this.headerBlockSize);
            if (l < expectedLength) {
                System.err.println("Found end of store, truncating to " + l + " blocks : " + size + " (" + failures + " failures " + dupes + " dupes)");
                e.printStackTrace();
            } else {
                System.err.println("Confirmed store is " + expectedLength + " blocks long (" + failures + " failures " + dupes + " dupes)");
            }
            this.blocksInStore = l;
            try {
                this.storeRAF.setLength(size);
                this.lruRAF.setLength(l * 8L);
                if (this.keysRAF == null) return;
                this.keysRAF.setLength(l * (long)this.keyLength);
                return;
            }
            catch (IOException e1) {
                System.err.println("Failed to set size");
            }
            return;
        }
    }

    private void reconstructAddFreeBlock(long l, Transaction t, long lru) throws DatabaseException {
        StoreBlock storeBlock = new StoreBlock(l, lru);
        byte[] buf = new byte[32];
        this.random.nextBytes(buf);
        DatabaseEntry routingkeyDBE = new DatabaseEntry(buf);
        DatabaseEntry blockDBE = new DatabaseEntry();
        this.storeBlockTupleBinding.objectToEntry((Object)storeBlock, blockDBE);
        OperationStatus op = this.keysDB.putNoOverwrite(t, routingkeyDBE, blockDBE);
        if (op != OperationStatus.SUCCESS) {
            Logger.error(this, "Impossible operation status inserting bogus key to LRU: " + op);
            this.addFreeBlock(l, true, "Impossible to add (invalid) to LRU: " + op);
        }
    }

    private boolean isAllNull(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public T fetch(byte[] routingkey, byte[] fullKey, boolean dontPromote) throws IOException {
        DatabaseEntry routingkeyDBE = new DatabaseEntry(routingkey);
        DatabaseEntry blockDBE = new DatabaseEntry();
        BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
        // MONITORENTER : berkeleyDBFreenetStore
        if (this.closed) {
            // MONITOREXIT : berkeleyDBFreenetStore
            return null;
        }
        int running = this.runningFetches++;
        // MONITOREXIT : berkeleyDBFreenetStore
        Cursor c = null;
        Transaction t = null;
        try {
            Object object;
            try {
                Object data;
                byte[] header;
                StorableBlock block;
                StoreBlock storeBlock;
                block63: {
                    T e3;
                    t = this.environment.beginTransaction(null, null);
                    c = this.keysDB.openCursor(t, null);
                    if (logMINOR) {
                        Logger.minor(this, "Fetching " + HexUtil.bytesToHex(routingkey) + " dontPromote=" + dontPromote + " for " + this.callback + " running fetches: " + running);
                    }
                    if (c.getSearchKey(routingkeyDBE, blockDBE, LockMode.RMW) != OperationStatus.SUCCESS) {
                        c.close();
                        c = null;
                        t.abort();
                        t = null;
                        BerkeleyDBFreenetStore berkeleyDBFreenetStore2 = this;
                        // MONITORENTER : berkeleyDBFreenetStore2
                        ++this.misses;
                        // MONITOREXIT : berkeleyDBFreenetStore2
                        if (logMINOR) {
                            Logger.minor(this, "Not found");
                        }
                        berkeleyDBFreenetStore2 = null;
                        Object var22_13 = null;
                        BerkeleyDBFreenetStore berkeleyDBFreenetStore3 = this;
                        // MONITORENTER : berkeleyDBFreenetStore3
                        int x = this.runningFetches--;
                        // MONITOREXIT : berkeleyDBFreenetStore3
                        if (!logMINOR) return (T)berkeleyDBFreenetStore2;
                        Logger.minor(this, "Running fetches now " + x);
                        return (T)berkeleyDBFreenetStore2;
                    }
                    storeBlock = (StoreBlock)this.storeBlockTupleBinding.entryToObject(blockDBE);
                    block = null;
                    if (logMINOR) {
                        Logger.minor(this, "Reading block " + storeBlock.offset + "...");
                    }
                    try {
                        long lru;
                        block64: {
                            header = new byte[this.headerBlockSize];
                            data = new byte[this.dataBlockSize];
                            try {
                                this.fcReadStore(storeBlock.offset, header, (byte[])data);
                            }
                            catch (EOFException e2) {
                                Logger.error(this, "No block");
                                c.close();
                                c = null;
                                this.keysDB.delete(t, routingkeyDBE);
                                t.commit();
                                t = null;
                                this.addFreeBlock(storeBlock.offset, true, "Data off end of store file");
                                T t2 = null;
                                Object var22_14 = null;
                                BerkeleyDBFreenetStore berkeleyDBFreenetStore4 = this;
                                // MONITORENTER : berkeleyDBFreenetStore4
                                int x = this.runningFetches--;
                                // MONITOREXIT : berkeleyDBFreenetStore4
                                if (!logMINOR) return t2;
                                Logger.minor(this, "Running fetches now " + x);
                                return t2;
                            }
                            block = (StorableBlock)this.callback.construct((byte[])data, header, routingkey, fullKey);
                            byte[] newFullKey = block.getFullKey();
                            if (this.keysRAF != null) {
                                this.fcWriteKey(storeBlock.offset, newFullKey);
                            }
                            if (Arrays.equals(block.getRoutingKey(), routingkey)) break block63;
                            BerkeleyDBFreenetStore berkeleyDBFreenetStore5 = this;
                            // MONITORENTER : berkeleyDBFreenetStore5
                            ++this.misses;
                            // MONITOREXIT : berkeleyDBFreenetStore5
                            this.keysDB.delete(t, routingkeyDBE);
                            lru = this.getMinRecentlyUsed(t) - 1L;
                            Logger.normal(this, "Does not verify (not the expected key), setting accessTime to " + lru + " for : " + HexUtil.bytesToHex(routingkey));
                            storeBlock = new StoreBlock(storeBlock.offset, lru);
                            routingkeyDBE = new DatabaseEntry(block.getRoutingKey());
                            blockDBE = new DatabaseEntry();
                            this.storeBlockTupleBinding.objectToEntry((Object)storeBlock, blockDBE);
                            try {
                                this.keysDB.put(t, routingkeyDBE, blockDBE);
                                if (fullKey == null) {
                                    fullKey = block.getFullKey();
                                }
                                if (this.keysRAF != null) {
                                    this.fcWriteKey(storeBlock.offset, fullKey);
                                    if (logDEBUG) {
                                        Logger.debug(this, "Written full key length " + fullKey.length + " to block " + storeBlock.offset + " at " + storeBlock.offset * (long)this.keyLength + " for " + this.callback);
                                    }
                                    break block64;
                                }
                                if (logDEBUG) {
                                    Logger.debug(this, "Not writing full key length " + fullKey.length + " for block " + storeBlock.offset + " for " + this.callback);
                                }
                            }
                            catch (DatabaseException e3) {
                                Logger.error(this, "Caught database exception " + (Object)((Object)e3) + " while replacing element");
                                this.addFreeBlock(storeBlock.offset, true, "Bogus key");
                                c.close();
                                c = null;
                                t.commit();
                                t = null;
                                T t3 = null;
                                Object var22_15 = null;
                                BerkeleyDBFreenetStore berkeleyDBFreenetStore6 = this;
                                // MONITORENTER : berkeleyDBFreenetStore6
                                int x = this.runningFetches--;
                                // MONITOREXIT : berkeleyDBFreenetStore6
                                if (!logMINOR) return t3;
                                Logger.minor(this, "Running fetches now " + x);
                                return t3;
                            }
                        }
                        Logger.normal(this, "Successfully replaced entry at block number " + storeBlock.offset + " lru " + lru);
                        c.close();
                        c = null;
                        t.commit();
                        t = null;
                        e3 = null;
                    }
                    catch (KeyVerifyException ex) {
                        Logger.normal(this, "Does not verify (" + ex + "), setting accessTime to 0 for : " + HexUtil.bytesToHex(routingkey), ex);
                        BerkeleyDBFreenetStore berkeleyDBFreenetStore7 = this;
                        data = berkeleyDBFreenetStore7;
                        // MONITORENTER : berkeleyDBFreenetStore7
                        ++this.misses;
                        // MONITOREXIT : data
                        byte[] buf = new byte[this.keyLength];
                        for (int i = 0; i < buf.length; ++i) {
                            buf[i] = 0;
                        }
                        if (this.keysRAF != null) {
                            this.fcWriteKey(storeBlock.offset, buf);
                        }
                        this.keysDB.delete(t, routingkeyDBE);
                        long lru = this.getMinRecentlyUsed(t) - 1L;
                        byte[] randomKey = new byte[this.keyLength];
                        this.random.nextBytes(randomKey);
                        storeBlock = new StoreBlock(storeBlock.offset, lru);
                        routingkeyDBE = new DatabaseEntry(randomKey);
                        blockDBE = new DatabaseEntry();
                        this.storeBlockTupleBinding.objectToEntry((Object)storeBlock, blockDBE);
                        try {
                            this.keysDB.put(t, routingkeyDBE, blockDBE);
                        }
                        catch (DatabaseException e4) {
                            Logger.error(this, "Caught database exception " + (Object)((Object)e4) + " while adding corrupt element to LRU");
                            this.addFreeBlock(storeBlock.offset, true, "Bogus key");
                            c.close();
                            c = null;
                            t.commit();
                            t = null;
                            T t4 = null;
                            Object var22_17 = null;
                            BerkeleyDBFreenetStore berkeleyDBFreenetStore8 = this;
                            // MONITORENTER : berkeleyDBFreenetStore8
                            int x = this.runningFetches--;
                            // MONITOREXIT : berkeleyDBFreenetStore8
                            if (!logMINOR) return t4;
                            Logger.minor(this, "Running fetches now " + x);
                            return t4;
                        }
                        c.close();
                        c = null;
                        t.commit();
                        t = null;
                        T t5 = null;
                        Object var22_18 = null;
                        BerkeleyDBFreenetStore berkeleyDBFreenetStore9 = this;
                        // MONITORENTER : berkeleyDBFreenetStore9
                        int x = this.runningFetches--;
                        // MONITOREXIT : berkeleyDBFreenetStore9
                        if (!logMINOR) return t5;
                        Logger.minor(this, "Running fetches now " + x);
                        return t5;
                    }
                    Object var22_16 = null;
                    BerkeleyDBFreenetStore berkeleyDBFreenetStore10 = this;
                    // MONITORENTER : berkeleyDBFreenetStore10
                    int x = this.runningFetches--;
                    // MONITOREXIT : berkeleyDBFreenetStore10
                    if (!logMINOR) return e3;
                    Logger.minor(this, "Running fetches now " + x);
                    return e3;
                }
                if (!dontPromote) {
                    storeBlock.updateRecentlyUsed(this);
                    DatabaseEntry updateDBE = new DatabaseEntry();
                    this.storeBlockTupleBinding.objectToEntry((Object)storeBlock, updateDBE);
                    c.putCurrent(updateDBE);
                    c.close();
                    c = null;
                    t.commit();
                    t = null;
                    this.fcWriteLRU(storeBlock.offset, storeBlock.recentlyUsed);
                } else {
                    c.close();
                    c = null;
                    t.abort();
                    t = null;
                }
                if (logMINOR) {
                    Logger.minor(this, "Headers: " + header.length + " bytes, hash " + Fields.hashCode(header));
                    Logger.minor(this, "Data: " + ((byte[])data).length + " bytes, hash " + Fields.hashCode(data) + " fetching " + HexUtil.bytesToHex(routingkey));
                }
                object = this;
                // MONITORENTER : object
                ++this.hits;
                // MONITOREXIT : object
                object = block;
                Object var22_19 = null;
                BerkeleyDBFreenetStore berkeleyDBFreenetStore11 = this;
            }
            catch (ClosedChannelException cce) {
                Logger.debug(this, "channel closed", cce);
                T block = null;
                Object var22_20 = null;
                BerkeleyDBFreenetStore berkeleyDBFreenetStore12 = this;
                // MONITORENTER : berkeleyDBFreenetStore12
                int x = this.runningFetches--;
                // MONITOREXIT : berkeleyDBFreenetStore12
                if (!logMINOR) return block;
                Logger.minor(this, "Running fetches now " + x);
                return block;
            }
            catch (Throwable ex) {
                if (ex instanceof IOException) {
                    BerkeleyDBFreenetStore block = this;
                    // MONITORENTER : block
                    if (this.closed) {
                        T t6 = null;
                        // MONITOREXIT : block
                        Object var22_21 = null;
                        BerkeleyDBFreenetStore berkeleyDBFreenetStore13 = this;
                        // MONITORENTER : berkeleyDBFreenetStore13
                        int x = this.runningFetches--;
                        // MONITOREXIT : berkeleyDBFreenetStore13
                        if (!logMINOR) return t6;
                        Logger.minor(this, "Running fetches now " + x);
                        return t6;
                    }
                    // MONITOREXIT : block
                }
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (DatabaseException ex2) {
                        // empty catch block
                    }
                }
                if (t != null) {
                    try {
                        t.abort();
                    }
                    catch (DatabaseException ex2) {
                        // empty catch block
                    }
                }
                this.checkSecondaryDatabaseError(ex);
                Logger.error(this, "Caught " + ex, ex);
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
            // MONITORENTER : berkeleyDBFreenetStore11
            int x = this.runningFetches--;
            // MONITOREXIT : berkeleyDBFreenetStore11
            if (!logMINOR) return (T)object;
            Logger.minor(this, "Running fetches now " + x);
            return (T)object;
        }
        catch (Throwable throwable) {
            Object var22_22 = null;
            BerkeleyDBFreenetStore berkeleyDBFreenetStore14 = this;
            // MONITORENTER : berkeleyDBFreenetStore14
            int x = this.runningFetches--;
            // MONITOREXIT : berkeleyDBFreenetStore14
            if (!logMINOR) throw throwable;
            Logger.minor(this, "Running fetches now " + x);
            throw throwable;
        }
    }

    private void addFreeBlock(long offset, boolean loud, String reason) {
        if (this.freeBlocks.push(offset)) {
            if (loud) {
                System.err.println("Freed block " + offset + " (" + reason + ')');
                Logger.normal(this, "Freed block " + offset + " (" + reason + ')');
            } else if (logMINOR) {
                Logger.minor(this, "Freed block " + offset + " (" + reason + ')');
            }
        } else if (logMINOR) {
            Logger.minor(this, "Already freed block " + offset + " (" + reason + ')');
        }
    }

    @Override
    public void put(StorableBlock block, byte[] data, byte[] header, boolean overwrite) throws KeyCollisionException, IOException {
        T oldBlock;
        byte[] routingkey = block.getRoutingKey();
        byte[] fullKey = block.getFullKey();
        if (logMINOR) {
            Logger.minor(this, "Putting " + HexUtil.bytesToHex(routingkey) + " for " + this.callback);
        }
        if ((oldBlock = this.fetch(routingkey, fullKey, false)) != null) {
            if (!this.collisionPossible) {
                return;
            }
            if (!block.equals(oldBlock)) {
                if (!overwrite) {
                    throw new KeyCollisionException();
                }
                this.overwriteKeyUnchanged(routingkey, fullKey, data, header);
            }
        } else {
            this.innerPut(block, routingkey, fullKey, data, header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean overwriteKeyUnchanged(byte[] routingkey, byte[] fullKey, byte[] data, byte[] header) throws IOException {
        block26: {
            DatabaseException ex2222;
            Transaction t;
            Cursor c;
            block25: {
                DatabaseEntry blockDBE;
                block22: {
                    DatabaseException ex2222;
                    boolean bl;
                    block23: {
                        BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
                        synchronized (berkeleyDBFreenetStore) {
                            if (this.closed) {
                                return false;
                            }
                        }
                        DatabaseEntry routingkeyDBE = new DatabaseEntry(routingkey);
                        blockDBE = new DatabaseEntry();
                        c = null;
                        t = null;
                        t = this.environment.beginTransaction(null, null);
                        c = this.keysDB.openCursor(t, null);
                        if (c.getSearchKey(routingkeyDBE, blockDBE, LockMode.RMW) == OperationStatus.SUCCESS) break block22;
                        c.close();
                        c = null;
                        t.abort();
                        t = null;
                        bl = false;
                        Object var11_13 = null;
                        if (c == null) break block23;
                        try {
                            c.close();
                        }
                        catch (DatabaseException ex2222) {
                            // empty catch block
                        }
                    }
                    if (t != null) {
                        try {
                            t.abort();
                        }
                        catch (DatabaseException ex2222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                StoreBlock storeBlock = (StoreBlock)this.storeBlockTupleBinding.entryToObject(blockDBE);
                this.fcWriteStore(storeBlock.offset, header, data);
                if (this.keysRAF != null) {
                    this.fcWriteKey(storeBlock.offset, fullKey);
                }
                c.close();
                c = null;
                t.commit();
                t = null;
                Object var11_14 = null;
                if (c == null) break block25;
                try {
                    c.close();
                }
                catch (DatabaseException ex2222) {
                    // empty catch block
                }
            }
            if (t != null) {
                try {
                    t.abort();
                }
                catch (DatabaseException ex2222) {}
            }
            break block26;
            {
                catch (Throwable ex) {
                    this.checkSecondaryDatabaseError(ex);
                    Logger.error(this, "Caught " + ex, ex);
                    ex.printStackTrace();
                    throw new IOException(ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                DatabaseException ex2222;
                Object var11_15 = null;
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (DatabaseException ex2222) {
                        // empty catch block
                    }
                }
                if (t != null) {
                    try {
                        t.abort();
                    }
                    catch (DatabaseException ex2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void innerPut(StorableBlock block, byte[] routingkey, byte[] fullKey, byte[] data, byte[] header) throws IOException {
        block33: {
            block32: {
                block31: {
                    var6_6 = this;
                    synchronized (var6_6) {
                        if (this.closed) {
                            return;
                        }
                        ** if (data.length == this.dataBlockSize) goto lbl8
                    }
lbl-1000:
                    // 1 sources

                    {
                        Logger.error(this, "This data is " + data.length + " bytes. Should be " + this.dataBlockSize);
                        return;
                    }
lbl8:
                    // 1 sources

                    if (header.length != this.headerBlockSize) {
                        Logger.error(this, "This header is " + data.length + " bytes. Should be " + this.headerBlockSize);
                        return;
                    }
                    t = null;
                    try {
                        try {
                            t = this.environment.beginTransaction(null, null);
                            routingkeyDBE = new DatabaseEntry(routingkey);
                            blockDBE = new DatabaseEntry();
                            if (BerkeleyDBFreenetStore.logMINOR) {
                                Logger.minor(this, "Putting key " + block + " - checking whether it exists first");
                            }
                            if ((result = this.keysDB.get(t, routingkeyDBE, blockDBE, LockMode.RMW)) == OperationStatus.SUCCESS || result == OperationStatus.KEYEXIST) {
                                if (BerkeleyDBFreenetStore.logMINOR) {
                                    Logger.minor(this, "Key already exists");
                                }
                                t.abort();
                                t = null;
                                if (this.fetch(routingkey, fullKey, false) != null) {
                                    var12_13 = null;
                                    if (t == null) return;
                                    break block31;
                                }
                                if (BerkeleyDBFreenetStore.logMINOR) {
                                    Logger.minor(this, "Old key was invalid, adding anyway");
                                }
                                this.innerPut(block, routingkey, fullKey, data, header);
                                break block32;
                            }
                            if (result == OperationStatus.KEYEMPTY) {
                                Logger.error(this, "Got KEYEMPTY - record deleted? Shouldn't be possible with record locking...!");
                            } else if (result != OperationStatus.NOTFOUND) throw new IllegalStateException("Unknown operation status: " + result);
                            this.writeBlock(header, data, t, routingkeyDBE, fullKey);
                            t.commit();
                            t = null;
                            if (BerkeleyDBFreenetStore.logMINOR) {
                                Logger.minor(this, "Headers: " + header.length + " bytes, hash " + Fields.hashCode(header));
                                Logger.minor(this, "Data: " + data.length + " bytes, hash " + Fields.hashCode(data) + " putting " + HexUtil.bytesToHex(routingkey));
                            }
                            break block33;
                        }
                        catch (ClosedChannelException cce) {
                            Logger.debug(this, "channel closed", cce);
                            var12_16 = null;
                            if (t == null) return;
                            try {
                                t.abort();
                                return;
                            }
                            catch (DatabaseException ex2) {
                                return;
                            }
                        }
                        catch (Throwable ex) {
                            if (ex instanceof IOException) {
                                var8_11 = this;
                                synchronized (var8_11) {
                                    if (this.closed) {
                                        // MONITOREXIT @DISABLED, blocks:[1, 18, 19, 7, 13] lbl63 : MonitorExitStatement: MONITOREXIT : var8_11
                                        var12_17 = null;
                                        if (t == null) return;
                                        ** try [egrp 5[TRYBLOCK] [18 : 620->628)] { 
lbl65:
                                        // 1 sources

                                        t.abort();
                                        return;
lbl67:
                                        // 1 sources

                                        catch (DatabaseException ex2) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                }
                            }
                            this.checkSecondaryDatabaseError(ex);
                            Logger.error(this, "Caught " + ex, ex);
                            ex.printStackTrace();
                            if (ex instanceof IOException == false) throw new IOException(ex.getMessage());
                            throw (IOException)ex;
                        }
                    }
                    catch (Throwable var11_25) {
                        var12_18 = null;
                        if (t == null) throw var11_25;
                        ** try [egrp 5[TRYBLOCK] [18 : 620->628)] { 
lbl80:
                        // 1 sources

                        t.abort();
                        throw var11_25;
lbl82:
                        // 1 sources

                        catch (DatabaseException ex2) {
                            // empty catch block
                        }
                        throw var11_25;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [18 : 620->628)] { 
lbl87:
                // 1 sources

                t.abort();
                return;
lbl89:
                // 1 sources

                catch (DatabaseException ex2) {
                    // empty catch block
                }
                return;
            }
            var12_14 = null;
            if (t == null) return;
            ** try [egrp 5[TRYBLOCK] [18 : 620->628)] { 
lbl96:
            // 1 sources

            t.abort();
            return;
lbl98:
            // 1 sources

            catch (DatabaseException ex2) {
                // empty catch block
            }
            return;
        }
        var12_15 = null;
        if (t == null) return;
        try {}
        catch (DatabaseException ex2) {}
        t.abort();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overwriteLRUBlock(byte[] header, byte[] data, Transaction t, DatabaseEntry routingkeyDBE, byte[] fullKey) throws DatabaseException, IOException {
        StoreBlock oldStoreBlock;
        Cursor c = this.accessTimeDB.openCursor(t, null);
        try {
            DatabaseEntry keyDBE = new DatabaseEntry();
            DatabaseEntry dataDBE = new DatabaseEntry();
            c.getFirst(keyDBE, dataDBE, LockMode.RMW);
            oldStoreBlock = (StoreBlock)this.storeBlockTupleBinding.entryToObject(dataDBE);
            c.delete();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            c.close();
            throw throwable;
        }
        c.close();
        StoreBlock storeBlock = new StoreBlock(this, oldStoreBlock.getOffset());
        DatabaseEntry blockDBE = new DatabaseEntry();
        this.storeBlockTupleBinding.objectToEntry((Object)storeBlock, blockDBE);
        this.keysDB.put(t, routingkeyDBE, blockDBE);
        this.fcWriteStore(storeBlock.getOffset(), header, data);
        this.fcWriteLRU(storeBlock.getOffset(), storeBlock.recentlyUsed);
        if (this.keysRAF != null) {
            this.fcWriteKey(storeBlock.getOffset(), fullKey);
        }
        BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
        synchronized (berkeleyDBFreenetStore) {
            ++this.writes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeNewBlock(long blockNum, byte[] header, byte[] data, Transaction t, DatabaseEntry routingkeyDBE, byte[] fullKey) throws DatabaseException, IOException {
        StoreBlock storeBlock = new StoreBlock(this, blockNum);
        long lruValue = storeBlock.recentlyUsed;
        DatabaseEntry blockDBE = new DatabaseEntry();
        this.storeBlockTupleBinding.objectToEntry((Object)storeBlock, blockDBE);
        try {
            this.keysDB.put(t, routingkeyDBE, blockDBE);
        }
        catch (DatabaseException e) {
            DatabaseEntry blockNumEntry = new DatabaseEntry();
            DatabaseEntry found = new DatabaseEntry();
            LongBinding.longToEntry((long)blockNum, (DatabaseEntry)blockNumEntry);
            OperationStatus success = this.blockNumDB.get(t, blockNumEntry, found, LockMode.DEFAULT);
            if (success == OperationStatus.KEYEXIST || success == OperationStatus.SUCCESS) {
                System.err.println("Trying to overwrite block " + blockNum + " but already used: " + this.getName() + " for " + (Object)((Object)e));
                e.printStackTrace();
                Logger.error(this, "Trying to overwrite block " + blockNum + " but already used: " + this.getName() + " for " + (Object)((Object)e));
                return false;
            }
            Logger.minor(this, "Key doesn't exist for block num " + blockNum + " but caught " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
        this.fcWriteStore(blockNum, header, data);
        this.fcWriteLRU(blockNum, lruValue);
        if (this.keysRAF != null) {
            this.fcWriteKey(blockNum, fullKey);
            if (logDEBUG) {
                Logger.debug(this, "Written full key length " + fullKey.length + " to block " + blockNum + " at " + blockNum * (long)this.keyLength + " for " + this.callback);
            }
        } else if (logDEBUG) {
            Logger.debug(this, "Not writing full key length " + fullKey.length + " for block " + blockNum + " for " + this.callback);
        }
        BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
        synchronized (berkeleyDBFreenetStore) {
            ++this.writes;
        }
        return true;
    }

    public final String getName() {
        return this.name;
    }

    private void checkSecondaryDatabaseError(Throwable ex) {
        String msg = ex.getMessage();
        if (ex instanceof DatabaseException) {
            if (msg != null && (msg.indexOf("missing key in the primary database") > -1 || msg.indexOf("the primary record contains a key that is not present in the secondary") > -1)) {
                try {
                    this.fixSecondaryFile.createNewFile();
                }
                catch (IOException e) {
                    Logger.error(this, "Corrupt secondary database (" + this.getName() + ") but could not create flag file " + this.fixSecondaryFile);
                    System.err.println("Corrupt secondary database (" + this.getName() + ") but could not create flag file " + this.fixSecondaryFile);
                    return;
                }
                Logger.error(this, "Corrupt secondary database (" + this.getName() + "). Should be cleaned up on restart.");
                System.err.println("Corrupt secondary database (" + this.getName() + "). Should be cleaned up on restart.");
                System.err.println("Flusing data store files (" + this.getName() + ")");
                BerkeleyDBFreenetStore.flushAndCloseRAF(this.storeRAF);
                this.storeRAF = null;
                BerkeleyDBFreenetStore.flushAndCloseRAF(this.lruRAF);
                this.lruRAF = null;
                BerkeleyDBFreenetStore.flushAndCloseRAF(this.keysRAF);
                this.keysRAF = null;
                WrapperManager.restart();
                System.exit(20);
            } else if (ex instanceof DbChecksumException || ex instanceof RunRecoveryException || ex instanceof LogFileNotFoundException || msg != null && (msg.indexOf("LogFileNotFoundException") >= 0 || msg.indexOf("DbChecksumException") >= 0 || msg.indexOf("RunRecoveryException") >= 0)) {
                System.err.println("Corrupt database! Will be reconstructed on restart");
                Logger.error(this, "Corrupt database! Will be reconstructed on restart");
                try {
                    this.reconstructFile.createNewFile();
                }
                catch (IOException e) {
                    Logger.error(this, "Corrupt database (" + this.getName() + ") but could not create flag file " + this.reconstructFile);
                    System.err.println("Corrupt database (" + this.getName() + ") but could not create flag file " + this.reconstructFile);
                    return;
                }
                System.err.println("Flusing data store files (" + this.getName() + ")");
                BerkeleyDBFreenetStore.flushAndCloseRAF(this.storeRAF);
                this.storeRAF = null;
                BerkeleyDBFreenetStore.flushAndCloseRAF(this.lruRAF);
                this.lruRAF = null;
                BerkeleyDBFreenetStore.flushAndCloseRAF(this.keysRAF);
                this.keysRAF = null;
                System.err.println("Restarting to fix corrupt store database...");
                Logger.error(this, "Restarting to fix corrupt store database...");
                WrapperManager.restart();
            } else if (ex.getCause() != null) {
                this.checkSecondaryDatabaseError(ex.getCause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeBlock(byte[] header, byte[] data, Transaction t, DatabaseEntry routingkeyDBE, byte[] fullKey) throws DatabaseException, IOException {
        block7: {
            do lbl-1000:
            // 3 sources

            {
                block8: {
                    if ((blockNum = this.grabFreeBlock()) < 0L) break block8;
                    if (BerkeleyDBFreenetStore.logMINOR) {
                        Logger.minor(this, "Overwriting free block: " + blockNum);
                    }
                    if (!this.writeNewBlock(blockNum, header, data, t, routingkeyDBE, fullKey)) ** GOTO lbl-1000
                    return;
                }
                if (this.blocksInStore >= this.maxBlocksInStore) break block7;
                var8_7 = this.blocksInStoreLock;
                synchronized (var8_7) {
                    blockNum = this.blocksInStore++;
                }
                if (BerkeleyDBFreenetStore.logMINOR) {
                    Logger.minor(this, "Expanding store and writing block " + blockNum);
                }
                this.freeBlocks.remove(blockNum);
            } while (!this.writeNewBlock(blockNum, header, data, t, routingkeyDBE, fullKey));
            return;
        }
        if (BerkeleyDBFreenetStore.logMINOR) {
            Logger.minor(this, "Overwriting LRU block");
        }
        this.overwriteLRUBlock(header, data, t, routingkeyDBE, fullKey);
    }

    private long grabFreeBlock() {
        while (!this.freeBlocks.isEmpty()) {
            long blockNum = this.freeBlocks.removeFirst();
            if (blockNum >= this.maxBlocksInStore) continue;
            return blockNum;
        }
        return -1L;
    }

    private static void flushAndCloseRAF(RandomAccessFile file) {
        try {
            if (file != null) {
                file.getChannel().force(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BerkeleyDBFreenetStore.closeRAF(file, false);
    }

    private static void closeRAF(RandomAccessFile file, boolean logError) {
        block3: {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                if (!logError) break block3;
                System.err.println("Caught closing file: " + e);
                e.printStackTrace();
            }
        }
    }

    private static void closeDB(Database db, boolean logError) {
        block3: {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (DatabaseException e) {
                if (!logError) break block3;
                System.err.println("Caught closing database: " + (Object)((Object)e));
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void close(boolean sleep) {
        try {
            try {
                logMINOR = Logger.shouldLog(4, this);
                if (logMINOR) {
                    Logger.minor(this, "Closing database " + this);
                }
                BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
                // MONITORENTER : berkeleyDBFreenetStore
                this.closed = true;
                // MONITOREXIT : berkeleyDBFreenetStore
                if (sleep) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        Logger.error(this, "Thread interrupted.", ie);
                    }
                }
                if (this.reallyClosed) {
                    Logger.error(this, "Already closed " + this);
                    Object var6_5 = null;
                    this.reallyClosed = true;
                    return;
                }
                Object ie = this.closeLock;
                // MONITORENTER : ie
                if (this.reallyClosed) {
                    Logger.error(this, "Already closed " + this);
                    // MONITOREXIT : ie
                    Object var6_6 = null;
                    this.reallyClosed = true;
                    return;
                }
                BerkeleyDBFreenetStore.closeRAF(this.storeRAF, true);
                this.storeRAF = null;
                BerkeleyDBFreenetStore.closeRAF(this.lruRAF, true);
                this.lruRAF = null;
                BerkeleyDBFreenetStore.closeRAF(this.keysRAF, true);
                this.keysRAF = null;
                BerkeleyDBFreenetStore.closeDB((Database)this.accessTimeDB, true);
                this.accessTimeDB = null;
                BerkeleyDBFreenetStore.closeDB((Database)this.blockNumDB, true);
                this.blockNumDB = null;
                BerkeleyDBFreenetStore.closeDB(this.keysDB, true);
                this.keysDB = null;
                if (logMINOR) {
                    Logger.minor(this, "Closing database finished.");
                }
                System.err.println("Closed database");
                // MONITOREXIT : ie
            }
            catch (RuntimeException ex) {
                Logger.error(this, "Error while closing database.", ex);
                ex.printStackTrace();
                Object var6_8 = null;
                this.reallyClosed = true;
                return;
            }
            Object var6_7 = null;
            this.reallyClosed = true;
            return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.reallyClosed = true;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long highestBlockNumberInDatabase() throws DatabaseException {
        Cursor c;
        block7: {
            long l;
            c = null;
            try {
                c = this.blockNumDB.openCursor(null, null);
                DatabaseEntry keyDBE = new DatabaseEntry();
                DatabaseEntry dataDBE = new DatabaseEntry();
                if (c.getLast(keyDBE, dataDBE, null) != OperationStatus.SUCCESS) break block7;
                StoreBlock storeBlock = (StoreBlock)this.storeBlockTupleBinding.entryToObject(dataDBE);
                l = storeBlock.offset + 1L;
                Object var8_6 = null;
                if (c == null) return l;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (c == null) throw throwable;
                try {
                    c.close();
                    throw throwable;
                }
                catch (DatabaseException e) {
                    Logger.error(this, "Caught " + (Object)((Object)e), e);
                }
                throw throwable;
            }
            try {
                c.close();
                return l;
            }
            catch (DatabaseException e) {
                Logger.error(this, "Caught " + (Object)((Object)e), e);
            }
            return l;
        }
        c.close();
        return 0L;
    }

    private long countCHKBlocksFromFile() throws IOException {
        int keySize = this.headerBlockSize + this.dataBlockSize;
        long fileSize = this.storeRAF.length();
        return fileSize / (long)keySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getMaxRecentlyUsed() {
        long maxRecentlyUsed = 0L;
        Cursor c = null;
        try {
            try {
                c = this.accessTimeDB.openCursor(null, null);
                DatabaseEntry keyDBE = new DatabaseEntry();
                DatabaseEntry dataDBE = new DatabaseEntry();
                if (c.getLast(keyDBE, dataDBE, null) == OperationStatus.SUCCESS) {
                    StoreBlock storeBlock = (StoreBlock)this.storeBlockTupleBinding.entryToObject(dataDBE);
                    maxRecentlyUsed = storeBlock.getRecentlyUsed();
                }
                c.close();
                return maxRecentlyUsed;
            }
            catch (DatabaseException ex) {
                ex.printStackTrace();
                Object var8_8 = null;
                if (c == null) return maxRecentlyUsed;
                try {
                    c.close();
                    return maxRecentlyUsed;
                }
                catch (DatabaseException e) {
                    Logger.error(this, "Caught " + (Object)((Object)e), e);
                }
                return maxRecentlyUsed;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (c == null) throw throwable;
            try {
                c.close();
                throw throwable;
            }
            catch (DatabaseException e) {
                Logger.error(this, "Caught " + (Object)((Object)e), e);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getMinRecentlyUsed(Transaction t) {
        long minRecentlyUsed = 0L;
        Cursor c = null;
        try {
            try {
                c = this.accessTimeDB.openCursor(t, null);
                DatabaseEntry keyDBE = new DatabaseEntry();
                DatabaseEntry dataDBE = new DatabaseEntry();
                if (c.getFirst(keyDBE, dataDBE, null) == OperationStatus.SUCCESS) {
                    StoreBlock storeBlock = (StoreBlock)this.storeBlockTupleBinding.entryToObject(dataDBE);
                    minRecentlyUsed = storeBlock.getRecentlyUsed();
                }
                c.close();
                return minRecentlyUsed;
            }
            catch (DatabaseException ex) {
                ex.printStackTrace();
                Object var9_9 = null;
                if (c == null) return minRecentlyUsed;
                try {
                    c.close();
                    return minRecentlyUsed;
                }
                catch (DatabaseException e) {
                    Logger.error(this, "Caught " + (Object)((Object)e), e);
                }
                return minRecentlyUsed;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (c == null) throw throwable;
            try {
                c.close();
                throw throwable;
            }
            catch (DatabaseException e) {
                Logger.error(this, "Caught " + (Object)((Object)e), e);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNewRecentlyUsed() {
        Object object = this.lastRecentlyUsedSync;
        synchronized (object) {
            ++this.lastRecentlyUsed;
            return this.lastRecentlyUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxKeys(long maxStoreKeys, boolean forceBigShrink) throws DatabaseException, IOException {
        BerkeleyDBFreenetStore berkeleyDBFreenetStore = this;
        synchronized (berkeleyDBFreenetStore) {
            this.maxBlocksInStore = maxStoreKeys;
        }
        this.maybeOnlineShrink(false);
    }

    @Override
    public long getMaxKeys() {
        return this.maxBlocksInStore;
    }

    @Override
    public long hits() {
        return this.hits;
    }

    @Override
    public long misses() {
        return this.misses;
    }

    @Override
    public long writes() {
        return this.writes;
    }

    @Override
    public long keyCount() {
        return this.blocksInStore;
    }

    private void removeSecondaryDatabase() throws DatabaseException {
        Logger.error(this, "Recreating secondary databases");
        Logger.error(this, "This may take some time...");
        System.err.println("Recreating secondary databases");
        System.err.println("This may take some time...");
        WrapperManager.signalStarting((int)((int)Math.min(Integer.MAX_VALUE, 300000L + this.keysDB.count() * 100L)));
        try {
            try {
                this.environment.removeDatabase(null, this.name + "CHK_accessTime");
            }
            catch (DatabaseNotFoundException e) {
                // empty catch block
            }
            try {
                this.environment.removeDatabase(null, this.name + "CHK_blockNum");
            }
            catch (DatabaseNotFoundException e) {}
        }
        catch (DatabaseException e) {
            this.close(false);
            throw e;
        }
    }

    private SecondaryDatabase openSecondaryDataBase(String dbName, boolean create, boolean populate, boolean sortedDuplicates, SecondaryKeyCreator secondaryKeyCreator) throws DatabaseException {
        SecondaryDatabase db = null;
        SecondaryConfig secDbConfig = new SecondaryConfig();
        secDbConfig.setAllowCreate(create);
        secDbConfig.setSortedDuplicates(sortedDuplicates);
        secDbConfig.setTransactional(true);
        secDbConfig.setAllowPopulate(populate);
        secDbConfig.setKeyCreator(secondaryKeyCreator);
        try {
            try {
                System.err.println("Opening secondary database: " + dbName);
                db = this.environment.openSecondaryDatabase(null, dbName, this.keysDB, secDbConfig);
            }
            catch (DatabaseException e) {
                WrapperManager.signalStarting((int)((int)Math.min(Integer.MAX_VALUE, 300000L + this.keysDB.count() * 100L)));
                System.err.println("Reconstructing index for secondary database: " + dbName);
                Logger.error(this, "Reconstructing index for secondary database: " + dbName);
                if (db != null) {
                    db.close();
                }
                try {
                    this.environment.removeDatabase(null, dbName);
                }
                catch (DatabaseNotFoundException e1) {
                    // empty catch block
                }
                secDbConfig.setAllowCreate(true);
                secDbConfig.setAllowPopulate(true);
                db = this.environment.openSecondaryDatabase(null, dbName, this.keysDB, secDbConfig);
            }
        }
        catch (DatabaseException e1) {
            System.err.println("Error opening secondary database: " + dbName);
            e1.printStackTrace();
            Logger.error(this, "Error opening secondary database: " + dbName + " (" + e1.getMessage() + ")", e1);
            this.close(false);
            throw e1;
        }
        System.err.println("Opened secondary database: " + dbName);
        return db;
    }

    private void fcWriteLRU(long entry, long data) throws IOException {
        ByteBuffer bf = ByteBuffer.allocate(8);
        bf.putLong(data);
        bf.flip();
        do {
            int byteWritten;
            if ((byteWritten = this.lruFC.write(bf, entry * 8L + (long)bf.position())) != -1) continue;
            throw new EOFException();
        } while (bf.hasRemaining());
    }

    private long fcReadLRU(long entry) throws IOException {
        ByteBuffer bf = ByteBuffer.allocate(8);
        do {
            int byteRead;
            if ((byteRead = this.lruFC.read(bf, entry * 8L + (long)bf.position())) != -1) continue;
            throw new EOFException();
        } while (bf.hasRemaining());
        bf.flip();
        return bf.getLong();
    }

    private void fcReadKey(long entry, byte[] data) throws IOException {
        ByteBuffer bf = ByteBuffer.wrap(data);
        do {
            int byteRead;
            if ((byteRead = this.keysFC.read(bf, entry * (long)this.keyLength + (long)bf.position())) != -1) continue;
            throw new EOFException();
        } while (bf.hasRemaining());
    }

    private void fcWriteKey(long entry, byte[] data) throws IOException {
        assert (data.length == this.keyLength);
        ByteBuffer bf = ByteBuffer.wrap(data);
        do {
            int byteWritten;
            if ((byteWritten = this.keysFC.write(bf, entry * (long)this.keyLength + (long)bf.position())) != -1) continue;
            throw new EOFException();
        } while (bf.hasRemaining());
    }

    private void fcWriteStore(long entry, byte[] header, byte[] data) throws IOException {
        ByteBuffer bf = ByteBuffer.allocate(this.headerBlockSize + this.dataBlockSize);
        bf.put(header);
        bf.put(data);
        bf.flip();
        do {
            int byteWritten;
            if ((byteWritten = this.storeFC.write(bf, (long)(this.headerBlockSize + this.dataBlockSize) * entry + (long)bf.position())) != -1) continue;
            throw new EOFException();
        } while (bf.hasRemaining());
    }

    private void fcReadStore(long entry, byte[] header, byte[] data) throws IOException {
        ByteBuffer bf = ByteBuffer.allocate(this.headerBlockSize + this.dataBlockSize);
        do {
            int dataRead;
            if ((dataRead = this.storeFC.read(bf, (long)(this.headerBlockSize + this.dataBlockSize) * entry)) != -1) continue;
            throw new EOFException();
        } while (bf.hasRemaining());
        bf.flip();
        bf.get(header);
        bf.get(data);
    }

    @Override
    public void handleLowMemory() throws Exception {
        if (this.storeFC != null) {
            this.storeFC.force(true);
        }
        if (this.keysFC != null) {
            this.keysFC.force(true);
        }
        if (this.lruFC != null) {
            this.lruFC.force(true);
        }
        this.environment.evictMemory();
    }

    @Override
    public void handleOutOfMemory() throws Exception {
        this.reconstructFile.createNewFile();
        if (this.storeFC != null) {
            this.storeFC.force(true);
        }
        if (this.keysFC != null) {
            this.keysFC.force(true);
        }
        if (this.lruFC != null) {
            this.lruFC.force(true);
        }
    }

    public static EnvironmentConfig getBDBConfig() {
        System.setProperty("je.cleaner.expunge", "true");
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setTxnWriteNoSync(true);
        envConfig.setLockTimeout(600000000L);
        envConfig.setConfigParam("je.log.faultReadSize", "6144");
        envConfig.setConfigParam("je.evictor.lruOnly", "false");
        envConfig.setConfigParam("je.evictor.nodesPerScan", "50");
        envConfig.setConfigParam("je.env.backgroundReadLimit", "65536");
        envConfig.setConfigParam("je.env.backgroundWriteLimit", "65536");
        envConfig.setConfigParam("je.env.backgroundSleepInterval", "10000");
        return envConfig;
    }

    @Override
    public long getBloomFalsePositive() {
        return -1L;
    }

    @Override
    public boolean probablyInStore(byte[] routingKey) {
        return true;
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            System.err.println("Closing database due to shutdown.");
            BerkeleyDBFreenetStore.this.close(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockNumberKeyCreator
    implements SecondaryKeyCreator {
        private final TupleBinding<StoreBlock> theBinding;

        public BlockNumberKeyCreator(TupleBinding<StoreBlock> theBinding1) {
            this.theBinding = theBinding1;
        }

        public boolean createSecondaryKey(SecondaryDatabase secDb, DatabaseEntry keyEntry, DatabaseEntry dataEntry, DatabaseEntry resultEntry) {
            StoreBlock storeblock = (StoreBlock)this.theBinding.entryToObject(dataEntry);
            LongBinding.longToEntry((long)storeblock.offset, (DatabaseEntry)resultEntry);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessTimeKeyCreator
    implements SecondaryKeyCreator {
        private final TupleBinding<StoreBlock> theBinding;

        public AccessTimeKeyCreator(TupleBinding<StoreBlock> theBinding1) {
            this.theBinding = theBinding1;
        }

        public boolean createSecondaryKey(SecondaryDatabase secDb, DatabaseEntry keyEntry, DatabaseEntry dataEntry, DatabaseEntry resultEntry) {
            StoreBlock storeblock = (StoreBlock)this.theBinding.entryToObject(dataEntry);
            LongBinding.longToEntry((long)storeblock.getRecentlyUsed(), (DatabaseEntry)resultEntry);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StoreBlockTupleBinding
    extends TupleBinding<StoreBlock> {
        private StoreBlockTupleBinding() {
        }

        public void objectToEntry(StoreBlock myData, TupleOutput to) {
            to.writeLong(myData.getOffset());
            to.writeLong(myData.getRecentlyUsed());
        }

        public StoreBlock entryToObject(TupleInput ti) {
            long offset = ti.readLong();
            long lastAccessed = ti.readLong();
            StoreBlock storeBlock = new StoreBlock(offset, lastAccessed);
            return storeBlock;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StoreBlock {
        private long recentlyUsed;
        private long offset;

        public StoreBlock(BerkeleyDBFreenetStore<?> bdbfs, long offset) {
            this(offset, ((BerkeleyDBFreenetStore)bdbfs).getNewRecentlyUsed());
        }

        public StoreBlock(long offset, long recentlyUsed) {
            this.offset = offset;
            this.recentlyUsed = recentlyUsed;
        }

        public long getRecentlyUsed() {
            return this.recentlyUsed;
        }

        public void setRecentlyUsedToZero() {
            this.recentlyUsed = 0L;
        }

        public void updateRecentlyUsed(BerkeleyDBFreenetStore<?> bdbfs) {
            this.recentlyUsed = ((BerkeleyDBFreenetStore)bdbfs).getNewRecentlyUsed();
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

