/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.filter.FilterCallback;
import freenet.node.Node;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginTalker;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.pluginmanager.PluginTalker;
import freenet.support.HTMLNode;
import freenet.support.URIPreEncoder;
import java.net.URISyntaxException;

public class PluginRespirator {
    private final HighLevelSimpleClient hlsc;
    private final Node node;
    private final PageMaker pageMaker;
    private final FredPlugin plugin;
    private final PluginManager pluginManager;

    public PluginRespirator(Node node, PluginManager pm, FredPlugin plug) {
        this.node = node;
        this.hlsc = node.clientCore.makeClient((short)1);
        this.plugin = plug;
        this.pluginManager = pm;
        this.pageMaker = null;
    }

    public HighLevelSimpleClient getHLSimpleClient() {
        return this.hlsc;
    }

    public Node getNode() {
        return this.node;
    }

    public FilterCallback makeFilterCallback(String path) {
        try {
            return this.node.clientCore.createFilterCallback(URIPreEncoder.encodeURI(path), null);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    public PageMaker getPageMaker() {
        ToadletContainer container = this.getToadletContainer();
        if (container == null) {
            return null;
        }
        return container.getPageMaker();
    }

    public HTMLNode addFormChild(HTMLNode parentNode, String target, String name) {
        HTMLNode formNode = parentNode.addChild("form", new String[]{"action", "method", "enctype", "id", "name", "accept-charset"}, new String[]{target, "post", "multipart/form-data", name, name, "utf-8"});
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.node.clientCore.formPassword});
        return formNode;
    }

    public PluginTalker getPluginTalker(FredPluginTalker fpt, String pluginname, String identifier) throws PluginNotFoundException {
        return new PluginTalker(fpt, this.node, pluginname, identifier);
    }

    public ToadletContainer getToadletContainer() {
        return this.node.clientCore.getToadletContainer();
    }
}

