/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.Ticker;
import freenet.node.useralerts.UserAlert;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.pluginmanager.FredPluginFCP;
import freenet.pluginmanager.FredPluginHTTP;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginL10n;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.pluginmanager.FredPluginRealVersioned;
import freenet.pluginmanager.FredPluginThemed;
import freenet.pluginmanager.FredPluginThreadless;
import freenet.pluginmanager.FredPluginWithClassLoader;
import freenet.pluginmanager.NotFoundPluginHTTPException;
import freenet.pluginmanager.PluginDownLoader;
import freenet.pluginmanager.PluginDownLoaderFile;
import freenet.pluginmanager.PluginDownLoaderFreenet;
import freenet.pluginmanager.PluginDownLoaderOfficial;
import freenet.pluginmanager.PluginDownLoaderURL;
import freenet.pluginmanager.PluginHTTPException;
import freenet.pluginmanager.PluginHandler;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.JarClassLoader;
import freenet.support.Logger;
import freenet.support.SerialExecutor;
import freenet.support.api.HTTPRequest;
import freenet.support.api.StringArrCallback;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.tanukisoftware.wrapper.WrapperManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    private final HashMap<String, FredPlugin> toadletList;
    private final Set<PluginProgress> startingPlugins = new HashSet<PluginProgress>();
    private final Vector<PluginInfoWrapper> pluginWrappers;
    private final Vector<String> pluginsFailedLoad;
    final Node node;
    private final NodeClientCore core;
    SubConfig pmconfig;
    private boolean logMINOR;
    private boolean logDEBUG;
    private final HighLevelSimpleClient client;
    private static PluginManager selfinstance = null;
    private PageMaker.THEME fproxyTheme;
    private final SerialExecutor executor;
    private boolean started;
    private String[] toStart;
    static Map<String, OfficialPluginDescription> officialPlugins = new HashMap<String, OfficialPluginDescription>();
    private final Object pluginLoadSyncObject = new Object();

    public PluginManager(Node node) {
        this.logMINOR = Logger.shouldLog(4, this);
        this.logDEBUG = Logger.shouldLog(2, this);
        this.toadletList = new HashMap();
        this.pluginWrappers = new Vector();
        this.pluginsFailedLoad = new Vector();
        this.node = node;
        this.core = node.clientCore;
        if (this.logMINOR) {
            Logger.minor(this, "Starting Plugin Manager");
        }
        if (this.logDEBUG) {
            Logger.debug(this, "Initialize Plugin Manager config");
        }
        this.client = this.core.makeClient((short)1, true);
        this.executor = new SerialExecutor(5);
        this.executor.start(node.executor, "PM callback executor");
        this.pmconfig = new SubConfig("pluginmanager", node.config);
        this.pmconfig.register("loadplugin", null, 0, true, false, "PluginManager.loadedOnStartup", "PluginManager.loadedOnStartupLong", new StringArrCallback(){

            public String[] get() {
                return PluginManager.this.getConfigLoadString();
            }

            public void set(String[] val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException(L10n.getString("PluginManager.cannotSetOnceLoaded"));
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        this.toStart = this.pmconfig.getStringArr("loadplugin");
        this.pmconfig.finishedInitialization();
        this.fproxyTheme = PageMaker.THEME.themeFromName(node.config.get("fproxy").getString("css"));
        selfinstance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Config config) {
        if (this.toStart != null) {
            for (String name : this.toStart) {
                this.startPluginAuto(name, false);
            }
        }
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            this.started = true;
            this.toStart = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getConfigLoadString() {
        Vector<String> v = new Vector<String>();
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            if (!this.started) {
                return this.toStart;
            }
            for (PluginInfoWrapper pi : this.pluginWrappers) {
                v.add(pi.getFilename());
            }
            for (String s : this.pluginsFailedLoad) {
                v.add(s);
            }
        }
        return v.toArray(new String[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PluginProgress> getStartingPlugins() {
        Set<PluginProgress> set = this.startingPlugins;
        synchronized (set) {
            return new HashSet<PluginProgress>(this.startingPlugins);
        }
    }

    public void startPluginAuto(String pluginname, boolean store) {
        if (this.isOfficialPlugin(pluginname)) {
            this.startPluginOfficial(pluginname, store);
            return;
        }
        try {
            new FreenetURI(pluginname);
            this.startPluginFreenet(pluginname, store);
            return;
        }
        catch (MalformedURLException e) {
            File[] roots;
            for (File f : roots = File.listRoots()) {
                if (!pluginname.startsWith(f.getName()) || !new File(pluginname).exists()) continue;
                this.startPluginFile(pluginname, store);
                return;
            }
            this.startPluginURL(pluginname, store);
            return;
        }
    }

    public void startPluginOfficial(String pluginname, boolean store) {
        this.realStartPlugin(new PluginDownLoaderOfficial(), pluginname, store);
    }

    public void startPluginFile(String filename, boolean store) {
        this.realStartPlugin(new PluginDownLoaderFile(), filename, store);
    }

    public void startPluginURL(String filename, boolean store) {
        this.realStartPlugin(new PluginDownLoaderURL(), filename, store);
    }

    public void startPluginFreenet(String filename, boolean store) {
        this.realStartPlugin(new PluginDownLoaderFreenet(this.client), filename, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void realStartPlugin(PluginDownLoader<?> pdl, String filename, boolean store) {
        block25: {
            PluginProgress pluginProgress;
            block24: {
                Set<PluginProgress> set;
                block23: {
                    if (filename.trim().length() == 0) {
                        return;
                    }
                    pluginProgress = new PluginProgress(filename);
                    Set<PluginProgress> set2 = this.startingPlugins;
                    synchronized (set2) {
                        this.startingPlugins.add(pluginProgress);
                    }
                    Logger.normal(this, "Loading plugin: " + filename);
                    try {
                        try {
                            FredPlugin plug = this.loadPlugin(pdl, filename);
                            if (plug == null) {
                                Object var12_6 = null;
                                set = this.startingPlugins;
                                break block23;
                            }
                            pluginProgress.setProgress(PluginProgress.STARTING);
                            PluginInfoWrapper pi = PluginHandler.startPlugin(this, filename, plug, new PluginRespirator(this.node, this, plug));
                            Vector<PluginInfoWrapper> vector = this.pluginWrappers;
                            synchronized (vector) {
                                this.pluginWrappers.add(pi);
                                this.pluginsFailedLoad.remove(filename);
                            }
                            Logger.normal(this, "Plugin loaded: " + filename);
                            break block24;
                        }
                        catch (PluginNotFoundException e) {
                            Logger.normal(this, "Loading plugin failed (" + filename + ')', e);
                            String message = e.getMessage();
                            Vector<PluginInfoWrapper> vector = this.pluginWrappers;
                            synchronized (vector) {
                                this.pluginsFailedLoad.add(filename);
                            }
                            this.core.alerts.register(new PluginLoadFailedUserAlert(filename, pdl instanceof PluginDownLoaderOfficial, message));
                            Object var12_8 = null;
                            Set<PluginProgress> set3 = this.startingPlugins;
                            synchronized (set3) {
                                this.startingPlugins.remove(pluginProgress);
                                break block25;
                            }
                        }
                        catch (UnsupportedClassVersionError e) {
                            Logger.error(this, "Could not load plugin " + filename + " : " + e, e);
                            System.err.println("Could not load plugin " + filename + " : " + e);
                            e.printStackTrace();
                            System.err.println("Plugin " + filename + " appears to require a later JVM");
                            Logger.error(this, "Plugin " + filename + " appears to require a later JVM");
                            Vector<PluginInfoWrapper> vector = this.pluginWrappers;
                            synchronized (vector) {
                                this.pluginsFailedLoad.add(filename);
                            }
                            this.core.alerts.register(new PluginLoadFailedUserAlert(filename, pdl instanceof PluginDownLoaderOfficial, this.l10n("pluginReqNewerJVMTitle", "name", filename)));
                            Object var12_9 = null;
                            Set<PluginProgress> set4 = this.startingPlugins;
                            synchronized (set4) {
                                this.startingPlugins.remove(pluginProgress);
                                break block25;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_10 = null;
                        Set<PluginProgress> set5 = this.startingPlugins;
                        synchronized (set5) {
                            this.startingPlugins.remove(pluginProgress);
                            throw throwable;
                        }
                    }
                }
                synchronized (set) {
                    this.startingPlugins.remove(pluginProgress);
                    return;
                }
            }
            Object var12_7 = null;
            Set<PluginProgress> set = this.startingPlugins;
            synchronized (set) {
                this.startingPlugins.remove(pluginProgress);
            }
        }
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            if (!store) return;
            this.core.storeConfig();
            return;
        }
    }

    void register(FredPlugin plug, PluginInfoWrapper pi) {
        if (pi.isPproxyPlugin()) {
            this.registerToadlet(plug);
        }
        if (pi.isIPDetectorPlugin()) {
            this.node.ipDetector.registerIPDetectorPlugin((FredPluginIPDetector)((Object)plug));
        }
        if (pi.isPortForwardPlugin()) {
            this.node.ipDetector.registerPortForwardPlugin((FredPluginPortForward)((Object)plug));
        }
        if (pi.isBandwidthIndicator()) {
            this.node.ipDetector.registerBandwidthIndicatorPlugin((FredPluginBandwidthIndicator)((Object)plug));
        }
    }

    private String l10n(String key) {
        return L10n.getString("PluginManager." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("PluginManager." + key, pattern, value);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("PluginManager." + key, patterns, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerToadlet(FredPlugin pl) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            this.toadletList.put(pl.getClass().getName(), pl);
        }
        Logger.normal(this, "Added HTTP handler for /plugins/" + pl.getClass().getName() + '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlugin(PluginInfoWrapper pi) {
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            if (!this.pluginWrappers.remove(pi)) {
                return;
            }
        }
        this.core.storeConfig();
    }

    public void removeCachedCopy(String pluginSpecification) {
        int lastSlash = pluginSpecification.lastIndexOf(47);
        if (lastSlash == -1) {
            lastSlash = pluginSpecification.lastIndexOf(92);
        }
        File pluginDirectory = new File(this.node.getNodeDir(), "plugins");
        File pluginFile = lastSlash == -1 ? new File(pluginDirectory, pluginSpecification + ".jar") : new File(pluginDirectory, pluginSpecification.substring(lastSlash + 1));
        if (this.logDEBUG) {
            Logger.minor(this, "Delete plugin - plugname: " + pluginSpecification + "filename: " + pluginFile.getAbsolutePath(), (Throwable)new Exception("debug"));
        }
        if (pluginFile.exists()) {
            pluginFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPluginToadlet(PluginInfoWrapper pi) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            try {
                this.toadletList.remove(pi.getPluginClassName());
                Logger.normal(this, "Removed HTTP handler for /plugins/" + pi.getPluginClassName() + '/', new Exception("debug"));
            }
            catch (Throwable ex) {
                Logger.error(this, "removing Plugin", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToadletSymlinks(PluginInfoWrapper pi) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            try {
                String[] targets = pi.getPluginToadletSymlinks();
                if (targets == null) {
                    return;
                }
                for (int i = 0; i < targets.length; ++i) {
                    this.toadletList.remove(targets[i]);
                    Logger.normal(this, "Removed HTTP symlink: " + targets[i] + " => /plugins/" + pi.getPluginClassName() + '/');
                }
            }
            catch (Throwable ex) {
                Logger.error(this, "removing Toadlet-link", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToadletSymlinks(PluginInfoWrapper pi) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            String rm = null;
            try {
                String[] targets = pi.getPluginToadletSymlinks();
                if (targets == null) {
                    return;
                }
                for (int i = 0; i < targets.length; ++i) {
                    rm = targets[i];
                    this.toadletList.remove(targets[i]);
                    pi.removePluginToadletSymlink(targets[i]);
                    Logger.normal(this, "Removed HTTP symlink: " + targets[i] + " => /plugins/" + pi.getPluginClassName() + '/');
                }
            }
            catch (Throwable ex) {
                Logger.error(this, "removing Toadlet-link: " + rm, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpPlugins() {
        StringBuilder out = new StringBuilder();
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                out.append(pi.toString());
                out.append('\n');
            }
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PluginInfoWrapper> getPlugins() {
        HashSet<PluginInfoWrapper> out = new HashSet<PluginInfoWrapper>();
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                out.add(pi);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginInfoWrapper getFCPPluginInfo(String plugname) {
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                if (!pi.getPluginClassName().equals(plugname)) continue;
                return pi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FredPluginFCP getFCPPlugin(String plugname) {
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                if (!pi.isFCPPlugin() || !pi.getPluginClassName().equals(plugname)) continue;
                return (FredPluginFCP)((Object)pi.plug);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPluginLoaded(String plugname) {
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                if (!pi.getPluginClassName().equals(plugname)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleHTTPGet(String plugin, HTTPRequest request) throws PluginHTTPException {
        ClassLoader oldClassLoader;
        block6: {
            FredPlugin handler = null;
            HashMap<String, FredPlugin> hashMap = this.toadletList;
            synchronized (hashMap) {
                handler = this.toadletList.get(plugin);
            }
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader pluginClassLoader = handler.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            try {
                if (!(handler instanceof FredPluginHTTP)) break block6;
                String string = ((FredPluginHTTP)((Object)handler)).handleHTTPGet(request);
                Object var8_8 = null;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                return string;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                throw throwable;
            }
        }
        Object var8_9 = null;
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        throw new NotFoundPluginHTTPException("Plugin not found!", "/plugins");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleHTTPPost(String plugin, HTTPRequest request) throws PluginHTTPException {
        ClassLoader oldClassLoader;
        block7: {
            FredPlugin handler = null;
            HashMap<String, FredPlugin> hashMap = this.toadletList;
            synchronized (hashMap) {
                handler = this.toadletList.get(plugin);
            }
            if (handler == null) {
                throw new NotFoundPluginHTTPException("Plugin '" + plugin + "' not found!", "/plugins");
            }
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader pluginClassLoader = handler.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            try {
                if (!(handler instanceof FredPluginHTTP)) break block7;
                String string = ((FredPluginHTTP)((Object)handler)).handleHTTPPost(request);
                Object var8_8 = null;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                return string;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                throw throwable;
            }
        }
        Object var8_9 = null;
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        throw new NotFoundPluginHTTPException("Plugin '" + plugin + "' not found!", "/plugins");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPlugin(String name, int maxWaitTime) {
        PluginInfoWrapper pi = null;
        boolean found = false;
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (int i = 0; i < this.pluginWrappers.size() && !found; ++i) {
                pi = this.pluginWrappers.get(i);
                if (!pi.getThreadName().equals(name)) continue;
                found = true;
                break;
            }
        }
        if (found) {
            pi.stopPlugin(this, maxWaitTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPluginByClass(String name, int maxWaitTime) {
        PluginInfoWrapper pi = null;
        boolean found = false;
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (int i = 0; i < this.pluginWrappers.size() && !found; ++i) {
                pi = this.pluginWrappers.get(i);
                if (!pi.getPluginClassName().equals(name)) continue;
                found = true;
                break;
            }
        }
        if (found) {
            pi.stopPlugin(this, maxWaitTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPlugin(FredPlugin plugin, int maxWaitTime) {
        PluginInfoWrapper pi = null;
        boolean found = false;
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (int i = 0; i < this.pluginWrappers.size() && !found; ++i) {
                pi = this.pluginWrappers.get(i);
                if (pi.plug != plugin) continue;
                found = true;
            }
        }
        if (found) {
            pi.stopPlugin(this, maxWaitTime);
        }
    }

    static void addOfficialPlugin(String name) {
        officialPlugins.put(name, new OfficialPluginDescription(name, false, -1L));
    }

    static void addOfficialPlugin(String name, boolean essential, long minVer) {
        officialPlugins.put(name, new OfficialPluginDescription(name, essential, minVer));
    }

    public List<String> findAvailablePlugins() {
        ArrayList<String> availablePlugins = new ArrayList<String>();
        availablePlugins.addAll(officialPlugins.keySet());
        return availablePlugins;
    }

    public boolean isOfficialPlugin(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        List<String> availablePlugins = this.findAvailablePlugins();
        for (String n : availablePlugins) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FredPlugin loadPlugin(PluginDownLoader<?> pdl, String name) throws PluginNotFoundException {
        pdl.setSource(name);
        File pluginDirectory = new File(this.node.getNodeDir(), "plugins");
        if (pluginDirectory.exists() && !pluginDirectory.isDirectory() || !pluginDirectory.exists() && !pluginDirectory.mkdirs()) {
            Logger.error(this, "could not create plugin directory");
            throw new PluginNotFoundException("could not create plugin directory");
        }
        String filename = pdl.getPluginName(name);
        File pluginFile = new File(pluginDirectory, filename);
        if (pdl instanceof PluginDownLoaderFile) {
            pluginFile.delete();
        }
        if (this.logMINOR) {
            Logger.minor(this, "plugin file " + pluginFile.getAbsolutePath() + " exists: " + pluginFile.exists() + " downloader " + pdl + " name " + name);
        }
        int RETRIES = 5;
        for (int i = 0; i < RETRIES; ++i) {
            if (pluginFile.exists() && pluginFile.length() != 0L) continue;
            try {
                Object var16_30;
                System.err.println("Downloading plugin " + name);
                WrapperManager.signalStarting((int)300000);
                File tempPluginFile = null;
                FileOutputStream pluginOutputStream = null;
                InputStream pluginInputStream = null;
                try {
                    try {
                        int read;
                        tempPluginFile = File.createTempFile("plugin-", ".jar", pluginDirectory);
                        tempPluginFile.deleteOnExit();
                        pluginOutputStream = new FileOutputStream(tempPluginFile);
                        pluginInputStream = pdl.getInputStream();
                        byte[] buffer = new byte[1024];
                        while ((read = pluginInputStream.read(buffer)) != -1) {
                            ((OutputStream)pluginOutputStream).write(buffer, 0, read);
                        }
                        ((OutputStream)pluginOutputStream).close();
                        if (tempPluginFile.length() == 0L) {
                            throw new PluginNotFoundException("downloaded zero length file");
                        }
                        if (!FileUtil.renameTo(tempPluginFile, pluginFile)) {
                            Logger.error(this, "could not rename temp file to plugin file");
                            throw new PluginNotFoundException("could not rename temp file to plugin file");
                        }
                        String testsum = null;
                        String digest = pdl.getSHA256sum();
                        if (digest == null) {
                            digest = pdl.getSHA1sum();
                        } else {
                            testsum = this.getFileDigest(pluginFile, "SHA-256");
                        }
                        if (digest != null && testsum == null) {
                            testsum = this.getFileDigest(pluginFile, "SHA-1");
                        }
                        if (digest != null && !digest.equalsIgnoreCase(testsum)) {
                            Logger.error(this, "Checksum verification failed, should be " + digest + " but was " + testsum);
                            throw new PluginNotFoundException("Checksum verification failed, should be " + digest + " but was " + testsum);
                        }
                        var16_30 = null;
                    }
                    catch (IOException ioe1) {
                        Logger.error(this, "could not load plugin", ioe1);
                        if (tempPluginFile == null) throw new PluginNotFoundException("could not load plugin: " + ioe1.getMessage(), ioe1);
                        tempPluginFile.delete();
                        throw new PluginNotFoundException("could not load plugin: " + ioe1.getMessage(), ioe1);
                    }
                }
                catch (Throwable throwable) {
                    var16_30 = null;
                    Closer.close(pluginOutputStream);
                    Closer.close(pluginInputStream);
                    throw throwable;
                }
                Closer.close(pluginOutputStream);
                Closer.close(pluginInputStream);
                continue;
            }
            catch (PluginNotFoundException e) {
                if (i >= RETRIES - 1) throw e;
                Logger.normal(this, "Failed to load plugin: " + e, e);
            }
        }
        Object object = this.pluginLoadSyncObject;
        synchronized (object) {
            String pluginMainClassName;
            JarFile pluginJarFile;
            block47: {
                FredPlugin read;
                pluginJarFile = null;
                pluginMainClassName = null;
                try {
                    try {
                        pluginJarFile = new JarFile(pluginFile);
                        Manifest manifest = pluginJarFile.getManifest();
                        if (manifest == null) {
                            Logger.error(this, "could not load manifest from plugin file");
                            pluginFile.delete();
                            throw new PluginNotFoundException("could not load manifest from plugin file");
                        }
                        Attributes mainAttributes = manifest.getMainAttributes();
                        if (mainAttributes == null) {
                            Logger.error(this, "manifest does not contain attributes");
                            pluginFile.delete();
                            throw new PluginNotFoundException("manifest does not contain attributes");
                        }
                        pluginMainClassName = mainAttributes.getValue("Plugin-Main-Class");
                        if (pluginMainClassName == null) {
                            Logger.error(this, "manifest does not contain a Plugin-Main-Class attribute");
                            pluginFile.delete();
                            throw new PluginNotFoundException("manifest does not contain a Plugin-Main-Class attribute");
                        }
                        if (!this.isPluginLoaded(pluginMainClassName)) break block47;
                        Logger.error(this, "Plugin already loaded: " + filename);
                        read = null;
                        Object var18_33 = null;
                    }
                    catch (JarException je1) {
                        Logger.error(this, "could not process jar file", je1);
                        pluginFile.delete();
                        throw new PluginNotFoundException("could not process jar file", je1);
                    }
                    catch (ZipException ze1) {
                        Logger.error(this, "could not process jar file", ze1);
                        pluginFile.delete();
                        throw new PluginNotFoundException("could not process jar file", ze1);
                    }
                    catch (IOException ioe1) {
                        Logger.error(this, "error processing jar file", ioe1);
                        pluginFile.delete();
                        throw new PluginNotFoundException("error procesesing jar file", ioe1);
                    }
                }
                catch (Throwable throwable) {
                    Object var18_35 = null;
                    Closer.close(pluginJarFile);
                    throw throwable;
                }
                Closer.close(pluginJarFile);
                return read;
            }
            Object var18_34 = null;
            Closer.close(pluginJarFile);
            try {
                JarClassLoader jarClassLoader = new JarClassLoader(pluginFile);
                Class<?> pluginMainClass = jarClassLoader.loadClass(pluginMainClassName);
                Object object2 = pluginMainClass.newInstance();
                if (!(object2 instanceof FredPlugin)) {
                    Logger.error(this, "plugin main class is not a plugin");
                    pluginFile.delete();
                    throw new PluginNotFoundException("plugin main class is not a plugin");
                }
                if (object2 instanceof FredPluginWithClassLoader) {
                    ((FredPluginWithClassLoader)object2).setClassLoader(jarClassLoader);
                }
                if (!(pdl instanceof PluginDownLoaderOfficial)) return (FredPlugin)object2;
                System.err.println("Loading official plugin " + name);
                OfficialPluginDescription desc = officialPlugins.get(name);
                long minVer = desc.minimumVersion;
                long ver = -1L;
                if (minVer != -1L && object2 instanceof FredPluginRealVersioned) {
                    ver = ((FredPluginRealVersioned)object2).getRealVersion();
                }
                if (ver >= minVer) return (FredPlugin)object2;
                System.err.println("Failed to load plugin " + name + " : TOO OLD: need at least version " + minVer + " but is " + ver);
                Logger.error(this, "Failed to load plugin " + name + " : TOO OLD: need at least version " + minVer + " but is " + ver);
                try {
                    if (object2 instanceof FredPluginThreadless) {
                        ((FredPlugin)object2).runPlugin(new PluginRespirator(this.node, this, (FredPlugin)object2));
                    }
                }
                catch (Throwable t) {
                    Logger.error(this, "Failed to start plugin (to prevent NPEs) while terminating it because it is too old: " + t, t);
                }
                try {
                    ((FredPlugin)object2).terminate();
                }
                catch (Throwable t) {
                    Logger.error(this, "Plugin failed to terminate: " + t, t);
                }
                try {
                    jarClassLoader.close();
                    throw new PluginNotFoundException("plugin too old: need at least version " + minVer);
                }
                catch (Throwable t) {
                    Logger.error(this, "Failed to close jar classloader for plugin: " + t, t);
                }
                throw new PluginNotFoundException("plugin too old: need at least version " + minVer);
            }
            catch (IOException ioe1) {
                Logger.error(this, "could not load plugin", ioe1);
                pluginFile.delete();
                throw new PluginNotFoundException("could not load plugin", ioe1);
            }
            catch (ClassNotFoundException cnfe1) {
                Logger.error(this, "could not find plugin class", cnfe1);
                pluginFile.delete();
                throw new PluginNotFoundException("could not find plugin class", cnfe1);
            }
            catch (InstantiationException ie1) {
                Logger.error(this, "could not instantiate plugin", ie1);
                pluginFile.delete();
                throw new PluginNotFoundException("could not instantiate plugin", ie1);
            }
            catch (IllegalAccessException iae1) {
                Logger.error(this, "could not access plugin main class", iae1);
                pluginFile.delete();
                throw new PluginNotFoundException("could not access plugin main class", iae1);
            }
            catch (NoClassDefFoundError ncdfe1) {
                Logger.error(this, "could not find class def, may a missing lib?", ncdfe1);
                pluginFile.delete();
                throw new PluginNotFoundException("could not find class def, may a missing lib?", ncdfe1);
            }
            catch (Throwable t) {
                Logger.error(this, "unexpected error while plugin loading", t);
                pluginFile.delete();
                throw new PluginNotFoundException("unexpected error while plugin loading " + t, t);
            }
        }
    }

    private String getFileDigest(File file, String digest) throws PluginNotFoundException {
        String result;
        int BUFFERSIZE = 4096;
        MessageDigest hash = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        boolean wasFromDigest256Pool = false;
        try {
            block7: {
                try {
                    if ("SHA-256".equals(digest)) {
                        hash = SHA256.getMessageDigest();
                        wasFromDigest256Pool = true;
                    } else {
                        hash = MessageDigest.getInstance(digest);
                    }
                    fis = new FileInputStream(file);
                    bis = new BufferedInputStream(fis);
                    int len = 0;
                    byte[] buffer = new byte[4096];
                    while ((len = bis.read(buffer)) > -1) {
                        hash.update(buffer, 0, len);
                    }
                    result = HexUtil.bytesToHex(hash.digest());
                    if (!wasFromDigest256Pool) break block7;
                    SHA256.returnMessageDigest(hash);
                }
                catch (Exception e) {
                    throw new PluginNotFoundException("Error while computing hash '" + digest + "' of the downloaded plugin: " + e, e);
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            Closer.close(bis);
            Closer.close(fis);
            throw throwable;
        }
        Closer.close(bis);
        Closer.close(fis);
        return result;
    }

    Ticker getTicker() {
        return this.node.getTicker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFProxyTheme(final PageMaker.THEME cssName) {
        this.fproxyTheme = cssName;
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (PluginInfoWrapper pi : this.pluginWrappers) {
                pi.pr.getPageMaker().setTheme(cssName);
                if (!pi.isThemedPlugin()) continue;
                final FredPluginThemed plug = (FredPluginThemed)((Object)pi.plug);
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            plug.setTheme(cssName);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Cought Trowable in Callback", t);
                        }
                    }
                }, "Callback");
            }
        }
    }

    public static void setLanguage(L10n.LANGUAGE lang) {
        if (selfinstance == null) {
            return;
        }
        selfinstance.setPluginLanguage(lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPluginLanguage(final L10n.LANGUAGE lang) {
        Vector<PluginInfoWrapper> vector = this.pluginWrappers;
        synchronized (vector) {
            for (PluginInfoWrapper pi : this.pluginWrappers) {
                if (!pi.isL10nPlugin()) continue;
                final FredPluginL10n plug = (FredPluginL10n)((Object)pi.plug);
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            plug.setLanguage(lang);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Cought Trowable in Callback", t);
                        }
                    }
                }, "Callback");
            }
        }
    }

    public PageMaker.THEME getFProxyTheme() {
        return this.fproxyTheme;
    }

    static {
        PluginManager.addOfficialPlugin("Echo");
        PluginManager.addOfficialPlugin("Freemail", false, 12L);
        PluginManager.addOfficialPlugin("HelloWorld");
        PluginManager.addOfficialPlugin("HelloFCP");
        PluginManager.addOfficialPlugin("JSTUN", true, 2L);
        PluginManager.addOfficialPlugin("KeyExplorer", false, 4004L);
        PluginManager.addOfficialPlugin("MDNSDiscovery", false, 2L);
        PluginManager.addOfficialPlugin("SNMP");
        PluginManager.addOfficialPlugin("TestGallery");
        PluginManager.addOfficialPlugin("ThawIndexBrowser", false, 2L);
        PluginManager.addOfficialPlugin("UPnP", true, 10003L);
        PluginManager.addOfficialPlugin("XMLLibrarian", false, 22L);
        PluginManager.addOfficialPlugin("XMLSpider", false, 37L);
    }

    public static class PluginProgress {
        public static final PluginProgress DOWNLOADING = new PluginProgress();
        public static final PluginProgress STARTING = new PluginProgress();
        private long startingTime = System.currentTimeMillis();
        private PluginProgress pluginProgress;
        private String name;

        private PluginProgress() {
        }

        PluginProgress(String name) {
            this.name = name;
            this.pluginProgress = DOWNLOADING;
        }

        public long getTime() {
            return System.currentTimeMillis() - this.startingTime;
        }

        public String getName() {
            return this.name;
        }

        public PluginProgress getProgress() {
            return this.pluginProgress;
        }

        void setProgress(PluginProgress pluginProgress) {
            this.pluginProgress = pluginProgress;
        }

        public String toString() {
            if (this == DOWNLOADING) {
                return "downloading";
            }
            if (this == STARTING) {
                return "starting";
            }
            return "PluginProgress[name=" + this.name + ",startingTime=" + this.startingTime + ",progress=" + this.pluginProgress + "]";
        }
    }

    private static class OfficialPluginDescription {
        final String name;
        final boolean essential;
        final long minimumVersion;

        OfficialPluginDescription(String name, boolean essential, long minVer) {
            this.name = name;
            this.essential = essential;
            this.minimumVersion = minVer;
        }
    }

    class PluginLoadFailedUserAlert
    implements UserAlert {
        final String filename;
        final String message;
        final boolean official;

        public PluginLoadFailedUserAlert(String filename, boolean official, String message) {
            this.filename = filename;
            this.official = official;
            this.message = message;
        }

        public String dismissButtonText() {
            return PluginManager.this.l10n("deleteFailedPluginButton");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDismiss() {
            Vector vector = PluginManager.this.pluginWrappers;
            synchronized (vector) {
                PluginManager.this.pluginsFailedLoad.remove(this.filename);
            }
        }

        public String anchor() {
            return "pluginfailed:" + this.filename;
        }

        public HTMLNode getHTMLText() {
            HTMLNode p = new HTMLNode("p");
            p.addChild("#", PluginManager.this.l10n("pluginLoadingFailedWithMessage", new String[]{"name", "message"}, new String[]{this.filename, this.message}));
            if (this.official) {
                HTMLNode reloadForm = p.addChild("form", new String[]{"action", "method"}, new String[]{"/plugins/", "post"});
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", PluginManager.this.node.clientCore.formPassword});
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "plugin-name", this.filename});
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-official", PluginManager.this.l10n("officialPluginLoadFailedTryAgain")});
            }
            return p;
        }

        public short getPriorityClass() {
            return 1;
        }

        public String getShortText() {
            return PluginManager.this.l10n("pluginLoadingFailedShort", "name", this.filename);
        }

        public String getText() {
            return PluginManager.this.l10n("pluginLoadingFailedWithMessage", new String[]{"name", "message"}, new String[]{this.filename, this.message});
        }

        public String getTitle() {
            return PluginManager.this.l10n("pluginLoadingFailedTitle");
        }

        public Object getUserIdentifier() {
            return PluginManager.class;
        }

        public boolean isEventNotification() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isValid() {
            boolean success;
            Vector vector = PluginManager.this.pluginWrappers;
            synchronized (vector) {
                success = PluginManager.this.pluginsFailedLoad.contains(this.filename);
            }
            if (!success) {
                ((PluginManager)PluginManager.this).core.alerts.unregister(this);
            }
            return success;
        }

        public void isValid(boolean validity) {
        }

        public boolean shouldUnregisterOnDismiss() {
            return true;
        }

        public boolean userCanDismiss() {
            return true;
        }
    }
}

