/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.l10n.L10n;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.pluginmanager.FredPluginFCP;
import freenet.pluginmanager.FredPluginHTTP;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginL10n;
import freenet.pluginmanager.FredPluginMultiple;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.pluginmanager.FredPluginRealVersioned;
import freenet.pluginmanager.FredPluginThemed;
import freenet.pluginmanager.FredPluginThreadless;
import freenet.pluginmanager.FredPluginUoF;
import freenet.pluginmanager.FredPluginVersioned;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.JarClassLoader;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.util.Date;
import java.util.HashSet;

public class PluginInfoWrapper {
    private final String className;
    private Thread thread;
    private final long start;
    final PluginRespirator pr;
    private final String threadName;
    final FredPlugin plug;
    private final boolean isPproxyPlugin;
    private final boolean isThreadlessPlugin;
    private final boolean isIPDetectorPlugin;
    private final boolean isBandwidthIndicator;
    private final boolean isPortForwardPlugin;
    private final boolean isMultiplePlugin;
    private final boolean isFCPPlugin;
    private final boolean isVersionedPlugin;
    private final boolean isLongVersionedPlugin;
    private final boolean isThemedPlugin;
    private final boolean isL10nPlugin;
    private final boolean isUpdatedablePlugin;
    private final String filename;
    private HashSet<String> toadletLinks = new HashSet();
    private volatile boolean stopping = false;
    private volatile boolean unregistered = false;

    public PluginInfoWrapper(PluginRespirator pr, FredPlugin plug, String filename) {
        this.plug = plug;
        this.className = plug.getClass().toString();
        this.filename = filename;
        this.pr = pr;
        this.threadName = 'p' + this.className.replaceAll("^class ", "") + '_' + this.hashCode();
        this.start = System.currentTimeMillis();
        this.isBandwidthIndicator = plug instanceof FredPluginBandwidthIndicator;
        this.isPproxyPlugin = plug instanceof FredPluginHTTP;
        this.isThreadlessPlugin = plug instanceof FredPluginThreadless;
        this.isIPDetectorPlugin = plug instanceof FredPluginIPDetector;
        this.isPortForwardPlugin = plug instanceof FredPluginPortForward;
        this.isMultiplePlugin = plug instanceof FredPluginMultiple;
        this.isFCPPlugin = plug instanceof FredPluginFCP;
        this.isVersionedPlugin = plug instanceof FredPluginVersioned;
        this.isLongVersionedPlugin = plug instanceof FredPluginRealVersioned;
        this.isThemedPlugin = plug instanceof FredPluginThemed;
        this.isL10nPlugin = plug instanceof FredPluginL10n;
        this.isUpdatedablePlugin = plug instanceof FredPluginUoF;
    }

    void setThread(Thread ps) {
        if (this.thread != null) {
            throw new IllegalStateException("Already set a thread");
        }
        this.thread = ps;
        this.thread.setName(this.threadName);
    }

    public String toString() {
        return "ID: \"" + this.threadName + "\", Name: " + this.className + ", Started: " + new Date(this.start).toString();
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getStarted() {
        return this.start;
    }

    public String getPluginClassName() {
        return this.plug.getClass().getName();
    }

    public String getPluginVersion() {
        if (this.isVersionedPlugin) {
            return ((FredPluginVersioned)((Object)this.plug)).getVersion();
        }
        return L10n.getString("PproxyToadlet.noVersion");
    }

    public synchronized String[] getPluginToadletSymlinks() {
        return this.toadletLinks.toArray(new String[0]);
    }

    public synchronized boolean addPluginToadletSymlink(String linkfrom) {
        if (this.toadletLinks.size() < 1) {
            this.toadletLinks = new HashSet();
        }
        return this.toadletLinks.add(linkfrom);
    }

    public synchronized boolean removePluginToadletSymlink(String linkfrom) {
        if (this.toadletLinks.size() < 1) {
            return false;
        }
        return this.toadletLinks.remove(linkfrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlugin(PluginManager manager, int maxWaitTime) {
        ClassLoader cl;
        this.unregister(manager);
        this.plug.terminate();
        PluginInfoWrapper pluginInfoWrapper = this;
        synchronized (pluginInfoWrapper) {
            this.stopping = true;
        }
        if (this.thread != null) {
            this.thread.interrupt();
            if (maxWaitTime >= 0) {
                try {
                    this.thread.join(maxWaitTime);
                }
                catch (InterruptedException e) {
                    Logger.normal(this, "stopPlugin interrupted while join()ed to terminating plugin thread - maybe one plugin stopping another???");
                }
                if (this.thread.isAlive()) {
                    String error = "Waited for " + this.thread + " for " + this.plug + " to exit for " + maxWaitTime + "ms, and it is still alive!";
                    Logger.error(this, error);
                    System.err.println(error);
                }
            }
        }
        if ((cl = this.plug.getClass().getClassLoader()) instanceof JarClassLoader) {
            Closer.close((JarClassLoader)cl);
        }
        manager.removePlugin(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(PluginManager manager) {
        PluginInfoWrapper pluginInfoWrapper = this;
        synchronized (pluginInfoWrapper) {
            if (this.unregistered) {
                return;
            }
            this.unregistered = true;
        }
        manager.unregisterPluginToadlet(this);
        if (this.isIPDetectorPlugin) {
            manager.node.ipDetector.unregisterIPDetectorPlugin((FredPluginIPDetector)((Object)this.plug));
        }
        if (this.isPortForwardPlugin) {
            manager.node.ipDetector.unregisterPortForwardPlugin((FredPluginPortForward)((Object)this.plug));
        }
        if (this.isBandwidthIndicator) {
            manager.node.ipDetector.unregisterBandwidthIndicatorPlugin((FredPluginBandwidthIndicator)((Object)this.plug));
        }
    }

    public boolean isPproxyPlugin() {
        return this.isPproxyPlugin;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isBandwidthIndicator() {
        return this.isBandwidthIndicator;
    }

    public boolean isThreadlessPlugin() {
        return this.isThreadlessPlugin;
    }

    public boolean isIPDetectorPlugin() {
        return this.isIPDetectorPlugin;
    }

    public boolean isPortForwardPlugin() {
        return this.isPortForwardPlugin;
    }

    public boolean isMultiplePlugin() {
        return this.isMultiplePlugin;
    }

    public boolean isFCPPlugin() {
        return this.isFCPPlugin;
    }

    public boolean isThemedPlugin() {
        return this.isThemedPlugin;
    }

    public boolean isL10nPlugin() {
        return this.isL10nPlugin;
    }

    public boolean isUpdatedablePlugin() {
        return this.isUpdatedablePlugin;
    }

    public synchronized boolean isStopping() {
        return this.stopping;
    }

    public long getPluginLongVersion() {
        if (this.isLongVersionedPlugin) {
            return ((FredPluginRealVersioned)((Object)this.plug)).getRealVersion();
        }
        return -1L;
    }
}

