/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.pluginmanager.PluginDownLoaderURL;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;

public class PluginDownLoaderOfficial
extends PluginDownLoaderURL {
    private static final String certurl = "freenet/clients/http/staticfiles/startssl.pem";
    private static final String certfile = "startssl.pem";

    public URL checkSource(String source) throws PluginNotFoundException {
        return super.checkSource("https://checksums.freenetproject.org/latest/" + source + ".jar");
    }

    String getPluginName(String source) throws PluginNotFoundException {
        return source + ".jar";
    }

    String getSHA1sum() throws PluginNotFoundException {
        try {
            int read;
            URL sha1url = new URL(((URL)this.getSource()).toString() + ".sha1");
            URLConnection urlConnection = sha1url.openConnection();
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            InputStream is = PluginDownLoaderOfficial.openConnectionCheckRedirects(urlConnection);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer)) != -1) {
                bos.write(buffer, 0, read);
            }
            return new String(bos.toByteArray()).split(" ")[0];
        }
        catch (MalformedURLException e) {
            throw new PluginNotFoundException("impossible: " + e, e);
        }
        catch (IOException e) {
            throw new PluginNotFoundException("Error while fetching sha1 for plugin: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream() throws IOException {
        File TMP_KEYSTORE = null;
        Closeable fis = null;
        InputStream is = null;
        try {
            try {
                TMP_KEYSTORE = File.createTempFile("keystore", ".tmp");
                TMP_KEYSTORE.deleteOnExit();
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(null, new char[0]);
                is = this.getCert();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> c = cf.generateCertificates(is);
                for (Certificate certificate : c) {
                    ks.setCertificateEntry(certificate.getPublicKey().toString(), certificate);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(TMP_KEYSTORE);
                try {
                    ks.store(fileOutputStream, new char[0]);
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    Closer.close(fileOutputStream);
                    throw throwable;
                }
                Closer.close(fileOutputStream);
                System.out.println("The CA has been imported into the trustStore");
            }
            catch (Exception e) {
                System.err.println("Error while handling the CA :" + e.getMessage());
                throw new IOException("Error while handling the CA : " + e);
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            Closer.close(fis);
            throw throwable;
        }
        Closer.close(fis);
        System.setProperty("javax.net.ssl.trustStore", TMP_KEYSTORE.toString());
        return super.getInputStream();
    }

    private InputStream getCert() throws IOException {
        File certFile = new File(certfile).getAbsoluteFile();
        if (certFile.exists()) {
            return new FileInputStream(certFile);
        }
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        InputStream in = loader.getResourceAsStream(certurl);
        if (in != null) {
            FileUtil.writeTo(in, certFile);
            if (certFile.exists()) {
                System.err.println("Nodes certfile created, use it");
                return new FileInputStream(certFile);
            }
            System.err.println("Nodes certfile couldnt created, try direct");
            return in;
        }
        System.err.println("Certficate file 'startssl.pem' not found on disk nor buildin.");
        throw new IOException("Certficate file 'startssl.pem' not found on disk nor buildin.");
    }
}

