/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.keys.FreenetURI;
import freenet.pluginmanager.PluginDownLoader;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.support.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDownLoaderFreenet
extends PluginDownLoader<FreenetURI> {
    final HighLevelSimpleClient hlsc;

    PluginDownLoaderFreenet(HighLevelSimpleClient hlsc) {
        this.hlsc = hlsc;
    }

    @Override
    public FreenetURI checkSource(String source) throws PluginNotFoundException {
        try {
            return new FreenetURI(source);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "not a valid freenet key: " + source, e);
            throw new PluginNotFoundException("not a valid freenet key: " + source, e);
        }
    }

    @Override
    InputStream getInputStream() throws IOException, PluginNotFoundException {
        FreenetURI uri = (FreenetURI)this.getSource();
        while (true) {
            try {
                FetchResult fres = this.hlsc.fetch(uri);
                return fres.asBucket().getInputStream();
            }
            catch (FetchException e) {
                if (e.getMode() == 27 || e.getMode() == 11) {
                    uri = e.newURI;
                    continue;
                }
                Logger.error(this, "error while fetching plugin: " + this.getSource(), e);
                throw new PluginNotFoundException("error while fetching plugin: " + this.getSource(), e);
            }
            break;
        }
    }

    @Override
    String getPluginName(String source) throws PluginNotFoundException {
        return source.substring(source.lastIndexOf(47) + 1);
    }

    @Override
    String getSHA1sum() throws PluginNotFoundException {
        return null;
    }

    @Override
    String getSHA256sum() throws PluginNotFoundException {
        return null;
    }
}

