/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.l10n.L10n;
import freenet.node.NodeClientCore;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAlertManager
implements Comparator<UserAlert> {
    private final HashSet<UserAlert> alerts;
    private final NodeClientCore core;

    public UserAlertManager(NodeClientCore core) {
        this.core = core;
        this.alerts = new LinkedHashSet<UserAlert>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(UserAlert alert) {
        HashSet<UserAlert> hashSet = this.alerts;
        synchronized (hashSet) {
            if (!this.alerts.contains(alert)) {
                this.alerts.add(alert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(UserAlert alert) {
        HashSet<UserAlert> hashSet = this.alerts;
        synchronized (hashSet) {
            this.alerts.remove(alert);
        }
    }

    public void dismissAlert(int alertHashCode) {
        for (UserAlert userAlert : this.getAlerts()) {
            if (userAlert.hashCode() != alertHashCode || !userAlert.userCanDismiss()) continue;
            if (userAlert.shouldUnregisterOnDismiss()) {
                userAlert.onDismiss();
                this.unregister(userAlert);
                continue;
            }
            userAlert.isValid(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAlert[] getAlerts() {
        UserAlert[] a;
        HashSet<UserAlert> hashSet = this.alerts;
        synchronized (hashSet) {
            a = this.alerts.toArray(new UserAlert[this.alerts.size()]);
        }
        Arrays.sort(a, this);
        return a;
    }

    @Override
    public int compare(UserAlert a0, UserAlert a1) {
        short prio1;
        if (a0 == a1) {
            return 0;
        }
        short prio0 = a0.getPriorityClass();
        if (prio0 - (prio1 = a1.getPriorityClass()) == 0) {
            int hash1;
            int classHash1;
            boolean isEvent0 = a0.isEventNotification();
            boolean isEvent1 = a1.isEventNotification();
            if (isEvent0 && !isEvent1) {
                return 1;
            }
            if (!isEvent0 && isEvent1) {
                return -1;
            }
            int classHash0 = a0.getClass().hashCode();
            if (classHash0 > (classHash1 = a1.getClass().hashCode())) {
                return 1;
            }
            if (classHash0 < classHash1) {
                return -1;
            }
            int hash0 = a0.hashCode();
            if (hash0 > (hash1 = a1.hashCode())) {
                return 1;
            }
            if (hash1 > hash0) {
                return -1;
            }
            return 0;
        }
        if (prio0 > prio1) {
            return 1;
        }
        return -1;
    }

    public HTMLNode createAlerts() {
        HTMLNode alertsNode = new HTMLNode("div");
        UserAlert[] alerts = this.getAlerts();
        int totalNumber = 0;
        for (int i = 0; i < alerts.length; ++i) {
            UserAlert alert = alerts[i];
            if (!alert.isValid()) continue;
            ++totalNumber;
            alertsNode.addChild("a", "name", alert.anchor());
            alertsNode.addChild(this.renderAlert(alert));
        }
        if (totalNumber == 0) {
            return new HTMLNode("#", "");
        }
        return alertsNode;
    }

    public HTMLNode createAlertsShort(String title, boolean advancedMode, boolean drawDumpEventsForm) {
        UserAlert[] currentAlerts = this.getAlerts();
        short maxLevel = Short.MAX_VALUE;
        int events = 0;
        for (int i = 0; i < currentAlerts.length; ++i) {
            if (!currentAlerts[i].isValid()) continue;
            short level = currentAlerts[i].getPriorityClass();
            if (level < maxLevel) {
                maxLevel = level;
            }
            if (!currentAlerts[i].isEventNotification()) continue;
            ++events;
        }
        if (maxLevel == Short.MAX_VALUE) {
            return new HTMLNode("#", "");
        }
        if (events < 2) {
            drawDumpEventsForm = false;
        }
        HTMLNode boxNode = new HTMLNode("div", "class", "infobox infobox-" + this.getAlertLevelName(maxLevel) + " infobox-summary-status-box");
        boxNode.addChild("div", "class", "infobox-header infobox summary-status-header", title);
        HTMLNode contentNode = boxNode.addChild("div", "class", "infobox-content infobox-summary-status-content");
        if (!advancedMode) {
            contentNode.addChild("p", "class", "click-for-more", this.l10n("clickForMore"));
        }
        HTMLNode alertsNode = contentNode.addChild("ul", "class", "alert-summary");
        int totalNumber = 0;
        for (int i = 0; i < currentAlerts.length; ++i) {
            UserAlert alert = currentAlerts[i];
            if (!alert.isValid()) continue;
            HTMLNode listItem = alertsNode.addChild("li", "class", "alert-summary-text-" + this.getAlertLevelName(alert.getPriorityClass()));
            listItem.addChild("a", "href", "/alerts/#" + alert.anchor(), alert.getShortText());
            ++totalNumber;
        }
        if (drawDumpEventsForm) {
            HTMLNode dumpFormNode = contentNode.addChild("form", new String[]{"action", "method"}, new String[]{"/", "post"}).addChild("div");
            dumpFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.core.formPassword});
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < currentAlerts.length; ++i) {
                if (!currentAlerts[i].isEventNotification()) continue;
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(currentAlerts[i].anchor());
            }
            dumpFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "events", sb.toString()});
            dumpFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "dismiss-events", this.l10n("dumpEventsButton")});
        }
        return boxNode;
    }

    public HTMLNode renderAlert(UserAlert userAlert) {
        HTMLNode userAlertNode = null;
        short level = userAlert.getPriorityClass();
        userAlertNode = new HTMLNode("div", "class", "infobox infobox-" + this.getAlertLevelName(level));
        userAlertNode.addChild("div", "class", "infobox-header", userAlert.getTitle());
        HTMLNode alertContentNode = userAlertNode.addChild("div", "class", "infobox-content");
        alertContentNode.addChild(userAlert.getHTMLText());
        if (userAlert.userCanDismiss()) {
            HTMLNode dismissFormNode = alertContentNode.addChild("form", new String[]{"action", "method"}, new String[]{"/", "post"}).addChild("div");
            dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "disable", String.valueOf(userAlert.hashCode())});
            dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.core.formPassword});
            dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "dismiss-user-alert", userAlert.dismissButtonText()});
        }
        return userAlertNode;
    }

    private String getAlertLevelName(short level) {
        if (level <= 0) {
            return "error";
        }
        if (level <= 1) {
            return "alert";
        }
        if (level <= 2) {
            return "warning";
        }
        if (level <= 3) {
            return "minor";
        }
        Logger.error(this, "Unknown alert level: " + level, new Exception("debug"));
        return "error";
    }

    public HTMLNode createSummary() {
        short highestLevel = 99;
        int numberOfCriticalError = 0;
        int numberOfError = 0;
        int numberOfWarning = 0;
        int numberOfMinor = 0;
        int totalNumber = 0;
        UserAlert[] alerts = this.getAlerts();
        for (int i = 0; i < alerts.length; ++i) {
            UserAlert alert = alerts[i];
            if (!alert.isValid()) continue;
            short level = alert.getPriorityClass();
            if (level < highestLevel) {
                highestLevel = level;
            }
            if (level <= 0) {
                ++numberOfCriticalError;
            } else if (level <= 1) {
                ++numberOfError;
            } else if (level <= 2) {
                ++numberOfWarning;
            } else if (level <= 3) {
                ++numberOfMinor;
            }
            ++totalNumber;
        }
        if (totalNumber == 0) {
            return new HTMLNode("#", "");
        }
        boolean separatorNeeded = false;
        int messageTypes = 0;
        StringBuilder alertSummaryString = new StringBuilder(1024);
        if (numberOfCriticalError != 0) {
            alertSummaryString.append(this.l10n("criticalErrorCountLabel")).append(' ').append(numberOfCriticalError);
            separatorNeeded = true;
            ++messageTypes;
        }
        if (numberOfError != 0) {
            if (separatorNeeded) {
                alertSummaryString.append(" | ");
            }
            alertSummaryString.append(this.l10n("errorCountLabel")).append(' ').append(numberOfError);
            separatorNeeded = true;
            ++messageTypes;
        }
        if (numberOfWarning != 0) {
            if (separatorNeeded) {
                alertSummaryString.append(" | ");
            }
            alertSummaryString.append(this.l10n("warningCountLabel")).append(' ').append(numberOfWarning);
            separatorNeeded = true;
            ++messageTypes;
        }
        if (numberOfMinor != 0) {
            if (separatorNeeded) {
                alertSummaryString.append(" | ");
            }
            alertSummaryString.append(this.l10n("minorCountLabel")).append(' ').append(numberOfMinor);
            separatorNeeded = true;
            ++messageTypes;
        }
        if (messageTypes != 1) {
            if (separatorNeeded) {
                alertSummaryString.append(" | ");
            }
            alertSummaryString.append(this.l10n("totalLabel")).append(' ').append(totalNumber);
        }
        HTMLNode summaryBox = null;
        if (highestLevel <= 0) {
            summaryBox = new HTMLNode("div", "class", "infobox infobox-error");
        } else if (highestLevel <= 1) {
            summaryBox = new HTMLNode("div", "class", "infobox infobox-alert");
        } else if (highestLevel <= 2) {
            summaryBox = new HTMLNode("div", "class", "infobox infobox-warning");
        } else if (highestLevel <= 3) {
            summaryBox = new HTMLNode("div", "class", "infobox infobox-information");
        }
        summaryBox.addChild("div", "class", "infobox-header", this.l10n("alertsTitle"));
        HTMLNode summaryContent = summaryBox.addChild("div", "class", "infobox-content", alertSummaryString.toString());
        summaryContent.addChild("#", " ");
        L10n.addL10nSubstitution(summaryContent, "UserAlertManager.alertsOnAlertsPage", new String[]{"link", "/link"}, new String[]{"<a href=\"/alerts/\">", "</a>"});
        return summaryBox;
    }

    private String l10n(String key) {
        return L10n.getString("UserAlertManager." + key);
    }

    public void dumpEvents(HashSet<String> toDump) {
        UserAlert[] alerts = this.getAlerts();
        for (int i = 0; i < alerts.length; ++i) {
            if (!alerts[i].isEventNotification() || !toDump.contains(alerts[i].anchor())) continue;
            this.unregister(alerts[i]);
            alerts[i].onDismiss();
        }
    }
}

