/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.l10n.L10n;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import freenet.support.TimeUtil;

public class UpdatedVersionAvailableUserAlert
extends AbstractUserAlert {
    private final NodeUpdateManager updater;

    public UpdatedVersionAvailableUserAlert(NodeUpdateManager updater) {
        super(false, null, null, null, null, (short)0, false, L10n.getString("UserAlert.hide"), false, null);
        this.updater = updater;
    }

    public String getTitle() {
        return this.l10n("title");
    }

    private String l10n(String key) {
        return L10n.getString("UpdatedVersionAvailableUserAlert." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("UpdatedVersionAvailableUserAlert." + key, pattern, value);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("UpdatedVersionAvailableUserAlert." + key, patterns, values);
    }

    public String getText() {
        UpdateThingy ut = this.createUpdateThingy();
        StringBuilder sb = new StringBuilder();
        sb.append(ut.firstBit);
        if (ut.formText != null) {
            sb.append(" <form action=\"/\" method=\"post\"><input type=\"submit\" name=\"update\" value=\"");
            sb.append(ut.formText);
            sb.append("\" /></form>");
        }
        return sb.toString();
    }

    public String getShortText() {
        if (!this.updater.isArmed()) {
            if (this.updater.canUpdateNow()) {
                return this.l10n("shortReadyNotArmed");
            }
            return this.l10n("shortNotReadyNotArmed");
        }
        return this.l10n("shortArmed");
    }

    public HTMLNode getHTMLText() {
        UpdateThingy ut = this.createUpdateThingy();
        HTMLNode alertNode = new HTMLNode("div");
        alertNode.addChild("#", ut.firstBit);
        if (ut.formText != null) {
            alertNode.addChild("form", new String[]{"action", "method"}, new String[]{"/", "post"}).addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "update", ut.formText});
        }
        return alertNode;
    }

    private UpdateThingy createUpdateThingy() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.l10n("notLatest"));
        sb.append(' ');
        if (this.updater.isArmed() && this.updater.inFinalCheck()) {
            sb.append(this.l10n("finalCheck", new String[]{"count", "max", "time"}, new String[]{Integer.toString(this.updater.getRevocationDNFCounter()), Integer.toString(3), TimeUtil.formatTime(this.updater.timeRemainingOnCheck())}));
            sb.append(' ');
        } else if (this.updater.isArmed()) {
            sb.append(this.l10n("armed"));
        } else {
            String formText;
            if (this.updater.canUpdateNow()) {
                boolean b = false;
                if (this.updater.hasNewMainJar()) {
                    sb.append(this.l10n("downloadedNewJar", "version", Integer.toString(this.updater.newMainJarVersion())));
                    sb.append(' ');
                    b = true;
                }
                if (this.updater.hasNewExtJar()) {
                    sb.append(this.l10n(b ? "alsoDownloadedNewExtJar" : "downloadedNewExtJar", "version", Integer.toString(this.updater.newExtJarVersion())));
                    sb.append(' ');
                }
                if (this.updater.canUpdateImmediately()) {
                    sb.append(this.l10n("clickToUpdateNow"));
                    formText = this.l10n("updateNowButton");
                } else {
                    sb.append(this.l10n("clickToUpdateASAP"));
                    formText = this.l10n("updateASAPButton");
                }
            } else {
                boolean fetchingNew = this.updater.fetchingNewMainJar();
                boolean fetchingNewExt = this.updater.fetchingNewExtJar();
                if (fetchingNew) {
                    if (fetchingNewExt) {
                        sb.append(this.l10n("fetchingNewBoth", new String[]{"nodeVersion", "extVersion"}, new String[]{Integer.toString(this.updater.fetchingNewMainJarVersion()), Integer.toString(this.updater.fetchingNewExtJarVersion())}));
                    } else {
                        sb.append(this.l10n("fetchingNewNode", "nodeVersion", Integer.toString(this.updater.fetchingNewMainJarVersion())));
                    }
                } else if (fetchingNewExt) {
                    sb.append(this.l10n("fetchingNewExt", "extVersion", Integer.toString(this.updater.fetchingNewExtJarVersion())));
                }
                sb.append(this.l10n("updateASAPQuestion"));
                formText = this.l10n("updateASAPButton");
            }
            return new UpdateThingy(sb.toString(), formText);
        }
        return new UpdateThingy(sb.toString(), null);
    }

    public short getPriorityClass() {
        if (this.updater.inFinalCheck()) {
            return 2;
        }
        return 3;
    }

    public boolean isValid() {
        return this.updater.isEnabled() && !this.updater.isBlown() && this.updater.fetchingNewExtJar() || this.updater.fetchingNewMainJar() || this.updater.hasNewExtJar() || this.updater.hasNewMainJar();
    }

    public void isValid(boolean b) {
    }

    private static class UpdateThingy {
        String firstBit;
        String formText;

        public UpdateThingy(String first, String form) {
            this.firstBit = first;
            this.formText = form;
        }
    }
}

