/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.support.HTMLNode;

public class ProxyUserAlert
implements UserAlert {
    private UserAlert alert;
    private final UserAlertManager uam;
    private final boolean autoRegister;

    public ProxyUserAlert(UserAlertManager uam, boolean autoRegister) {
        this.uam = uam;
        this.autoRegister = autoRegister;
    }

    public void setAlert(UserAlert a) {
        UserAlert old = this.alert;
        this.alert = a;
        if (this.autoRegister && old == null && this.alert != null) {
            this.uam.register(this);
        }
        if (this.autoRegister && this.alert == null) {
            this.uam.unregister(this);
        }
    }

    public boolean userCanDismiss() {
        return this.alert.userCanDismiss();
    }

    public String getTitle() {
        return this.alert.getTitle();
    }

    public String getText() {
        return this.alert.getText();
    }

    public HTMLNode getHTMLText() {
        return this.alert.getHTMLText();
    }

    public short getPriorityClass() {
        return this.alert.getPriorityClass();
    }

    public boolean isValid() {
        return this.alert != null && this.alert.isValid();
    }

    public void isValid(boolean validity) {
        if (this.alert != null) {
            this.alert.isValid(validity);
        }
    }

    public String dismissButtonText() {
        return this.alert.dismissButtonText();
    }

    public boolean shouldUnregisterOnDismiss() {
        return this.alert.shouldUnregisterOnDismiss();
    }

    public void onDismiss() {
        if (this.alert != null) {
            this.alert.onDismiss();
        }
    }

    public Object getUserIdentifier() {
        return this.alert.getUserIdentifier();
    }

    public String anchor() {
        return "anchor:" + Integer.toString(this.hashCode());
    }

    public String getShortText() {
        return this.alert.getShortText();
    }

    public boolean isEventNotification() {
        if (this.alert == null) {
            return false;
        }
        return this.alert.isEventNotification();
    }
}

