/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.l10n.L10n;
import freenet.node.NodeStats;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;

public class PeerManagerUserAlert
extends AbstractUserAlert {
    final NodeStats n;
    public int conns = 0;
    public int peers = 0;
    public int neverConn = 0;
    public int clockProblem = 0;
    public int connError = 0;
    public int disconnDarknetPeers = 0;
    int bwlimitDelayTime = 1;
    int nodeAveragePingTime = 1;
    long oldestNeverConnectedPeerAge = 0L;
    public int darknetConns = 0;
    public int darknetPeers = 0;
    public boolean isOpennetEnabled;
    public boolean darknetDefinitelyPortForwarded;
    public boolean opennetDefinitelyPortForwarded;
    public boolean opennetAssumeNAT;
    public boolean darknetAssumeNAT;
    public static final int MIN_CONN_ALERT_THRESHOLD = 3;
    public static final int MAX_CONN_ALERT_THRESHOLD = 30;
    public static final int MAX_DISCONN_PEER_ALERT_THRESHOLD = 50;
    public static final int MAX_NEVER_CONNECTED_PEER_ALERT_THRESHOLD = 5;
    public static final int MIN_CLOCK_PROBLEM_PEER_ALERT_THRESHOLD = 5;
    public static final int MIN_CONN_ERROR_ALERT_THRESHOLD = 5;
    public static final int MAX_PEER_ALERT_THRESHOLD = 100;
    public static final long MAX_OLDEST_NEVER_CONNECTED_PEER_AGE_ALERT_THRESHOLD = 1209600000L;

    public PeerManagerUserAlert(NodeStats n) {
        super(false, null, null, null, null, (short)0, true, L10n.getString("UserAlert.hide"), false, null);
        this.n = n;
    }

    public String getTitle() {
        if (!this.isOpennetEnabled) {
            if (this.peers == 0) {
                return this.l10n("noPeersTitle");
            }
            if (this.conns == 0) {
                return this.l10n("noConnsTitle");
            }
            if (this.conns < 3) {
                return this.l10n("onlyFewConnsTitle", "count", Integer.toString(this.conns));
            }
        }
        if (this.n.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > 6000L) {
            return this.l10n("tooHighBwlimitDelayTimeTitle");
        }
        if (this.n.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > 3000L) {
            return this.l10n("tooHighPingTimeTitle");
        }
        if (this.clockProblem > 5) {
            return this.l10n("clockProblemTitle");
        }
        if (this.neverConn > 5) {
            return this.l10n("tooManyNeverConnectedTitle");
        }
        if (this.connError > 5) {
            return this.l10n("connErrorTitle");
        }
        if (this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT) {
            return this.l10n("tooManyDisconnectedTitle");
        }
        if (this.conns > 30) {
            return this.l10n("tooManyConnsTitle");
        }
        if (this.peers > 100) {
            return this.l10n("tooManyPeersTitle");
        }
        if (this.oldestNeverConnectedPeerAge > 1209600000L) {
            return this.l10n("tooOldNeverConnectedPeersTitle");
        }
        throw new IllegalArgumentException("Not valid");
    }

    public String getShortText() {
        return this.getTitle();
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("PeerManagerUserAlert." + key, pattern, value);
    }

    private String l10n(String key, String[] pattern, String[] value) {
        return L10n.getString("PeerManagerUserAlert." + key, pattern, value);
    }

    private String l10n(String key) {
        return L10n.getString("PeerManagerUserAlert." + key);
    }

    public String getText() {
        String s;
        if (this.peers == 0 && !this.isOpennetEnabled) {
            if (this.n.isTestnetEnabled()) {
                return this.l10n("noPeersTestnet");
            }
            return this.l10n("noPeersDarknet");
        }
        if (this.conns < 3 && this.clockProblem > 5) {
            s = this.l10n("clockProblem", "count", Integer.toString(this.clockProblem));
        } else if (this.conns < 3 && this.connError > 5 && !this.isOpennetEnabled) {
            s = this.l10n("connError", "count", Integer.toString(this.connError));
        } else {
            if (this.conns == 0 && !this.isOpennetEnabled) {
                return this.l10n("noConns");
            }
            if (this.conns == 1 && !this.isOpennetEnabled) {
                return this.l10n("oneConn");
            }
            if (this.conns == 2 && !this.isOpennetEnabled) {
                return this.l10n("twoConns");
            }
            if (this.n.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > 6000L) {
                s = this.l10n("tooHighBwlimitDelayTime", new String[]{"delay", "max"}, new String[]{Integer.toString(this.bwlimitDelayTime), Long.toString(6000L)});
            } else if (this.n.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > 3000L) {
                s = this.l10n("tooHighPingTime", new String[]{"ping", "max"}, new String[]{Integer.toString(this.nodeAveragePingTime), Long.toString(3000L)});
            } else if (this.clockProblem > 5) {
                s = this.l10n("clockProblem", "count", Integer.toString(this.clockProblem));
            } else if (this.neverConn > 5) {
                s = this.l10n("tooManyNeverConnected", "count", Integer.toString(this.neverConn));
            } else if (this.connError > 5) {
                s = this.l10n("connError", "count", Integer.toString(this.connError));
            } else if (this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT) {
                s = this.l10n("tooManyDisconnected", new String[]{"count", "max"}, new String[]{Integer.toString(this.disconnDarknetPeers), Integer.toString(50)});
            } else if (this.conns > 30) {
                s = this.l10n("tooManyConns", new String[]{"count", "max"}, new String[]{Integer.toString(this.conns), Integer.toString(30)});
            } else if (this.peers > 100) {
                s = this.l10n("tooManyPeers", new String[]{"count", "max"}, new String[]{Integer.toString(this.peers), Integer.toString(100)});
            } else {
                if (this.oldestNeverConnectedPeerAge > 1209600000L) {
                    return this.l10n("tooOldNeverConnectedPeers");
                }
                throw new IllegalArgumentException("Not valid");
            }
        }
        return s;
    }

    public static final String replace(String text, String find, String replace) {
        return PeerManagerUserAlert.replaceCareful(text, find, replace);
    }

    public static String replaceAll(String text, String find, String replace) {
        int i;
        while ((i = text.indexOf(find)) >= 0) {
            text = text.substring(0, i) + replace + text.substring(i + find.length());
        }
        return text;
    }

    public static String replaceCareful(String text, String find, String replace) {
        String[] split = text.split(find, -1);
        StringBuilder sb = new StringBuilder(text.length() + (split.length - 1) * (replace.length() - find.length()));
        for (int i = 0; i < split.length; ++i) {
            sb.append(split[i]);
            if (i >= split.length - 1) continue;
            sb.append(replace);
        }
        return sb.toString();
    }

    public HTMLNode getHTMLText() {
        HTMLNode alertNode = new HTMLNode("div");
        if (this.peers == 0 && !this.isOpennetEnabled) {
            if (this.n.isTestnetEnabled()) {
                alertNode.addChild("#", this.l10n("noPeersTestnet"));
            } else {
                alertNode.addChild("#", this.l10n("noPeersDarknet"));
            }
        } else if (this.conns < 3 && this.clockProblem > 5) {
            alertNode.addChild("#", this.l10n("clockProblem", "count", Integer.toString(this.clockProblem)));
        } else if (this.conns < 3 && this.connError > 5) {
            alertNode.addChild("#", this.l10n("connError", "count", Integer.toString(this.connError)));
        } else if (this.conns == 0 && !this.isOpennetEnabled) {
            alertNode.addChild("#", this.l10n("noConns"));
        } else if (this.conns == 1 && !this.isOpennetEnabled) {
            alertNode.addChild("#", this.l10n("oneConn"));
        } else if (this.conns == 2 && !this.isOpennetEnabled) {
            alertNode.addChild("#", this.l10n("twoConns"));
        } else if (this.n.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > 6000L) {
            alertNode.addChild("#", this.l10n("tooHighBwlimitDelayTime", new String[]{"delay", "max"}, new String[]{Integer.toString(this.bwlimitDelayTime), Long.toString(6000L)}));
        } else if (this.n.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > 3000L) {
            alertNode.addChild("#", this.l10n("tooHighPingTime", new String[]{"ping", "max"}, new String[]{Integer.toString(this.nodeAveragePingTime), Long.toString(3000L)}));
        } else if (this.clockProblem > 5) {
            alertNode.addChild("#", this.l10n("clockProblem", "count", Integer.toString(this.clockProblem)));
        } else if (this.neverConn > 5) {
            L10n.addL10nSubstitution(alertNode, "PeerManagerUserAlert.tooManyNeverConnectedWithLink", new String[]{"link", "/link", "count"}, new String[]{"<a href=\"/friends/myref.fref\">", "</a>", Integer.toString(this.neverConn)});
        } else if (this.connError > 5) {
            alertNode.addChild("#", this.l10n("connError", "count", Integer.toString(this.connError)));
        } else if (this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT) {
            alertNode.addChild("#", this.l10n("tooManyDisconnected", new String[]{"count", "max"}, new String[]{Integer.toString(this.disconnDarknetPeers), Integer.toString(50)}));
        } else if (this.conns > 30) {
            alertNode.addChild("#", this.l10n("tooManyConns", new String[]{"count", "max"}, new String[]{Integer.toString(this.conns), Integer.toString(30)}));
        } else if (this.peers > 100) {
            alertNode.addChild("#", this.l10n("tooManyPeers", new String[]{"count", "max"}, new String[]{Integer.toString(this.peers), Integer.toString(100)}));
        } else if (this.oldestNeverConnectedPeerAge > 1209600000L) {
            alertNode.addChild("#", this.l10n("tooOldNeverConnectedPeers"));
        } else {
            throw new IllegalArgumentException("not valid");
        }
        return alertNode;
    }

    public short getPriorityClass() {
        if (this.peers == 0 && !this.isOpennetEnabled) {
            return 0;
        }
        if (this.conns == 0 && !this.isOpennetEnabled) {
            return 1;
        }
        if (this.conns < 3 && this.clockProblem > 5) {
            return 1;
        }
        if (this.conns < 3 && this.connError > 5) {
            return 1;
        }
        if (this.conns < 3 && !this.isOpennetEnabled) {
            return 1;
        }
        if (this.n.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > 6000L) {
            return 1;
        }
        if (this.n.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > 3000L) {
            return 1;
        }
        if (this.clockProblem > 5) {
            return 1;
        }
        if (this.neverConn > 5) {
            return 2;
        }
        if (this.connError > 5) {
            return 2;
        }
        if (this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT) {
            return 2;
        }
        if (this.conns > 30) {
            return 2;
        }
        if (this.peers > 100) {
            return 2;
        }
        if (this.oldestNeverConnectedPeerAge > 1209600000L) {
            return 2;
        }
        return 1;
    }

    public boolean isValid() {
        this.bwlimitDelayTime = (int)this.n.getBwlimitDelayTime();
        this.nodeAveragePingTime = (int)this.n.getNodeAveragePingTime();
        this.oldestNeverConnectedPeerAge = (int)this.n.peers.getOldestNeverConnectedPeerAge();
        return (this.peers == 0 && !this.isOpennetEnabled || this.conns < 3 && !this.isOpennetEnabled || this.neverConn > 5 || this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT || this.conns > 30 || this.peers > 100 || this.clockProblem > 5 || this.connError > 5 || this.n.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > 6000L || this.n.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > 3000L || this.oldestNeverConnectedPeerAge > 1209600000L) && super.isValid();
    }
}

