/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.l10n.L10n;
import freenet.node.DarknetPeerNode;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import java.text.DateFormat;
import java.util.Date;

public class N2NTMUserAlert
extends AbstractUserAlert {
    private DarknetPeerNode sourcePeerNode;
    private String sourceNodename;
    private String messageText;
    private int fileNumber;
    private long composedTime;
    private long sentTime;
    private long receivedTime;

    public N2NTMUserAlert(DarknetPeerNode sourcePeerNode, String source, String target, String message, int fileNumber, long composedTime, long sentTime, long receivedTime) {
        super(true, null, null, null, null, (short)3, true, null, true, null);
        this.sourcePeerNode = sourcePeerNode;
        this.sourceNodename = source;
        this.messageText = message;
        this.fileNumber = fileNumber;
        this.composedTime = composedTime;
        this.sentTime = sentTime;
        this.receivedTime = receivedTime;
    }

    public String getTitle() {
        return this.l10n("title", new String[]{"number", "peername", "peer"}, new String[]{Integer.toString(this.fileNumber), this.sourcePeerNode.getName(), this.sourcePeerNode.getPeer().toString()});
    }

    public String getText() {
        return this.l10n("header", new String[]{"from", "composed", "sent", "received"}, new String[]{this.sourceNodename, DateFormat.getInstance().format(new Date(this.composedTime)), DateFormat.getInstance().format(new Date(this.sentTime)), DateFormat.getInstance().format(new Date(this.receivedTime))}) + ": " + this.messageText;
    }

    public String getShortText() {
        return this.l10n("headerShort", "from", this.sourceNodename);
    }

    public HTMLNode getHTMLText() {
        HTMLNode alertNode = new HTMLNode("div");
        alertNode.addChild("p", this.l10n("header", new String[]{"from", "composed", "sent", "received"}, new String[]{this.sourceNodename, DateFormat.getInstance().format(new Date(this.composedTime)), DateFormat.getInstance().format(new Date(this.sentTime)), DateFormat.getInstance().format(new Date(this.receivedTime))}));
        String[] lines = this.messageText.split("\n");
        int c = lines.length;
        for (int i = 0; i < c; ++i) {
            alertNode.addChild("#", lines[i]);
            if (i == lines.length - 1) continue;
            alertNode.addChild("br");
        }
        alertNode.addChild("p").addChild("a", "href", "/send_n2ntm/?peernode_hashcode=" + this.sourcePeerNode.hashCode(), this.l10n("reply"));
        return alertNode;
    }

    public String dismissButtonText() {
        return this.l10n("delete");
    }

    private String l10n(String key) {
        return L10n.getString("N2NTMUserAlert." + key);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("N2NTMUserAlert." + key, patterns, values);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("N2NTMUserAlert." + key, pattern, value);
    }

    public void onDismiss() {
        this.sourcePeerNode.deleteExtraPeerDataFile(this.fileNumber);
    }
}

