/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;

public class IPUndetectedUserAlert
extends AbstractUserAlert {
    final Node node;

    public IPUndetectedUserAlert(Node n) {
        super(true, null, null, null, null, (short)0, true, L10n.getString("UserAlert.hide"), false, null);
        this.node = n;
    }

    public String getTitle() {
        return this.l10n("unknownAddressTitle");
    }

    public String getText() {
        if (this.node.ipDetector.noDetectPlugins()) {
            return this.l10n("noDetectorPlugins");
        }
        if (this.node.ipDetector.isDetecting()) {
            return this.l10n("detecting");
        }
        return this.l10n("unknownAddress", "port", Integer.toString(this.node.getDarknetPortNumber())) + ' ' + this.textPortForwardSuggestion();
    }

    private String l10n(String key) {
        return L10n.getString("IPUndetectedUserAlert." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("IPUndetectedUserAlert." + key, pattern, value);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("IPUndetectedUserAlert." + key, patterns, values);
    }

    public HTMLNode getHTMLText() {
        if (this.node.ipDetector.noDetectPlugins()) {
            HTMLNode p = new HTMLNode("p");
            L10n.addL10nSubstitution(p, "IPUndetectedUserAlert.loadDetectPlugins", new String[]{"plugins", "/plugins", "config", "/config"}, new String[]{"<a href=\"/plugins/\">", "</a>", "<a href=\"/config/node\">", "</a>"});
            return p;
        }
        HTMLNode textNode = new HTMLNode("div");
        SubConfig sc = this.node.config.get("node");
        Option<?> o = sc.getOption("tempIPAddressHint");
        L10n.addL10nSubstitution(textNode, "IPUndetectedUserAlert." + (this.node.ipDetector.isDetecting() ? "detectingWithConfigLink" : "unknownAddressWithConfigLink"), new String[]{"link", "/link"}, new String[]{"<a href=\"/config/" + sc.getPrefix() + "\">", "</a>"});
        this.addPortForwardSuggestion(textNode);
        HTMLNode formNode = textNode.addChild("form", new String[]{"action", "method"}, new String[]{"/config/" + sc.getPrefix(), "post"});
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.node.clientCore.formPassword});
        HTMLNode listNode = formNode.addChild("ul", "class", "config");
        HTMLNode itemNode = listNode.addChild("li");
        itemNode.addChild("span", "class", "configshortdesc", L10n.getString(o.getShortDesc())).addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", sc.getPrefix() + ".tempIPAddressHint", o.getValueString()});
        itemNode.addChild("span", "class", "configlongdesc", L10n.getString(o.getLongDesc()));
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", L10n.getString("UserAlert.apply")});
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", L10n.getString("UserAlert.reset")});
        return textNode;
    }

    private void addPortForwardSuggestion(HTMLNode textNode) {
        int darknetPort = this.node.getDarknetPortNumber();
        int opennetPort = this.node.getOpennetFNPPort();
        if (opennetPort <= 0) {
            textNode.addChild("#", " " + this.l10n("suggestForwardPort", "port", Integer.toString(darknetPort)));
        } else {
            textNode.addChild("#", " " + this.l10n("suggestForwardTwoPorts", new String[]{"port1", "port2"}, new String[]{Integer.toString(darknetPort), Integer.toString(opennetPort)}));
        }
    }

    private String textPortForwardSuggestion() {
        int darknetPort = this.node.getDarknetPortNumber();
        int opennetPort = this.node.getOpennetFNPPort();
        if (opennetPort <= 0) {
            return this.l10n("suggestForwardPort", "port", Integer.toString(darknetPort));
        }
        return " " + this.l10n("suggestForwardTwoPorts", new String[]{"port1", "port2"}, new String[]{Integer.toString(darknetPort), Integer.toString(opennetPort)});
    }

    public short getPriorityClass() {
        if (this.node.ipDetector.isDetecting()) {
            return 2;
        }
        return 1;
    }

    public String getShortText() {
        if (this.node.ipDetector.noDetectPlugins()) {
            return this.l10n("noDetectorPlugins");
        }
        if (this.node.ipDetector.isDetecting()) {
            return this.l10n("detectingShort");
        }
        return this.l10n("unknownAddressShort");
    }
}

