/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.BinaryBlob;
import freenet.client.async.BinaryBlobFormatException;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutter;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.SimpleBlockSet;
import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.xfer.BulkReceiver;
import freenet.io.xfer.BulkTransmitter;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.NodeStarter;
import freenet.node.PeerNode;
import freenet.node.RequestClient;
import freenet.node.Version;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.updater.NodeUpdater;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.api.Bucket;
import freenet.support.io.FileBucket;
import freenet.support.io.RandomAccessFileWrapper;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpdateOverMandatoryManager
implements RequestClient {
    private static volatile boolean logMINOR;
    final NodeUpdateManager updateManager;
    private final HashSet<PeerNode> nodesSayKeyRevoked;
    private final HashSet<PeerNode> nodesSayKeyRevokedFailedTransfer;
    private final HashSet<PeerNode> nodesSayKeyRevokedTransferring;
    private final HashSet<PeerNode> nodesOfferedMainJar;
    private final HashSet<PeerNode> nodesOfferedExtJar;
    private final HashSet<PeerNode> nodesAskedSendMainJar;
    private final HashSet<PeerNode> nodesAskedSendExtJar;
    private final HashSet<PeerNode> nodesSendingMainJar;
    private final HashSet<PeerNode> nodesSendingExtJar;
    static final int MAX_NODES_SENDING_JAR = 2;
    static final int REQUEST_MAIN_JAR_TIMEOUT = 60000;
    public static final int GRACE_TIME = 10800000;
    private UserAlert alert;
    private static final Pattern extBuildNumberPattern;
    private static final Pattern mainBuildNumberPattern;
    private static final Pattern extTempBuildNumberPattern;
    private static final Pattern mainTempBuildNumberPattern;
    private static final Pattern revocationTempBuildNumberPattern;

    public UpdateOverMandatoryManager(NodeUpdateManager manager) {
        this.updateManager = manager;
        this.nodesSayKeyRevoked = new HashSet();
        this.nodesSayKeyRevokedFailedTransfer = new HashSet();
        this.nodesSayKeyRevokedTransferring = new HashSet();
        this.nodesOfferedMainJar = new HashSet();
        this.nodesOfferedExtJar = new HashSet();
        this.nodesAskedSendMainJar = new HashSet();
        this.nodesAskedSendExtJar = new HashSet();
        this.nodesSendingMainJar = new HashSet();
        this.nodesSendingExtJar = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleAnnounce(Message m, final PeerNode source) {
        long extraJarFileLength;
        long mainJarFileLength;
        long extraJarVersion;
        long mainJarVersion;
        String extraJarKey;
        String mainJarKey;
        block15: {
            mainJarKey = m.getString("mainJarKey");
            extraJarKey = m.getString("extraJarKey");
            String revocationKey = m.getString("revocationKey");
            boolean haveRevocationKey = m.getBoolean("haveRevocationKey");
            mainJarVersion = m.getLong("mainJarVersion");
            extraJarVersion = m.getLong("extJarVersion");
            long revocationKeyLastTried = m.getLong("revocationKeyTimeLastTried");
            int revocationKeyDNFs = m.getInt("revocationKeyDNFCount");
            long revocationKeyFileLength = m.getLong("revocationKeyFileLength");
            mainJarFileLength = m.getLong("mainJarFileLength");
            extraJarFileLength = m.getLong("extraJarFileLength");
            int pingTime = m.getInt("pingTime");
            int delayTime = m.getInt("bwlimitDelayTime");
            if (logMINOR) {
                Logger.minor(this, "Update Over Mandatory offer from node " + source.getPeer() + " : " + source.userToString() + ":");
                Logger.minor(this, "Main jar key: " + mainJarKey + " version=" + mainJarVersion + " length=" + mainJarFileLength);
                Logger.minor(this, "Extra jar key: " + extraJarKey + " version=" + extraJarVersion + " length=" + extraJarFileLength);
                Logger.minor(this, "Revocation key: " + revocationKey + " found=" + haveRevocationKey + " length=" + revocationKeyFileLength + " last had 3 DNFs " + revocationKeyLastTried + " ms ago, " + revocationKeyDNFs + " DNFs so far");
                Logger.minor(this, "Load stats: " + pingTime + "ms ping, " + delayTime + "ms bwlimit delay time");
            }
            if (haveRevocationKey) {
                if (this.updateManager.isBlown()) {
                    return true;
                }
                try {
                    FreenetURI revocationURI = new FreenetURI(revocationKey);
                    if (revocationURI.equals(this.updateManager.revocationURI)) {
                        UpdateOverMandatoryManager updateOverMandatoryManager = this;
                        synchronized (updateOverMandatoryManager) {
                            this.nodesSayKeyRevoked.add(source);
                        }
                        this.updateManager.peerClaimsKeyBlown();
                        this.alertUser();
                        System.err.println("Your peer " + source.userToString() + " says that the auto-update key is blown!");
                        System.err.println("Attempting to fetch it...");
                        Message msg = DMT.createUOMRequestRevocation(this.updateManager.node.random.nextLong());
                        source.sendAsync(msg, new AsyncMessageCallback(){

                            public void acknowledged() {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void disconnected() {
                                System.err.println("Failed to send request for revocation key to " + source.userToString() + " because it disconnected!");
                                UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                                synchronized (updateOverMandatoryManager) {
                                    UpdateOverMandatoryManager.this.nodesSayKeyRevokedFailedTransfer.add(source);
                                }
                            }

                            public void fatalError() {
                                System.err.println("Failed to send request for revocation key to " + source.userToString() + " because of a fatal error.");
                            }

                            public void sent() {
                            }
                        }, this.updateManager.ctr);
                        this.updateManager.node.getTicker().queueTimedJob(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                if (UpdateOverMandatoryManager.this.updateManager.isBlown()) {
                                    return;
                                }
                                UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                                synchronized (updateOverMandatoryManager) {
                                    if (UpdateOverMandatoryManager.this.nodesSayKeyRevokedFailedTransfer.contains(source)) {
                                        return;
                                    }
                                    if (UpdateOverMandatoryManager.this.nodesSayKeyRevokedTransferring.contains(source)) {
                                        return;
                                    }
                                    UpdateOverMandatoryManager.this.nodesSayKeyRevoked.remove(source);
                                }
                                System.err.println("Peer " + source + " said that the auto-update key had been blown, but did not transfer the revocation certificate. The most likely explanation is that the key has not been blown (the node is buggy or malicious), so we are ignoring this.");
                                UpdateOverMandatoryManager.this.maybeNotRevoked();
                            }
                        }, 60000L);
                        break block15;
                    }
                    Logger.normal(this, "Node " + source + " sent us a UOM claiming that the auto-update key was blown, but it used a different key to us: \nour key=" + this.updateManager.revocationURI + "\nhis key=" + revocationURI);
                }
                catch (MalformedURLException e) {
                    Logger.error(this, "Node " + source + " sent us a UOMAnnounce claiming that the auto-update key was blown, but it had an invalid revocation URI: " + revocationKey + " : " + e, e);
                    System.err.println("Node " + source.userToString() + " sent us a UOMAnnounce claiming that the revocation key was blown, but it had an invalid revocation URI: " + revocationKey + " : " + e);
                }
                catch (NotConnectedException e) {
                    System.err.println("Node " + source + " says that the auto-update key was blown, but has now gone offline! Something bad may be happening!");
                    Logger.error(this, "Node " + source + " says that the auto-update key was blown, but has now gone offline! Something bad may be happening!");
                    UpdateOverMandatoryManager updateOverMandatoryManager = this;
                    synchronized (updateOverMandatoryManager) {
                        this.nodesSayKeyRevokedFailedTransfer.add(source);
                    }
                }
            }
        }
        if (this.updateManager.isBlown()) {
            return true;
        }
        if (!this.updateManager.isEnabled()) {
            return true;
        }
        long now = System.currentTimeMillis();
        this.handleMainJarOffer(now, mainJarFileLength, mainJarVersion, source, mainJarKey);
        this.handleExtJarOffer(now, extraJarFileLength, extraJarVersion, source, extraJarKey);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMainJarOffer(long now, long mainJarFileLength, long mainJarVersion, PeerNode source, String jarKey) {
        block13: {
            long started = this.updateManager.getStartedFetchingNextMainJarTimestamp();
            long whenToTakeOverTheNormalUpdater = started > 0L ? started + 10800000L : System.currentTimeMillis() + 10800000L;
            boolean isOutdated = this.updateManager.node.isOudated();
            Logger.normal(this, "We received a valid UOMAnnounce (main) : (isOutdated=" + isOutdated + " version=" + mainJarVersion + " whenToTakeOverTheNormalUpdater=" + TimeUtil.formatTime(whenToTakeOverTheNormalUpdater - now) + ") file length " + mainJarFileLength + " updateManager version " + this.updateManager.newMainJarVersion());
            if (mainJarVersion > (long)Version.buildNumber() && mainJarFileLength > 0L && mainJarVersion > (long)this.updateManager.newMainJarVersion()) {
                source.setMainJarOfferedVersion(mainJarVersion);
                if (logMINOR) {
                    Logger.minor(this, "Offer is valid");
                }
                if (isOutdated || whenToTakeOverTheNormalUpdater < now) {
                    if (!isOutdated) {
                        String howLong = TimeUtil.formatTime(now - started);
                        Logger.error(this, "The update process seems to have been stuck for " + howLong + "; let's switch to UoM! SHOULD NOT HAPPEN! (1)");
                        System.out.println("The update process seems to have been stuck for " + howLong + "; let's switch to UoM! SHOULD NOT HAPPEN! (1)");
                    } else if (logMINOR) {
                        Logger.minor(this, "Fetching via UOM as our build is deprecated");
                    }
                    try {
                        FreenetURI mainJarURI = new FreenetURI(jarKey).setSuggestedEdition(mainJarVersion);
                        if (mainJarURI.equals(this.updateManager.updateURI.setSuggestedEdition(mainJarVersion))) {
                            this.sendUOMRequest(source, true, false);
                            break block13;
                        }
                        System.err.println("Node " + source.userToString() + " offered us a new main jar (version " + mainJarVersion + ") but his key was different to ours:\n" + "our key: " + this.updateManager.updateURI + "\nhis key:" + mainJarURI);
                    }
                    catch (MalformedURLException e) {
                        Logger.error(this, "Node " + source + " sent us a UOMAnnounce claiming to have a new ext jar, but it had an invalid URI: " + jarKey + " : " + e, e);
                        System.err.println("Node " + source.userToString() + " sent us a UOMAnnounce claiming to have a new ext jar, but it had an invalid URI: " + jarKey + " : " + e);
                    }
                } else {
                    UpdateOverMandatoryManager updateOverMandatoryManager = this;
                    synchronized (updateOverMandatoryManager) {
                        this.nodesOfferedMainJar.add(source);
                    }
                    this.updateManager.node.getTicker().queueTimedJob(new Runnable(){

                        public void run() {
                            if (UpdateOverMandatoryManager.this.updateManager.isBlown()) {
                                return;
                            }
                            if (!UpdateOverMandatoryManager.this.updateManager.isEnabled()) {
                                return;
                            }
                            if (UpdateOverMandatoryManager.this.updateManager.hasNewMainJar()) {
                                return;
                            }
                            if (!UpdateOverMandatoryManager.this.updateManager.node.isOudated()) {
                                Logger.error(this, "The update process seems to have been stuck for too long; let's switch to UoM! SHOULD NOT HAPPEN! (2) (ext)");
                                System.out.println("The update process seems to have been stuck for too long; let's switch to UoM! SHOULD NOT HAPPEN! (2) (ext)");
                            }
                            UpdateOverMandatoryManager.this.maybeRequestMainJar();
                        }
                    }, whenToTakeOverTheNormalUpdater - now);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExtJarOffer(long now, long extJarFileLength, long extJarVersion, PeerNode source, String jarKey) {
        block13: {
            long started = this.updateManager.getStartedFetchingNextExtJarTimestamp();
            long whenToTakeOverTheNormalUpdater = started > 0L ? started + 10800000L : System.currentTimeMillis() + 10800000L;
            boolean isOutdated = this.updateManager.node.isOudated();
            Logger.normal(this, "We received a valid UOMAnnounce (ext) : (isOutdated=" + isOutdated + " version=" + extJarVersion + " whenToTakeOverTheNormalUpdater=" + TimeUtil.formatTime(whenToTakeOverTheNormalUpdater - now) + ") file length " + extJarFileLength + " updateManager version " + this.updateManager.newExtJarVersion());
            if (extJarVersion > (long)NodeStarter.extBuildNumber && extJarFileLength > 0L && extJarVersion > (long)this.updateManager.newExtJarVersion()) {
                source.setExtJarOfferedVersion(extJarVersion);
                if (logMINOR) {
                    Logger.minor(this, "Offer is valid");
                }
                if (isOutdated || whenToTakeOverTheNormalUpdater < now) {
                    if (!isOutdated) {
                        String howLong = TimeUtil.formatTime(now - started);
                        Logger.error(this, "The update process seems to have been stuck for " + howLong + "; let's switch to UoM! SHOULD NOT HAPPEN! (1) (ext)");
                        System.out.println("The update process seems to have been stuck for " + howLong + "; let's switch to UoM! SHOULD NOT HAPPEN! (1) (ext)");
                    } else if (logMINOR) {
                        Logger.minor(this, "Fetching via UOM as our build is deprecated");
                    }
                    try {
                        FreenetURI extJarURI = new FreenetURI(jarKey).setSuggestedEdition(extJarVersion);
                        if (extJarURI.equals(this.updateManager.extURI.setSuggestedEdition(extJarVersion))) {
                            this.sendUOMRequest(source, true, true);
                            break block13;
                        }
                        System.err.println("Node " + source.userToString() + " offered us a new ext jar (version " + extJarVersion + ") but his key was different to ours:\n" + "our key: " + this.updateManager.extURI + "\nhis key:" + extJarURI);
                    }
                    catch (MalformedURLException e) {
                        Logger.error(this, "Node " + source + " sent us a UOMAnnounce claiming to have a new ext jar, but it had an invalid URI: " + jarKey + " : " + e, e);
                        System.err.println("Node " + source.userToString() + " sent us a UOMAnnounce claiming to have a new jar, but it had an invalid URI: " + jarKey + " : " + e);
                    }
                } else {
                    UpdateOverMandatoryManager updateOverMandatoryManager = this;
                    synchronized (updateOverMandatoryManager) {
                        this.nodesOfferedExtJar.add(source);
                    }
                    this.updateManager.node.getTicker().queueTimedJob(new Runnable(){

                        public void run() {
                            if (UpdateOverMandatoryManager.this.updateManager.isBlown()) {
                                return;
                            }
                            if (!UpdateOverMandatoryManager.this.updateManager.isEnabled()) {
                                return;
                            }
                            if (UpdateOverMandatoryManager.this.updateManager.hasNewExtJar()) {
                                return;
                            }
                            if (!UpdateOverMandatoryManager.this.updateManager.node.isOudated()) {
                                Logger.error(this, "The update process seems to have been stuck for too long; let's switch to UoM! SHOULD NOT HAPPEN! (2)");
                                System.out.println("The update process seems to have been stuck for too long; let's switch to UoM! SHOULD NOT HAPPEN! (2)");
                            }
                            UpdateOverMandatoryManager.this.maybeRequestExtJar();
                        }
                    }, whenToTakeOverTheNormalUpdater - now);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUOMRequest(final PeerNode source, boolean addOnFail, final boolean isExt) {
        String lname;
        final String name = isExt ? "Extra" : "Main";
        String string = lname = isExt ? "ext" : "main";
        if (logMINOR) {
            Logger.minor(this, "sendUOMRequest" + name + "(" + source + "," + addOnFail + ")");
        }
        if (!source.isConnected()) {
            return;
        }
        final HashSet<PeerNode> sendingJar = isExt ? this.nodesSendingExtJar : this.nodesSendingMainJar;
        final HashSet<PeerNode> askedSendJar = isExt ? this.nodesAskedSendExtJar : this.nodesAskedSendMainJar;
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            int curVersion;
            long updateVersion;
            long offeredVersion = isExt ? source.getExtJarOfferedVersion() : source.getMainJarOfferedVersion();
            long l = updateVersion = isExt ? (long)this.updateManager.newExtJarVersion() : (long)this.updateManager.newMainJarVersion();
            if (offeredVersion < updateVersion) {
                if (offeredVersion <= 0L) {
                    Logger.error(this, "Not sending UOM " + lname + " request to " + source + " because it hasn't offered anything!");
                } else if (logMINOR) {
                    Logger.minor(this, "Not sending UOM " + lname + " request to " + source + " because we already have its offered version " + offeredVersion);
                }
                return;
            }
            int n = curVersion = isExt ? this.updateManager.getExtVersion() : this.updateManager.getMainVersion();
            if ((long)curVersion >= offeredVersion) {
                if (logMINOR) {
                    Logger.minor(this, "Not fetching from " + source + " because current " + lname + " jar version " + curVersion + " is more recent than " + offeredVersion);
                }
                return;
            }
            if (askedSendJar.contains(source)) {
                if (logMINOR) {
                    Logger.minor(this, "Recently asked node " + source + " (" + lname + ") so not re-asking yet.");
                }
                return;
            }
            if (addOnFail && askedSendJar.size() + sendingJar.size() >= 2) {
                HashSet<PeerNode> offeredJar;
                HashSet<PeerNode> hashSet = offeredJar = isExt ? this.nodesOfferedExtJar : this.nodesOfferedMainJar;
                if (offeredJar.add(source)) {
                    System.err.println("Offered " + lname + " jar by " + source.userToString() + " (already fetching from " + sendingJar.size() + "), but will use this offer if our current fetches fail).");
                }
                return;
            }
            if (sendingJar.contains(source)) {
                if (logMINOR) {
                    Logger.minor(this, "Not fetching " + lname + " jar from " + source.userToString() + " because already fetching from that node");
                }
                return;
            }
            sendingJar.add(source);
        }
        Message msg = isExt ? DMT.createUOMRequestExtra(this.updateManager.node.random.nextLong()) : DMT.createUOMRequestMain(this.updateManager.node.random.nextLong());
        try {
            System.err.println("Fetching " + lname + " jar from " + source.userToString());
            source.sendAsync(msg, new AsyncMessageCallback(){

                public void acknowledged() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void disconnected() {
                    Logger.normal(this, "Disconnected from " + source.userToString() + " after sending UOMRequest" + name);
                    UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                    synchronized (updateOverMandatoryManager) {
                        sendingJar.remove(source);
                    }
                    if (isExt) {
                        UpdateOverMandatoryManager.this.maybeRequestExtJar();
                    } else {
                        UpdateOverMandatoryManager.this.maybeRequestMainJar();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fatalError() {
                    Logger.normal(this, "Fatal error from " + source.userToString() + " after sending UOMRequest" + name);
                    UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                    synchronized (updateOverMandatoryManager) {
                        askedSendJar.remove(source);
                    }
                    if (isExt) {
                        UpdateOverMandatoryManager.this.maybeRequestExtJar();
                    } else {
                        UpdateOverMandatoryManager.this.maybeRequestMainJar();
                    }
                }

                public void sent() {
                    UpdateOverMandatoryManager.this.updateManager.node.ps.queueTimedJob(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                            synchronized (updateOverMandatoryManager) {
                                if (!askedSendJar.contains(source)) {
                                    return;
                                }
                                askedSendJar.remove(source);
                            }
                            if (isExt) {
                                UpdateOverMandatoryManager.this.maybeRequestExtJar();
                            } else {
                                UpdateOverMandatoryManager.this.maybeRequestMainJar();
                            }
                        }
                    }, 60000L);
                }
            }, this.updateManager.ctr);
        }
        catch (NotConnectedException e) {
            UpdateOverMandatoryManager updateOverMandatoryManager2 = this;
            synchronized (updateOverMandatoryManager2) {
                askedSendJar.remove(source);
            }
            if (isExt) {
                this.maybeRequestExtJar();
            }
            this.maybeRequestMainJar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeRequestMainJar() {
        PeerNode[] offers;
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            if (this.nodesAskedSendMainJar.size() + this.nodesSendingMainJar.size() >= 2) {
                return;
            }
            if (this.nodesOfferedMainJar.isEmpty()) {
                return;
            }
            offers = this.nodesOfferedMainJar.toArray(new PeerNode[this.nodesOfferedMainJar.size()]);
        }
        for (int i = 0; i < offers.length; ++i) {
            if (!offers[i].isConnected()) continue;
            UpdateOverMandatoryManager updateOverMandatoryManager2 = this;
            synchronized (updateOverMandatoryManager2) {
                if (this.nodesAskedSendMainJar.size() + this.nodesSendingMainJar.size() >= 2) {
                    return;
                }
                if (this.nodesSendingMainJar.contains(offers[i])) {
                    continue;
                }
                if (this.nodesAskedSendMainJar.contains(offers[i])) {
                    continue;
                }
            }
            this.sendUOMRequest(offers[i], false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeRequestExtJar() {
        PeerNode[] offers;
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            if (this.nodesAskedSendExtJar.size() + this.nodesSendingExtJar.size() >= 2) {
                return;
            }
            if (this.nodesOfferedExtJar.isEmpty()) {
                return;
            }
            offers = this.nodesOfferedExtJar.toArray(new PeerNode[this.nodesOfferedExtJar.size()]);
        }
        for (int i = 0; i < offers.length; ++i) {
            if (!offers[i].isConnected()) continue;
            UpdateOverMandatoryManager updateOverMandatoryManager2 = this;
            synchronized (updateOverMandatoryManager2) {
                if (this.nodesAskedSendExtJar.size() + this.nodesSendingExtJar.size() >= 2) {
                    return;
                }
                if (this.nodesSendingExtJar.contains(offers[i])) {
                    continue;
                }
                if (this.nodesAskedSendExtJar.contains(offers[i])) {
                    continue;
                }
            }
            this.sendUOMRequest(offers[i], false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alertUser() {
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            if (this.alert != null) {
                return;
            }
            this.alert = new PeersSayKeyBlownAlert();
        }
        this.updateManager.node.clientCore.alerts.register(this.alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerNode[][] getNodesSayBlown() {
        Vector<PeerNode> nodesConnectedSayRevoked = new Vector<PeerNode>();
        Vector<PeerNode> nodesDisconnectedSayRevoked = new Vector<PeerNode>();
        Vector<PeerNode> nodesFailedSayRevoked = new Vector<PeerNode>();
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            PeerNode[] nodesSayRevoked = this.nodesSayKeyRevoked.toArray(new PeerNode[this.nodesSayKeyRevoked.size()]);
            for (int i = 0; i < nodesSayRevoked.length; ++i) {
                PeerNode pn = nodesSayRevoked[i];
                if (this.nodesSayKeyRevokedFailedTransfer.contains(pn)) {
                    nodesFailedSayRevoked.add(pn);
                    continue;
                }
                nodesConnectedSayRevoked.add(pn);
            }
        }
        for (int i = 0; i < nodesConnectedSayRevoked.size(); ++i) {
            PeerNode pn = (PeerNode)nodesConnectedSayRevoked.get(i);
            if (pn.isConnected()) continue;
            nodesDisconnectedSayRevoked.add(pn);
            nodesConnectedSayRevoked.remove(i);
            --i;
        }
        return new PeerNode[][]{nodesConnectedSayRevoked.toArray(new PeerNode[nodesConnectedSayRevoked.size()]), nodesDisconnectedSayRevoked.toArray(new PeerNode[nodesDisconnectedSayRevoked.size()]), nodesFailedSayRevoked.toArray(new PeerNode[nodesFailedSayRevoked.size()])};
    }

    public boolean handleRequestRevocation(Message m, final PeerNode source) {
        BulkTransmitter bt;
        PartiallyReceivedBulk prb;
        long length;
        RandomAccessFileWrapper raf;
        File data = this.updateManager.revocationChecker.getBlobFile();
        if (data == null) {
            Logger.normal(this, "Peer " + source + " asked us for the blob file for the revocation key but we don't have it!");
            return true;
        }
        final long uid = m.getLong("uid");
        try {
            raf = new RandomAccessFileWrapper(data, "r");
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, we have downloaded it but don't have the file even though we did have it when we checked!: " + e, e);
            return true;
        }
        try {
            length = raf.size();
            prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, raf, true);
        }
        catch (IOException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, we have downloaded it but we can't determine the file size: " + e, e);
            return true;
        }
        try {
            bt = new BulkTransmitter(prb, source, uid, false, this.updateManager.ctr);
        }
        catch (DisconnectedException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, then disconnected: " + e, e);
            return true;
        }
        final Runnable r = new Runnable(){

            public void run() {
                if (!bt.send()) {
                    Logger.error(this, "Failed to send revocation key blob to " + source.userToString() + " : " + bt.getCancelReason());
                } else {
                    Logger.normal(this, "Sent revocation key blob to " + source.userToString());
                }
            }
        };
        Message msg = DMT.createUOMSendingRevocation(uid, length, this.updateManager.revocationURI.toString());
        try {
            source.sendAsync(msg, new AsyncMessageCallback(){

                public void acknowledged() {
                    if (logMINOR) {
                        Logger.minor(this, "Sending data...");
                    }
                    UpdateOverMandatoryManager.this.updateManager.node.executor.execute(r, "Revocation key send for " + uid + " to " + source.userToString());
                }

                public void disconnected() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, then disconnected when we tried to send the UOMSendingRevocation");
                }

                public void fatalError() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, then got a fatal error when we tried to send the UOMSendingRevocation");
                }

                public void sent() {
                    if (logMINOR) {
                        Logger.minor(this, "Message sent, data soon");
                    }
                }

                public String toString() {
                    return super.toString() + "(" + uid + ":" + source.getPeer() + ")";
                }
            }, this.updateManager.ctr);
        }
        catch (NotConnectedException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, then disconnected when we tried to send the UOMSendingRevocation: " + e, e);
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSendingRevocation(Message m, final PeerNode source) {
        RandomAccessFileWrapper raf;
        File temp;
        FreenetURI revocationURI;
        long uid = m.getLong("uid");
        long length = m.getLong("fileLength");
        String key = m.getString("revocationKey");
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            this.nodesSayKeyRevokedTransferring.add(source);
        }
        try {
            revocationURI = new FreenetURI(key);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Failed receiving recovation because URI not parsable: " + e + " for " + key, e);
            System.err.println("Failed receiving recovation because URI not parsable: " + e + " for " + key);
            e.printStackTrace();
            UpdateOverMandatoryManager updateOverMandatoryManager2 = this;
            synchronized (updateOverMandatoryManager2) {
                this.nodesSayKeyRevokedFailedTransfer.add(source);
                this.nodesSayKeyRevokedTransferring.remove(source);
            }
            this.cancelSend(source, uid);
            this.maybeNotRevoked();
            return true;
        }
        if (!revocationURI.equals(this.updateManager.revocationURI)) {
            System.err.println("Node sending us a revocation certificate from the wrong URI:\nNode: " + source.userToString() + "\n" + "Our   URI: " + this.updateManager.revocationURI + "\n" + "Their URI: " + revocationURI);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesSayKeyRevoked.remove(source);
                this.nodesSayKeyRevokedFailedTransfer.add(source);
                this.nodesSayKeyRevokedTransferring.remove(source);
            }
            this.cancelSend(source, uid);
            this.maybeNotRevoked();
            return true;
        }
        if (this.updateManager.isBlown()) {
            if (logMINOR) {
                Logger.minor(this, "Already blown, so not receiving from " + source + "(" + uid + ")");
            }
            this.cancelSend(source, uid);
            return true;
        }
        if (length > 0x400000L) {
            System.err.println("Node " + source.userToString() + " offered us a revocation certificate " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer.");
            Logger.error(this, "Node " + source.userToString() + " offered us a revocation certificate " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer.");
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesSayKeyRevoked.remove(source);
                this.nodesSayKeyRevokedFailedTransfer.add(source);
                this.nodesSayKeyRevokedTransferring.remove(source);
            }
            this.cancelSend(source, uid);
            this.maybeNotRevoked();
            return true;
        }
        if (length <= 0L) {
            System.err.println("Revocation key is zero bytes from " + source + " - ignoring as this is almost certainly a bug or an attack, it is definitely not valid.");
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesSayKeyRevoked.remove(source);
                this.nodesSayKeyRevokedFailedTransfer.add(source);
                this.nodesSayKeyRevokedTransferring.remove(source);
            }
            this.cancelSend(source, uid);
            this.maybeNotRevoked();
            return true;
        }
        System.err.println("Transferring auto-updater revocation certificate length " + length + " from " + source);
        try {
            temp = File.createTempFile("revocation-", ".fblob.tmp", this.updateManager.node.clientCore.getPersistentTempDir());
            temp.deleteOnExit();
        }
        catch (IOException e) {
            System.err.println("Cannot save revocation certificate to disk and therefore cannot fetch it from our peer!: " + e);
            e.printStackTrace();
            this.updateManager.blow("Cannot fetch the revocation certificate from our peer because we cannot write it to disk: " + e);
            this.cancelSend(source, uid);
            return true;
        }
        try {
            raf = new RandomAccessFileWrapper(temp, "rw");
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, we have downloaded it but don't have the file even though we did have it when we checked!: " + e, e);
            this.updateManager.blow("Internal error after fetching the revocation certificate from our peer, maybe out of disk space, file disappeared " + temp + " : " + e);
            return true;
        }
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, raf, false);
        final BulkReceiver br = new BulkReceiver(prb, source, uid, this.updateManager.ctr);
        this.updateManager.node.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                UpdateOverMandatoryManager updateOverMandatoryManager;
                try {
                    try {
                        if (br.receive()) {
                            UpdateOverMandatoryManager.this.processRevocationBlob(temp, source);
                        }
                        Logger.error(this, "Failed to transfer revocation certificate from " + source);
                        System.err.println("Failed to transfer revocation certificate from " + source);
                        UpdateOverMandatoryManager updateOverMandatoryManager2 = UpdateOverMandatoryManager.this;
                        synchronized (updateOverMandatoryManager2) {
                            UpdateOverMandatoryManager.this.nodesSayKeyRevokedFailedTransfer.add(source);
                        }
                        UpdateOverMandatoryManager.this.maybeNotRevoked();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught error while transferring revocation certificate from " + source + " : " + t, t);
                        System.err.println("Peer " + source + " said that the revocation key has been blown, but we got an internal error while transferring it:");
                        t.printStackTrace();
                        UpdateOverMandatoryManager.this.updateManager.blow("Internal error while fetching the revocation certificate from our peer " + source + " : " + t);
                        Object var4_4 = null;
                        UpdateOverMandatoryManager updateOverMandatoryManager2 = UpdateOverMandatoryManager.this;
                        synchronized (updateOverMandatoryManager2) {
                            UpdateOverMandatoryManager.this.nodesSayKeyRevokedTransferring.remove(source);
                            return;
                        }
                    }
                    Object var4_3 = null;
                    updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    UpdateOverMandatoryManager updateOverMandatoryManager4 = UpdateOverMandatoryManager.this;
                    synchronized (updateOverMandatoryManager4) {
                        UpdateOverMandatoryManager.this.nodesSayKeyRevokedTransferring.remove(source);
                        throw throwable;
                    }
                }
                synchronized (updateOverMandatoryManager) {
                    UpdateOverMandatoryManager.this.nodesSayKeyRevokedTransferring.remove(source);
                    return;
                }
            }
        }, "Revocation key receive for " + uid + " from " + source.userToString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeNotRevoked() {
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            if (!this.updateManager.peersSayBlown()) {
                return;
            }
            if (this.mightBeRevoked()) {
                return;
            }
            this.updateManager.notPeerClaimsKeyBlown();
        }
    }

    private synchronized boolean mightBeRevoked() {
        if (!this.nodesSayKeyRevoked.isEmpty()) {
            return true;
        }
        if (this.nodesSayKeyRevokedFailedTransfer.size() >= 3) {
            return true;
        }
        return !this.nodesSayKeyRevokedTransferring.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void processRevocationBlob(final File temp, final PeerNode source) {
        block31: {
            blocks = new SimpleBlockSet();
            dis = null;
            try {
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(temp)));
                BinaryBlob.readBinaryBlob((DataInputStream)dis, blocks, true);
                var10_5 = null;
                ** if (dis == null) goto lbl-1000
            }
            catch (Throwable var9_29) {
                var10_10 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var9_29;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block31;
                catch (FileNotFoundException e) {
                    Logger.error(this, "Somebody deleted " + temp + " ? We lost the revocation certificate from " + source.userToString() + "!");
                    System.err.println("Somebody deleted " + temp + " ? We lost the revocation certificate from " + source.userToString() + "!");
                    this.updateManager.blow("Somebody deleted " + temp + " ? We lost the revocation certificate from " + source.userToString() + "!");
                    var10_6 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (EOFException e) {
                    Logger.error(this, "Peer " + source.userToString() + " sent us an invalid revocation certificate! (data too short, might be truncated): " + e + " (data in " + temp + ")", e);
                    System.err.println("Peer " + source.userToString() + " sent us an invalid revocation certificate! (data too short, might be truncated): " + e + " (data in " + temp + ")");
                    e.printStackTrace();
                    var6_22 = this;
                    synchronized (var6_22) {
                        this.nodesSayKeyRevokedFailedTransfer.add(source);
                    }
                    var10_7 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (BinaryBlobFormatException e) {
                    Logger.error(this, "Peer " + source.userToString() + " sent us an invalid revocation certificate!: " + e + " (data in " + temp + ")", e);
                    System.err.println("Peer " + source.userToString() + " sent us an invalid revocation certificate!: " + e + " (data in " + temp + ")");
                    e.printStackTrace();
                    var6_23 = this;
                    synchronized (var6_23) {
                        this.nodesSayKeyRevokedFailedTransfer.add(source);
                    }
                    var10_8 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    Logger.error(this, "Could not read revocation cert from temp file " + temp + " from node " + source.userToString() + " ! : " + e, e);
                    System.err.println("Could not read revocation cert from temp file " + temp + " from node " + source.userToString() + " ! : " + e);
                    e.printStackTrace();
                    this.updateManager.blow("Could not read revocation cert from temp file " + temp + " from node " + source.userToString() + " ! : " + e);
                    var10_9 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        seedContext = this.updateManager.node.clientCore.makeClient((short)0, true).getFetchContext();
        tempContext = new FetchContext(seedContext, 0, true, blocks);
        tempContext.localRequestOnly = true;
        b = null;
        try {
            f = File.createTempFile("revocation-", ".fblob.tmp", this.updateManager.node.clientCore.getPersistentTempDir());
            b = new FileBucket(f, false, false, true, true, true);
        }
        catch (IOException e) {
            Logger.error(this, "Cannot share revocation key from " + source.userToString() + " with our peers because cannot write the cleaned version to disk: " + e, e);
            System.err.println("Cannot share revocation key from " + source.userToString() + " with our peers because cannot write the cleaned version to disk: " + e);
            e.printStackTrace();
            b = null;
            f = null;
        }
        cleanedBlob = b;
        cleanedBlobFile = f;
        myCallback = new ClientGetCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
                if (e.mode == 25) {
                    Logger.error(this, "Cancelled fetch from store/blob of revocation certificate from " + source.userToString());
                    System.err.println("Cancelled fetch from store/blob of revocation certificate from " + source.userToString() + " to " + temp + " - please report to developers");
                } else if (e.isFatal()) {
                    System.err.println("Got revocation certificate from " + source.userToString() + " (fatal error i.e. someone with the key inserted bad data) : " + e);
                    UpdateOverMandatoryManager.this.updateManager.revocationChecker.onFailure(e, state, cleanedBlobFile);
                    temp.delete();
                    UpdateOverMandatoryManager.this.insertBlob(UpdateOverMandatoryManager.this.updateManager.revocationChecker.getBlobFile(), "revocation");
                } else {
                    Logger.error(this, "Failed to fetch revocation certificate from blob from " + source.userToString() + " : " + e);
                    System.err.println("Failed to fetch revocation certificate from blob from " + source.userToString() + " : " + e);
                    UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                    synchronized (updateOverMandatoryManager) {
                        UpdateOverMandatoryManager.this.nodesSayKeyRevokedFailedTransfer.add(source);
                    }
                }
            }

            public void onMajorProgress(ObjectContainer container) {
            }

            public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
                System.err.println("Got revocation certificate from " + source.userToString());
                UpdateOverMandatoryManager.this.updateManager.revocationChecker.onSuccess(result, state, cleanedBlobFile);
                temp.delete();
                UpdateOverMandatoryManager.this.insertBlob(UpdateOverMandatoryManager.this.updateManager.revocationChecker.getBlobFile(), "revocation");
            }
        };
        cg = new ClientGetter(myCallback, this.updateManager.revocationURI, tempContext, 0, (RequestClient)this, null, (Bucket)cleanedBlob);
        try {
            this.updateManager.node.clientCore.clientContext.start(cg);
        }
        catch (FetchException e1) {
            System.err.println("Failed to decode UOM blob: " + e1);
            e1.printStackTrace();
            myCallback.onFailure(e1, cg, null);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
    }

    protected void insertBlob(File blob, final String type) {
        ClientPutCallback callback = new ClientPutCallback(){

            public void onFailure(InsertException e, BaseClientPutter state, ObjectContainer container) {
                Logger.error(this, "Failed to insert " + type + " binary blob: " + e, e);
            }

            public void onFetchable(BaseClientPutter state, ObjectContainer container) {
            }

            public void onGeneratedURI(FreenetURI uri, BaseClientPutter state, ObjectContainer container) {
            }

            public void onMajorProgress(ObjectContainer container) {
            }

            public void onSuccess(BaseClientPutter state, ObjectContainer container) {
                Logger.normal(this, "Inserted " + type + " binary blob");
            }
        };
        FileBucket bucket = new FileBucket(blob, true, false, false, false, false);
        ClientPutter putter = new ClientPutter(callback, (Bucket)bucket, FreenetURI.EMPTY_CHK_URI, null, this.updateManager.node.clientCore.makeClient((short)1).getInsertContext(true), 1, false, false, (RequestClient)this, null, null, true);
        try {
            this.updateManager.node.clientCore.clientContext.start(putter, false);
        }
        catch (InsertException e1) {
            Logger.error(this, "Failed to start insert of " + type + " binary blob: " + e1, e1);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
    }

    private void cancelSend(PeerNode source, long uid) {
        Message msg = DMT.createFNPBulkReceiveAborted(uid);
        try {
            source.sendAsync(msg, null, this.updateManager.ctr);
        }
        catch (NotConnectedException e1) {
            // empty catch block
        }
    }

    public void killAlert() {
        this.updateManager.node.clientCore.alerts.unregister(this.alert);
    }

    public boolean handleRequestJar(Message m, final PeerNode source, boolean isExt) {
        BulkTransmitter bt;
        PartiallyReceivedBulk prb;
        long length;
        RandomAccessFileWrapper raf;
        String name;
        int version = isExt ? this.updateManager.newExtJarVersion() : this.updateManager.newMainJarVersion();
        File data = isExt ? this.updateManager.getExtBlob(version) : this.updateManager.getMainBlob(version);
        String string = name = isExt ? "ext" : "main";
        if (data == null) {
            Logger.normal(this, "Peer " + source + " asked us for the blob file for the " + name + " jar but we don't have it!");
            return true;
        }
        final long uid = m.getLong("uid");
        try {
            raf = new RandomAccessFileWrapper(data, "r");
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, we have downloaded it but don't have the file even though we did have it when we checked!: " + e, e);
            return true;
        }
        try {
            length = raf.size();
            prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, raf, true);
        }
        catch (IOException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, we have downloaded it but we can't determine the file size: " + e, e);
            return true;
        }
        try {
            bt = new BulkTransmitter(prb, source, uid, false, this.updateManager.ctr);
        }
        catch (DisconnectedException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, then disconnected: " + e, e);
            return true;
        }
        final Runnable r = new Runnable(){

            public void run() {
                if (!bt.send()) {
                    Logger.error(this, "Failed to send " + name + " jar blob to " + source.userToString() + " : " + bt.getCancelReason());
                } else {
                    Logger.normal(this, "Sent " + name + " jar blob to " + source.userToString());
                }
            }
        };
        Message msg = isExt ? DMT.createUOMSendingExtra(uid, length, this.updateManager.extURI.toString(), version) : DMT.createUOMSendingMain(uid, length, this.updateManager.updateURI.toString(), version);
        try {
            source.sendAsync(msg, new AsyncMessageCallback(){

                public void acknowledged() {
                    if (logMINOR) {
                        Logger.minor(this, "Sending data...");
                    }
                    UpdateOverMandatoryManager.this.updateManager.node.executor.execute(r, name + " jar send for " + uid + " to " + source.userToString());
                }

                public void disconnected() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, then disconnected when we tried to send the UOMSendingMain");
                }

                public void fatalError() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, then got a fatal error when we tried to send the UOMSendingMain");
                }

                public void sent() {
                    if (logMINOR) {
                        Logger.minor(this, "Message sent, data soon");
                    }
                }

                public String toString() {
                    return super.toString() + "(" + uid + ":" + source.getPeer() + ")";
                }
            }, this.updateManager.ctr);
        }
        catch (NotConnectedException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, then disconnected when we tried to send the UOMSendingExt: " + e, e);
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSendingMain(Message m, final PeerNode source) {
        RandomAccessFileWrapper raf;
        File temp;
        FreenetURI jarURI;
        long uid = m.getLong("uid");
        long length = m.getLong("fileLength");
        String key = m.getString("mainJarKey");
        final int version = m.getInt("mainJarVersion");
        try {
            jarURI = new FreenetURI(key).setSuggestedEdition(version);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Failed receiving main jar " + version + " because URI not parsable: " + e + " for " + key, e);
            System.err.println("Failed receiving main jar " + version + " because URI not parsable: " + e + " for " + key);
            e.printStackTrace();
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        if (!jarURI.equals(this.updateManager.updateURI.setSuggestedEdition(version))) {
            System.err.println("Node sending us a main jar update (" + version + ") from the wrong URI:\n" + "Node: " + source.userToString() + "\n" + "Our   URI: " + this.updateManager.updateURI + "\n" + "Their URI: " + jarURI);
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        if (this.updateManager.isBlown()) {
            if (logMINOR) {
                Logger.minor(this, "Key blown, so not receiving main jar from " + source + "(" + uid + ")");
            }
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        if (length > 0x1000000L) {
            System.err.println("Node " + source.userToString() + " offered us a main jar (" + version + ") " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer.");
            Logger.error(this, "Node " + source.userToString() + " offered us a main jar (" + version + ") " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer.");
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        try {
            temp = File.createTempFile("main-", ".fblob.tmp", this.updateManager.node.clientCore.getPersistentTempDir());
            temp.deleteOnExit();
        }
        catch (IOException e) {
            System.err.println("Cannot save new main jar to disk and therefore cannot fetch it from our peer!: " + e);
            e.printStackTrace();
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        try {
            raf = new RandomAccessFileWrapper(temp, "rw");
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Peer " + source + " sending us a main jar binary blob, but we lost the temp file " + temp + " : " + e, e);
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, raf, false);
        final BulkReceiver br = new BulkReceiver(prb, source, uid, this.updateManager.ctr);
        this.updateManager.node.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Class<UpdateOverMandatoryManager> clazz = UpdateOverMandatoryManager.class;
                    synchronized (UpdateOverMandatoryManager.class) {
                        UpdateOverMandatoryManager.this.nodesAskedSendMainJar.remove(source);
                        UpdateOverMandatoryManager.this.nodesSendingMainJar.add(source);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        if (br.receive()) {
                            UpdateOverMandatoryManager.this.processMainJarBlob(temp, source, version, jarURI);
                        } else {
                            Logger.error(this, "Failed to transfer main jar " + version + " from " + source);
                            System.err.println("Failed to transfer main jar " + version + " from " + source);
                        }
                        Object var4_3 = null;
                        Class<UpdateOverMandatoryManager> clazz2 = UpdateOverMandatoryManager.class;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Class<UpdateOverMandatoryManager> clazz = UpdateOverMandatoryManager.class;
                    synchronized (UpdateOverMandatoryManager.class) {
                        UpdateOverMandatoryManager.this.nodesSendingMainJar.remove(source);
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        throw throwable;
                    }
                }
                {
                    synchronized (UpdateOverMandatoryManager.class) {
                        UpdateOverMandatoryManager.this.nodesSendingMainJar.remove(source);
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                }
            }
        }, "Main jar (" + version + ") receive for " + uid + " from " + source.userToString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSendingExt(Message m, final PeerNode source) {
        RandomAccessFileWrapper raf;
        File temp;
        FreenetURI jarURI;
        long uid = m.getLong("uid");
        long length = m.getLong("fileLength");
        String key = m.getString("extraJarKey");
        final int version = m.getInt("extJarVersion");
        try {
            jarURI = new FreenetURI(key).setSuggestedEdition(version);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Failed receiving ext jar " + version + " because URI not parsable: " + e + " for " + key, e);
            System.err.println("Failed receiving ext jar " + version + " because URI not parsable: " + e + " for " + key);
            e.printStackTrace();
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesAskedSendExtJar.remove(source);
            }
            return true;
        }
        if (!jarURI.equals(this.updateManager.extURI.setSuggestedEdition(version))) {
            System.err.println("Node sending us a ext jar update (" + version + ") from the wrong URI:\n" + "Node: " + source.userToString() + "\n" + "Our   URI: " + this.updateManager.extURI + "\n" + "Their URI: " + jarURI);
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesAskedSendExtJar.remove(source);
            }
            return true;
        }
        if (this.updateManager.isBlown()) {
            if (logMINOR) {
                Logger.minor(this, "Key blown, so not receiving main jar from " + source + "(" + uid + ")");
            }
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesAskedSendExtJar.remove(source);
            }
            return true;
        }
        if (length > 0x1000000L) {
            System.err.println("Node " + source.userToString() + " offered us a ext jar (" + version + ") " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer.");
            Logger.error(this, "Node " + source.userToString() + " offered us a ext jar (" + version + ") " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer.");
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesAskedSendExtJar.remove(source);
            }
            return true;
        }
        try {
            temp = File.createTempFile("ext-", ".fblob.tmp", this.updateManager.node.clientCore.getPersistentTempDir());
            temp.deleteOnExit();
        }
        catch (IOException e) {
            System.err.println("Cannot save new ext jar to disk and therefore cannot fetch it from our peer!: " + e);
            e.printStackTrace();
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesAskedSendExtJar.remove(source);
            }
            return true;
        }
        try {
            raf = new RandomAccessFileWrapper(temp, "rw");
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Peer " + source + " sending us a ext jar binary blob, but we lost the temp file " + temp + " : " + e, e);
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesAskedSendExtJar.remove(source);
            }
            return true;
        }
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, raf, false);
        final BulkReceiver br = new BulkReceiver(prb, source, uid, this.updateManager.ctr);
        this.updateManager.node.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Class<UpdateOverMandatoryManager> clazz = UpdateOverMandatoryManager.class;
                    synchronized (UpdateOverMandatoryManager.class) {
                        UpdateOverMandatoryManager.this.nodesAskedSendExtJar.remove(source);
                        UpdateOverMandatoryManager.this.nodesSendingExtJar.add(source);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        if (br.receive()) {
                            UpdateOverMandatoryManager.this.processExtJarBlob(temp, source, version, jarURI);
                        } else {
                            Logger.error(this, "Failed to transfer ext jar " + version + " from " + source);
                            System.err.println("Failed to transfer ext jar " + version + " from " + source);
                        }
                        Object var4_3 = null;
                        Class<UpdateOverMandatoryManager> clazz2 = UpdateOverMandatoryManager.class;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Class<UpdateOverMandatoryManager> clazz = UpdateOverMandatoryManager.class;
                    synchronized (UpdateOverMandatoryManager.class) {
                        UpdateOverMandatoryManager.this.nodesSendingExtJar.remove(source);
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        throw throwable;
                    }
                }
                {
                    synchronized (UpdateOverMandatoryManager.class) {
                        UpdateOverMandatoryManager.this.nodesSendingExtJar.remove(source);
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                }
            }
        }, "Ext jar (" + version + ") receive for " + uid + " from " + source.userToString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void processMainJarBlob(final File temp, final PeerNode source, final int version, FreenetURI uri) {
        block22: {
            blocks = new SimpleBlockSet();
            dis = null;
            try {
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(temp)));
                BinaryBlob.readBinaryBlob((DataInputStream)dis, blocks, true);
                var9_7 = null;
                ** if (dis == null) goto lbl-1000
            }
            catch (Throwable var8_21) {
                var9_11 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var8_21;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block22;
                catch (FileNotFoundException e) {
                    Logger.error(this, "Somebody deleted " + temp + " ? We lost the main jar (" + version + ") from " + source.userToString() + "!");
                    System.err.println("Somebody deleted " + temp + " ? We lost the main jar (" + version + ") from " + source.userToString() + "!");
                    var9_8 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    Logger.error(this, "Could not read main jar (" + version + ") from temp file " + temp + " from node " + source.userToString() + " !");
                    System.err.println("Could not read main jar (" + version + ") from temp file " + temp + " from node " + source.userToString() + " !");
                    var9_9 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (BinaryBlobFormatException e) {
                    Logger.error(this, "Peer " + source.userToString() + " sent us an invalid main jar (" + version + ")!: " + e, e);
                    System.err.println("Peer " + source.userToString() + " sent us an invalid main jar (" + version + ")!: " + e);
                    e.printStackTrace();
                    var9_10 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        seedContext = this.updateManager.node.clientCore.makeClient((short)0, true).getFetchContext();
        tempContext = new FetchContext(seedContext, 0, true, blocks);
        tempContext.localRequestOnly = true;
        b = null;
        try {
            f = File.createTempFile("main-", ".fblob.tmp", this.updateManager.node.clientCore.getPersistentTempDir());
            f.deleteOnExit();
            b = new FileBucket(f, false, false, true, true, true);
        }
        catch (IOException e) {
            Logger.error(this, "Cannot share main jar from " + source.userToString() + " with our peers because cannot write the cleaned version to disk: " + e, e);
            System.err.println("Cannot share main jar from " + source.userToString() + " with our peers because cannot write the cleaned version to disk: " + e);
            e.printStackTrace();
            b = null;
            f = null;
        }
        cleanedBlob = b;
        cleanedBlobFile = f;
        myCallback = new ClientGetCallback(){

            public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
                if (e.mode == 25) {
                    Logger.error(this, "Cancelled fetch from store/blob of main jar (" + version + ") from " + source.userToString());
                    System.err.println("Cancelled fetch from store/blob of main jar (" + version + ") from " + source.userToString() + " to " + temp + " - please report to developers");
                } else if (e.isFatal()) {
                    temp.delete();
                    Logger.error(this, "Failed to fetch main jar " + version + " from " + source.userToString() + " : fatal error (update was probably inserted badly): " + e, e);
                    System.err.println("Failed to fetch main jar " + version + " from " + source.userToString() + " : fatal error (update was probably inserted badly): " + e);
                } else {
                    Logger.error(this, "Failed to fetch main jar " + version + " from blob from " + source.userToString());
                    System.err.println("Failed to fetch main jar " + version + " from blob from " + source.userToString());
                }
            }

            public void onMajorProgress(ObjectContainer container) {
            }

            public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
                System.err.println("Got main jar version " + version + " from " + source.userToString());
                if (result.size() == 0L) {
                    System.err.println("Ignoring because 0 bytes long");
                    return;
                }
                NodeUpdater mainUpdater = UpdateOverMandatoryManager.this.updateManager.mainUpdater;
                if (mainUpdater == null) {
                    System.err.println("Not updating because updater is disabled!");
                    return;
                }
                mainUpdater.onSuccess(result, state, cleanedBlobFile, version);
                temp.delete();
                UpdateOverMandatoryManager.this.insertBlob(mainUpdater.getBlobFile(version), "main jar");
            }
        };
        cg = new ClientGetter(myCallback, uri, tempContext, 0, (RequestClient)this, null, (Bucket)cleanedBlob);
        try {
            this.updateManager.node.clientCore.clientContext.start(cg);
        }
        catch (FetchException e1) {
            myCallback.onFailure(e1, cg, null);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void processExtJarBlob(final File temp, final PeerNode source, final int version, FreenetURI uri) {
        block22: {
            blocks = new SimpleBlockSet();
            dis = null;
            try {
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(temp)));
                BinaryBlob.readBinaryBlob((DataInputStream)dis, blocks, true);
                var9_7 = null;
                ** if (dis == null) goto lbl-1000
            }
            catch (Throwable var8_21) {
                var9_11 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var8_21;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block22;
                catch (FileNotFoundException e) {
                    Logger.error(this, "Somebody deleted " + temp + " ? We lost the ext jar (" + version + ") from " + source.userToString() + "!");
                    System.err.println("Somebody deleted " + temp + " ? We lost the ext jar (" + version + ") from " + source.userToString() + "!");
                    var9_8 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    Logger.error(this, "Could not read ext jar (" + version + ") from temp file " + temp + " from node " + source.userToString() + " !");
                    System.err.println("Could not read ext jar (" + version + ") from temp file " + temp + " from node " + source.userToString() + " !");
                    var9_9 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (BinaryBlobFormatException e) {
                    Logger.error(this, "Peer " + source.userToString() + " sent us an invalid ext jar (" + version + ")!: " + e, e);
                    System.err.println("Peer " + source.userToString() + " sent us an invalid ext jar (" + version + ")!: " + e);
                    e.printStackTrace();
                    var9_10 = null;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        seedContext = this.updateManager.node.clientCore.makeClient((short)0, true).getFetchContext();
        tempContext = new FetchContext(seedContext, 0, true, blocks);
        tempContext.localRequestOnly = true;
        b = null;
        try {
            f = File.createTempFile("ext-", ".fblob.tmp", this.updateManager.node.clientCore.getPersistentTempDir());
            f.deleteOnExit();
            b = new FileBucket(f, false, false, true, true, true);
        }
        catch (IOException e) {
            Logger.error(this, "Cannot share ext jar from " + source.userToString() + " with our peers because cannot write the cleaned version to disk: " + e, e);
            System.err.println("Cannot share ext jar from " + source.userToString() + " with our peers because cannot write the cleaned version to disk: " + e);
            e.printStackTrace();
            b = null;
            f = null;
        }
        cleanedBlob = b;
        cleanedBlobFile = f;
        myCallback = new ClientGetCallback(){

            public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
                if (e.mode == 25) {
                    Logger.error(this, "Cancelled fetch from store/blob of ext jar (" + version + ") from " + source.userToString());
                    System.err.println("Cancelled fetch from store/blob of ext jar (" + version + ") from " + source.userToString() + " to " + temp + " - please report to developers");
                } else if (e.isFatal()) {
                    temp.delete();
                    Logger.error(this, "Failed to fetch ext jar " + version + " from " + source.userToString() + " : fatal error (update was probably inserted badly): " + e, e);
                    System.err.println("Failed to fetch ext jar " + version + " from " + source.userToString() + " : fatal error (update was probably inserted badly): " + e);
                } else {
                    Logger.error(this, "Failed to fetch ext jar " + version + " from blob from " + source.userToString());
                    System.err.println("Failed to fetch ext jar " + version + " from blob from " + source.userToString());
                }
            }

            public void onMajorProgress(ObjectContainer container) {
            }

            public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
                System.err.println("Got ext jar version " + version + " from " + source.userToString());
                if (result.size() == 0L) {
                    System.err.println("Ignoring because 0 bytes long");
                    return;
                }
                NodeUpdater extUpdater = UpdateOverMandatoryManager.this.updateManager.extUpdater;
                if (extUpdater == null) {
                    System.err.println("Not updating because ext updater is disabled!");
                    return;
                }
                extUpdater.onSuccess(result, state, cleanedBlobFile, version);
                temp.delete();
                UpdateOverMandatoryManager.this.insertBlob(extUpdater.getBlobFile(version), "ext jar");
            }
        };
        cg = new ClientGetter(myCallback, uri, tempContext, 0, (RequestClient)this, null, (Bucket)cleanedBlob);
        try {
            this.updateManager.node.clientCore.clientContext.start(cg);
        }
        catch (FetchException e1) {
            myCallback.onFailure(e1, cg, null);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
    }

    protected boolean removeOldTempFiles() {
        File[] oldTempFiles;
        File oldTempFilesPeerDir = this.updateManager.node.clientCore.getPersistentTempDir();
        if (!oldTempFilesPeerDir.exists()) {
            return false;
        }
        if (!oldTempFilesPeerDir.isDirectory()) {
            Logger.error(this, "Persistent temporary files location is not a directory: " + oldTempFilesPeerDir.getPath());
            return false;
        }
        boolean gotError = false;
        for (File fileToDelete : oldTempFiles = oldTempFilesPeerDir.listFiles(new FileFilter(){
            private final int lastGoodMainBuildNumber = Version.lastGoodBuild();
            private final int recommendedExtBuildNumber = 26;

            public boolean accept(File file) {
                block10: {
                    String fileName = file.getName();
                    if (fileName.startsWith("revocation-") && fileName.endsWith(".fblob.tmp")) {
                        return true;
                    }
                    Matcher extBuildNumberMatcher = extBuildNumberPattern.matcher(fileName);
                    Matcher mainBuildNumberMatcher = mainBuildNumberPattern.matcher(fileName);
                    Matcher extTempBuildNumberMatcher = extTempBuildNumberPattern.matcher(fileName);
                    Matcher mainTempBuildNumberMatcher = mainTempBuildNumberPattern.matcher(fileName);
                    Matcher revocationTempBuildNumberMatcher = revocationTempBuildNumberPattern.matcher(fileName);
                    if (mainBuildNumberMatcher.matches()) {
                        try {
                            String buildNumberStr = mainBuildNumberMatcher.group(1);
                            int buildNumber = Integer.parseInt(buildNumberStr);
                            if (buildNumber < this.lastGoodMainBuildNumber) {
                                return true;
                            }
                            break block10;
                        }
                        catch (NumberFormatException e) {
                            Logger.error(this, "Wierd file in persistent temp: " + fileName);
                            return false;
                        }
                    }
                    if (extBuildNumberMatcher.matches()) {
                        try {
                            String buildNumberStr = extBuildNumberMatcher.group(1);
                            int buildNumber = Integer.parseInt(buildNumberStr);
                            if (buildNumber < 26) {
                                return true;
                            }
                            break block10;
                        }
                        catch (NumberFormatException e) {
                            Logger.error(this, "Wierd file in persistent temp: " + fileName);
                            return false;
                        }
                    }
                    if (mainTempBuildNumberMatcher.matches() || extTempBuildNumberMatcher.matches() || revocationTempBuildNumberMatcher.matches()) {
                        return true;
                    }
                }
                return false;
            }
        })) {
            String fileToDeleteName = fileToDelete.getName();
            if (fileToDelete.delete()) continue;
            if (fileToDelete.exists()) {
                Logger.error(this, "Cannot delete temporary persistent file " + fileToDeleteName + " even though it exists: must be TOO persistent :)");
            } else {
                Logger.normal(this, "Temporary persistent file does not exist when deleting: " + fileToDeleteName);
            }
            gotError = true;
        }
        return !gotError;
    }

    public boolean persistent() {
        return false;
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
        extBuildNumberPattern = Pattern.compile("^ext(?:-jar)?-(\\d+)\\.fblob$");
        mainBuildNumberPattern = Pattern.compile("^main(?:-jar)?-(\\d+)\\.fblob$");
        extTempBuildNumberPattern = Pattern.compile("^ext(?:-jar)?-(\\d+-)?(\\d+)\\.fblob\\.tmp*$");
        mainTempBuildNumberPattern = Pattern.compile("^main(?:-jar)?-(\\d+-)?(\\d+)\\.fblob\\.tmp*$");
        revocationTempBuildNumberPattern = Pattern.compile("^revocation(?:-jar)?-(\\d+-)?(\\d+)\\.fblob\\.tmp*$");
    }

    private class PeersSayKeyBlownAlert
    extends AbstractUserAlert {
        public PeersSayKeyBlownAlert() {
            super(false, null, null, null, null, (short)0, true, null, false, null);
        }

        public HTMLNode getHTMLText() {
            int i;
            HTMLNode list;
            HTMLNode div = new HTMLNode("div");
            div.addChild("p").addChild("#", this.l10n("intro"));
            PeerNode[][] nodes = UpdateOverMandatoryManager.this.getNodesSayBlown();
            PeerNode[] nodesSayBlownConnected = nodes[0];
            PeerNode[] nodesSayBlownDisconnected = nodes[1];
            PeerNode[] nodesSayBlownFailedTransfer = nodes[2];
            if (nodesSayBlownConnected.length > 0) {
                div.addChild("p").addChild("#", this.l10n("fetching"));
            } else {
                div.addChild("p").addChild("#", this.l10n("failedFetch"));
            }
            if (nodesSayBlownConnected.length > 0) {
                div.addChild("p").addChild("#", this.l10n("connectedSayBlownLabel"));
                list = div.addChild("ul");
                for (i = 0; i < nodesSayBlownConnected.length; ++i) {
                    list.addChild("li", nodesSayBlownConnected[i].userToString() + " (" + nodesSayBlownConnected[i].getPeer() + ")");
                }
            }
            if (nodesSayBlownDisconnected.length > 0) {
                div.addChild("p").addChild("#", this.l10n("disconnectedSayBlownLabel"));
                list = div.addChild("ul");
                for (i = 0; i < nodesSayBlownDisconnected.length; ++i) {
                    list.addChild("li", nodesSayBlownDisconnected[i].userToString() + " (" + nodesSayBlownDisconnected[i].getPeer() + ")");
                }
            }
            if (nodesSayBlownFailedTransfer.length > 0) {
                div.addChild("p").addChild("#", this.l10n("failedTransferSayBlownLabel"));
                list = div.addChild("ul");
                for (i = 0; i < nodesSayBlownFailedTransfer.length; ++i) {
                    list.addChild("li", nodesSayBlownFailedTransfer[i].userToString() + " (" + nodesSayBlownFailedTransfer[i].getPeer() + ")");
                }
            }
            return div;
        }

        private String l10n(String key) {
            return L10n.getString("PeersSayKeyBlownAlert." + key);
        }

        private String l10n(String key, String pattern, String value) {
            return L10n.getString("PeersSayKeyBlownAlert." + key, pattern, value);
        }

        public String getText() {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append(this.l10n("intro")).append("\n\n");
            PeerNode[][] nodes = UpdateOverMandatoryManager.this.getNodesSayBlown();
            PeerNode[] nodesSayBlownConnected = nodes[0];
            PeerNode[] nodesSayBlownDisconnected = nodes[1];
            PeerNode[] nodesSayBlownFailedTransfer = nodes[2];
            if (nodesSayBlownConnected.length > 0) {
                sb.append(this.l10n("fetching")).append("\n\n");
            } else {
                sb.append(this.l10n("failedFetch")).append("\n\n");
            }
            if (nodesSayBlownConnected.length > 0) {
                sb.append(this.l10n("connectedSayBlownLabel")).append("\n\n");
                for (i = 0; i < nodesSayBlownConnected.length; ++i) {
                    sb.append(nodesSayBlownConnected[i].userToString() + " (" + nodesSayBlownConnected[i].getPeer() + ")").append("\n");
                }
                sb.append("\n");
            }
            if (nodesSayBlownDisconnected.length > 0) {
                sb.append(this.l10n("disconnectedSayBlownLabel"));
                for (i = 0; i < nodesSayBlownDisconnected.length; ++i) {
                    sb.append(nodesSayBlownDisconnected[i].userToString() + " (" + nodesSayBlownDisconnected[i].getPeer() + ")").append("\n");
                }
                sb.append("\n");
            }
            if (nodesSayBlownFailedTransfer.length > 0) {
                sb.append(this.l10n("failedTransferSayBlownLabel"));
                for (i = 0; i < nodesSayBlownFailedTransfer.length; ++i) {
                    sb.append(nodesSayBlownFailedTransfer[i].userToString() + " (" + nodesSayBlownFailedTransfer[i].getPeer() + ")").append('\n');
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        public String getTitle() {
            return this.l10n("titleWithCount", "count", Integer.toString(UpdateOverMandatoryManager.this.nodesSayKeyRevoked.size()));
        }

        public void isValid(boolean validity) {
        }

        public boolean isValid() {
            if (UpdateOverMandatoryManager.this.updateManager.isBlown()) {
                return false;
            }
            return UpdateOverMandatoryManager.this.mightBeRevoked();
        }

        public String getShortText() {
            return this.l10n("short");
        }
    }
}

