/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import freenet.l10n.L10n;
import freenet.node.updater.UpdaterParserException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.tanukisoftware.wrapper.WrapperManager;

class UpdateDeployContext {
    File mainJar;
    File extJar;
    int mainClasspathNo;
    int extClasspathNo;
    File newMainJar;
    File newExtJar;
    boolean mainJarAbsolute;
    boolean extJarAbsolute;

    /*
     * Unable to fully structure code
     */
    UpdateDeployContext() throws UpdaterParserException {
        super();
        p = WrapperManager.getProperties();
        propNo = 1;
        while ((prop = p.getProperty("wrapper.java.classpath." + propNo)) != null) {
            f = new File(prop);
            isAbsolute = f.isAbsolute();
            name = f.getName().toLowerCase();
            if (this.extJar != null) ** GOTO lbl-1000
            if (name.equals("freenet-ext.jar.new")) {
                this.extJar = f;
                this.newExtJar = new File(this.extJar.getParent(), "freenet-ext.jar");
                this.extJarAbsolute = isAbsolute;
                this.extClasspathNo = propNo;
            } else if (name.equals("freenet-ext.jar")) {
                this.extJar = f;
                this.newExtJar = new File(this.extJar.getParent(), "freenet-ext.jar.new");
                this.extClasspathNo = propNo;
            } else if (this.mainJar == null) {
                if (name.startsWith("freenet") && name.endsWith(".jar")) {
                    this.mainJar = f;
                    this.newMainJar = new File(this.mainJar.getParent(), "freenet.jar.new");
                    this.mainJarAbsolute = isAbsolute;
                    this.mainClasspathNo = propNo;
                } else if (name.startsWith("freenet") && name.endsWith(".jar.new")) {
                    this.mainJar = f;
                    this.newMainJar = new File(this.mainJar.getParent(), "freenet.jar");
                    this.mainJarAbsolute = isAbsolute;
                    this.mainClasspathNo = propNo;
                }
            }
            ++propNo;
        }
        if (this.mainJar == null && this.extJar == null) {
            throw new UpdaterParserException(this.l10n("cannotUpdateNoJars"));
        }
        if (this.mainJar == null) {
            throw new UpdaterParserException(UpdateDeployContext.l10n("cannotUpdateNoMainJar", "extFilename", this.extJar.toString()));
        }
        if (this.extJar == null) {
            throw new UpdaterParserException(UpdateDeployContext.l10n("cannotUpdateNoExtJar", "mainFilename", this.mainJar.toString()));
        }
    }

    private String l10n(String key) {
        return L10n.getString("UpdateDeployContext." + key);
    }

    public static String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("UpdateDeployContext." + key, patterns, values);
    }

    public static String l10n(String key, String pattern, String value) {
        return L10n.getString("UpdateDeployContext." + key, pattern, value);
    }

    File getMainJar() {
        return this.mainJar;
    }

    File getNewMainJar() {
        return this.newMainJar;
    }

    File getExtJar() {
        return this.extJar;
    }

    File getNewExtJar() {
        return this.newExtJar;
    }

    void rewriteWrapperConf(boolean writtenNewJar, boolean writtenNewExt) throws IOException, UpdateCatastropheException, UpdaterParserException {
        String line;
        String newExt;
        File oldConfig = new File("wrapper.conf");
        File newConfig = new File("wrapper.conf.new");
        FileInputStream fis = new FileInputStream(oldConfig);
        BufferedInputStream bis = new BufferedInputStream(fis);
        InputStreamReader isr = new InputStreamReader(bis);
        BufferedReader br = new BufferedReader(isr);
        FileOutputStream fos = new FileOutputStream(newConfig);
        OutputStreamWriter osw = new OutputStreamWriter(fos);
        BufferedWriter bw = new BufferedWriter(osw);
        boolean writtenMain = false;
        boolean writtenExt = false;
        boolean writtenReload = false;
        String newMain = this.mainJarAbsolute ? this.newMainJar.getAbsolutePath() : this.newMainJar.getPath();
        String string = newExt = this.extJarAbsolute ? this.newExtJar.getAbsolutePath() : this.newExtJar.getPath();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("wrapper.java.classpath.")) {
                if (writtenNewJar && line.startsWith("wrapper.java.classpath." + this.mainClasspathNo + '=')) {
                    bw.write("wrapper.java.classpath." + this.mainClasspathNo + '=' + newMain + '\n');
                    System.err.println("Rewritten wrapper.conf for main jar");
                    writtenMain = true;
                    continue;
                }
                if (writtenNewExt && line.startsWith("wrapper.java.classpath." + this.extClasspathNo + '=')) {
                    bw.write("wrapper.java.classpath." + this.extClasspathNo + '=' + newExt + '\n');
                    System.err.println("Rewritten wrapper.conf for ext jar");
                    writtenExt = true;
                    continue;
                }
                bw.write(line + '\n');
                continue;
            }
            if (line.equalsIgnoreCase("wrapper.restart.reload_configuration=TRUE")) {
                writtenReload = true;
                bw.write(line + '\n');
                continue;
            }
            bw.write(line + '\n');
        }
        br.close();
        if (!writtenMain && writtenNewJar || !writtenExt && writtenNewExt) {
            throw new UpdaterParserException(UpdateDeployContext.l10n("updateFailedNonStandardConfig", new String[]{"main", "ext"}, new String[]{Boolean.toString(writtenMain), Boolean.toString(writtenExt)}));
        }
        if (!writtenReload) {
            bw.write("wrapper.restart.reload_configuration=TRUE");
        }
        bw.close();
        if (!newConfig.renameTo(oldConfig)) {
            if (!oldConfig.delete()) {
                throw new UpdaterParserException(UpdateDeployContext.l10n("updateFailedCannotDeleteOldConfig", "old", oldConfig.toString()));
            }
            if (!newConfig.renameTo(oldConfig)) {
                throw new UpdateCatastropheException(oldConfig, newConfig);
            }
        }
        System.err.println("Rewritten wrapper.conf for" + (writtenNewJar ? " new main jar: " + this.newMainJar : "") + (writtenNewExt ? " new ext jar: " + this.newExtJar : ""));
    }

    public static class UpdateCatastropheException
    extends Exception {
        private static final long serialVersionUID = 1L;
        File oldConfig;
        File newConfig;

        UpdateCatastropheException(File oldConfig, File newConfig) {
            super(UpdateDeployContext.l10n("updateCatastrophe", new String[]{"old", "new"}, new String[]{oldConfig.toString(), newConfig.toString()}));
            this.oldConfig = oldConfig;
            this.newConfig = newConfig;
        }
    }
}

