/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.updater.NodeUpdateManager;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;

public class RevocationChecker
implements ClientGetCallback,
RequestClient {
    public static final int REVOCATION_DNF_MIN = 3;
    private boolean logMINOR;
    private NodeUpdateManager manager;
    private NodeClientCore core;
    private int revocationDNFCounter;
    private FetchContext ctxRevocation;
    private ClientGetter revocationGetter;
    private boolean wasAggressive;
    private long lastSucceeded;
    private File blobFile;
    private File tmpBlobFile;

    public RevocationChecker(NodeUpdateManager manager, File blobFile) {
        this.manager = manager;
        this.core = manager.node.clientCore;
        this.revocationDNFCounter = 0;
        this.blobFile = blobFile;
        this.logMINOR = Logger.shouldLog(4, this);
        this.ctxRevocation = this.core.makeClient((short)0, true).getFetchContext();
        this.ctxRevocation.allowSplitfiles = false;
        this.ctxRevocation.cacheLocalRequests = false;
        this.ctxRevocation.maxArchiveLevels = 1;
        this.ctxRevocation.maxOutputLength = 4096L;
        this.ctxRevocation.maxTempLength = 4096L;
        this.ctxRevocation.maxSplitfileBlockRetries = -1;
        this.ctxRevocation.maxNonSplitfileRetries = 0;
    }

    public int getRevocationDNFCounter() {
        return this.revocationDNFCounter;
    }

    public void start(boolean aggressive) {
        this.start(aggressive, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean aggressive, boolean reset) {
        if (this.manager.isBlown()) {
            Logger.error(this, "Not starting revocation checker: key already blown!");
            return;
        }
        this.logMINOR = Logger.shouldLog(4, this);
        try {
            ClientGetter cg = null;
            ClientGetter toCancel = null;
            RevocationChecker revocationChecker = this;
            synchronized (revocationChecker) {
                if (aggressive && !this.wasAggressive) {
                    toCancel = this.revocationGetter;
                    if (this.logMINOR) {
                        Logger.minor(this, "Ignoring old request, because was low priority");
                    }
                    this.revocationGetter = null;
                }
                this.wasAggressive = aggressive;
                if (this.revocationGetter != null && !this.revocationGetter.isCancelled() && !this.revocationGetter.isFinished()) {
                    if (this.logMINOR) {
                        Logger.minor(this, "Not queueing another revocation fetcher yet, old one still running");
                    }
                    reset = false;
                } else {
                    if (reset) {
                        if (this.logMINOR) {
                            Logger.minor(this, "Resetting DNF count from " + this.revocationDNFCounter, (Throwable)new Exception("debug"));
                        }
                        this.revocationDNFCounter = 0;
                    } else if (this.logMINOR) {
                        Logger.minor(this, "Revocation count " + this.revocationDNFCounter);
                    }
                    if (this.logMINOR) {
                        Logger.minor(this, "fetcher=" + this.revocationGetter);
                    }
                    if (this.revocationGetter != null && this.logMINOR) {
                        Logger.minor(this, "revocation fetcher: cancelled=" + this.revocationGetter.isCancelled() + ", finished=" + this.revocationGetter.isFinished());
                    }
                    try {
                        this.tmpBlobFile = File.createTempFile("revocation-", ".fblob.tmp", this.manager.node.clientCore.getPersistentTempDir());
                    }
                    catch (IOException e) {
                        Logger.error(this, "Cannot record revocation fetch (therefore cannot pass it on to peers)!: " + e, e);
                    }
                    cg = this.revocationGetter = new ClientGetter(this, this.manager.revocationURI, this.ctxRevocation, aggressive ? (short)0 : 2, (RequestClient)this, null, (Bucket)(this.tmpBlobFile == null ? null : new FileBucket(this.tmpBlobFile, false, false, false, false, false)));
                    if (this.logMINOR) {
                        Logger.minor(this, "Queued another revocation fetcher (count=" + this.revocationDNFCounter + ")");
                    }
                }
            }
            if (toCancel != null) {
                toCancel.cancel(null, this.core.clientContext);
            }
            if (cg != null) {
                this.core.clientContext.start(cg);
                if (this.logMINOR) {
                    Logger.minor(this, "Started revocation fetcher");
                }
            }
        }
        catch (FetchException e) {
            Logger.error(this, "Not able to start the revocation fetcher.");
            this.manager.blow("Cannot fetch the auto-update URI");
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
    }

    long lastSucceeded() {
        return this.lastSucceeded;
    }

    long lastSucceededDelta() {
        if (this.lastSucceeded <= 0L) {
            return -1L;
        }
        return System.currentTimeMillis() - this.lastSucceeded;
    }

    public void onChangeRevocationURI() {
        this.kill();
        this.start(this.wasAggressive);
    }

    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
        this.onSuccess(result, state, this.tmpBlobFile);
    }

    void onSuccess(FetchResult result, ClientGetter state, File blob) {
        this.moveBlob(blob);
        String msg = null;
        try {
            byte[] buf = result.asByteArray();
            msg = new String(buf);
        }
        catch (Throwable t) {
            try {
                msg = "Failed to extract result when key blown: " + t;
                Logger.error(this, msg, t);
                System.err.println(msg);
                t.printStackTrace();
            }
            catch (Throwable t1) {
                msg = "Internal error after retreiving revocation key";
            }
        }
        this.manager.blow(msg);
    }

    private void moveBlob(File tmpBlobFile) {
        if (tmpBlobFile == null) {
            Logger.error(this, "No temporary binary blob file moving it: may not be able to propagate revocation, bug???");
            return;
        }
        FileUtil.renameTo(tmpBlobFile, this.blobFile);
    }

    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
        this.onFailure(e, state, this.tmpBlobFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFailure(FetchException e, ClientGetter state, File tmpBlobFile) {
        this.logMINOR = Logger.shouldLog(4, this);
        if (this.logMINOR) {
            Logger.minor(this, "Revocation fetch failed: " + e);
        }
        int errorCode = e.getMode();
        boolean completed = false;
        long now = System.currentTimeMillis();
        if (errorCode == 25) {
            if (tmpBlobFile != null) {
                tmpBlobFile.delete();
            }
            return;
        }
        if (e.isFatal()) {
            this.manager.blow("Permanent error fetching revocation (error inserting the revocation key?): " + e.toString());
            this.moveBlob(tmpBlobFile);
            return;
        }
        if (tmpBlobFile != null) {
            tmpBlobFile.delete();
        }
        if (e.newURI != null) {
            this.manager.blow("Revocation URI redirecting to " + e.newURI + " - maybe you set the revocation URI to the update URI?");
        }
        RevocationChecker revocationChecker = this;
        synchronized (revocationChecker) {
            if (errorCode == 13) {
                ++this.revocationDNFCounter;
                if (this.logMINOR) {
                    Logger.minor(this, "Incremented DNF counter to " + this.revocationDNFCounter);
                }
            }
            if (this.revocationDNFCounter >= 3) {
                this.lastSucceeded = now;
                completed = true;
                this.revocationDNFCounter = 0;
            }
            this.revocationGetter = null;
        }
        if (completed) {
            this.manager.noRevocationFound();
        } else {
            this.start(this.wasAggressive, false);
        }
    }

    public void onMajorProgress(ObjectContainer container) {
    }

    public void kill() {
        if (this.revocationGetter != null) {
            this.revocationGetter.cancel(null, this.core.clientContext);
        }
    }

    public long getBlobSize() {
        return this.blobFile.length();
    }

    public File getBlobFile() {
        if (!this.manager.isBlown()) {
            return null;
        }
        if (this.blobFile.exists()) {
            return this.blobFile;
        }
        return null;
    }

    public boolean persistent() {
        return false;
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

