/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.USKCallback;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.Ticker;
import freenet.node.Version;
import freenet.node.updater.NodeUpdateManager;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class NodeUpdater
implements ClientGetCallback,
USKCallback,
RequestClient {
    private static boolean logMINOR;
    private FetchContext ctx;
    private FetchResult result;
    private ClientGetter cg;
    private FreenetURI URI;
    private final Ticker ticker;
    public final NodeClientCore core;
    private final Node node;
    public final NodeUpdateManager manager;
    private final int currentVersion;
    private int realAvailableVersion;
    private int availableVersion;
    private int fetchingVersion;
    private int fetchedVersion;
    private int writtenVersion;
    private int maxDeployVersion;
    private int minDeployVersion;
    private boolean isRunning;
    private boolean isFetching;
    public final boolean extUpdate;
    private final String blobFilenamePrefix;
    private File tempBlobFile;
    private final Object writeJarSync = new Object();
    private static final String REQUIRED_EXT_PREFIX = "Required-Ext-Version: ";
    private static final String RECOMMENDED_EXT_PREFIX = "Recommended-Ext-Version: ";
    private static final int MAX_MANIFEST_SIZE = 0x100000;

    NodeUpdater(NodeUpdateManager manager, FreenetURI URI2, boolean extUpdate, int current, int min, int max, String blobFilenamePrefix) {
        logMINOR = Logger.shouldLog(4, this);
        this.manager = manager;
        this.node = manager.node;
        this.URI = URI2.setSuggestedEdition(Version.buildNumber() + 1);
        this.ticker = this.node.ps;
        this.core = this.node.clientCore;
        this.currentVersion = current;
        this.availableVersion = -1;
        this.isRunning = true;
        this.cg = null;
        this.isFetching = false;
        this.extUpdate = extUpdate;
        this.blobFilenamePrefix = blobFilenamePrefix;
        this.maxDeployVersion = max;
        this.minDeployVersion = min;
        FetchContext tempContext = this.core.makeClient((short)0, true).getFetchContext();
        tempContext.allowSplitfiles = true;
        tempContext.dontEnterImplicitArchives = false;
        this.ctx = tempContext;
    }

    void start() {
        try {
            USK myUsk = USK.create(this.URI.setSuggestedEdition(this.currentVersion));
            this.core.uskManager.subscribe(myUsk, this, true, this);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "The auto-update URI isn't valid and can't be used");
            this.manager.blow("The auto-update URI isn't valid and can't be used");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFoundEdition(long l, USK key, ObjectContainer container, ClientContext context, boolean wasMetadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        int found;
        if (newKnownGood && !newSlotToo) {
            return;
        }
        logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "Found edition " + l);
        }
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            if (!this.isRunning) {
                return;
            }
            this.realAvailableVersion = found = (int)key.suggestedEdition;
            if (found > this.maxDeployVersion) {
                System.err.println("Ignoring " + (this.extUpdate ? "freenet-ext.jar " : "") + "update edition " + l + ": version too new");
                found = this.maxDeployVersion;
            }
            if (found <= this.availableVersion) {
                return;
            }
            System.err.println("Found " + (this.extUpdate ? "freenet-ext.jar " : "") + "update edition " + found);
            Logger.minor(this, "Updating availableVersion from " + this.availableVersion + " to " + found + " and queueing an update");
            this.availableVersion = found;
        }
        this.finishOnFoundEdition(found);
    }

    private void finishOnFoundEdition(int found) {
        this.ticker.queueTimedJob(new Runnable(){

            public void run() {
                NodeUpdater.this.maybeUpdate();
            }
        }, 60000L);
        if (found <= this.currentVersion) {
            System.err.println("Cancelling fetch for " + found + ": not newer than current version " + this.currentVersion);
            return;
        }
        this.manager.onStartFetching(this.extUpdate);
        Logger.minor(this, "Fetching " + (this.extUpdate ? "freenet-ext.jar " : "") + "update edition " + found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdate() {
        ClientGetter toStart = null;
        if (!this.manager.isEnabled()) {
            return;
        }
        if (this.manager.isBlown()) {
            return;
        }
        ClientGetter cancelled = null;
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            if (logMINOR) {
                Logger.minor(this, "maybeUpdate: isFetching=" + this.isFetching + ", isRunning=" + this.isRunning + ", availableVersion=" + this.availableVersion);
            }
            if (!this.isRunning) {
                return;
            }
            if (this.isFetching && this.availableVersion == this.fetchingVersion) {
                return;
            }
            if (this.availableVersion <= this.fetchedVersion) {
                return;
            }
            if (this.fetchingVersion < this.minDeployVersion || this.fetchingVersion == this.currentVersion) {
                Logger.normal(this, "Cancelling previous fetch");
                cancelled = this.cg;
                this.cg = null;
            }
            this.fetchingVersion = this.availableVersion;
            if (this.availableVersion > this.currentVersion) {
                Logger.normal(this, "Starting the update process (" + this.availableVersion + ')');
                System.err.println("Starting the update process: found the update (" + this.availableVersion + "), now fetching it.");
            }
            if (logMINOR) {
                Logger.minor(this, "Starting the update process (" + this.availableVersion + ')');
            }
            try {
                if (this.cg == null || this.cg.isCancelled()) {
                    if (logMINOR) {
                        Logger.minor(this, "Scheduling request for " + this.URI.setSuggestedEdition(this.availableVersion));
                    }
                    if (this.availableVersion > this.currentVersion) {
                        System.err.println("Starting " + (this.extUpdate ? "freenet-ext.jar " : "") + "fetch for " + this.availableVersion);
                    }
                    this.tempBlobFile = File.createTempFile(this.blobFilenamePrefix + this.availableVersion + "-", ".fblob.tmp", this.manager.node.clientCore.getPersistentTempDir());
                    FreenetURI uri = this.URI.setSuggestedEdition(this.availableVersion);
                    uri = uri.sskForUSK();
                    toStart = this.cg = new ClientGetter(this, uri, this.ctx, 2, (RequestClient)this, null, (Bucket)new FileBucket(this.tempBlobFile, false, false, false, false, false));
                } else {
                    System.err.println("Already fetching " + (this.extUpdate ? "freenet-ext.jar " : "") + "fetch for " + this.fetchingVersion + " want " + this.availableVersion);
                }
                this.isFetching = true;
            }
            catch (Exception e) {
                Logger.error(this, "Error while starting the fetching: " + e, e);
                this.isFetching = false;
            }
        }
        if (toStart != null) {
            try {
                this.node.clientCore.clientContext.start(toStart);
            }
            catch (FetchException e) {
                Logger.error(this, "Error while starting the fetching: " + e, e);
                NodeUpdater nodeUpdater2 = this;
                synchronized (nodeUpdater2) {
                    this.isFetching = false;
                }
            }
            catch (DatabaseDisabledException databaseDisabledException) {
                // empty catch block
            }
        }
        if (cancelled != null) {
            cancelled.cancel(null, this.core.clientContext);
        }
    }

    File getBlobFile(int availableVersion) {
        return new File(this.node.clientCore.getPersistentTempDir(), this.blobFilenamePrefix + availableVersion + ".fblob");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJarTo(File fNew) throws IOException {
        int fetched;
        Object object = this;
        synchronized (object) {
            fetched = this.fetchedVersion;
        }
        object = this.writeJarSync;
        synchronized (object) {
            if (!fNew.delete() && fNew.exists()) {
                System.err.println("Can't delete " + fNew + "!");
            }
            FileOutputStream fos = new FileOutputStream(fNew);
            BucketTools.copyTo(this.result.asBucket(), fos, -1L);
            fos.flush();
            fos.close();
        }
        object = this;
        synchronized (object) {
            this.writtenVersion = fetched;
        }
        System.err.println("Written " + (this.extUpdate ? "ext" : "main") + " jar to " + fNew);
    }

    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
        this.onSuccess(result, state, this.tempBlobFile, this.fetchingVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onSuccess(FetchResult result, ClientGetter state, File tempBlobFile, int fetchedVersion) {
        logMINOR = Logger.shouldLog(4, this);
        int requiredExt = -1;
        int recommendedExt = -1;
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            if (fetchedVersion <= this.fetchedVersion) {
                Bucket toFree;
                tempBlobFile.delete();
                if (result != null && (toFree = result.asBucket()) != null) {
                    toFree.free();
                }
                return;
            }
            if (result == null || result.asBucket() == null || result.asBucket().size() == 0L) {
                tempBlobFile.delete();
                Logger.error(this, "Cannot update: result either null or empty for " + this.availableVersion);
                System.err.println("Cannot update: result either null or empty for " + this.availableVersion);
                if (result == null || result.asBucket() == null || this.availableVersion > fetchedVersion) {
                    this.node.ps.queueTimedJob(new Runnable(){

                        public void run() {
                            NodeUpdater.this.maybeUpdate();
                        }
                    }, 0L);
                }
                return;
            }
            File blobFile = this.getBlobFile(fetchedVersion);
            if (!tempBlobFile.renameTo(blobFile)) {
                blobFile.delete();
                if (!tempBlobFile.renameTo(blobFile)) {
                    if (blobFile.exists() && tempBlobFile.exists() && blobFile.length() == tempBlobFile.length()) {
                        Logger.minor(this, "Can't rename " + tempBlobFile + " over " + blobFile + " for " + fetchedVersion + " - probably not a big deal though as the files are the same size");
                    } else {
                        Logger.error(this, "Not able to rename binary blob for node updater: " + tempBlobFile + " -> " + blobFile + " - may not be able to tell other peers about this build");
                    }
                }
            }
            this.fetchedVersion = fetchedVersion;
            System.out.println("Found " + (this.extUpdate ? "ext " : "") + fetchedVersion);
            if (fetchedVersion > this.currentVersion) {
                Logger.normal(this, "Found version " + fetchedVersion + ", setting up a new UpdatedVersionAvailableUserAlert");
            }
            if (!this.extUpdate) {
                block28: {
                    InputStream is = null;
                    try {
                        try {
                            ZipEntry ze;
                            is = result.asBucket().getInputStream();
                            ZipInputStream zis = new ZipInputStream(is);
                            while ((ze = zis.getNextEntry()) != null) {
                                if (ze.isDirectory()) continue;
                                String name = ze.getName();
                                if (name.equals("META-INF/MANIFEST.MF")) {
                                    String line;
                                    if (logMINOR) {
                                        Logger.minor(this, "Found manifest");
                                    }
                                    long size = ze.getSize();
                                    if (logMINOR) {
                                        Logger.minor(this, "Manifest size: " + size);
                                    }
                                    if (size > 0x100000L) {
                                        Logger.error(this, "Manifest is too big: " + size + " bytes, limit is " + 0x100000);
                                        break;
                                    }
                                    byte[] buf = new byte[(int)size];
                                    DataInputStream dis = new DataInputStream(zis);
                                    dis.readFully(buf);
                                    ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                                    InputStreamReader isr = new InputStreamReader((InputStream)bais, "UTF-8");
                                    BufferedReader br = new BufferedReader(isr);
                                    while ((line = br.readLine()) != null) {
                                        if (line.startsWith(REQUIRED_EXT_PREFIX)) {
                                            requiredExt = Integer.parseInt(line.substring(REQUIRED_EXT_PREFIX.length()));
                                            continue;
                                        }
                                        if (!line.startsWith(RECOMMENDED_EXT_PREFIX)) continue;
                                        recommendedExt = Integer.parseInt(line.substring(RECOMMENDED_EXT_PREFIX.length()));
                                    }
                                    continue;
                                }
                                zis.closeEntry();
                            }
                            Object var22_23 = null;
                        }
                        catch (IOException e) {
                            Logger.error(this, "IOException trying to read manifest on update");
                            Object var22_24 = null;
                            Closer.close(is);
                            break block28;
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Failed to parse update manifest: " + t, t);
                            recommendedExt = -1;
                            requiredExt = -1;
                            Object var22_25 = null;
                            Closer.close(is);
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var22_26 = null;
                        Closer.close(is);
                        throw throwable;
                    }
                    Closer.close(is);
                }
                if (requiredExt != -1) {
                    System.err.println("Required ext version: " + requiredExt);
                    Logger.normal(this, "Required ext version: " + requiredExt);
                }
                if (recommendedExt != -1) {
                    System.err.println("Recommended ext version: " + recommendedExt);
                    Logger.normal(this, "Recommended ext version: " + recommendedExt);
                }
            }
            this.cg = null;
            if (this.result != null) {
                this.result.asBucket().free();
            }
            this.result = result;
        }
        this.manager.onDownloadedNewJar(this.extUpdate, requiredExt, recommendedExt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
        logMINOR = Logger.shouldLog(4, this);
        if (!this.isRunning) {
            return;
        }
        int errorCode = e.getMode();
        this.tempBlobFile.delete();
        if (logMINOR) {
            Logger.minor(this, "onFailure(" + e + ',' + state + ')');
        }
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            this.cg = null;
            this.isFetching = false;
        }
        if (errorCode == 25 || !e.isFatal()) {
            Logger.normal(this, "Rescheduling new request");
            this.ticker.queueTimedJob(new Runnable(){

                public void run() {
                    NodeUpdater.this.maybeUpdate();
                }
            }, 0L);
        } else {
            Logger.error(this, "Canceling fetch : " + e.getMessage());
            System.err.println("Unexpected error fetching update: " + e.getMessage());
            if (!e.isFatal()) {
                this.ticker.queueTimedJob(new Runnable(){

                    public void run() {
                        NodeUpdater.this.maybeUpdate();
                    }
                }, 3600000L);
            }
        }
    }

    public void preKill() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        try {
            ClientGetter c;
            NodeUpdater nodeUpdater = this;
            synchronized (nodeUpdater) {
                this.isRunning = false;
                USK myUsk = USK.create(this.URI.setSuggestedEdition(this.currentVersion));
                this.core.uskManager.unsubscribe(myUsk, this);
                c = this.cg;
                this.cg = null;
            }
            c.cancel(null, this.core.clientContext);
        }
        catch (Exception e) {
            Logger.minor(this, "Cannot kill NodeUpdater", (Throwable)e);
        }
    }

    public FreenetURI getUpdateKey() {
        return this.URI;
    }

    public void onMajorProgress(ObjectContainer container) {
    }

    public synchronized boolean canUpdateNow() {
        return this.fetchedVersion > this.currentVersion;
    }

    public void onChangeURI(FreenetURI uri) {
        this.kill();
        this.URI = uri;
        this.maybeUpdate();
    }

    public int getWrittenVersion() {
        return this.writtenVersion;
    }

    public int getFetchedVersion() {
        return this.fetchedVersion;
    }

    public boolean isFetching() {
        return this.availableVersion > this.fetchedVersion && this.availableVersion > this.currentVersion;
    }

    public int fetchingVersion() {
        if (this.fetchingVersion <= this.currentVersion) {
            return this.availableVersion;
        }
        return this.fetchingVersion;
    }

    public long getBlobSize() {
        return this.getBlobFile(this.getFetchedVersion()).length();
    }

    public File getBlobFile() {
        return this.getBlobFile(this.getFetchedVersion());
    }

    public short getPollingPriorityNormal() {
        return 2;
    }

    public short getPollingPriorityProgress() {
        return 1;
    }

    public boolean persistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinMax(int requiredExt, int recommendedExt) {
        int callFinishedFound = -1;
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            if (recommendedExt > -1) {
                this.maxDeployVersion = recommendedExt;
            }
            if (requiredExt > -1) {
                this.minDeployVersion = requiredExt;
                if (this.realAvailableVersion != this.availableVersion && this.availableVersion < requiredExt && this.realAvailableVersion >= requiredExt) {
                    System.err.println("Previously out-of-range edition " + this.realAvailableVersion + " is now needed by the new jar; scheduling fetch.");
                    callFinishedFound = this.availableVersion = this.realAvailableVersion;
                } else if (this.availableVersion < requiredExt) {
                    callFinishedFound = this.availableVersion = requiredExt;
                    System.err.println("Need minimum edition " + requiredExt + " for new jar, found " + this.availableVersion + "; scheduling fetch.");
                }
            }
        }
        if (callFinishedFound > -1) {
            this.finishOnFoundEdition(callFinishedFound);
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing NodeUpdater in database", new Exception("error"));
        return false;
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

