/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import com.db4o.ObjectContainer;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.PeerNode;
import freenet.node.Version;
import freenet.node.updater.NodeUpdater;
import freenet.node.updater.RevocationChecker;
import freenet.node.updater.UpdateDeployContext;
import freenet.node.updater.UpdateOverMandatoryManager;
import freenet.node.updater.UpdaterParserException;
import freenet.node.useralerts.RevocationKeyFoundUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.UpdatedVersionAvailableUserAlert;
import freenet.support.Logger;
import freenet.support.api.BooleanCallback;
import freenet.support.api.StringCallback;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.tanukisoftware.wrapper.WrapperManager;

public class NodeUpdateManager {
    public static final String UPDATE_URI = "freenet:USK@BFa1voWr5PunINSZ5BGMqFwhkJTiDBBUrOZ0MYBXseg,BOrxeLzUMb6R9tEZzexymY0zyKAmBNvrU4A9Q0tAqu0,AQACAAE/update/" + Version.buildNumber();
    public static final String REVOCATION_URI = "SSK@tHlY8BK2KFB7JiO2bgeAw~e4sWU43YdJ6kmn73gjrIw,DnQzl0BYed15V8WQn~eRJxxIA-yADuI8XW7mnzEbut8,AQACAAE/revoked";
    public static final String EXT_URI = "freenet:USK@BFa1voWr5PunINSZ5BGMqFwhkJTiDBBUrOZ0MYBXseg,BOrxeLzUMb6R9tEZzexymY0zyKAmBNvrU4A9Q0tAqu0,AQACAAE/ext/" + NodeStarter.extBuildNumber;
    public static final long MAX_REVOCATION_KEY_LENGTH = 0x400000L;
    public static final long MAX_MAIN_JAR_LENGTH = 0x1000000L;
    FreenetURI updateURI;
    FreenetURI extURI;
    FreenetURI revocationURI;
    NodeUpdater mainUpdater;
    NodeUpdater extUpdater;
    boolean wasEnabledOnStartup;
    volatile boolean isAutoUpdateAllowed;
    volatile boolean armed;
    final boolean shouldUpdateExt;
    boolean isDeployingUpdate;
    final Object broadcastUOMAnnouncesSync = new Object();
    boolean broadcastUOMAnnounces = false;
    Node node;
    final RevocationChecker revocationChecker;
    private String revocationMessage;
    private volatile boolean hasBeenBlown;
    private volatile boolean peersSayBlown;
    private volatile boolean hasNewMainJar;
    private volatile boolean hasNewExtJar;
    private long startedFetchingNextMainJar;
    private long startedFetchingNextExtJar;
    private long gotJarTime;
    private int minExtVersion;
    private int maxExtVersion;
    private RevocationKeyFoundUserAlert revocationAlert;
    private final UpdatedVersionAvailableUserAlert alert;
    public final UpdateOverMandatoryManager uom;
    private boolean logMINOR;
    private boolean disabledThisSession;
    private static final int WAIT_FOR_SECOND_FETCH_TO_COMPLETE = 240000;
    private static final int RECENT_REVOCATION_INTERVAL = 120000;
    private static final int REVOCATION_FETCH_TIMEOUT = 300000;
    final ByteCounter ctr = new ByteCounter(){

        public void receivedBytes(int x) {
        }

        public void sentBytes(int x) {
            NodeUpdateManager.this.node.nodeStats.reportUOMBytesSent(x);
        }

        public void sentPayload(int x) {
        }
    };

    public NodeUpdateManager(Node node, Config config) throws InvalidConfigValueException {
        long ver;
        this.logMINOR = Logger.shouldLog(4, this);
        this.node = node;
        this.hasBeenBlown = false;
        this.shouldUpdateExt = NodeStarter.extBuildNumber < 26;
        this.alert = new UpdatedVersionAvailableUserAlert(this);
        this.alert.isValid(false);
        SubConfig updaterConfig = new SubConfig("node.updater", config);
        updaterConfig.register("enabled", WrapperManager.isControlledByNativeWrapper(), 1, true, false, "NodeUpdateManager.enabled", "NodeUpdateManager.enabledLong", new UpdaterEnabledCallback());
        this.wasEnabledOnStartup = updaterConfig.getBoolean("enabled");
        updaterConfig.register("autoupdate", false, 2, false, true, "NodeUpdateManager.installNewVersions", "NodeUpdateManager.installNewVersionsLong", new AutoUpdateAllowedCallback());
        this.isAutoUpdateAllowed = updaterConfig.getBoolean("autoupdate");
        updaterConfig.register("URI", UPDATE_URI, 3, true, false, "NodeUpdateManager.updateURI", "NodeUpdateManager.updateURILong", new UpdateURICallback(false));
        try {
            this.updateURI = new FreenetURI(updaterConfig.getString("URI"));
            ver = this.updateURI.getSuggestedEdition();
            if (ver < (long)Version.buildNumber()) {
                ver = Version.buildNumber();
            }
            this.updateURI = this.updateURI.setSuggestedEdition(ver);
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigValueException(this.l10n("invalidUpdateURI", "error", e.getLocalizedMessage()));
        }
        updaterConfig.register("revocationURI", REVOCATION_URI, 4, true, false, "NodeUpdateManager.revocationURI", "NodeUpdateManager.revocationURILong", new UpdateRevocationURICallback());
        try {
            this.revocationURI = new FreenetURI(updaterConfig.getString("revocationURI"));
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigValueException(this.l10n("invalidRevocationURI", "error", e.getLocalizedMessage()));
        }
        updaterConfig.register("extURI", EXT_URI, 5, true, false, "NodeUpdateManager.extURI", "NodeUpdateManager.extURILong", new UpdateURICallback(true));
        try {
            this.extURI = new FreenetURI(updaterConfig.getString("extURI"));
            ver = this.extURI.getSuggestedEdition();
            if (ver < (long)NodeStarter.extBuildNumber) {
                ver = NodeStarter.extBuildNumber;
            }
            this.extURI = this.extURI.setSuggestedEdition(ver);
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigValueException(this.l10n("invalidExtURI", "error", e.getLocalizedMessage()));
        }
        updaterConfig.finishedInitialization();
        this.revocationChecker = new RevocationChecker(this, new File(node.clientCore.getPersistentTempDir(), "revocation-key.fblob"));
        this.uom = new UpdateOverMandatoryManager(this);
        this.uom.removeOldTempFiles();
        this.maxExtVersion = 26;
        this.minExtVersion = 24;
    }

    public void start() throws InvalidConfigValueException {
        this.node.clientCore.alerts.register(this.alert);
        this.enable(this.wasEnabledOnStartup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void broadcastUOMAnnounces() {
        Message msg;
        Object object = this.broadcastUOMAnnouncesSync;
        synchronized (object) {
            msg = this.getUOMAnnouncement();
            this.broadcastUOMAnnounces = true;
        }
        this.node.peers.localBroadcast(msg, true, true, this.ctr);
    }

    private Message getUOMAnnouncement() {
        return DMT.createUOMAnnounce(this.updateURI.toString(), this.extURI.toString(), this.revocationURI.toString(), this.hasBeenBlown, this.mainUpdater == null ? -1L : (long)this.mainUpdater.getFetchedVersion(), this.extUpdater == null ? -1L : (long)this.extUpdater.getFetchedVersion(), this.revocationChecker.lastSucceededDelta(), this.revocationChecker.getRevocationDNFCounter(), this.revocationChecker.getBlobSize(), this.mainUpdater == null ? -1L : this.mainUpdater.getBlobSize(), this.extUpdater == null ? -1L : this.extUpdater.getBlobSize(), (int)this.node.nodeStats.getNodeAveragePingTime(), (int)this.node.nodeStats.getBwlimitDelayTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeSendUOMAnnounce(PeerNode peer) {
        Object object = this.broadcastUOMAnnouncesSync;
        synchronized (object) {
            if (!this.broadcastUOMAnnounces) {
                return;
            }
        }
        object = this;
        synchronized (object) {
            if (!(this.hasBeenBlown || this.mainUpdater != null && this.mainUpdater.getFetchedVersion() > 0)) {
                return;
            }
        }
        try {
            peer.sendAsync(this.getUOMAnnouncement(), null, this.ctr);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    public synchronized boolean isEnabled() {
        return this.mainUpdater != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enable(boolean enable) throws InvalidConfigValueException {
        this.logMINOR = Logger.shouldLog(4, this);
        if (!this.node.isUsingWrapper()) {
            Logger.normal(this, "Don't try to start the updater as we are not running under the wrapper.");
            return;
        }
        NodeUpdater main = null;
        NodeUpdater ext = null;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            boolean enabled;
            boolean bl = enabled = this.mainUpdater != null;
            if (enabled == enable) {
                return;
            }
            if (!enable) {
                this.mainUpdater.preKill();
                main = this.mainUpdater;
                this.mainUpdater = null;
                if (this.extUpdater != null) {
                    this.extUpdater.preKill();
                }
                ext = this.extUpdater;
                this.extUpdater = null;
            } else {
                if (!WrapperManager.isControlledByNativeWrapper() || NodeStarter.extBuildNumber == -1) {
                    Logger.error(this, "Cannot update because not running under wrapper");
                    throw new InvalidConfigValueException(this.l10n("noUpdateWithoutWrapper"));
                }
                this.mainUpdater = new NodeUpdater(this, this.updateURI, false, Version.buildNumber(), -1, Integer.MAX_VALUE, "main-jar-");
                this.extUpdater = new NodeUpdater(this, this.extURI, true, NodeStarter.extBuildNumber, 24, 26, "ext-jar-");
            }
        }
        if (!enable) {
            if (main != null) {
                main.kill();
            }
            if (ext != null) {
                ext.kill();
            }
            this.revocationChecker.kill();
        } else {
            this.mainUpdater.start();
            if (this.extUpdater != null) {
                this.extUpdater.start();
            }
            this.revocationChecker.start(false);
        }
    }

    public static NodeUpdateManager maybeCreate(Node node, Config config) throws InvalidConfigValueException {
        return new NodeUpdateManager(node, config);
    }

    public synchronized FreenetURI getURI(boolean isExt) {
        return isExt ? this.extURI : this.updateURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURI(boolean isExt, FreenetURI uri) {
        NodeUpdater updater;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (isExt) {
                if (this.extURI.equals(uri)) {
                    return;
                }
                this.extURI = uri;
                updater = this.extUpdater;
            } else {
                if (this.updateURI.equals(uri)) {
                    return;
                }
                this.updateURI = uri;
                updater = this.mainUpdater;
            }
            if (updater == null) {
                return;
            }
        }
        updater.onChangeURI(uri);
    }

    public synchronized FreenetURI getRevocationURI() {
        return this.revocationURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevocationURI(FreenetURI uri) {
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.revocationURI.equals(uri)) {
                return;
            }
            this.revocationURI = uri;
        }
        this.revocationChecker.onChangeRevocationURI();
    }

    public boolean isAutoUpdateAllowed() {
        return this.isAutoUpdateAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoUpdateAllowed(boolean val) {
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (val == this.isAutoUpdateAllowed) {
                return;
            }
            this.isAutoUpdateAllowed = val;
            if (val) {
                if (!this.isReadyToDeployUpdate(false)) {
                    return;
                }
            } else {
                return;
            }
        }
        this.deployOffThread(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReadyToDeployUpdate(boolean ignoreRevocation) {
        long startedMillisAgo;
        long now = System.currentTimeMillis();
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (!this.hasNewMainJar && !this.hasNewExtJar) {
                if (this.logMINOR) {
                    Logger.minor(this, "hasNewMainJar=" + this.hasNewMainJar + " hasNewExtJar=" + this.hasNewExtJar);
                }
                return false;
            }
            if (this.hasBeenBlown) {
                return false;
            }
            if (this.peersSayBlown) {
                return false;
            }
            startedMillisAgo = now - Math.max(this.startedFetchingNextMainJar, this.startedFetchingNextExtJar);
            if (startedMillisAgo < 240000L) {
                if (this.logMINOR) {
                    Logger.minor(this, "Not ready: Still fetching");
                }
                return false;
            }
            int extVer = this.getReadyExt();
            if (extVer < this.minExtVersion || extVer > this.maxExtVersion) {
                if (this.logMINOR) {
                    Logger.minor(this, "Invalid ext: current " + extVer + " must be between " + this.minExtVersion + " and " + this.maxExtVersion);
                }
                return false;
            }
            if (!ignoreRevocation) {
                if (now - this.revocationChecker.lastSucceeded() < 120000L) {
                    return true;
                }
                if (this.gotJarTime > 0L && now - this.gotJarTime >= 300000L) {
                    return true;
                }
            }
        }
        if (this.logMINOR) {
            Logger.minor(this, "Still here in isReadyToDeployUpdate");
        }
        this.revocationChecker.start(true);
        if (ignoreRevocation) {
            if (this.logMINOR) {
                Logger.minor(this, "Returning true because of ignoreRevocation");
            }
            return true;
        }
        this.deployOffThread(240000L - startedMillisAgo);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployUpdate() {
        this.logMINOR = Logger.shouldLog(4, this);
        try {
            NodeUpdateManager nodeUpdateManager = this;
            synchronized (nodeUpdateManager) {
                if (this.disabledThisSession) {
                    String msg = "Not deploying update because disabled for this session (bad java version??)";
                    Logger.error(this, msg);
                    System.err.println(msg);
                    return;
                }
                if (this.hasBeenBlown) {
                    String msg = "Trying to update but key has been blown! Not updating, message was " + this.revocationMessage;
                    Logger.error(this, msg);
                    System.err.println(msg);
                    return;
                }
                if (this.peersSayBlown) {
                    String msg = "Trying to update but at least one peer says the key has been blown! Not updating.";
                    Logger.error(this, msg);
                    System.err.println(msg);
                    return;
                }
                if (!this.isEnabled()) {
                    if (this.logMINOR) {
                        Logger.minor(this, "Not enabled");
                    }
                    return;
                }
                if (!this.isAutoUpdateAllowed && !this.armed) {
                    if (this.logMINOR) {
                        Logger.minor(this, "Not armed");
                    }
                    return;
                }
                if (!this.isReadyToDeployUpdate(false)) {
                    if (this.logMINOR) {
                        Logger.minor(this, "Not ready to deploy update");
                    }
                    return;
                }
                int extVer = this.getReadyExt();
                if (extVer < this.minExtVersion || extVer > this.maxExtVersion) {
                    if (this.logMINOR) {
                        Logger.minor(this, "Invalid ext: current " + extVer + " must be between " + this.minExtVersion + " and " + this.maxExtVersion);
                    }
                    return;
                }
                if (this.isDeployingUpdate) {
                    if (this.logMINOR) {
                        Logger.minor(this, "Already deploying update");
                    }
                    return;
                }
                this.isDeployingUpdate = true;
            }
            this.innerDeployUpdate();
        }
        catch (Throwable t) {
            NodeUpdateManager nodeUpdateManager = this;
            synchronized (nodeUpdateManager) {
                this.isDeployingUpdate = false;
            }
        }
    }

    private void innerDeployUpdate() {
        UpdateDeployContext ctx;
        try {
            ctx = new UpdateDeployContext();
        }
        catch (UpdaterParserException e) {
            this.failUpdate("Could not determine which jars are in use: " + e.getMessage());
            return;
        }
        if (this.writeJars(ctx)) {
            this.restart(ctx);
        } else if (this.logMINOR) {
            Logger.minor(this, "Did not write jars");
        }
    }

    private boolean writeJars(UpdateDeployContext ctx) {
        boolean writtenNewJar = false;
        boolean writtenNewExt = false;
        boolean tryEasyWay = File.pathSeparatorChar == ':' && !this.hasNewExtJar;
        File mainJar = ctx.getMainJar();
        File newMainJar = ctx.getNewMainJar();
        if (this.hasNewMainJar) {
            boolean writtenToTempFile;
            block23: {
                writtenNewJar = true;
                writtenToTempFile = false;
                try {
                    if (newMainJar.exists()) {
                        if (!newMainJar.delete()) {
                            if (newMainJar.exists()) {
                                System.err.println("Cannot write to preferred new jar location " + newMainJar);
                                if (tryEasyWay) {
                                    try {
                                        newMainJar = File.createTempFile("freenet", ".jar", mainJar.getParentFile());
                                    }
                                    catch (IOException e) {
                                        this.failUpdate("Cannot write to any other location either - disk full? " + e);
                                        return false;
                                    }
                                    try {
                                        this.mainUpdater.writeJarTo(newMainJar);
                                        writtenToTempFile = true;
                                        break block23;
                                    }
                                    catch (IOException e) {
                                        newMainJar.delete();
                                        this.failUpdate("Cannot write new jar - disk full? " + e);
                                        return false;
                                    }
                                }
                                this.mainUpdater.writeJarTo(newMainJar);
                                break block23;
                            }
                            this.mainUpdater.writeJarTo(newMainJar);
                            break block23;
                        }
                        if (this.logMINOR) {
                            Logger.minor(this, "Deleted old jar " + newMainJar);
                        }
                        this.mainUpdater.writeJarTo(newMainJar);
                        break block23;
                    }
                    this.mainUpdater.writeJarTo(newMainJar);
                }
                catch (IOException e) {
                    this.failUpdate("Cannot update: Cannot write to " + (tryEasyWay ? " temp file " : "new jar ") + newMainJar);
                    return false;
                }
            }
            if (tryEasyWay) {
                if (!newMainJar.renameTo(mainJar)) {
                    Logger.error(this, "Cannot rename temp file " + newMainJar + " over original jar " + mainJar);
                    if (writtenToTempFile) {
                        newMainJar.delete();
                        this.failUpdate("Cannot write to preferred new jar location and cannot rename temp file over old jar, update failed");
                        return false;
                    }
                } else {
                    System.err.println("Written new Freenet jar: " + this.mainUpdater.getWrittenVersion());
                    return true;
                }
            }
        }
        if (this.hasNewExtJar) {
            writtenNewExt = true;
            File newExtJar = ctx.getNewExtJar();
            try {
                this.extUpdater.writeJarTo(newExtJar);
            }
            catch (IOException e) {
                this.failUpdate("Cannot write new ext jar to " + newExtJar);
                return false;
            }
        }
        try {
            ctx.rewriteWrapperConf(writtenNewJar, writtenNewExt);
        }
        catch (IOException e) {
            this.failUpdate("Cannot rewrite wrapper.conf: " + e);
            return false;
        }
        catch (UpdateDeployContext.UpdateCatastropheException e) {
            this.failUpdate(e.getMessage());
            this.node.clientCore.alerts.register(new SimpleUserAlert(false, this.l10n("updateCatastropheTitle"), e.getMessage(), this.l10n("updateCatastropheTitle"), 0));
            return false;
        }
        catch (UpdaterParserException e) {
            this.node.clientCore.alerts.register(new SimpleUserAlert(false, this.l10n("updateFailedTitle"), e.getMessage(), this.l10n("updateFailedShort", "reason", e.getMessage()), 0));
            return false;
        }
        return true;
    }

    private void restart(UpdateDeployContext ctx) {
        if (this.logMINOR) {
            Logger.minor(this, "Restarting...");
        }
        this.node.getNodeStarter().restart();
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.err.println("Failed to restart. Exiting, please restart the node.");
        System.exit(24);
    }

    private void failUpdate(String reason) {
        Logger.error(this, "Update failed: " + reason);
        System.err.println("Update failed: " + reason);
        this.killUpdateAlerts();
        this.node.clientCore.alerts.register(new SimpleUserAlert(true, this.l10n("updateFailedTitle"), this.l10n("updateFailed", "reason", reason), this.l10n("updateFailedShort", "reason", reason), 1));
    }

    private String l10n(String key) {
        return L10n.getString("NodeUpdateManager." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("NodeUpdateManager." + key, pattern, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDownloadedNewJar(boolean isExt, int requiredExt, int recommendedExt) {
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (isExt) {
                if (this.extUpdater.getFetchedVersion() > NodeStarter.extBuildNumber) {
                    this.hasNewExtJar = true;
                    this.startedFetchingNextExtJar = -1L;
                    this.gotJarTime = System.currentTimeMillis();
                    if (this.logMINOR) {
                        Logger.minor(this, "Got ext jar: " + this.extUpdater.getFetchedVersion());
                    }
                }
            } else if (this.mainUpdater.getFetchedVersion() > Version.buildNumber()) {
                this.hasNewMainJar = true;
                this.startedFetchingNextMainJar = -1L;
                this.gotJarTime = System.currentTimeMillis();
                if (this.logMINOR) {
                    Logger.minor(this, "Got main jar: " + this.mainUpdater.getFetchedVersion());
                }
            }
            if (!isExt) {
                if (requiredExt > -1) {
                    this.minExtVersion = requiredExt;
                }
                if (recommendedExt > -1) {
                    this.maxExtVersion = recommendedExt;
                }
            }
        }
        if (!(isExt || requiredExt <= -1 && recommendedExt <= -1)) {
            this.extUpdater.setMinMax(requiredExt, recommendedExt);
        }
        this.revocationChecker.start(true);
        this.deployOffThread(300000L);
        if (!this.isAutoUpdateAllowed) {
            this.broadcastUOMAnnounces();
        }
    }

    private int getReadyExt() {
        int ver = NodeStarter.extBuildNumber;
        int fetched = this.extUpdater.getFetchedVersion();
        if (fetched > 0) {
            ver = fetched;
        }
        return ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStartFetching(boolean isExt) {
        long now = System.currentTimeMillis();
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (isExt) {
                this.startedFetchingNextExtJar = now;
            } else {
                this.startedFetchingNextMainJar = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blow(String msg) {
        NodeUpdater ext;
        NodeUpdater main;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.hasBeenBlown) {
                Logger.error(this, "The key has ALREADY been marked as blown! Message was " + this.revocationMessage + " new message " + msg);
                return;
            }
            this.revocationMessage = msg;
            this.hasBeenBlown = true;
            try {
                System.err.println("THE AUTO-UPDATING SYSTEM HAS BEEN COMPROMIZED!");
                System.err.println("The auto-updating system revocation key has been inserted. It says: " + this.revocationMessage);
            }
            catch (Throwable t) {
                try {
                    Logger.error(this, "Caught " + t, t);
                }
                catch (Throwable t1) {
                    // empty catch block
                }
            }
            main = this.mainUpdater;
            ext = this.extUpdater;
            if (main != null) {
                main.preKill();
            }
            if (ext != null) {
                ext.preKill();
            }
            this.mainUpdater = null;
            this.extUpdater = null;
        }
        if (main != null) {
            main.kill();
        }
        if (ext != null) {
            ext.kill();
        }
        if (this.revocationAlert == null) {
            this.revocationAlert = new RevocationKeyFoundUserAlert(msg);
            this.node.clientCore.alerts.register(this.revocationAlert);
            this.killUpdateAlerts();
        }
        this.uom.killAlert();
        this.broadcastUOMAnnounces();
    }

    private void killUpdateAlerts() {
        this.node.clientCore.alerts.unregister(this.alert);
    }

    public void noRevocationFound() {
        this.deployUpdate();
        this.broadcastUOMAnnounces();
        this.node.ps.queueTimedJob(new Runnable(){

            public void run() {
                NodeUpdateManager.this.revocationChecker.start(false);
            }
        }, this.node.random.nextInt(86400000));
    }

    public void arm() {
        this.armed = true;
        this.deployOffThread(0L);
    }

    void deployOffThread(long delay) {
        this.node.ps.queueTimedJob(new Runnable(){

            public void run() {
                if (NodeUpdateManager.this.logMINOR) {
                    Logger.minor(this, "Running deployOffThread");
                }
                try {
                    NodeUpdateManager.this.deployUpdate();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " trying to deployOffThread", t);
                }
                if (NodeUpdateManager.this.logMINOR) {
                    Logger.minor(this, "Run deployOffThread");
                }
            }
        }, delay);
    }

    public boolean isBlown() {
        return this.hasBeenBlown;
    }

    public boolean hasNewMainJar() {
        return this.hasNewMainJar;
    }

    public boolean hasNewExtJar() {
        return this.hasNewExtJar;
    }

    public int newMainJarVersion() {
        if (this.mainUpdater == null) {
            return -1;
        }
        return this.mainUpdater.getFetchedVersion();
    }

    public int newExtJarVersion() {
        if (this.extUpdater == null) {
            return -1;
        }
        return this.extUpdater.getFetchedVersion();
    }

    public boolean fetchingNewMainJar() {
        return this.mainUpdater != null && this.mainUpdater.isFetching();
    }

    public boolean fetchingNewExtJar() {
        return this.extUpdater != null && this.extUpdater.isFetching();
    }

    public int fetchingNewMainJarVersion() {
        if (this.mainUpdater == null) {
            return -1;
        }
        return this.mainUpdater.fetchingVersion();
    }

    public int fetchingNewExtJarVersion() {
        if (this.extUpdater == null) {
            return -1;
        }
        return this.extUpdater.fetchingVersion();
    }

    public boolean inFinalCheck() {
        return this.isReadyToDeployUpdate(true) && !this.isReadyToDeployUpdate(false);
    }

    public int getRevocationDNFCounter() {
        return this.revocationChecker.getRevocationDNFCounter();
    }

    public int getMainVersion() {
        return Version.buildNumber();
    }

    public int getExtVersion() {
        return NodeStarter.extBuildNumber;
    }

    public boolean isArmed() {
        return this.armed || this.isAutoUpdateAllowed;
    }

    public boolean canUpdateNow() {
        return this.isReadyToDeployUpdate(true);
    }

    public boolean canUpdateImmediately() {
        return this.isReadyToDeployUpdate(false);
    }

    void peerClaimsKeyBlown() {
        this.peersSayBlown = true;
    }

    public void notPeerClaimsKeyBlown() {
        this.peersSayBlown = false;
        this.node.executor.execute(new Runnable(){

            public void run() {
                NodeUpdateManager.this.isReadyToDeployUpdate(false);
            }
        }, "Check for updates");
    }

    boolean peersSayBlown() {
        return this.peersSayBlown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getMainBlob(int version) {
        NodeUpdater updater;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.hasBeenBlown) {
                return null;
            }
            updater = this.mainUpdater;
            if (updater == null) {
                return null;
            }
        }
        return updater.getBlobFile(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getExtBlob(int version) {
        NodeUpdater updater;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.hasBeenBlown) {
                return null;
            }
            updater = this.extUpdater;
            if (updater == null) {
                return null;
            }
        }
        return updater.getBlobFile(version);
    }

    public synchronized long timeRemainingOnCheck() {
        long now = System.currentTimeMillis();
        return Math.max(0L, 300000L - (now - this.gotJarTime));
    }

    public void disableThisSession() {
        this.disabledThisSession = true;
    }

    protected long getStartedFetchingNextMainJarTimestamp() {
        return this.startedFetchingNextMainJar;
    }

    protected long getStartedFetchingNextExtJarTimestamp() {
        return this.startedFetchingNextExtJar;
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing NodeUpdateManager in database", new Exception("error"));
        return false;
    }

    public class UpdateRevocationURICallback
    extends StringCallback {
        public String get() {
            return NodeUpdateManager.this.getRevocationURI().toString(false, false);
        }

        public void set(String val) throws InvalidConfigValueException {
            FreenetURI uri;
            try {
                uri = new FreenetURI(val);
            }
            catch (MalformedURLException e) {
                throw new InvalidConfigValueException(NodeUpdateManager.this.l10n("invalidRevocationURI", "error", e.getLocalizedMessage()));
            }
            NodeUpdateManager.this.setRevocationURI(uri);
        }
    }

    class UpdateURICallback
    extends StringCallback {
        boolean isExt;

        UpdateURICallback(boolean isExt) {
            this.isExt = isExt;
        }

        public String get() {
            return NodeUpdateManager.this.getURI(this.isExt).toString(false, false);
        }

        public void set(String val) throws InvalidConfigValueException {
            FreenetURI uri;
            try {
                uri = new FreenetURI(val);
            }
            catch (MalformedURLException e) {
                throw new InvalidConfigValueException(NodeUpdateManager.this.l10n(this.isExt ? "invalidExtURI" : "invalidUpdateURI", "error", e.getLocalizedMessage()));
            }
            NodeUpdateManager.this.setURI(this.isExt, uri);
        }
    }

    class AutoUpdateAllowedCallback
    extends BooleanCallback {
        AutoUpdateAllowedCallback() {
        }

        public Boolean get() {
            return NodeUpdateManager.this.isAutoUpdateAllowed();
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            NodeUpdateManager.this.setAutoUpdateAllowed(val);
        }
    }

    class UpdaterEnabledCallback
    extends BooleanCallback {
        UpdaterEnabledCallback() {
        }

        public Boolean get() {
            return NodeUpdateManager.this.isEnabled();
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            NodeUpdateManager.this.enable(val);
        }
    }
}

